<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método não permitido']);
    exit;
}

/* --- Validação de entrada --- */
$amount    = isset($_POST['amount']) ? (float)str_replace(',', '.', $_POST['amount']) : 0;
$cpf       = isset($_POST['cpf']) ? preg_replace('/\D/', '', $_POST['cpf']) : '';
$bonusCode = isset($_POST['bonus_code']) ? strtoupper(trim($_POST['bonus_code'])) : '';


if (empty($_SESSION['usuario_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Usuário não autenticado.']);
    exit;
}

/* --- Dependências --- */
require_once __DIR__ . '/../conexao.php';
require_once __DIR__ . '/../classes/zyropay.php';

try {
    $usuario_id = (int)$_SESSION['usuario_id'];

    /* --- Busca usuário (agora só temos usuario; nome/email podem não existir) --- */
    $stmt = $pdo->prepare("SELECT nome, email FROM usuarios WHERE id = :id LIMIT 1");
    $stmt->execute([':id' => $usuario_id]);
    $u = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$u) throw new Exception('Usuário não encontrado.');

    // Nome a ser enviado ao gateway (obrigatório em vários PSPs)
    $payerName = $u['nome'] ?: 'Cliente Box';
    $payerName = mb_substr(trim($payerName), 0, 80);

    /* --- Garantir colunas opcionais na tabela depositos (ignora erro se não suportar IF NOT EXISTS) --- */
    try {
        $pdo->exec("ALTER TABLE depositos ADD COLUMN IF NOT EXISTS bonus_code VARCHAR(100) NULL");
        $pdo->exec("ALTER TABLE depositos ADD COLUMN IF NOT EXISTS bonus_percent DECIMAL(5,2) NULL");
        $pdo->exec("ALTER TABLE depositos ADD COLUMN IF NOT EXISTS bonus_amount DECIMAL(10,2) NOT NULL DEFAULT 0.00");
        $pdo->exec("ALTER TABLE depositos ADD COLUMN IF NOT EXISTS bonus_applied TINYINT(1) NOT NULL DEFAULT 0");
        $pdo->exec("ALTER TABLE depositos ADD COLUMN IF NOT EXISTS copiaecola TEXT NULL");
        $pdo->exec("ALTER TABLE depositos ADD COLUMN IF NOT EXISTS idempotency_key VARCHAR(191) NULL");
        $pdo->exec("ALTER TABLE depositos ADD COLUMN IF NOT EXISTS expires_at VARCHAR(64) NULL");
    } catch (Throwable $e) {
        // ok
    }

    /* --- Bônus (placeholder) --- */
    $bonus_percent = null;
    $bonus_amount  = 0.00;
    if ($bonusCode !== '') {
        // sua lógica de bônus aqui
    }

    /* --- Config da requisição ao PSP --- */
    // Callback fixo conforme solicitado
    $protocol    = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
    $host        = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $postbackUrl = $protocol . $host . '/callback/zyropay.php';

    $idempotencyKey = 'idemp_' . bin2hex(random_bytes(12));

  // Dados do pagador a enviar para o gateway
// Gera email fallback caso o usuário não tenha email cadastrado
//$baseUser  = !empty($u['usuario']) ? preg_replace('/[^a-z0-9]/i', '', $u['usuario']) : ('user' . (int)$usuario_id);
$baseUser  = 'user' . (int)$usuario_id;
$fallbackEmail = strtolower($baseUser) . '@box.com';

$customerEmail = !empty($u['email']) ? $u['email'] : $fallbackEmail;

$customerData = [
    'name'     => $payerName,
    'document' => (!empty($cpf) ? $cpf : '00000000191'), // fallback se não informar
    'email'    => $customerEmail
];

/* --- Criação do PIX via classe ZyroPay --- */
$externalId = uniqid() . '_' . $usuario_id;

// log debug temporário
@file_put_contents(__DIR__.'/../payment.log', date('Y-m-d H:i:s')." POSTBACK=".$postbackUrl."\n", FILE_APPEND);

$result = ZyroPay::createPix(
    $pdo,
    $customerData,
    $amount,
    $externalId,
    $postbackUrl,
    [],
    $idempotencyKey
);

    // Normaliza chaves possíveis retornadas pela classe
    $txId    = $result['transaction_id'] ?? $result['transactionId'] ?? null;
    $qrCode  = $result['qr_code']        ?? $result['qrcode']        ?? null;
    $copia   = $result['copy_paste_key'] ?? $result['copyPaste']     ?? null;
    $expires = $result['expires_at']     ?? $result['expiresAt']     ?? null;

    if (!$txId || !$qrCode) {
        throw new Exception('Falha ao gerar o PIX. Resposta inesperada da ZyroPay.');
    }


    /* --- Persistência --- */
    @file_put_contents(
        __DIR__ . '/../payment.log',
    date('Y-m-d H:i:s') . " TX_CREATED: " . $txId . PHP_EOL,
        FILE_APPEND
    );

  $stmt = $pdo->prepare("
    INSERT INTO depositos
    (transactionId, user_id, nome, cpf, valor, status, qrcode, copiaecola, gateway, idempotency_key, bonus_code, bonus_percent, bonus_amount, expires_at, created_at, utms, fbp, fbc)
    VALUES
    (:transactionId, :user_id, :nome, :cpf, :valor, 'PENDING', :qrcode, :copiaecola, 'zyropay', :idempotency_key, :bonus_code, :bonus_percent, :bonus_amount, :expires_at, NOW(), :utms, :fbp, :fbc)
");
$stmt->execute([
    ':transactionId'   => $txId,
    ':user_id'         => $usuario_id,
    ':nome'            => $payerName,
    ':cpf'             => $cpf,
    ':valor'           => $amount,
    ':qrcode'          => $qrCode,
    ':copiaecola'      => $copia,
    ':idempotency_key' => $idempotencyKey,
    ':bonus_code'      => ($bonusCode !== '' ? $bonusCode : null),
    ':bonus_percent'   => $bonus_percent,
    ':bonus_amount'    => $bonus_amount,
    ':expires_at'      => $expires,
    ':utms'            => isset($_SESSION['utms']) ? json_encode($_SESSION['utms']) : null,
    ':fbp'             => $_SESSION['_fbp'] ?? null,
    ':fbc'             => $_SESSION['_fbc'] ?? null
]);

    $_SESSION['transactionId'] = $txId;

    echo json_encode([
        'gateway'       => 'zyropay',
        'transactionId' => $txId,
        'qrcode'        => $qrCode,
        'copiaecola'    => $copia,
        'expiresAt'     => $expires,
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
