<?php
// callback/zyropay.php
require_once __DIR__ . '/../conexao.php';

// It is highly recommended to secure your webhook with a secret key.
// This key must be configured in your ZyroPay dashboard and used here to validate the request.
define('ZYROPAY_WEBHOOK_SECRET', 'jidsauihfashu@djioasdjsaiojdsa@123');
// jidsauihfashu@djioasdjsaiojdsa@123
// --- Functions for Security ---

/**
 * Verifies the signature of the incoming webhook request.
 * This is a critical security measure to prevent fake callbacks.
 * The exact implementation of this function will depend on ZyroPay's signature generation method.
 * You should consult the ZyroPay API documentation for the precise signature calculation.
 *
 * @param string $requestBody The raw request body.
 * @param string $signatureHeader The signature received in the request headers.
 * @return bool
 */
function verifyWebhookSignature(string $requestBody, string $signatureHeader): bool
{
    // Example signature verification (the actual method may differ):
    // ZyroPay might use an HMAC-SHA256 signature, for instance.
    $json = json_decode($requestBody, true);

    // It's important to use hash_equals for secure string comparison to prevent timing attacks.
    return hash_equals($json['securityParaphrase'], ZYROPAY_WEBHOOK_SECRET);
}

// --- Main Script Logic ---

// Read the raw request body
$raw = file_get_contents('php://input');
$data = json_decode($raw, true);

// Log the raw data for auditing and debugging purposes
@file_put_contents(
    __DIR__ . '/../runtime_zyropay_callback.log',
    date('Y-m-d H:i:s') . " RAW: " . $raw . "\n",
    FILE_APPEND
);

// --- Security Check ---

// Retrieve the signature from the request headers. The header name 'X-ZyroPay-Signature' is an example.
// Please check ZyroPay's documentation for the correct header name.
$signature = $_SERVER['HTTP_X_ZYROPAY_SIGNATURE'] ?? '';

if (!verifyWebhookSignature($raw, $signature)) {
    http_response_code(401); // Unauthorized
    echo 'Signature verification failed.';
    @file_put_contents(
        __DIR__ . '/../runtime_zyropay_callback.log',
        date('Y-m-d H:i:s') . " ERROR: Signature verification failed.\n",
        FILE_APPEND
    );
    exit;
}

// --- Data Validation ---

// Validate the presence of essential data fields.
// Based on common payment gateway formats, the transaction ID could be 'transaction_id', 'id', or 'order_id'.
// The status might be indicated by a 'status' or 'result' field.
if (!$data || !isset($data['paymentId'], $data['status'])) {
    http_response_code(400);
    echo 'Invalid payload';
    exit;
}

// Assign variables from the payload
$transactionId = $data['paymentId'];
$status        = strtoupper($data['status']); // e.g., 'COMPLETED', 'PAID', 'FAILED'

try {
    // Begin a transaction to ensure data integrity
    $pdo->beginTransaction();
    
    // Update the deposit status based on the received transaction ID
    $stmt = $pdo->prepare("UPDATE depositos SET status = :s WHERE transactionId = :t LIMIT 1");
    $stmt->execute([':s' => $status, ':t' => $transactionId]);

    // If the payment was successful, credit the user's account
    if ($status === 'COMPLETED' || $status === 'PAID' || $status === 'CONFIRMED') {
       
        // Fetch the deposit details to get the user ID and amounts
        $stmt = $pdo->prepare("SELECT user_id, valor, bonus_amount, status FROM depositos WHERE transactionId = :t LIMIT 1");
        $stmt->execute([':t' => $transactionId]);
        $deposit = $stmt->fetch(PDO::FETCH_ASSOC);

        // Ensure the deposit exists and hasn't been processed already
        if ($deposit && $deposit['status'] !== 'PAID') {
            $totalAmount = (float)$deposit['valor'] + (float)$deposit['bonus_amount'];

            // Update the user's balance
            $stmtUser = $pdo->prepare("UPDATE usuarios SET saldo = saldo + :v WHERE id = :u");
            $stmtUser->execute([':v' => $totalAmount, ':u' => $deposit['user_id']]);

            // Mark the bonus as applied to prevent double crediting
            $stmtBonus = $pdo->prepare("UPDATE depositos SET bonus_applied = 1, status = 'PAID' WHERE transactionId = :t");
            $stmtBonus->execute([':t' => $transactionId]);
        }
    }

    // Commit the transaction
    $pdo->commit();

    // Send a success response to ZyroPay
    http_response_code(200);
    echo 'ok';
} catch (Throwable $e) {
    // Rollback the transaction in case of an error
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    
    // Log the error
    http_response_code(500);
    @file_put_contents(
        __DIR__ . '/../runtime_zyropay_callback.log',
        date('Y-m-d H:i:s') . " ERROR: " . $e->getMessage() . "\n",
        FILE_APPEND
    );
    echo 'error';
}