<?php
// callback/zyropay.php
require_once __DIR__ . '/../conexao.php';

// It is highly recommended to secure your webhook with a secret key.
// This key must be configured in your ZyroPay dashboard and used here to validate the request.
define('ZYROPAY_WEBHOOK_SECRET', 'jidsauihfashu@djioasdjsaiojdsa@123');
// jidsauihfashu@djioasdjsaiojdsa@123

// Função para log detalhado
function logCallback($message, $data = null) {
    $timestamp = date('Y-m-d H:i:s');
    $logMessage = "[$timestamp] $message";
    if ($data !== null) {
        $logMessage .= " | Data: " . json_encode($data, JSON_UNESCAPED_UNICODE);
    }
    $logMessage .= "\n";
    
    @file_put_contents(
        __DIR__ . '/../runtime_zyropay_callback.log',
        $logMessage,
        FILE_APPEND
    );
}

// --- Functions for Security ---

/**
 * Verifies the signature of the incoming webhook request.
 * This is a critical security measure to prevent fake callbacks.
 * The exact implementation of this function will depend on ZyroPay's signature generation method.
 * You should consult the ZyroPay API documentation for the precise signature calculation.
 *
 * @param string $requestBody The raw request body.
 * @param string $signatureHeader The signature received in the request headers.
 * @return bool
 */
function verifyWebhookSignature(string $requestBody, string $signatureHeader): bool
{
    // Example signature verification (the actual method may differ):
    // ZyroPay might use an HMAC-SHA256 signature, for instance.
    $json = json_decode($requestBody, true);

    // It's important to use hash_equals for secure string comparison to prevent timing attacks.
    return hash_equals($json['securityParaphrase'], ZYROPAY_WEBHOOK_SECRET);
}

// --- Main Script Logic ---

logCallback("=== CALLBACK ZYROPAY INICIADO ===");

// Read the raw request body
$raw = file_get_contents('php://input');
$data = json_decode($raw, true);

logCallback("Dados brutos recebidos", ['raw_length' => strlen($raw), 'is_json_valid' => json_last_error() === JSON_ERROR_NONE]);

// Log the raw data for auditing and debugging purposes
logCallback("RAW DATA", $raw);

// --- Security Check ---

logCallback("Iniciando verificação de segurança");

// Retrieve the signature from the request headers. The header name 'X-ZyroPay-Signature' is an example.
// Please check ZyroPay's documentation for the correct header name.
$signature = $_SERVER['HTTP_X_ZYROPAY_SIGNATURE'] ?? '';

logCallback("Headers recebidos", [
    'x_zyropay_signature' => $signature,
    'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'N/A',
    'remote_addr' => $_SERVER['REMOTE_ADDR'] ?? 'N/A'
]);

if (!verifyWebhookSignature($raw, $signature)) {
    logCallback("ERRO: Falha na verificação de assinatura", [
        'received_signature' => $signature,
        'expected_secret' => ZYROPAY_WEBHOOK_SECRET
    ]);
    http_response_code(401); // Unauthorized
    echo 'Signature verification failed.';
    exit;
}

logCallback("✅ Verificação de assinatura bem-sucedida");

// --- Data Validation ---

logCallback("Iniciando validação de dados");

// Validate the presence of essential data fields.
// Based on common payment gateway formats, the transaction ID could be 'transaction_id', 'id', or 'order_id'.
// The status might be indicated by a 'status' or 'result' field.
if (!$data || !isset($data['paymentId'], $data['status'])) {
    logCallback("ERRO: Payload inválido", [
        'data_exists' => $data !== null,
        'has_paymentId' => isset($data['paymentId']),
        'has_status' => isset($data['status']),
        'data_keys' => $data ? array_keys($data) : []
    ]);
    http_response_code(400);
    echo 'Invalid payload';
    exit;
}

logCallback("✅ Payload válido");

// Assign variables from the payload
$transactionId = $data['paymentId'];
$status        = strtoupper($data['status']); // e.g., 'COMPLETED', 'PAID', 'FAILED'

logCallback("Dados extraídos do payload", [
    'transactionId' => $transactionId,
    'status' => $status,
    'movId' => $data['movId'] ?? 'N/A',
    'value' => $data['value'] ?? 'N/A',
    'payer_name' => $data['payer']['name'] ?? 'N/A',
    'payer_document' => $data['payer']['document'] ?? 'N/A'
]);

try {
    logCallback("Iniciando processamento do depósito", ['transactionId' => $transactionId, 'status' => $status]);
    
    // Begin a transaction to ensure data integrity
    $pdo->beginTransaction();
    logCallback("✅ Transação de banco iniciada");

    // Update the deposit status based on the received transaction ID
    $stmt = $pdo->prepare("UPDATE depositos SET status = :s WHERE transactionId = :t LIMIT 1");
    $stmt->execute([':s' => $status, ':t' => $transactionId]);
    $rowsAffected = $stmt->rowCount();
    
    logCallback("Atualização de status do depósito", [
        'transactionId' => $transactionId,
        'new_status' => $status,
        'rows_affected' => $rowsAffected
    ]);

    // If the payment was successful, credit the user's account
    if ($status === 'COMPLETED' || $status === 'PAID' || $status === 'CONFIRMED') {
        logCallback("Status indica pagamento bem-sucedido, iniciando processamento de crédito");
       
       
       // DEPOIS

        // Fetch the deposit details to get the user ID and amounts
        // LINHA MODIFICADA: Adicionamos os novos campos (nome, cpf, utms, fbp, fbc)
        $stmt = $pdo->prepare("SELECT user_id, valor, bonus_amount, status, nome, cpf, utms, fbp, fbc FROM depositos WHERE transactionId = :t LIMIT 1");
        $stmt->execute([':t' => $transactionId]);
        $deposit = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($deposit) {
            logCallback("Depósito encontrado no banco", [
                'deposit_id' => $deposit['id'] ?? 'N/A',
                'user_id' => $deposit['user_id'],
                'valor' => $deposit['valor'],
                'bonus_amount' => $deposit['bonus_amount'],
                'current_status' => $deposit['status']
            ]);

            // ===== INÍCIO DO NOVO CÓDIGO UTMIFY =====
            logCallback("Iniciando envio para UTMify", ['transactionId' => $transactionId]);

            // Buscando o e-mail do usuário separadamente
            $stmtUserEmail = $pdo->prepare("SELECT email FROM usuarios WHERE id = :id LIMIT 1");
            $stmtUserEmail->execute([':id' => $deposit['user_id']]);
            $user = $stmtUserEmail->fetch(PDO::FETCH_ASSOC);
            $customerEmail = $user['email'] ?? 'nao_informado@email.com';

            // Certifique-se de que UTMIFY_API_TOKEN está configurado como variável de ambiente
            $utmifyApiToken = getenv('UTMIFY_API_TOKEN');

            if ($utmifyApiToken) {
                $orderData = [
                    'order_id' => $transactionId,
                    'value' => (float)$deposit['valor'],
                    'currency' => 'BRL',
                    'payment_method' => 'PIX',
                    'status' => 'approved',
                    'created_at' => date('Y-m-d H:i:s'),
                    'customer' => [
                        'email' => $customerEmail,
                        'name' => $deposit['nome'],
                        'phone' => $deposit['cpf'], // Usando CPF como telefone conforme relatório
                    ],
                    'products' => [
                        ['id' => 'deposit', 'name' => 'Depósito', 'price' => (float)$deposit['valor'], 'quantity' => 1]
                    ],
                    // Decodifica o JSON das UTMs salvo no banco
                    'utms' => !empty($deposit['utms']) ? json_decode($deposit['utms'], true) : [],
                    'fbp' => $deposit['fbp'] ?? null,
                    'fbc' => $deposit['fbc'] ?? null,
                ];

                $ch = curl_init('https://api.utmify.com.br/api-credentials/orders');
                curl_setopt_array($ch, [
                    CURLOPT_POST => 1,
                    CURLOPT_HTTPHEADER => [
                        'Content-Type: application/json',
                        'x-api-token: ' . $utmifyApiToken
                    ],
                    CURLOPT_POSTFIELDS => json_encode($orderData),
                    CURLOPT_RETURNTRANSFER => 1,
                    CURLOPT_TIMEOUT => 10,
                ]);
                $response = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
                
                logCallback("📡 UTMify API Response", ['http_code' => $httpCode, 'response' => $response]);
            } else {
                logCallback("⚠️  UTMIFY_API_TOKEN não configurado. Envio para UTMify ignorado.");
            }
            // ===== FIM DO NOVO CÓDIGO UTMIFY =====

            // Ensure the deposit exists and hasn't been processed already
            if ($deposit['status'] !== 'PAID') {
                $totalAmount = (float)$deposit['valor'] + (float)$deposit['bonus_amount'];
                
                logCallback("Processando crédito para usuário", [
                    'user_id' => $deposit['user_id'],
                    'valor_deposito' => $deposit['valor'],
                    'bonus_amount' => $deposit['bonus_amount'],
                    'total_amount' => $totalAmount
                ]);

                // Update the user's balance
                $stmtUser = $pdo->prepare("UPDATE usuarios SET saldo = saldo + :v WHERE id = :u");
                $stmtUser->execute([':v' => $totalAmount, ':u' => $deposit['user_id']]);
                $userRowsAffected = $stmtUser->rowCount();
                
                logCallback("Saldo do usuário atualizado", [
                    'user_id' => $deposit['user_id'],
                    'amount_credited' => $totalAmount,
                    'rows_affected' => $userRowsAffected
                ]);

                // Mark the bonus as applied to prevent double crediting
                $stmtBonus = $pdo->prepare("UPDATE depositos SET bonus_applied = 1, status = 'PAID' WHERE transactionId = :t");
                $stmtBonus->execute([':t' => $transactionId]);
                $bonusRowsAffected = $stmtBonus->rowCount();
                
                logCallback("Bônus aplicado e status atualizado para PAID", [
                    'transactionId' => $transactionId,
                    'rows_affected' => $bonusRowsAffected
                ]);
            } else {
                logCallback("⚠️ Depósito já foi processado anteriormente", [
                    'transactionId' => $transactionId,
                    'current_status' => $deposit['status']
                ]);
            }
        } else {
            logCallback("❌ Depósito não encontrado no banco", ['transactionId' => $transactionId]);
        }
    } else {
        logCallback("Status não indica pagamento bem-sucedido, pulando processamento de crédito", ['status' => $status]);
    }



    // Commit the transaction
    $pdo->commit();
    logCallback("✅ Transação commitada com sucesso");
    
        // ===== CAPI Purchase (server-side) =====
    if (in_array($status, ['COMPLETED','PAID','CONFIRMED'], true) && isset($deposit) && ($deposit['status'] === 'PAID' || $status === 'PAID')) {
        $PIXEL_ID     = '2780324705485909';
        $ACCESS_TOKEN = 'EAARKgOGRWZCEBPRrmTmzEjdEZCxd186ZCxbD9rn91onjNZAAx1j0xQXeQOThisy9o59B45ZCJR7zWdA52bHRUnhwyBJiuxalvyzeZCLnF0q8tHAFDzCWnVkCGtta2sfYKZBZCFudMutQHvz1J8bkVapoN8fQOwcXF2dRwBxaJYpwiplzoiwJhTBzKs66sAzxxc4KXAZDZD';

        $value = (float)($deposit['valor'] ?? 0);
        $fbp   = $deposit['fbp'] ?? ($_COOKIE['_fbp'] ?? null);
        $fbc   = $deposit['fbc'] ?? ($_COOKIE['_fbc'] ?? null);
        $event_id = 'srv-' . ($deposit['id'] ?? $transactionId) . '-' . time();

        $payload = [
            'data' => [[
                'event_name'        => 'Purchase',
                'event_time'        => time(),
                'event_id'          => $event_id,
                'action_source'     => 'website',
                'event_source_url'  => 'https://' . ($_SERVER['HTTP_HOST'] ?? 'localhost') . '/obrigado',
                'user_data'         => array_filter([
                    'fbp' => $fbp,
                    'fbc' => $fbc,
                ]),
                'custom_data'       => [
                    'currency' => 'BRL',
                    'value'    => $value
                ]
            ]],
            'access_token' => $ACCESS_TOKEN
        ];

        $ch = curl_init("https://graph.facebook.com/v18.0/{$PIXEL_ID}/events");
        curl_setopt_array($ch, [
            CURLOPT_POST           => true,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER     => ['Content-Type: application/json'],
            CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_UNICODE)
        ]);
        $resp = curl_exec($ch);
        $err  = curl_error($ch);
        $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        logCallback("📡 CAPI Purchase enviado", ['http' => $http, 'err' => $err, 'resp' => $resp]);
    }


    // Send a success response to ZyroPay
    http_response_code(200);
    echo 'ok';
    logCallback("✅ Resposta de sucesso enviada para ZyroPay");
} catch (Throwable $e) {
    logCallback("❌ ERRO CRÍTICO durante processamento", [
        'error_message' => $e->getMessage(),
        'error_file' => $e->getFile(),
        'error_line' => $e->getLine(),
        'error_trace' => $e->getTraceAsString()
    ]);
    
    // Rollback the transaction in case of an error
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
        logCallback("✅ Transação revertida devido ao erro");
    }
    
    // Log the error
    http_response_code(500);
    echo 'error';
    logCallback("❌ Resposta de erro enviada para ZyroPay");
}

logCallback("=== CALLBACK ZYROPAY FINALIZADO ===");