<?php
session_start();
$mostrar_popup = false;

if (isset($_SESSION['sucesso'])) {
  $mostrar_popup = true;
  unset($_SESSION['sucesso']);
}

if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
  header('Location: login.php');
  exit;
}

require 'db.php';
$distribuicao = [];
if (file_exists('distribuicao.json')) {
  $distribuicao = json_decode(file_get_contents('distribuicao.json'), true);
}

$config = $pdo->query("SELECT * FROM configuracoes LIMIT 1")->fetch();

$stmt = $pdo->query("SELECT * FROM raspadinhas_config ORDER BY valor ASC");
$raspadinhas = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Configurações da Plataforma</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet" />
  <style>
    :root {
      --bg-dark: #121212;
      --bg-panel: #1e1e1e;
      --primary-green: #00ff99;
      --text-light: #e0e0e0;
      --radius: 12px;
      --transition: 0.3s ease;
      --border-panel: rgba(0, 255, 153, 0.1);
      --box-shadow-hover: 0 0 15px rgba(0, 255, 153, 0.4);
    }

    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(to bottom right, #0d0d0d, #1a1a1a);
      color: var(--text-light);
      min-height: 100vh;
    }

    .sidebar {
      position: fixed;
      top: 0;
      left: 0;
      width: 260px;
      height: 100%;
      background: #101010;
      padding: 30px 20px;
      color: var(--primary-green);
      border-right: 2px solid var(--primary-green);
    }

    .sidebar h2 {
      font-size: 24px;
      text-align: center;
      margin-bottom: 30px;
      font-weight: 700;
    }

    .sidebar ul {
      list-style: none;
      padding: 0;
    }

    .sidebar ul li {
      margin-bottom: 15px;
    }

    .sidebar ul li a {
      display: block;
      padding: 12px 20px;
      background-color: #1b1b1b;
      color: var(--text-light);
      border: 1px solid transparent;
      border-radius: var(--radius);
      text-decoration: none;
      transition: var(--transition);
    }

    .sidebar ul li a:hover {
      background-color: var(--primary-green);
      color: #000;
      border-color: var(--primary-green);
    }

    .content {
      margin-left: 260px;
      padding: 40px;
      max-width: calc(100% - 260px);
    }

    h2 {
      font-size: 28px;
      color: var(--primary-green);
      margin-bottom: 20px;
    }

    .desc {
      color: #ccc;
      margin-bottom: 30px;
      font-weight: 500;
    }

    form {
      display: flex;
      flex-wrap: wrap;
      gap: 20px;
    }

    .form-group {
      flex: 1 1 45%;
      display: flex;
      flex-direction: column;
    }

    label {
      font-weight: 600;
      margin-bottom: 6px;
      color: var(--primary-green);
      user-select: none;
    }

    input, select {
      padding: 12px;
      border: 1px solid var(--border-panel);
      border-radius: var(--radius);
      font-size: 15px;
      background-color: var(--bg-dark);
      color: var(--text-light);
      transition: border-color 0.3s;
    }

    input:focus, select:focus {
      border-color: var(--primary-green);
      outline: none;
      box-shadow: 0 0 6px var(--primary-green);
    }

    button {
      margin-top: 20px;
      padding: 14px 20px;
      background-color: var(--primary-green);
      color: #000;
      font-weight: 700;
      border: none;
      border-radius: var(--radius);
      cursor: pointer;
      transition: var(--transition);
      flex: 1 1 100%;
      max-width: 300px;
      align-self: flex-start;
    }

    button:hover {
      background-color: #00cc77;
    }

    /* Popup sucesso */
    #overlay-sucesso {
      position: fixed;
      top: 0; left: 0;
      width: 100vw; height: 100vh;
      background: rgba(0,0,0,0.6);
      display: flex;
      align-items: center;
      justify-content: center;
      z-index: 9999;
    }

    #popup-sucesso {
      background: var(--bg-panel);
      color: var(--primary-green);
      padding: 30px 40px;
      border-radius: var(--radius);
      box-shadow: 0 5px 20px rgba(0,255,153,0.5);
      font-size: 20px;
      text-align: center;
      position: relative;
      max-width: 90%;
      user-select: none;
    }

    #btn-fechar-popup {
      position: absolute;
      top: 10px;
      right: 15px;
      background: none;
      border: none;
      font-size: 28px;
      cursor: pointer;
      color: var(--primary-green);
      font-weight: 700;
      line-height: 1;
    }

    /* Bloco raspadinha */
    .raspadinha-bloco {
      flex: 1 1 100%;
      background: var(--bg-panel);
      padding: 20px;
      margin-top: 30px;
      border: 1px solid var(--border-panel);
      border-radius: var(--radius);
      box-shadow: 0 0 10px rgba(0,255,153,0.1);
    }

    .raspadinha-titulo {
      font-weight: 700;
      font-size: 1.3rem;
      margin-bottom: 10px;
      color: var(--primary-green);
      user-select: none;
    }

    .raspadinha-chance {
      flex: 1 1 100%;
      display: flex;
      flex-direction: column;
    }

    .raspadinha-chance input {
      width: 150px;
      font-size: 1rem;
      padding: 8px;
      border-radius: var(--radius);
      border: 1px solid var(--border-panel);
      background-color: var(--bg-dark);
      color: var(--text-light);
      transition: border-color 0.3s;
    }

    .raspadinha-chance input:focus {
      border-color: var(--primary-green);
      outline: none;
      box-shadow: 0 0 6px var(--primary-green);
    }

    .form-group > div > label {
      display: block;
      margin-bottom: 6px;
      color: var(--primary-green);
      user-select: none;
    }

    .form-group > div > input {
      width: 100px;
      padding: 6px;
      border-radius: var(--radius);
      border: 1px solid var(--border-panel);
      background-color: var(--bg-dark);
      color: var(--text-light);
      transition: border-color 0.3s;
    }

    .form-group > div > input:focus {
      border-color: var(--primary-green);
      outline: none;
      box-shadow: 0 0 6px var(--primary-green);
    }

    @media (max-width: 768px) {
      .content {
        margin-left: 0;
        padding: 20px;
        max-width: 100%;
      }
      form {
        flex-direction: column;
      }
      .form-group {
        flex: 1 1 100%;
      }
      button {
        max-width: 100%;
      }
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        border: none;
        padding: 20px;
        text-align: center;
      }
      .sidebar ul {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 15px;
      }
      .sidebar ul li {
        width: auto;
        margin-bottom: 10px;
      }
    }
  </style>
</head>
<body>
  <div class="sidebar">
    <h2>Admin</h2>
    <ul>
      <li><a href="painel_admin.php">Painel de Controle</a></li>
      <li><a href="configuracoes_admin.php">Configurações</a></li>
      <li><a href="usuarios_admin.php">Config Usuários</a></li>
      <li><a href="saques_admin.php">Saques</a></li>
      <li><a href="saques_comissao_admin.php">Saques Afiliado</a></li>
      <li><a href="gateways_admin.php">Gateways</a></li>
      <li><a href="pix_admin.php">Transacoes</a></li>
    </ul>
  </div>

  <div class="content">
    <h2>Configurações da Plataforma</h2>
    <p class="desc">Gerencie as configurações de taxas, bônus, afiliados e prêmios.</p>
    <form action="salvar_configuracoes.php" method="POST">
      <div class="form-group">
        <label for="min_deposito">Mínimo Depósito</label>
        <input type="number" id="min_deposito" name="min_deposito" step="0.01" value="<?= htmlspecialchars($config['min_deposito']) ?>" required>
      </div>
      <div class="form-group">
        <label for="max_deposito">Máximo Depósito</label>
        <input type="number" id="max_deposito" name="max_deposito" step="0.01" value="<?= htmlspecialchars($config['max_deposito']) ?>" required>
      </div>
      <div class="form-group">
        <label for="min_saque">Mínimo Saque</label>
        <input type="number" id="min_saque" name="min_saque" step="0.01" value="<?= htmlspecialchars($config['min_saque']) ?>" required>
      </div>
      <div class="form-group">
        <label for="max_saque">Máximo Saque</label>
        <input type="number" id="max_saque" name="max_saque" step="0.01" value="<?= htmlspecialchars($config['max_saque']) ?>" required>
      </div>
      <div class="form-group">
        <label for="bonus_deposito">Bônus de Depósito (%)</label>
        <input type="number" id="bonus_deposito" name="bonus_deposito" step="0.01" value="<?= htmlspecialchars($config['bonus_deposito']) ?>">
      </div>
      <div class="form-group">
        <label for="tipo_comissao">Tipo de Comissão</label>
        <select id="tipo_comissao" name="tipo_comissao">
          <option value="revshare" <?= $config['tipo_comissao'] == 'revshare' ? 'selected' : '' ?>>RevShare</option>
        </select>
      </div>
      <div class="form-group">
        <label for="valor_comissao">Comissão Afiliados (%)</label>
        <input type="number" id="valor_comissao" name="valor_comissao" step="0.01" value="<?= htmlspecialchars($config['valor_comissao']) ?>" required>
      </div>
      <div class="form-group">
  <label for="valor_comissao_n2">Comissão Afiliados Nível 2 (%)</label>
  <input type="number" id="valor_comissao_n2" name="valor_comissao_n2" step="0.01" value="<?= htmlspecialchars($config['valor_comissao_n2']) ?>" required>
</div>
      <div class="form-group">
        <label for="min_saque_comissao">Mínimo Saque Comissão</label>
        <input type="number" id="min_saque_comissao" name="min_saque_comissao" step="0.01" value="<?= htmlspecialchars($config['min_saque_comissao']) ?>" required>
      </div>
      <div class="form-group">
        <label for="max_saque_comissao">Máximo Saque Comissão</label>
        <input type="number" id="max_saque_comissao" name="max_saque_comissao" step="0.01" value="<?= htmlspecialchars($config['max_saque_comissao']) ?>" required>
      </div>
      <div class="form-group">
        <label for="rollover_multiplicador">Rollover (multiplicador X o valor depositado)</label>
        <input type="number" id="rollover_multiplicador" name="rollover_multiplicador" step="0.1" value="<?= htmlspecialchars($config['rollover_multiplicador']) ?>" required>
      </div>

      <?php foreach ($raspadinhas as $r): ?>
        <div class="raspadinha-bloco">
          <h3 class="raspadinha-titulo">🎟️ <?= htmlspecialchars($r['nome']) ?> (R$<?= number_format($r['valor'], 2, ',', '.') ?>)</h3>

          <div class="raspadinha-chance">
            <label for="chance_ganho_<?= $r['id'] ?>">Chance de Ganho (%)</label>
            <input type="number" id="chance_ganho_<?= $r['id'] ?>" name="chance_ganho_<?= $r['id'] ?>" step="0.0001" value="<?= htmlspecialchars($r['chance_ganho']) ?>" required>
          </div>

          <?php
            $premios = json_decode($r['premios_json'], true);
          ?>
          <div class="form-group" style="margin-top: 20px;">
            <label>Distribuição de Prêmios - Chances (%)</label>
            <div style="display: flex; flex-wrap: wrap; gap: 10px;">
              <?php foreach ($premios as $valorPremio => $chancePremio): ?>
                <div style="flex: 1 1 100px;">
                  <label for="premios_<?= $r['id'] ?>_<?= $valorPremio ?>"><?= htmlspecialchars($valorPremio) ?>:</label>
                  <input
                    type="number"
                    id="premios_<?= $r['id'] ?>_<?= $valorPremio ?>"
                    name="premios_<?= $r['id'] ?>_<?= $valorPremio ?>"
                    value="<?= htmlspecialchars($chancePremio) ?>"
                    step="0.0001" min="0" required
                  >
                </div>
              <?php endforeach; ?>
            </div>
          </div>
        </div>
      <?php endforeach; ?>

      <button type="submit">Salvar Configurações</button>
    </form>
  </div>

  <?php if ($mostrar_popup): ?>
    <div id="overlay-sucesso">
      <div id="popup-sucesso">
        <button id="btn-fechar-popup">&times;</button>
        <strong>✅ Salvo com sucesso!</strong>
      </div>
    </div>

    <script>
      document.getElementById('btn-fechar-popup').addEventListener('click', function () {
        document.getElementById('overlay-sucesso').style.display = 'none';
      });
    </script>
  <?php endif; ?>

</body>
</html>
