<?php
$duracao = 60 * 60 * 24 * 30; // 30 dias

session_set_cookie_params([
    'lifetime' => $duracao,
    'path' => '/',
    'secure' => false,
    'httponly' => true,
    'samesite' => 'Lax'
]);

ini_set('session.gc_maxlifetime', $duracao);
session_start();

require 'db.php';
$config = $pdo->query("SELECT min_deposito, max_deposito FROM configuracoes LIMIT 1")->fetch();
$min = floatval($config['min_deposito']);
$max = floatval($config['max_deposito']);

if (!isset($_SESSION['usuario_id'])) {
    header('Location: index.php');
    exit;
}

$usuarioId = $_SESSION['usuario_id'];
$stmt = $pdo->prepare("SELECT valor, status, criado_em FROM transacoes_pix WHERE usuario_id = ? ORDER BY criado_em DESC");
$stmt->execute([$usuarioId]);
$transacoes = $stmt->fetchAll(PDO::FETCH_ASSOC);
$jsonFile = __DIR__ . '/imagens_menu.json';
$imagens = file_exists($jsonFile) ? json_decode(file_get_contents($jsonFile), true) : [];
$banner1 = isset($imagens['banner1']) ? $imagens['banner1'] : 'banner.webp';
$banner2 = isset($imagens['banner2']) ? $imagens['banner2'] : 'banner2.png';
$dadosJson = file_exists('imagens_menu.json') ? json_decode(file_get_contents('imagens_menu.json'), true) : [];
$logo = isset($dadosJson['logo']) ? $dadosJson['logo'] : 'logo.png';
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <title>Depositar</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
  <link rel=stylesheet href=./css/Kt7nQe9P.css>
</head>
<body>
 
  <div class="container">
    <div class="title">DEPOSITAR</div>
    <div class="tab">PIX</div>
    <form method="POST" action="gerar_pix.php">
<input type="number" name="valor" id="valor" class="input-box" value="<?= $min ?>" min="<?= $min ?>" max="<?= $max ?>" step="1" required>
<div class="subtitle">Mínimo R$ <?= number_format($min, 2, ',', '.') ?> | Máximo: R$ <?= number_format($max, 2, ',', '.') ?></div>
      <div class="quick-buttons">
        <?php
        $valores = [20, 30, 50, 100, 150, 200];
        foreach ($valores as $v) {
            echo "<button type='button' onclick='setValor($v)'>R$ {$v}</button>";
        }
        ?>
      </div>

      <button type="submit" class="generate-btn">Gerar PIX</button>
    </form>
  </div>
    <script>
    function setValor(v) {
    document.getElementById('valor').value = v;
    }
  </script>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<div class="footer">
  <a href="index">
    <div><i class="fas fa-house"></i><br></div>
  </a>
  <a href="menu">
    <div><i class="fas fa-box"></i><br></div>
  </a>
  <a href="deposito" class="deposito-btn">
    <div><i class="fas fa-credit-card"></i><br></div>
  </a>
  <a href="afiliado">
    <div><i class="fas fa-user-plus"></i><br></div>
  </a>
  <a href="perfil">
    <div><i class="fas fa-user-group"></i><br></div>
  </a>
</div>


  <div class="title" style="margin-top: 40px;">Histórico de Depósitos</div>
<?php if (count($transacoes) === 0): ?>
  <div class="subtitle">Nenhuma transação encontrada.</div>
<?php else: ?>
  <div style="margin-top: 10px;">
    <?php foreach ($transacoes as $t): ?>
      <div style="background: #121419; border: 1px solid #333; padding: 10px; border-radius: 8px; margin-bottom: 10px;">
        <div><strong>Valor:</strong> R$ <?= number_format($t['valor'], 2, ',', '.') ?></div>
        <div>
          <strong>Status:</strong>
            <span style="color: <?= $t['status'] === 'aprovado' ? '#00e880' : '#ff0000' ?>; font-weight: bold;">
            <?= $t['status'] === 'aprovado' ? 'Pago' : 'Pendente' ?>
            </span>
        </div>
<?php
  $dataUtc = new DateTime($t['criado_em'], new DateTimeZone('UTC'));
  $dataUtc->setTimezone(new DateTimeZone('America/Sao_Paulo'));
?>
<div><strong>Data:</strong> <?= $dataUtc->format('d/m/Y H:i') ?></div>

      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
  <div style="height: 90px;"></div>
</body>
</html>
