<?php
session_start();
require 'db.php';

if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
  header('Location: login.php');
  exit;
}

// Processa envio do formulário para atualizar gateways
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Adicionar Pixup
    if (isset($_POST['adicionar_gateway']) && $_POST['adicionar_gateway'] === 'pixup') {
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM gateways WHERE nome = 'pixup'");
        $stmt->execute();
        if ($stmt->fetchColumn() == 0) {
            $stmt = $pdo->prepare("INSERT INTO gateways (nome, client_id, client_secret, callback_url, ativo) VALUES ('pixup', '', '', ?, 0)");
            $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
            $callback_url = $protocol . $_SERVER['HTTP_HOST'] . '/callback/Pixup.php';
            $stmt->execute([$callback_url]);
        }
        header('Location: gateways_admin.php?msg=Gateway Pixup adicionado');
        exit;
    }

    // Adicionar ZyroPay
    if (isset($_POST['adicionar_gateway']) && $_POST['adicionar_gateway'] === 'zyropay') {
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM gateways WHERE nome = 'zyropay'");
        $stmt->execute();
        if ($stmt->fetchColumn() == 0) {
            $stmt = $pdo->prepare("INSERT INTO gateways (nome, client_id, client_secret, callback_url, ativo) VALUES ('zyropay', '', '', ?, 0)");
            $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
            $callback_url = $protocol . $_SERVER['HTTP_HOST'] . '/callback/ZyroPay.php';
            $stmt->execute([$callback_url]);
        }
        header('Location: gateways_admin.php?msg=Gateway ZyroPay adicionado');
        exit;
    }

    // Atualiza credenciais e ativo
    $ativo = $_POST['ativo'] ?? '';
    $gateways = $_POST['gateways'] ?? [];

    foreach ($gateways as $id => $dados) {
        $client_id = trim($dados['client_id'] ?? '');
        $client_secret = trim($dados['client_secret'] ?? '');
        $callback_base = trim($dados['callback_base'] ?? '');

        // Buscar o nome do gateway pelo id
        $stmt = $pdo->prepare("SELECT nome FROM gateways WHERE id = ?");
        $stmt->execute([$id]);
        $gateway_nome = $stmt->fetchColumn();

        // Definir callback_url correto sem duplicação
        if ($gateway_nome === 'zyropay') {
            if (strpos($callback_base, '/callback/ZyroPay.php') === false) {
                $callback_url = rtrim($callback_base, '/') . '/callback/ZyroPay.php';
            } else {
                $callback_url = $callback_base;
            }
        } elseif ($gateway_nome === 'pixup') {
            if (strpos($callback_base, '/callback/Pixup.php') === false) {
                $callback_url = rtrim($callback_base, '/') . '/callback/Pixup.php';
            } else {
                $callback_url = $callback_base;
            }
        } else {
            $callback_url = rtrim($callback_base, '/');
        }

        $is_ativo = ($ativo == $id) ? 1 : 0;

        $stmt = $pdo->prepare("UPDATE gateways SET client_id = ?, client_secret = ?, callback_url = ?, ativo = ? WHERE id = ?");
        $stmt->execute([$client_id, $client_secret, $callback_url, $is_ativo, $id]);
    }

    header('Location: gateways_admin.php?msg=Salvo com sucesso!');
    exit;
}

// Busca gateways
$gateways = $pdo->query("SELECT * FROM gateways ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
$mensagem = $_GET['msg'] ?? '';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Configuração de Gateways</title>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet" />
<style>
:root { --bg-dark:#121212; --bg-panel:#1e1e1e; --primary-green:#00ff99; --text-light:#e0e0e0; --radius:12px; --transition:.3s ease; --border-panel:rgba(0,255,153,.1); --box-shadow-hover:0 0 15px rgba(0,255,153,.4);}
*{box-sizing:border-box;margin:0;padding:0;}
body{font-family:'Inter',sans-serif;background:linear-gradient(to bottom right,#0d0d0d,#1a1a1a);color:var(--text-light);min-height:100vh;}
.sidebar{position:fixed;top:0;left:0;width:260px;height:100%;background:#101010;padding:30px 20px;color:var(--primary-green);border-right:2px solid var(--primary-green);}
.sidebar h2{font-size:24px;text-align:center;margin-bottom:30px;font-weight:700;}
.sidebar ul{list-style:none;padding:0;}
.sidebar ul li{margin-bottom:15px;}
.sidebar ul li a{display:block;padding:12px 20px;background:#1b1b1b;color:var(--text-light);border:1px solid transparent;border-radius:var(--radius);text-decoration:none;transition:var(--transition);}
.sidebar ul li a:hover{background-color:var(--primary-green);color:#000;border-color:var(--primary-green);}
.content{margin-left:260px;padding:40px;max-width:calc(100% - 260px);}
h2{font-size:28px;color:var(--primary-green);margin-bottom:30px;}
form{max-width:800px;}
table{width:100%;border-collapse:separate;border-spacing:0 8px;}
thead tr th{padding:14px;color:var(--primary-green);font-weight:700;text-align:left;border-radius:var(--radius);user-select:none;}
tbody tr{box-shadow:0 0 3px rgb(0 255 153);border-radius:20px;transition:box-shadow .3s;}
tbody tr:hover{box-shadow:var(--box-shadow-hover);}
tbody tr td{padding:14px;color:var(--text-light);vertical-align:middle;border:none;}
input[type="text"],input[type="password"]{width:100%;padding:8px;font-size:14px;border:1px solid var(--border-panel);border-radius:var(--radius);background-color:var(--bg-dark);color:var(--text-light);}
input[type="text"]:focus,input[type="password"]:focus{outline:none;border-color:var(--primary-green);box-shadow:0 0 6px var(--primary-green);}
input[type="radio"]{cursor:pointer;width:18px;height:18px;vertical-align:middle;}
label{font-size:14px;color:var(--primary-green);user-select:none;cursor:pointer;}
.btn{padding:12px 20px;background-color:var(--primary-green);color:#000;font-weight:700;border:none;border-radius:var(--radius);cursor:pointer;transition:.3s;margin-top:20px;}
.btn:hover{background-color:#00cc77;}
.msg-sucesso{color:var(--primary-green);margin-bottom:20px;font-weight:600;}
.hidden-field{display:none;}
.switch{position:relative;display:inline-block;width:50px;height:24px;margin-right:10px;}
.switch input{opacity:0;width:0;height:0;}
.slider{position:absolute;cursor:pointer;top:0;left:0;right:0;bottom:0;background-color:#2b2b2b;transition:.4s;border-radius:24px;}
.slider:before{position:absolute;content:"";height:16px;width:16px;left:4px;bottom:4px;background-color:white;transition:.4s;border-radius:50%;}
input:checked + .slider{background-color:var(--primary-green);}
input:focus + .slider{box-shadow:0 0 1px var(--primary-green);}
input:checked + .slider:before{transform:translateX(26px);}
.url-toggle{margin:5px 0;display:flex;align-items:center;}
@media(max-width:768px){.sidebar{position:relative;width:100%;height:auto;border:none;padding:20px;text-align:center;}.sidebar ul{display:flex;flex-wrap:wrap;justify-content:center;gap:15px;}.sidebar ul li{width:auto;margin-bottom:10px;}.content{margin-left:0;padding:20px;max-width:100%;}table{font-size:14px;}}
</style>
</head>
<body>
<div class="sidebar">
<h2>Admin</h2>
<ul>
<li><a href="painel_admin.php">Painel de Controle</a></li>
<li><a href="configuracoes_admin.php">Configurações</a></li>
<li><a href="usuarios_admin.php">Config Usuários</a></li>
<li><a href="saques_admin.php">Saques</a></li>
<li><a href="saques_comissao_admin.php">Saques Afiliado</a></li>
<li><a href="gateways_admin.php">Gateways</a></li>
<li><a href="pix_admin.php">Transacoes</a></li>
</ul>
</div>

<div class="content">
<h2>Configuração de Gateways de Pagamento</h2>

<?php if($mensagem): ?>
<div class="msg-sucesso"><?= htmlspecialchars($mensagem) ?></div>
<?php endif; ?>

<form method="POST" action="gateways_admin.php">
<table>
<thead>
<tr>
<th>Ativo</th>
<th>Gateway</th>
<th>Client ID</th>
<th>Client Secret</th>
<th>Callback (seu dominio)</th>
</tr>
</thead>
<tbody>
<?php foreach($gateways as $g):
if(!in_array($g['nome'],['pixup','zyropay'])) continue;
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!=='off') ? 'https://' : 'http://';
$current_domain = $protocol . $_SERVER['HTTP_HOST'];
$saved_callback = $g['callback_url'] ?? $current_domain;
$is_custom = ($saved_callback !== $current_domain);
?>
<tr>
<td style="text-align:center;">
<input type="radio" name="ativo" value="<?= $g['id'] ?>" <?= $g['ativo']?'checked':'' ?> />
</td>
<td><?= htmlspecialchars(ucfirst($g['nome'])) ?></td>
<td><input type="text" name="gateways[<?= $g['id'] ?>][client_id]" value="<?= htmlspecialchars($g['client_id']) ?>" required /></td>
<td><input type="password" name="gateways[<?= $g['id'] ?>][client_secret]" value="<?= htmlspecialchars($g['client_secret']) ?>" required /></td>
<td>
<div class="url-toggle">
<label class="switch">
<input type="checkbox" class="toggle-url" id="toggle_<?= $g['id'] ?>" <?= $is_custom?'checked':'' ?>>
<span class="slider"></span>
</label>
<label for="toggle_<?= $g['id'] ?>">URL personalizada</label>
</div>

<input type="text" id="auto_url_<?= $g['id'] ?>" value="<?= $current_domain ?>" class="<?= $is_custom?'hidden-field':'' ?>" readonly style="background-color:#333;color:#aaa;" />
<input type="text" id="custom_url_<?= $g['id'] ?>" name="gateways[<?= $g['id'] ?>][callback_base]" value="<?= $is_custom?htmlspecialchars($saved_callback):'' ?>" placeholder="https://seudominio.com" class="<?= $is_custom?'':'hidden-field' ?>" />
<input type="hidden" id="actual_url_<?= $g['id'] ?>" name="gateways[<?= $g['id'] ?>][callback_base]" value="<?= htmlspecialchars($saved_callback) ?>" />
</td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
<button class="btn" type="submit">Salvar Configurações</button>
</form>

<?php
foreach(['pixup'=>'#0077ff','zyropay'=>'#ff6600'] as $gw=>$color):
$stmt = $pdo->prepare("SELECT COUNT(*) FROM gateways WHERE nome=?");
$stmt->execute([$gw]);
$exists = $stmt->fetchColumn()>0;
if(!$exists):
?>
<form method="POST" action="gateways_admin.php" style="margin-top:10px;">
<input type="hidden" name="adicionar_gateway" value="<?= $gw ?>">
<button class="btn" type="submit" style="background-color:<?= $color ?>;">Adicionar Gateway <?= ucfirst($gw) ?></button>
</form>
<?php
endif;
endforeach;
?>

</div>

<script>
function toggleCustomUrl(id){
const toggle=document.getElementById(`toggle_${id}`);
const autoField=document.getElementById(`auto_url_${id}`);
const customField=document.getElementById(`custom_url_${id}`);
const actualField=document.getElementById(`actual_url_${id}`);
if(toggle.checked){
autoField.classList.add('hidden-field');
customField.classList.remove('hidden-field');
customField.required=true;
if(customField.value){ actualField.value=customField.value; }
}else{
autoField.classList.remove('hidden-field');
customField.classList.add('hidden-field');
customField.required=false;
actualField.value=autoField.value;
}
}
document.addEventListener('DOMContentLoaded',function(){
const toggles=document.querySelectorAll('.toggle-url');
toggles.forEach(toggle=>{
const id=toggle.id.split('_')[1];
const customField=document.getElementById(`custom_url_${id}`);
const actualField=document.getElementById(`actual_url_${id}`);
customField.addEventListener('input',function(){
if(toggle.checked){ actualField.value=this.value; }
});
});
});
</script>
</body>
</html>
