<?php
session_start();
date_default_timezone_set('America/Sao_Paulo');
if (!isset($_SESSION['admin_id'])) {
    header("Location: login_admin.php");
    exit;
}
require 'db.php';
$usuarios = $pdo->query("SELECT COUNT(*) FROM usuarios")->fetchColumn();
// Soma o valor de todos os PIX com status 'pendente'
$total_pix_pendente = $pdo->query("SELECT SUM(valor) FROM transacoes_pix WHERE status = 'pendente'")->fetchColumn();

// Formata como moeda
$total_pix_pendente_raw = $total_pix_pendente ?? 0;
$total_depositos_pagos_raw = $pdo->query("
    SELECT SUM(valor) 
    FROM transacoes_pix 
    WHERE status = 'aprovado'
")->fetchColumn() ?? 0;

// Soma ambos para obter o total geral (pendente + aprovado)
$total_depositos_gerados_raw = $total_pix_pendente_raw + $total_depositos_pagos_raw;

// Formata os valores
$total_pix_pendente = number_format($total_pix_pendente_raw, 2, ',', '.');
$total_depositos_pagos = number_format($total_depositos_pagos_raw, 2, ',', '.');
$total_depositos_gerados = number_format($total_depositos_gerados_raw, 2, ',', '.');


// Soma o valor de todos os saques com status 'recusado' ou 'pendente'
$total_saques_recusados = $pdo->query("
    SELECT SUM(valor) 
    FROM saques 
    WHERE status IN ('recusado', 'pendente')
")->fetchColumn();

// Formata como moeda
$total_saques_recusados = number_format($total_saques_recusados ?? 0, 2, ',', '.');

// Soma o valor de todos os saques com status 'aprovado'
$total_saques_pagos = $pdo->query("
    SELECT SUM(valor) 
    FROM saques 
    WHERE status = 'aprovado'
")->fetchColumn();

// Formata como moeda
$total_saques_pagos = number_format($total_saques_pagos ?? 0, 2, ',', '.');

// Soma o valor de todos os depósitos com status 'aprovado'
$total_depositos_pagos = $pdo->query("
    SELECT SUM(valor) 
    FROM transacoes_pix 
    WHERE status = 'aprovado'
")->fetchColumn();

// Formata como moeda
$total_depositos_pagos = number_format($total_depositos_pagos ?? 0, 2, ',', '.');



// Upload dos banners (usando JSON dinâmico)
// Caminhos e variáveis comuns
$jsonFile = __DIR__ . '/imagens_menu.json';
$diretorio = __DIR__ . '/images';
$formatosPermitidos = ['png', 'jpg', 'jpeg', 'webp', 'gif'];

if (!is_dir($diretorio)) {
    mkdir($diretorio, 0755, true);
}

$dadosJson = file_exists($jsonFile) ? json_decode(file_get_contents($jsonFile), true) : [];

// Função para salvar imagem e atualizar JSON
function salvarImagem($alvo, $arquivo, &$mensagem, &$dadosJson, $jsonFile, $diretorio, $formatosPermitidos) {
    if ($arquivo['error'] === 0) {
        $extensao = strtolower(pathinfo($arquivo['name'], PATHINFO_EXTENSION));

        if (in_array($extensao, $formatosPermitidos)) {
            $nomeFinal = "$alvo.$extensao";
            $destino = "$diretorio/$nomeFinal";

            if (move_uploaded_file($arquivo['tmp_name'], $destino)) {
                $dadosJson[$alvo] = $nomeFinal;
                file_put_contents($jsonFile, json_encode($dadosJson, JSON_PRETTY_PRINT));
                $mensagem = "<p style='color:green;'><strong>✅ Imagem atualizada com sucesso!</strong></p>";
            } else {
                $mensagem = "<p style='color:red;'><strong>❌ Erro ao mover o arquivo!</strong></p>";
            }
        } else {
            $mensagem = "<p style='color:red;'><strong>❌ Formato não permitido! (png, jpg, jpeg, webp, gif)</strong></p>";
        }
    } else {
        $mensagem = "<p style='color:red;'><strong>❌ Erro no envio do arquivo.</strong></p>";
    }
}

// Processamento do upload de banner
$msgBanner = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['alvo'], $_FILES['imagem'])) {
    $alvo = $_POST['alvo'];
    if (in_array($alvo, ['banner1', 'banner2'])) {
        salvarImagem($alvo, $_FILES['imagem'], $msgBanner, $dadosJson, $jsonFile, $diretorio, $formatosPermitidos);
    } else {
        $msgBanner = "<p style='color:red;'><strong>❌ Alvo de banner inválido.</strong></p>";
    }
}

// Processamento do upload de imagem do menu
$msgMenu = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['alvo_menu'], $_FILES['imagem_menu'], $_POST['enviar_menu'])) {
    $alvoMenu = $_POST['alvo_menu'];
    if (in_array($alvoMenu, ['menu1', 'menu2', 'menu3', 'menu4', 'menu5'])) {
        salvarImagem($alvoMenu, $_FILES['imagem_menu'], $msgMenu, $dadosJson, $jsonFile, $diretorio, $formatosPermitidos);
    } else {
        $msgMenu = "<p style='color:red;'><strong>❌ Alvo do menu inválido.</strong></p>";
    }
}

// Upload da logo
$msgLogo = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['alvo_logo'], $_FILES['imagem_logo'], $_POST['enviar_logo'])) {
    $alvoLogo = $_POST['alvo_logo'];
    if ($alvoLogo === 'logo') {
        salvarImagem($alvoLogo, $_FILES['imagem_logo'], $msgLogo, $dadosJson, $jsonFile, $diretorio, $formatosPermitidos);
    } else {
        $msgLogo = "<p style='color:red;'><strong>❌ Alvo de logo inválido.</strong></p>";
    }
}


// Upload das imagens da raspadinha

// Carrega imagens da raspadinha (se existirem)
$imgJson = __DIR__ . '/images/imagens_raspadinha.json';
$imagensRaspadinha = file_exists($imgJson) ? json_decode(file_get_contents($imgJson), true) : [];

$imgRaspeAqui = isset($imagensRaspadinha['raspe_aqui']) ? $imagensRaspadinha['raspe_aqui'] : 'RASPE-AQUI.png';
$imgBannerGame = isset($imagensRaspadinha['banner_game']) ? $imagensRaspadinha['banner_game'] : 'banner-game.png';


$msgRaspadinha = '';
$formatosPermitidos = ['png', 'jpg', 'jpeg', 'webp', 'gif'];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['alvo_raspadinha']) && isset($_FILES['imagem_raspadinha'])) {
    $alvo = $_POST['alvo_raspadinha'];
    $imagem = $_FILES['imagem_raspadinha'];

    if (in_array($alvo, ['raspe_aqui', 'banner_game']) && $imagem['error'] === 0) {
        $extensao = strtolower(pathinfo($imagem['name'], PATHINFO_EXTENSION));

        if (in_array($extensao, $formatosPermitidos)) {
            $nomeArquivo = "$alvo.$extensao";
            $diretorio = __DIR__ . "/images";

            if (!is_dir($diretorio)) mkdir($diretorio, 0755, true);

            if (move_uploaded_file($imagem['tmp_name'], "$diretorio/$nomeArquivo")) {
                $jsonFile = __DIR__ . '/images/imagens_raspadinha.json';
                $dados = file_exists($jsonFile) ? json_decode(file_get_contents($jsonFile), true) : [];
                $dados[$alvo] = $nomeArquivo;
                file_put_contents($jsonFile, json_encode($dados, JSON_PRETTY_PRINT));

                $msgRaspadinha = "<p style='color:green;'>✅ Imagem atualizada com sucesso!</p>";
            } else {
                $msgRaspadinha = "<p style='color:red;'>❌ Erro ao mover o arquivo!</p>";
            }
        } else {
            $msgRaspadinha = "<p style='color:red;'>❌ Formato inválido!</p>";
        }
    }
}

// Total apostado
$total_apostado = $pdo->query("SELECT SUM(valor_apostado) FROM historico_jogos")->fetchColumn();
$total_apostado = number_format($total_apostado ?? 0, 2, ',', '.');

// Total ganho pelos usuários
$total_ganho = $pdo->query("SELECT SUM(valor_premiado) FROM historico_jogos")->fetchColumn();
$total_ganho = number_format($total_ganho ?? 0, 2, ',', '.');

// Total perdido (apostas - prêmios)
$total_perdido = $pdo->query("
    SELECT SUM(valor_apostado - valor_premiado) 
    FROM historico_jogos
")->fetchColumn();
$total_perdido = number_format($total_perdido ?? 0, 2, ',', '.');

// Lucro bruto da plataforma (mesmo cálculo que perda)
$lucro_bruto = $total_perdido;

// Pega cadastros de hoje
$hoje = date('Y-m-d');

$stmt = $pdo->prepare("SELECT COUNT(*) FROM usuarios WHERE DATE(data_cadastro) = ?");
$stmt->execute([$hoje]);
$cadastrosHoje = $stmt->fetchColumn();

$depositosPorDia = [];
for ($i = 6; $i >= 0; $i--) {
    $data = date('Y-m-d', strtotime("-$i days"));
    $stmt = $pdo->prepare("SELECT SUM(valor) FROM transacoes_pix WHERE status = 'aprovado' AND DATE(criado_em) = ?");
    $stmt->execute([$data]);
    $totalDia = $stmt->fetchColumn() ?? 0;
    $depositosPorDia[$data] = (float)$totalDia;
}

$datas = array_keys($depositosPorDia);
$valores = array_values($depositosPorDia);

$cadastrosPorDia = [];
for ($i = 6; $i >= 0; $i--) {
    $data = date('Y-m-d', strtotime("-$i days"));
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM usuarios WHERE DATE(data_cadastro) = ?");
    $stmt->execute([$data]);
    $totalCadastros = $stmt->fetchColumn() ?? 0;
    $cadastrosPorDia[$data] = (int)$totalCadastros;
}

$datasCadastros = array_keys($cadastrosPorDia);
$valoresCadastros = array_values($cadastrosPorDia);


?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Painel de Controle - Admin</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
  <style>
    :root {
      --bg-dark: #121212;
      --bg-panel: #1e1e1e;
      --primary-green: #00ff99;
      --text-light: #e0e0e0;
      --radius: 12px;
      --transition: 0.3s ease;
    }

    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(to bottom right, #0d0d0d, #1a1a1a);
      color: var(--text-light);
    }

    .sidebar {
      position: fixed;
      top: 0;
      left: 0;
      width: 260px;
      height: 100%;
      background: #101010;
      padding: 30px 20px;
      color: var(--primary-green);
      border-right: 2px solid #00ff99;
    }

    .sidebar h2 {
      font-size: 24px;
      text-align: center;
      margin-bottom: 30px;
    }

    .sidebar a {
      display: block;
      padding: 12px 20px;
      margin-bottom: 15px;
      background-color: #1b1b1b;
      color: var(--text-light);
      border: 1px solid transparent;
      border-radius: var(--radius);
      text-decoration: none;
      transition: var(--transition);
    }

    .sidebar a:hover {
      background-color: #00ff99;
      color: #000;
      border-color: #00ff99;
    }

    .content {
      margin-left: 260px;
      padding: 20px 10px;
    }

    h1 {
      font-size: 28px;
      color: var(--primary-green);
      margin-bottom: 30px;
    }

    .cards {
      display: flex;
      flex-wrap: wrap;
      gap: 20px;
    }

    .card {
      background: var(--bg-panel);
      border-radius: var(--radius);
      box-shadow: var(--card-glow);
      padding: 20px;
      flex: 1 1 calc(33.333% - 20px);
      min-width: 280px;
      border: 1px solid rgba(0, 255, 153, 0.1);
      transition: transform 0.2s, box-shadow 0.3s;
    }

    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0;
    }

    .card h3 {
      font-size: 16px;
      color: #ccc;
      margin-bottom: 8px;
    }

    .card p {
      font-size: 20px;
      font-weight: bold;
      color: var(--primary-green);
    }

    form input[type="file"],
    form select,
    form button {
      display: block;
      width: 100%;
      margin-top: 10px;
      margin-bottom: 20px;
      padding: 12px;
      font-size: 14px;
      border-radius: var(--radius);
      border: 1px solid #444;
      background-color: #1f1f1f;
      color: var(--text-light);
    }

    form button {
      background-color: var(--primary-green);
      color: black;
      font-weight: bold;
      cursor: pointer;
      transition: var(--transition);
    }

    form button:hover {
      background-color: #00cc77;
    }

    #preview-logo img,
    #preview-area img,
    #preview-menu img,
    #preview-raspadinha img {
      max-width: 100%;
      border: 1px solid #00ff99;
      border-radius: var(--radius);
      margin-top: 10px;
    }

    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        padding: 20px;
      }

      .content {
        margin-left: 0;
        padding: 20px;
      }

      .cards {
        flex-direction: column;
      }
    }
  </style>
</head>


<body>
  <div class="sidebar">
    <h2>Admin</h2>
    <a href="#">Painel de Controle</a>
    <a href="configuracoes_admin.php">Configurações</a>
    <a href="usuarios_admin.php">Config Usuários</a>
    <a href="saques_admin.php">Saques</a>
    <a href="saques_comissao_admin.php">Saques Afiliado</a>
    <a href="gateways_admin.php">Gateways</a>
    <a href="pix_admin.php">Transacoes</a>
  </div>
  
 

  <div class="content">
    <h1>Painel de Admin</h1>
    
  <div style="display: flex; gap: 20px; margin-top: 90px;">
  <div style="flex: 1 1 0; padding: 0;">
    <h2 style="color: var(--primary-green); text-align: center;">Depósitos Últimos 7 Dias</h2>
    <canvas id="depositosChart" style="width: 100%; height: 300px; display: block;"></canvas>
  </div>
  
  <div style="flex: 1 1 0; padding: 0;">
    <h2 style="color: var(--primary-green); text-align: center;">Cadastros Últimos 7 Dias</h2>
    <canvas id="cadastrosChart" style="width: 100%; height: 300px; display: block;"></canvas>
  </div>
</div>
</br>
    <?= $msgBanner ?>
    <div class="cards">
      <div class="card">
        <h3>Total Usuários</h3>
        <p><?php echo $usuarios; ?></p>
      </div>
      <div class="card">
  <h3>Cadastros Hoje</h3>
  <p><strong><?= $cadastrosHoje ?></strong></p>
</div>
      <div class="card">
        <h3>Total Ganhos</h3>
        <p>R$<?= $total_ganho ?></p>
      </div>
            <div class="card">
        <h3>Total Depósitos Gerados</h3>
        <p>R$<?= $total_depositos_gerados ?></p>
      </div>

      <div class="card">
        <h3>Ganhos Bruto da Plataforma</h3>
        <p>R$<?= $lucro_bruto ?></p>
      </div>
      <div class="card">
        <h3>Total Perdas</h3>
        <p>R$<?= $total_perdido ?></p>
      </div>
      <div class="card">
        <h3>Total Depósitos Pagos</h3>
        <p>R$<?= $total_depositos_pagos ?></p>
      </div>
      <div class="card">
        <h3>Total Saques Pagos</h3>
        <p>R$<?= $total_saques_pagos ?></p>
      </div>
      <div class="card">
        <h3>Total Apostado</h3>
        <p>R$<?= $total_apostado ?></p>
      </div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
  const ctx = document.getElementById('depositosChart').getContext('2d');

  // Dados vindos do PHP
  const labels = <?= json_encode($datas) ?>;
  const dataValores = <?= json_encode($valores) ?>;

  const depositosChart = new Chart(ctx, {
    type: 'line',
    data: {
      labels: labels,
      datasets: [{
        label: 'Depósitos Aprovados (R$)',
        data: dataValores,
        borderColor: 'rgba(0, 255, 153, 0.8)',
        backgroundColor: 'rgba(0, 255, 153, 0.2)',
        fill: true,
        tension: 0.3,
        pointRadius: 5,
        pointHoverRadius: 7,
        borderWidth: 2,
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: {
          labels: {
            color: '#00ff99',
            font: {
              size: 14,
              weight: 'bold',
            }
          }
        },
        tooltip: {
          mode: 'index',
          intersect: false,
          backgroundColor: 'rgba(0,0,0,0.8)',
          titleColor: '#00ff99',
          bodyColor: '#e0e0e0',
          borderColor: '#00ff99',
          borderWidth: 1,
        }
      },
      scales: {
        x: {
          ticks: {
            color: '#e0e0e0',
          },
          grid: {
            color: 'rgba(0, 255, 153, 0.1)',
          }
        },
        y: {
          ticks: {
            color: '#e0e0e0',
            callback: function(value) {
              return 'R$ ' + value.toLocaleString('pt-BR', {minimumFractionDigits: 2});
            }
          },
          grid: {
            color: 'rgba(0, 255, 153, 0.1)',
          },
          beginAtZero: true,
        }
      }
    }
  });
</script>

<script>
  const ctxCadastros = document.getElementById('cadastrosChart').getContext('2d');
  const labelsCadastros = <?= json_encode($datasCadastros) ?>;
  const dataCadastros = <?= json_encode($valoresCadastros) ?>;

  const cadastrosChart = new Chart(ctxCadastros, {
  type: 'line',
  data: {
    labels: labelsCadastros,
    datasets: [{
      label: 'Cadastros por Dia',
      data: dataCadastros,
      borderColor: 'rgba(0, 255, 153, 0.8)',
      backgroundColor: 'rgba(0, 255, 153, 0.2)',
      fill: true,
      tension: 0.3,
      pointRadius: 5,
      pointHoverRadius: 7,
      borderWidth: 2
    }]
  },
options: {
  responsive: true,
  interaction: {
    mode: 'index',
    intersect: false
  },
  scales: {
    x: {
      ticks: { color: '#e0e0e0' },
      grid: { color: 'rgba(0,255,153,0.1)' }
    },
    y: {
      beginAtZero: true,
      ticks: { color: '#e0e0e0' },
      grid: { color: 'rgba(0,255,153,0.1)' }
    }
  },
  plugins: {
    legend: {
      labels: {
        color: '#00ff99',
        font: { size: 14 }
      }
    },
    tooltip: {
      backgroundColor: 'rgba(0,0,0,0.8)',
      titleColor: '#00ff99',
      bodyColor: '#e0e0e0',
      borderColor: '#00ff99',
      borderWidth: 1
    }
  }
}
});
</script>


<div class="cards">

  <!-- EDIÇÃO DA LOGO -->
  <div class="card">
    <h3>Editar Logo da Plataforma (600x200)</h3>
    <?= $msgLogo ?? '' ?>
    <form method="POST" enctype="multipart/form-data" style="margin-top: 10px;">
      <input type="hidden" name="alvo_logo" value="logo">

      <div id="preview-logo" style="margin-bottom: 10px;">
        <?php
        $logo = isset($dadosJson['logo']) ? $dadosJson['logo'] : 'logo.png';
        echo '<strong>Logo atual:</strong><br><img src="/images/' . $logo . '?' . time() . '" style="max-width:100%; border:1px solid #ccc; margin-top:10px; border-radius:10px;">';
        ?>
      </div>

      <label for="imagem_logo">Nova Logo:</label>
      <input type="file" name="imagem_logo" accept="image/*" required>

      <button type="submit" name="enviar_logo">
        Atualizar Logo
      </button>
    </form>
  </div>

  <!-- EDIÇÃO DE IMAGENS DO MENU -->
  <div class="card">
    <h3>Editar Imagens do Menu de Caixas</h3>
    <?= $msgMenu ?? '' ?>
    <form method="post" enctype="multipart/form-data" style="margin-top: 10px;">
      <label for="alvo_menu">Selecionar imagem:</label>
<select name="alvo_menu" id="alvo_menu" required onchange="mostrarPreviewMenu()">
  <option value="menu1" selected>Caixas R$1</option>
  <option value="menu2">Caixas R$2</option>
  <option value="menu3">Caixas R$5</option>
  <option value="menu4">Caixas R$25</option>
  <option value="menu5">Caixas R$50</option>
</select>

      <div id="preview-menu" style="margin: 10px 0;"></div>

      <label for="imagem_menu">Nova Imagem:</label>
      <input type="file" name="imagem_menu" accept="image/*" required>

      <button type="submit" name="enviar_menu">
        Atualizar Imagem
      </button>
    </form>
  </div>

  <!-- EDIÇÃO DE BANNERS -->
  <div class="card">
    <h3>Editar Banners da Página Inicial</h3>
    <form method="POST" enctype="multipart/form-data" style="margin-top: 10px;">
      <label for="alvo">Selecionar banner:</label>
<select name="alvo" id="alvo" required onchange="mostrarPreview()">
  <option value="banner1" selected>Banner Principal (Topo)</option>
</select>

      <div id="preview-area" style="margin: 10px 0;"></div>

      <label for="imagem">Nova Imagem:</label>
      <input type="file" name="imagem" accept="image/*" required>

      <button type="submit">
        Atualizar Banner
      </button>
    </form>
  </div>

</div> <!-- /cards -->





<script>
function mostrarPreviewRaspadinha() {
  const alvo = document.getElementById('alvo_raspadinha').value;
  const preview = document.getElementById('preview-raspadinha');

  if (!alvo) {
    preview.innerHTML = '';
    return;
  }

  fetch('/images/imagens_raspadinha.json?v=' + Date.now())
    .then(res => res.json())
    .then(data => {
      let nome = data[alvo] || `${alvo}.png`;

      preview.innerHTML = `
        <strong>Imagem atual:</strong><br>
        <img src="/images/${nome}?v=${Date.now()}" style="max-width:100%; border:1px solid #ccc; margin-top:10px; border-radius:10px;">
      `;
    })
    .catch(() => {
      preview.innerHTML = `
        <strong>Imagem atual:</strong><br>
        <img src="/images/${alvo}.png?v=${Date.now()}" style="max-width:100%; border:1px solid #ccc; margin-top:10px; border-radius:10px;">
      `;
    });
}

</script>




<script>
// Banner preview
function mostrarPreview() {
  const alvo = document.getElementById('alvo').value;
  const preview = document.getElementById('preview-area');

  if (!alvo) {
    preview.innerHTML = '';
    return;
  }

  fetch('/imagens_menu.json')
    .then(res => res.json())
    .then(data => {
      const nome = data[alvo] || `${alvo}.png`;
      preview.innerHTML = `
        <strong>Banner atual:</strong><br>
        <img src="/images/${nome}?v=${Date.now()}" style="max-width:100%; border:1px solid #ccc; margin-top:10px; border-radius:10px;">
      `;
    })
    .catch(() => {
      preview.innerHTML = `
        <strong>Banner atual:</strong><br>
        <img src="/images/${alvo}.png?v=${Date.now()}" style="max-width:100%; border:1px solid #ccc; margin-top:10px; border-radius:10px;">
      `;
    });
}

// Menu preview
function mostrarPreviewMenu() {
  const alvo = document.getElementById('alvo_menu').value;
  const preview = document.getElementById('preview-menu');

  if (!alvo) {
    preview.innerHTML = '';
    return;
  }

  fetch('/imagens_menu.json')
    .then(res => res.json())
    .then(data => {
      const nome = data[alvo] || `${alvo}.png`;
      preview.innerHTML = `
        <strong>Imagem atual:</strong><br>
        <img src="/images/${nome}?v=${Date.now()}" style="max-width:100%; border:1px solid #ccc; margin-top:10px; border-radius:10px;">
      `;
    })
    .catch(() => {
      preview.innerHTML = `
        <strong>Imagem atual:</strong><br>
        <img src="/images/${alvo}.png?v=${Date.now()}" style="max-width:100%; border:1px solid #ccc; margin-top:10px; border-radius:10px;">
      `;
    });
}

// Raspadinha preview
function mostrarPreviewRaspadinha() {
  const alvo = document.getElementById('alvo_raspadinha').value;
  const preview = document.getElementById('preview-raspadinha');

  if (!alvo) {
    preview.innerHTML = '';
    return;
  }

  fetch('/images/imagens_raspadinha.json?v=' + Date.now())
    .then(res => res.json())
    .then(data => {
      const nome = data[alvo] || `${alvo}.png`;
      preview.innerHTML = `
        <strong>Imagem atual:</strong><br>
        <img src="/images/${nome}?v=${Date.now()}" style="max-width:100%; border:1px solid #ccc; margin-top:10px; border-radius:10px;">
      `;
    })
    .catch(() => {
      preview.innerHTML = `
        <strong>Imagem atual:</strong><br>
        <img src="/images/${alvo}.png?v=${Date.now()}" style="max-width:100%; border:1px solid #ccc; margin-top:10px; border-radius:10px;">
      `;
    });
}

// Chama preview inicial ao carregar
document.addEventListener("DOMContentLoaded", () => {
  if (document.getElementById('alvo')) mostrarPreview();
  if (document.getElementById('alvo_menu')) mostrarPreviewMenu();
  if (document.getElementById('alvo_raspadinha')) mostrarPreviewRaspadinha();
});
</script>




    </div>
  </div>
</body>
</html>
