<?php
session_start();
require 'db.php';
date_default_timezone_set('America/Sao_Paulo');


if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
  header('Location: login.php');
  exit;
}

// Filtro status (opcional)
$status_filter = $_GET['status'] ?? '';
$data_inicial = $_GET['data_inicial'] ?? '';
$data_final = $_GET['data_final'] ?? '';


// Paginação simples
$pagina = max(1, intval($_GET['pagina'] ?? 1));
$limite = 20;
$offset = ($pagina - 1) * $limite;

// Query base
// Filtra para listagem e estatísticas
$where = [];
$params = [];

if ($status_filter && in_array($status_filter, ['pendente', 'aprovado', 'cancelado'])) {
  $where[] = "status = ?";
  $params[] = $status_filter;
}

if ($data_inicial) {
  $where[] = "DATE(criado_em) >= ?";
  $params[] = $data_inicial;
}

if ($data_final) {
  $where[] = "DATE(criado_em) <= ?";
  $params[] = $data_final;
}

$where_sql = count($where) ? 'WHERE ' . implode(' AND ', $where) : '';

// Paginação
$stmtTotal = $pdo->prepare("SELECT COUNT(*) FROM transacoes_pix $where_sql");
$stmtTotal->execute($params);
$total = $stmtTotal->fetchColumn();

$totalPaginas = ceil($total / $limite);

$stmt = $pdo->prepare("SELECT * FROM transacoes_pix $where_sql ORDER BY criado_em DESC LIMIT $limite OFFSET $offset");
$stmt->execute($params);
$transacoes = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Estatísticas
$stmtStats = $pdo->prepare("SELECT status, COUNT(*) as total FROM transacoes_pix $where_sql GROUP BY status");
$stmtStats->execute($params);

$stats = ['aprovado' => 0, 'pendente' => 0, 'cancelado' => 0];
$totalGeral = 0;

while ($row = $stmtStats->fetch(PDO::FETCH_ASSOC)) {
  $status = strtolower($row['status']);
  $stats[$status] = (int)$row['total'];
  $totalGeral += (int)$row['total'];
}



// Calcular porcentagem de aprovação
$percentualAprovado = $totalGeral > 0 ? round(($stats['aprovado'] / $totalGeral) * 100, 2) : 0;

?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Transações PIX</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet" />
  <style>
    :root {
      --bg-dark: #121212;
      --bg-panel: #1e1e1e;
      --primary-green: #00ff99;
      --text-light: #e0e0e0;
      --radius: 12px;
      --transition: 0.3s ease;
      --border-panel: rgba(0, 255, 153, 0.1);
      --box-shadow-hover: 0 0 15px rgba(0, 255, 153, 0.4);
    }
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }
    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(to bottom right, #0d0d0d, #1a1a1a);
      color: var(--text-light);
      min-height: 100vh;
    }
    .sidebar {
      position: fixed;
      top: 0;
      left: 0;
      width: 260px;
      height: 100%;
      background: #101010;
      padding: 30px 20px;
      color: var(--primary-green);
      border-right: 2px solid var(--primary-green);
    }
    .sidebar h2 {
      font-size: 24px;
      text-align: center;
      margin-bottom: 30px;
      font-weight: 700;
    }
    .sidebar ul {
      list-style: none;
      padding: 0;
    }
    .sidebar ul li {
      margin-bottom: 15px;
    }
    .sidebar ul li a {
      display: block;
      padding: 12px 20px;
      background-color: #1b1b1b;
      color: var(--text-light);
      border: 1px solid transparent;
      border-radius: var(--radius);
      text-decoration: none;
      transition: var(--transition);
    }
    .sidebar ul li a:hover,
    .sidebar ul li a.active {
      background-color: var(--primary-green);
      color: #000;
      border-color: var(--primary-green);
    }
    .content {
      margin-left: 260px;
      padding: 40px;
      max-width: calc(100% - 260px);
    }
    h2 {
      font-size: 28px;
      color: var(--primary-green);
      margin-bottom: 30px;
    }
    table {
      width: 100%;
      border-collapse: separate;
      border-spacing: 0 8px;
      background: transparent;
    }
    thead tr th {
      padding: 14px;
      color: var(--primary-green);
      font-weight: 700;
      text-align: left;
      border-radius: var(--radius);
      user-select: none;
    }
    tbody tr {
      box-shadow: 0 0 3px rgb(0 255 153);
      border-radius: 20px;
      transition: box-shadow 0.3s;
      background: ;
    }
    tbody tr:hover {
      box-shadow: var(--box-shadow-hover);
    }
    tbody tr td {
      padding: 14px;
      color: var(--text-light);
      vertical-align: middle;
      border: none;
      font-family: monospace;
    }
    select, .btn {
      padding: 10px 16px;
      font-size: 14px;
      border-radius: var(--radius);
      border: 1px solid var(--border-panel);
      background: var(--bg-dark);
      color: var(--text-light);
      cursor: pointer;
      margin-bottom: 20px;
      transition: 0.3s;
    }
    select:hover, .btn:hover {
      border-color: var(--primary-green);
      box-shadow: 0 0 6px var(--primary-green);
    }
    .pagination {
      margin-top: 25px;
      text-align: center;
    }
    .pagination a {
      color: var(--primary-green);
      text-decoration: none;
      margin: 0 8px;
      font-weight: 600;
      user-select: none;
    }
    .msg-sucesso {
      color: var(--primary-green);
      margin-bottom: 20px;
      font-weight: 600;
    }
    
          .status-aprovado {
  color: #00ff99;
  font-weight: 600;
}

.status-pendente {
  color: #ffa500;
  font-weight: 600;
}

.status-cancelado {
  color: #ff4d4d;
  font-weight: 600;
}

input[type="date"] {
  background: #00ff99;
  color: #000000;
  border: 1px solid var(--border-panel);
  padding: 10px 16px;
  border-radius: var(--radius);
  transition: 0.3s;
}

input[type="date"]:hover {
  border-color: var(--primary-green);
  box-shadow: 0 0 6px var(--primary-green);
}

    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        border: none;
        padding: 20px;
        text-align: center;
      }
      .sidebar ul {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 15px;
      }
      .sidebar ul li {
        width: auto;
        margin-bottom: 10px;
      }
      .content {
        margin-left: 0;
        padding: 20px;
        max-width: 100%;
      }
      table {
        font-size: 14px;
      }
    }
  </style>
</head>
<body>
  <div class="sidebar">
    <h2>Admin</h2>
    <ul>
      <li><a href="painel_admin.php">Painel de Controle</a></li>
      <li><a href="configuracoes_admin.php">Configurações</a></li>
      <li><a href="usuarios_admin.php">Config Usuários</a></li>
      <li><a href="saques_admin.php">Saques</a></li>
      <li><a href="saques_comissao_admin.php">Saques Afiliado</a></li>
      <li><a href="gateways_admin.php">Gateways</a></li>
      <li><a href="pix_admin.php">Transacoes</a></li>
    </ul>
  </div>

  <div class="content">
    <h2>Transações PIX</h2>

    <?php if ($mensagem): ?>
      <div class="msg-sucesso"><?= htmlspecialchars($mensagem) ?></div>
    <?php endif; ?>


    <form method="GET" action="" style="margin-bottom: 15px;">
      <label for="status">Filtrar por status:</label>
      <select name="status" id="status" onchange="this.form.submit()">
        <option value="" <?= $status_filter === '' ? 'selected' : '' ?>>Todos</option>
        <option value="pendente" <?= $status_filter === 'pendente' ? 'selected' : '' ?>>Pendente</option>
        <option value="aprovado" <?= $status_filter === 'aprovado' ? 'selected' : '' ?>>Aprovado</option>
        <option value="cancelado" <?= $status_filter === 'cancelado' ? 'selected' : '' ?>>Cancelado</option>
      </select>
    </form>
    
<form method="GET" action="" style="margin-bottom: 20px; display: flex; gap: 10px; align-items: center; flex-wrap: wrap;">


  <label for="data_inicial">Data:</label>
  <input type="date" name="data_inicial" id="data_inicial" value="<?= htmlspecialchars($_GET['data_inicial'] ?? '') ?>" onchange="this.form.submit()">

  <label for="data_final">Até:</label>
  <input type="date" name="data_final" id="data_final" value="<?= htmlspecialchars($_GET['data_final'] ?? '') ?>" onchange="this.form.submit()">
</form>


    <div style="margin-bottom: 30px; background: var(--bg-panel); padding: 20px; border-radius: var(--radius); border: 1px solid var(--border-panel); box-shadow: 0 0 10px rgba(0,255,153,0.2);">
  <h3 style="margin-bottom: 10px; color: var(--primary-green);">Resumo Geral</h3>
  <p>Total de Transações: <strong><?= $totalGeral ?></strong></p>
  <p>Aprovadas: <strong style="color:#00ff99"><?= $stats['aprovado'] ?></strong></p>
  <p>Pendentes: <strong style="color:#ffa500"><?= $stats['pendente'] ?></strong></p>
  <p>Canceladas: <strong style="color:#ff4d4d"><?= $stats['cancelado'] ?></strong></p>
  <p>Taxa de Aprovação: <strong style="color:<?= $percentualAprovado >= 80 ? '#00ff99' : ($percentualAprovado >= 50 ? '#ffa500' : '#ff4d4d') ?>"><?= $percentualAprovado ?>%</strong></p>
</div>
    <table>
      <thead>
        <tr>
          <th>ID</th>
          <th>Usuário</th>
          <th>Telefone</th>
          <th>Valor (R$)</th>
          <th>External ID</th>
          <th>Status</th>
          <th>Criado em</th>
          <th>Transaction ID</th>
        </tr>
      </thead>
      <tbody>
        <?php if (count($transacoes) === 0): ?>
          <tr><td colspan="7" style="text-align:center; color: #777;">Nenhuma transação encontrada.</td></tr>
        <?php else: ?>
          <?php foreach ($transacoes as $t): ?>
            <tr>
              <td><?= htmlspecialchars($t['id']) ?></td>
              <td><?= htmlspecialchars($t['usuario_id']) ?></td>
              <td><?= htmlspecialchars($t['telefone']) ?></td>
              <td><?= number_format($t['valor'], 2, ',', '.') ?></td>
              <td><?= htmlspecialchars($t['external_id']) ?></td>
              <?php
  $status = htmlspecialchars($t['status']);
  $classeStatus = 'status-' . strtolower($status);
?>
<td class="<?= $classeStatus ?>" style="text-transform: capitalize;"><?= $status ?></td>

              <?php
  $dt = new DateTime($t['criado_em'], new DateTimeZone('UTC')); // Data original está em UTC
  $dt->setTimezone(new DateTimeZone('America/Sao_Paulo')); // Converte para horário de Brasília
?>
<td><?= $dt->format('d/m/Y H:i:s') ?></td>

              <td><?= htmlspecialchars($t['transaction_id']) ?></td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>

    <div class="pagination">
<?php
$queryString = http_build_query([
  'status' => $status_filter,
  'data_inicial' => $data_inicial,
  'data_final' => $data_final
]);
?>

<?php if ($pagina > 1): ?>
  <a href="?<?= $queryString ?>&pagina=<?= $pagina - 1 ?>">&laquo; Anterior</a>
<?php endif; ?>

<span>Página <?= $pagina ?> de <?= $totalPaginas ?></span>

<?php if ($pagina < $totalPaginas): ?>
  <a href="?<?= $queryString ?>&pagina=<?= $pagina + 1 ?>">Próximo &raquo;</a>
<?php endif; ?>

    </div>
  </div>
</body>
</html>
