<?php
header('Content-Type: application/json');
session_start();
require 'db.php';

if (!isset($_SESSION['usuario_id'])) {
    echo json_encode(['status' => 'erro', 'mensagem' => 'Sessão expirada. Faça login novamente.']);
    exit;
}

$usuario_id = $_SESSION['usuario_id'];
$valor = floatval($_POST['valor'] ?? 0);
$chave_pix = trim($_POST['chave_pix'] ?? '');

// Buscar limites de saque
$config = $pdo->query("SELECT min_saque, max_saque FROM configuracoes LIMIT 1")->fetch();
$min_saque = floatval($config['min_saque']);
$max_saque = floatval($config['max_saque']);

// Buscar comissão do usuário
$stmt = $pdo->prepare("SELECT comissao FROM usuarios WHERE id = ?");
$stmt->execute([$usuario_id]);
$usuario = $stmt->fetch();
$comissao = floatval($usuario['comissao'] ?? 0);

if ($valor < $min_saque || $valor > $max_saque) {
    echo json_encode(['status' => 'erro', 'mensagem' => '❌ Valor fora dos limites permitidos.']);
    exit;
}

if ($valor > $comissao) {
    echo json_encode(['status' => 'erro', 'mensagem' => '❌ Comissão insuficiente.']);
    exit;
}

if (empty($chave_pix)) {
    echo json_encode(['status' => 'erro', 'mensagem' => '❌ Chave Pix inválida.']);
    exit;
}

// === DADOS PIXUP ===
$CLIENT_ID = 'aranamikel_3926180968';
$CLIENT_SECRET = '3819c91eb96e1d482cbfb46ea8b966d6c0c2849ad4cd77270dd148bf3b5e0eb8';
$POSTBACK_URL = "https://seudominio.com/webhook-saque.php"; // Altere para o seu domínio

function gerarTokenPixup($clientId, $clientSecret) {
    $url = "https://api.pixupbr.com/v2/oauth/token";
    $credentials = base64_encode("$clientId:$clientSecret");

    $headers = [
        "Authorization: Basic $credentials",
        "Accept: application/json"
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "");
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode !== 200) {
        file_put_contents("log_saque.txt", "[TOKEN ERROR COMISSAO] HTTP $httpCode\nResposta: $response\n\n", FILE_APPEND);
        return false;
    }

    $data = json_decode($response, true);
    return $data['access_token'] ?? false;
}

function enviarSaquePixup($token, $valor, $usuario_id, $chavePix, $postbackUrl) {
    $url = "https://api.pixupbr.com/v2/pix/payment";
    $external_id = md5(uniqid("saque_comissao_user{$usuario_id}_", true));

    $payload = json_encode([
        "amount" => floatval($valor),
        "external_id" => $external_id,
        "description" => "Saque de comissão do usuário $usuario_id",
        "creditParty" => [
            "key" => $chavePix
        ],
        "postbackUrl" => $postbackUrl
    ]);

    $headers = [
        "Authorization: Bearer $token",
        "Accept: application/json",
        "Content-Type: application/json"
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);

    file_put_contents("log_saque.txt", "[SAQUE COMISSAO] HTTP $httpCode\nPayload: $payload\nResposta: $response\nErro: $error\n\n", FILE_APPEND);

    return [
        "http_code" => $httpCode,
        "response" => json_decode($response, true)
    ];
}

// Executa o fluxo
$token = gerarTokenPixup($CLIENT_ID, $CLIENT_SECRET);
if (!$token) {
    echo json_encode(['status' => 'erro', 'mensagem' => '❌ Erro ao gerar token. Tente novamente mais tarde.']);
    exit;
}

// Registra no banco como pendente (você pode usar mesma tabela `saques` ou `saques_comissao` se desejar separar)
$stmt = $pdo->prepare("INSERT INTO saques (usuario_id, valor, chave_pix, status, data, tipo) VALUES (?, ?, ?, 'pendente', NOW(), 'comissao')");
$stmt->execute([$usuario_id, $valor, $chave_pix]);

// Desconta da comissão
$stmt = $pdo->prepare("UPDATE usuarios SET comissao = comissao - ? WHERE id = ?");
$stmt->execute([$valor, $usuario_id]);

// Chama a API PixUp
$resultado = enviarSaquePixup($token, $valor, $usuario_id, $chave_pix, $POSTBACK_URL);

echo json_encode([
    'status' => 'sucesso',
    'mensagem' => '✅ Saque de comissão solicitado com sucesso! Aguardando confirmação.'
]);
exit;
