<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 5.3.0
*/namespace
Adminer;const
VERSION="5.3.0";error_reporting(24575);set_error_handler(function($Fc,$Hc){return!!preg_match('~^Undefined (array key|offset|index)~',$Hc);},E_WARNING|E_NOTICE);$cd=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($cd||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$sj=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($sj)$$X=$sj;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection($h=null){return($h?:Db::$instance);}function
adminer(){return
Adminer::$instance;}function
driver(){return
Driver::$instance;}function
connect(){$Hb=adminer()->credentials();$J=Driver::connect($Hb[0],$Hb[1],$Hb[2]);return(is_object($J)?$J:null);}function
idf_unescape($v){if(!preg_match('~^[`\'"[]~',$v))return$v;$Ke=substr($v,-1);return
str_replace($Ke.$Ke,$Ke,substr($v,1,-1));}function
q($Q){return
connection()->quote($Q);}function
escape_string($X){return
substr(q($X),1,-1);}function
idx($xa,$y,$l=null){return($xa&&array_key_exists($y,$xa)?$xa[$y]:$l);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes(array$ah,$cd=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($y,$X)=each($ah)){foreach($X
as$Be=>$W){unset($ah[$y][$Be]);if(is_array($W)){$ah[$y][stripslashes($Be)]=$W;$ah[]=&$ah[$y][stripslashes($Be)];}else$ah[$y][stripslashes($Be)]=($cd?$W:stripslashes($W));}}}}function
bracket_escape($v,$Ea=false){static$bj=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($v,($Ea?array_flip($bj):$bj));}function
min_version($Ij,$Ze="",$h=null){$h=connection($h);$Uh=$h->server_info;if($Ze&&preg_match('~([\d.]+)-MariaDB~',$Uh,$A)){$Uh=$A[1];$Ij=$Ze;}return$Ij&&version_compare($Uh,$Ij)>=0;}function
charset(Db$g){return(min_version("5.5.3",0,$g)?"utf8mb4":"utf8");}function
ini_bool($le){$X=ini_get($le);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$J;if($J===null)$J=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$J;}function
set_password($Hj,$N,$V,$F){$_SESSION["pwds"][$Hj][$N][$V]=($_COOKIE["adminer_key"]&&is_string($F)?array(encrypt_string($F,$_COOKIE["adminer_key"])):$F);}function
get_password(){$J=get_session("pwds");if(is_array($J))$J=($_COOKIE["adminer_key"]?decrypt_string($J[0],$_COOKIE["adminer_key"]):false);return$J;}function
get_val($H,$n=0,$vb=null){$vb=connection($vb);$I=$vb->query($H);if(!is_object($I))return
false;$K=$I->fetch_row();return($K?$K[$n]:false);}function
get_vals($H,$d=0){$J=array();$I=connection()->query($H);if(is_object($I)){while($K=$I->fetch_row())$J[]=$K[$d];}return$J;}function
get_key_vals($H,$h=null,$Xh=true){$h=connection($h);$J=array();$I=$h->query($H);if(is_object($I)){while($K=$I->fetch_row()){if($Xh)$J[$K[0]]=$K[1];else$J[]=$K[0];}}return$J;}function
get_rows($H,$h=null,$m="<p class='error'>"){$vb=connection($h);$J=array();$I=$vb->query($H);if(is_object($I)){while($K=$I->fetch_assoc())$J[]=$K;}elseif(!$I&&!$h&&$m&&(defined('Adminer\PAGE_HEADER')||$m=="-- "))echo$m.error()."\n";return$J;}function
unique_array($K,array$x){foreach($x
as$w){if(preg_match("~PRIMARY|UNIQUE~",$w["type"])){$J=array();foreach($w["columns"]as$y){if(!isset($K[$y]))continue
2;$J[$y]=$K[$y];}return$J;}}}function
escape_key($y){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$y,$A))return$A[1].idf_escape(idf_unescape($A[2])).$A[3];return
idf_escape($y);}function
where(array$Z,array$o=array()){$J=array();foreach((array)$Z["where"]as$y=>$X){$y=bracket_escape($y,true);$d=escape_key($y);$n=idx($o,$y,array());$ad=$n["type"];$J[]=$d.(JUSH=="sql"&&$ad=="json"?" = CAST(".q($X)." AS JSON)":(JUSH=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):(JUSH=="mssql"&&strpos($ad,"datetime")===false?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($n,q($X)))));if(JUSH=="sql"&&preg_match('~char|text~',$ad)&&preg_match("~[^ -@]~",$X))$J[]="$d = ".q($X)." COLLATE ".charset(connection())."_bin";}foreach((array)$Z["null"]as$y)$J[]=escape_key($y)." IS NULL";return
implode(" AND ",$J);}function
where_check($X,array$o=array()){parse_str($X,$Ya);remove_slashes(array(&$Ya));return
where($Ya,$o);}function
where_link($t,$d,$Y,$Xf="="){return"&where%5B$t%5D%5Bcol%5D=".urlencode($d)."&where%5B$t%5D%5Bop%5D=".urlencode(($Y!==null?$Xf:"IS NULL"))."&where%5B$t%5D%5Bval%5D=".urlencode($Y);}function
convert_fields(array$e,array$o,array$M=array()){$J="";foreach($e
as$y=>$X){if($M&&!in_array(idf_escape($y),$M))continue;$ya=convert_field($o[$y]);if($ya)$J
.=", $ya AS ".idf_escape($y);}return$J;}function
cookie($B,$Y,$Se=2592000){header("Set-Cookie: $B=".urlencode($Y).($Se?"; expires=".gmdate("D, d M Y H:i:s",time()+$Se)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).(HTTPS?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
get_settings($Db){parse_str($_COOKIE[$Db],$Yh);return$Yh;}function
get_setting($y,$Db="adminer_settings"){$Yh=get_settings($Db);return$Yh[$y];}function
save_settings(array$Yh,$Db="adminer_settings"){$Y=http_build_query($Yh+get_settings($Db));cookie($Db,$Y);$_COOKIE[$Db]=$Y;}function
restart_session(){if(!ini_bool("session.use_cookies")&&(!function_exists('session_status')||session_status()==1))session_start();}function
stop_session($kd=false){$_j=ini_bool("session.use_cookies");if(!$_j||$kd){session_write_close();if($_j&&@ini_set("session.use_cookies",'0')===false)session_start();}}function&get_session($y){return$_SESSION[$y][DRIVER][SERVER][$_GET["username"]];}function
set_session($y,$X){$_SESSION[$y][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($Hj,$N,$V,$k=null){$wj=remove_from_uri(implode("|",array_keys(SqlDriver::$drivers))."|username|ext|".($k!==null?"db|":"").($Hj=='mssql'||$Hj=='pgsql'?"":"ns|").session_name());preg_match('~([^?]*)\??(.*)~',$wj,$A);return"$A[1]?".(sid()?SID."&":"").($Hj!="server"||$N!=""?urlencode($Hj)."=".urlencode($N)."&":"").($_GET["ext"]?"ext=".urlencode($_GET["ext"])."&":"")."username=".urlencode($V).($k!=""?"&db=".urlencode($k):"").($A[2]?"&$A[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($Ve,$mf=null){if($mf!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($Ve!==null?$Ve:$_SERVER["REQUEST_URI"]))][]=$mf;}if($Ve!==null){if($Ve=="")$Ve=".";header("Location: $Ve");exit;}}function
query_redirect($H,$Ve,$mf,$jh=true,$Mc=true,$Vc=false,$Oi=""){if($Mc){$ni=microtime(true);$Vc=!connection()->query($H);$Oi=format_time($ni);}$hi=($H?adminer()->messageQuery($H,$Oi,$Vc):"");if($Vc){adminer()->error
.=error().$hi.script("messagesPrint();")."<br>";return
false;}if($jh)redirect($Ve,$mf.$hi);return
true;}class
Queries{static$queries=array();static$start=0;}function
queries($H){if(!Queries::$start)Queries::$start=microtime(true);Queries::$queries[]=(preg_match('~;$~',$H)?"DELIMITER ;;\n$H;\nDELIMITER ":$H).";";return
connection()->query($H);}function
apply_queries($H,array$T,$Ic='Adminer\table'){foreach($T
as$R){if(!queries("$H ".$Ic($R)))return
false;}return
true;}function
queries_redirect($Ve,$mf,$jh){$eh=implode("\n",Queries::$queries);$Oi=format_time(Queries::$start);return
query_redirect($eh,$Ve,$mf,$jh,false,!$jh,$Oi);}function
format_time($ni){return
lang(0,max(0,microtime(true)-$ni));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($ug=""){return
substr(preg_replace("~(?<=[?&])($ug".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
get_file($y,$Tb=false,$Zb=""){$bd=$_FILES[$y];if(!$bd)return
null;foreach($bd
as$y=>$X)$bd[$y]=(array)$X;$J='';foreach($bd["error"]as$y=>$m){if($m)return$m;$B=$bd["name"][$y];$Wi=$bd["tmp_name"][$y];$_b=file_get_contents($Tb&&preg_match('~\.gz$~',$B)?"compress.zlib://$Wi":$Wi);if($Tb){$ni=substr($_b,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$ni))$_b=iconv("utf-16","utf-8",$_b);elseif($ni=="\xEF\xBB\xBF")$_b=substr($_b,3);}$J
.=$_b;if($Zb)$J
.=(preg_match("($Zb\\s*\$)",$_b)?"":$Zb)."\n\n";}return$J;}function
upload_error($m){$hf=($m==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($m?lang(1).($hf?" ".lang(2,$hf):""):lang(3));}function
repeat_pattern($Gg,$Qe){return
str_repeat("$Gg{0,65535}",$Qe/65535)."$Gg{0,".($Qe%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
format_number($X){return
strtr(number_format($X,0,".",lang(4)),preg_split('~~u',lang(5),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~\W~i','-',$X);}function
table_status1($R,$Wc=false){$J=table_status($R,$Wc);return($J?reset($J):array("Name"=>$R));}function
column_foreign_keys($R){$J=array();foreach(adminer()->foreignKeys($R)as$q){foreach($q["source"]as$X)$J[$X][]=$q;}return$J;}function
fields_from_edit(){$J=array();foreach((array)$_POST["field_keys"]as$y=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$y];$_POST["fields"][$X]=$_POST["field_vals"][$y];}}foreach((array)$_POST["fields"]as$y=>$X){$B=bracket_escape($y,true);$J[$B]=array("field"=>$B,"privileges"=>array("insert"=>1,"update"=>1,"where"=>1,"order"=>1),"null"=>1,"auto_increment"=>($y==driver()->primary),);}return$J;}function
dump_headers($Sd,$wf=false){$J=adminer()->dumpHeaders($Sd,$wf);$qg=$_POST["output"];if($qg!="text")header("Content-Disposition: attachment; filename=".adminer()->dumpFilename($Sd).".$J".($qg!="file"&&preg_match('~^[0-9a-z]+$~',$qg)?".$qg":""));session_write_close();if(!ob_get_level())ob_start(null,4096);ob_flush();flush();return$J;}function
dump_csv(array$K){foreach($K
as$y=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$K[$y]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$K)."\r\n";}function
apply_sql_function($s,$d){return($s?($s=="unixepoch"?"DATETIME($d, '$s')":($s=="count distinct"?"COUNT(DISTINCT ":strtoupper("$s("))."$d)"):$d);}function
get_temp_dir(){$J=ini_get("upload_tmp_dir");if(!$J){if(function_exists('sys_get_temp_dir'))$J=sys_get_temp_dir();else{$p=@tempnam("","");if(!$p)return'';$J=dirname($p);unlink($p);}}return$J;}function
file_open_lock($p){if(is_link($p))return;$r=@fopen($p,"c+");if(!$r)return;chmod($p,0660);if(!flock($r,LOCK_EX)){fclose($r);return;}return$r;}function
file_write_unlock($r,$Nb){rewind($r);fwrite($r,$Nb);ftruncate($r,strlen($Nb));file_unlock($r);}function
file_unlock($r){flock($r,LOCK_UN);fclose($r);}function
first(array$xa){return
reset($xa);}function
password_file($i){$p=get_temp_dir()."/adminer.key";if(!$i&&!file_exists($p))return'';$r=file_open_lock($p);if(!$r)return'';$J=stream_get_contents($r);if(!$J){$J=rand_string();file_write_unlock($r,$J);}else
file_unlock($r);return$J;}function
rand_string(){return
md5(uniqid(strval(mt_rand()),true));}function
select_value($X,$_,array$n,$Ni){if(is_array($X)){$J="";foreach($X
as$Be=>$W)$J
.="<tr>".($X!=array_values($X)?"<th>".h($Be):"")."<td>".select_value($W,$_,$n,$Ni);return"<table>$J</table>";}if(!$_)$_=adminer()->selectLink($X,$n);if($_===null){if(is_mail($X))$_="mailto:$X";if(is_url($X))$_=$X;}$J=adminer()->editVal($X,$n);if($J!==null){if(!is_utf8($J))$J="\0";elseif($Ni!=""&&is_shortable($n))$J=shorten_utf8($J,max(0,+$Ni));else$J=h($J);}return
adminer()->selectVal($J,$_,$n,$X);}function
is_mail($wc){$za='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$ic='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$Gg="$za+(\\.$za+)*@($ic?\\.)+$ic";return
is_string($wc)&&preg_match("(^$Gg(,\\s*$Gg)*\$)i",$wc);}function
is_url($Q){$ic='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($ic?\\.)+$ic(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$Q);}function
is_shortable(array$n){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$n["type"]);}function
count_rows($R,array$Z,$ve,array$yd){$H=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($ve&&(JUSH=="sql"||count($yd)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$yd).")$H":"SELECT COUNT(*)".($ve?" FROM (SELECT 1$H GROUP BY ".implode(", ",$yd).") x":$H));}function
slow_query($H){$k=adminer()->database();$Pi=adminer()->queryTimeout();$ci=driver()->slowQuery($H,$Pi);$h=null;if(!$ci&&support("kill")){$h=connect();if($h&&($k==""||$h->select_db($k))){$Ee=get_val(connection_id(),0,$h);echo
script("const timeout = setTimeout(() => { ajax('".js_escape(ME)."script=kill', function () {}, 'kill=$Ee&token=".get_token()."'); }, 1000 * $Pi);");}}ob_flush();flush();$J=@get_key_vals(($ci?:$H),$h,false);if($h){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$J;}function
get_token(){$hh=rand(1,1e6);return($hh^$_SESSION["token"]).":$hh";}function
verify_token(){list($Xi,$hh)=explode(":",$_POST["token"]);return($hh^$_SESSION["token"])==$Xi;}function
lzw_decompress($Ka){$ec=256;$La=8;$ib=array();$uh=0;$vh=0;for($t=0;$t<strlen($Ka);$t++){$uh=($uh<<8)+ord($Ka[$t]);$vh+=8;if($vh>=$La){$vh-=$La;$ib[]=$uh>>$vh;$uh&=(1<<$vh)-1;$ec++;if($ec>>$La)$La++;}}$dc=range("\0","\xFF");$J="";$Rj="";foreach($ib
as$t=>$hb){$vc=$dc[$hb];if(!isset($vc))$vc=$Rj.$Rj[0];$J
.=$vc;if($t)$dc[]=$Rj.$vc[0];$Rj=$vc;}return$J;}function
script($ei,$aj="\n"){return"<script".nonce().">$ei</script>$aj";}function
script_src($xj,$Wb=false){return"<script src='".h($xj)."'".nonce().($Wb?" defer":"")."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
input_hidden($B,$Y=""){return"<input type='hidden' name='".h($B)."' value='".h($Y)."'>\n";}function
input_token(){return
input_hidden("token",get_token());}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($Q){return
str_replace("\0","&#0;",htmlspecialchars($Q,ENT_QUOTES,'utf-8'));}function
nl_br($Q){return
str_replace("\n","<br>",$Q);}function
checkbox($B,$Y,$bb,$Ge="",$Wf="",$fb="",$Ie=""){$J="<input type='checkbox' name='$B' value='".h($Y)."'".($bb?" checked":"").($Ie?" aria-labelledby='$Ie'":"").">".($Wf?script("qsl('input').onclick = function () { $Wf };",""):"");return($Ge!=""||$fb?"<label".($fb?" class='$fb'":"").">$J".h($Ge)."</label>":$J);}function
optionlist($bg,$Mh=null,$Aj=false){$J="";foreach($bg
as$Be=>$W){$cg=array($Be=>$W);if(is_array($W)){$J
.='<optgroup label="'.h($Be).'">';$cg=$W;}foreach($cg
as$y=>$X)$J
.='<option'.($Aj||is_string($y)?' value="'.h($y).'"':'').($Mh!==null&&($Aj||is_string($y)?(string)$y:$X)===$Mh?' selected':'').'>'.h($X);if(is_array($W))$J
.='</optgroup>';}return$J;}function
html_select($B,array$bg,$Y="",$Vf="",$Ie=""){static$Ge=0;$He="";if(!$Ie&&substr($bg[""],0,1)=="("){$Ge++;$Ie="label-$Ge";$He="<option value='' id='$Ie'>".h($bg[""]);unset($bg[""]);}return"<select name='".h($B)."'".($Ie?" aria-labelledby='$Ie'":"").">".$He.optionlist($bg,$Y)."</select>".($Vf?script("qsl('select').onchange = function () { $Vf };",""):"");}function
html_radios($B,array$bg,$Y="",$Qh=""){$J="";foreach($bg
as$y=>$X)$J
.="<label><input type='radio' name='".h($B)."' value='".h($y)."'".($y==$Y?" checked":"").">".h($X)."</label>$Qh";return$J;}function
confirm($mf="",$Nh="qsl('input')"){return
script("$Nh.onclick = () => confirm('".($mf?js_escape($mf):lang(6))."');","");}function
print_fieldset($u,$Pe,$Lj=false){echo"<fieldset><legend>","<a href='#fieldset-$u'>$Pe</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$u');",""),"</legend>","<div id='fieldset-$u'".($Lj?"":" class='hidden'").">\n";}function
bold($Na,$fb=""){return($Na?" class='active $fb'":($fb?" class='$fb'":""));}function
js_escape($Q){return
addcslashes($Q,"\r\n'\\/");}function
pagination($D,$Kb){return" ".($D==$Kb?$D+1:'<a href="'.h(remove_from_uri("page").($D?"&page=$D".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($D+1)."</a>");}function
hidden_fields(array$ah,array$Wd=array(),$Sg=''){$J=false;foreach($ah
as$y=>$X){if(!in_array($y,$Wd)){if(is_array($X))hidden_fields($X,array(),$y);else{$J=true;echo
input_hidden(($Sg?$Sg."[$y]":$y),$X);}}}return$J;}function
hidden_fields_get(){echo(sid()?input_hidden(session_name(),session_id()):''),(SERVER!==null?input_hidden(DRIVER,SERVER):""),input_hidden("username",$_GET["username"]);}function
enum_input($U,$_a,array$n,$Y,$zc=null){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$cf);$J=($zc!==null?"<label><input type='$U'$_a value='$zc'".((is_array($Y)?in_array($zc,$Y):$Y===$zc)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($cf[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$bb=(is_array($Y)?in_array($X,$Y):$Y===$X);$J
.=" <label><input type='$U'$_a value='".h($X)."'".($bb?' checked':'').'>'.h(adminer()->editVal($X,$n)).'</label>';}return$J;}function
input(array$n,$Y,$s,$Da=false){$B=h(bracket_escape($n["field"]));echo"<td class='function'>";if(is_array($Y)&&!$s){$Y=json_encode($Y,128|64|256);$s="json";}$th=(JUSH=="mssql"&&$n["auto_increment"]);if($th&&!$_POST["save"])$s=null;$td=(isset($_GET["select"])||$th?array("orig"=>lang(8)):array())+adminer()->editFunctions($n);$fc=stripos($n["default"],"GENERATED ALWAYS AS ")===0?" disabled=''":"";$_a=" name='fields[$B]'$fc".($Da?" autofocus":"");$Ec=driver()->enumLength($n);if($Ec){$n["type"]="enum";$n["length"]=$Ec;}echo
driver()->unconvertFunction($n)." ";$R=$_GET["edit"]?:$_GET["select"];if($n["type"]=="enum")echo
h($td[""])."<td>".adminer()->editInput($R,$n,$_a,$Y);else{$Fd=(in_array($s,$td)||isset($td[$s]));echo(count($td)>1?"<select name='function[$B]'$fc>".optionlist($td,$s===null||$Fd?$s:"")."</select>".on_help("event.target.value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($td))).'<td>';$ne=adminer()->editInput($R,$n,$_a,$Y);if($ne!="")echo$ne;elseif(preg_match('~bool~',$n["type"]))echo"<input type='hidden'$_a value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$_a value='1'>";elseif($n["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$cf);foreach($cf[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$bb=in_array($X,explode(",",$Y),true);echo" <label><input type='checkbox' name='fields[$B][$t]' value='".h($X)."'".($bb?' checked':'').">".h(adminer()->editVal($X,$n)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$B'>";elseif($s=="json"||preg_match('~^jsonb?$~',$n["type"]))echo"<textarea$_a cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';elseif(($Li=preg_match('~text|lob|memo~i',$n["type"]))||preg_match("~\n~",$Y)){if($Li&&JUSH!="sqlite")$_a
.=" cols='50' rows='12'";else{$L=min(12,substr_count($Y,"\n")+1);$_a
.=" cols='30' rows='$L'";}echo"<textarea$_a>".h($Y).'</textarea>';}else{$mj=driver()->types();$jf=(!preg_match('~int~',$n["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$n["length"],$A)?((preg_match("~binary~",$n["type"])?2:1)*$A[1]+($A[3]?1:0)+($A[2]&&!$n["unsigned"]?1:0)):($mj[$n["type"]]?$mj[$n["type"]]+($n["unsigned"]?0:1):0));if(JUSH=='sql'&&min_version(5.6)&&preg_match('~time~',$n["type"]))$jf+=7;echo"<input".((!$Fd||$s==="")&&preg_match('~(?<!o)int(?!er)~',$n["type"])&&!preg_match('~\[\]~',$n["full_type"])?" type='number'":"")." value='".h($Y)."'".($jf?" data-maxlength='$jf'":"").(preg_match('~char|binary~',$n["type"])&&$jf>20?" size='".($jf>99?60:40)."'":"")."$_a>";}echo
adminer()->editHint($R,$n,$Y);$dd=0;foreach($td
as$y=>$X){if($y===""||!$X)break;$dd++;}if($dd&&count($td)>1)echo
script("qsl('td').oninput = partial(skipOriginal, $dd);");}}function
process_input(array$n){if(stripos($n["default"],"GENERATED ALWAYS AS ")===0)return;$v=bracket_escape($n["field"]);$s=idx($_POST["function"],$v);$Y=$_POST["fields"][$v];if($n["type"]=="enum"||driver()->enumLength($n)){if($Y==-1)return
false;if($Y=="")return"NULL";}if($n["auto_increment"]&&$Y=="")return
null;if($s=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?idf_escape($n["field"]):false);if($s=="NULL")return"NULL";if($n["type"]=="set")$Y=implode(",",(array)$Y);if($s=="json"){$s="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads")){$bd=get_file("fields-$v");if(!is_string($bd))return
false;return
driver()->quoteBinary($bd);}return
adminer()->processInput($n,$Y,$s);}function
search_tables(){$_GET["where"][0]["val"]=$_POST["query"];$Ph="<ul>\n";foreach(table_status('',true)as$R=>$S){$B=adminer()->tableName($S);if(isset($S["Engine"])&&$B!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$I=connection()->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",adminer()->selectSearchProcess(fields($R),array())),1));if(!$I||$I->fetch_row()){$Wg="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$B</a>";echo"$Ph<li>".($I?$Wg:"<p class='error'>$Wg: ".error())."\n";$Ph="";}}}echo($Ph?"<p class='message'>".lang(9):"</ul>")."\n";}function
on_help($ob,$ai=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $ob, $ai) }, onmouseout: helpMouseout});","");}function
edit_form($R,array$o,$K,$vj,$m=''){$zi=adminer()->tableName(table_status1($R,true));page_header(($vj?lang(10):lang(11)),$m,array("select"=>array($R,$zi)),$zi);adminer()->editRowPrint($R,$o,$K,$vj);if($K===false){echo"<p class='error'>".lang(12)."\n";return;}echo"<form action='' method='post' enctype='multipart/form-data' id='form'>\n";if(!$o)echo"<p class='error'>".lang(13)."\n";else{echo"<table class='layout'>".script("qsl('table').onkeydown = editingKeydown;");$Da=!$_POST;foreach($o
as$B=>$n){echo"<tr><th>".adminer()->fieldName($n);$l=idx($_GET["set"],bracket_escape($B));if($l===null){$l=$n["default"];if($n["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$l,$qh))$l=$qh[1];if(JUSH=="sql"&&preg_match('~binary~',$n["type"]))$l=bin2hex($l);}$Y=($K!==null?($K[$B]!=""&&JUSH=="sql"&&preg_match("~enum|set~",$n["type"])&&is_array($K[$B])?implode(",",$K[$B]):(is_bool($K[$B])?+$K[$B]:$K[$B])):(!$vj&&$n["auto_increment"]?"":(isset($_GET["select"])?false:$l)));if(!$_POST["save"]&&is_string($Y))$Y=adminer()->editVal($Y,$n);$s=($_POST["save"]?idx($_POST["function"],$B,""):($vj&&preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$vj&&$Y==$n["default"]&&preg_match('~^[\w.]+\(~',$Y))$s="SQL";if(preg_match("~time~",$n["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$s="now";}if($n["type"]=="uuid"&&$Y=="uuid()"){$Y="";$s="uuid";}if($Da!==false)$Da=($n["auto_increment"]||$s=="now"||$s=="uuid"?null:true);input($n,$Y,$s,$Da);if($Da)$Da=false;echo"\n";}if(!support("table")&&!fields($R))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",adminer()->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($o){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"]))echo"<input type='submit' name='insert' value='".($vj?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($vj?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}echo($vj?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":"");if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo
input_hidden("referer",(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"])),input_hidden("save",1),input_token(),"</form>\n";}function
shorten_utf8($Q,$Qe=80,$ti=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$Qe).")($)?)u",$Q,$A))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$Qe).")($)?)",$Q,$A);return
h($A[1]).$ti.(isset($A[2])?"":"<i>…</i>");}function
icon($Rd,$B,$Qd,$Ri){return"<button type='submit' name='$B' title='".h($Ri)."' class='icon icon-$Rd'><span>$Qd</span></button>";}if(isset($_GET["file"])){if(substr(VERSION,-4)!='-dev'){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");}@ini_set("zlib.output_compression",'1');if($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:M��h��g�б���\"P�i��m��cQCa��	2ó��d<��f�a��:;NB�q�R;1Lf�9��u7&)�l;3�����J/��CQX�r2M�a�i0���)��e:LuÝh�-9��23l��i7��m�Zw4���њ<-��̴�!�U,��Fé�vt2��S,��a�҇F�VX�a�Nq�)�-���ǜh�:n5���9�Y�;j��-��_�9kr��ٓ;.�tTq�o�0�����{��y��\r�Hn��GS��Zh��;�i^�ux�WΒC@����k��=��b����/A��0�+�(���l���\\��x�:\r��b8\0�0!\0F�\nB�͎�(�3�\r\\�����Ȅa���'I�|�(i�\n�\r���4O�g@�4�C��@@�!�QB��	°�c��¯�q,\r1Eh��&2PZ���iG�H9G�\"v���������4r����D�R�\n�pJ�-A�|/.�c�Du�����:,��=��R�]U5�mV�k�LLQ@-\\����@9��%�S�r���MPD��Ia\r�(YY\\�@X�p��:��p�l�LC �������O,\r�2]7�?m06�p�T��aҥC�;_˗�yȴd�>��bn���n�ܣ3�X���8\r�[ˀ-)�i>V[Y�y&L3�#�X|�	�X�\\ù`�C���#��H��2�2.#���Z�`�<��s����Ò��\0u�h־��M��_\niZeO/CӒ_�`3���1>�=��k3����R/;�/d��\0�����ڵm���7/���A�X�������q.�s�L��� :\$�F�������w�8�߾~�H�j��\"�����Գ7gS���FL�ί�Q�_��O'W��]c=�5�1X~7;��i��\r�*\n��JS1Z���������c���t��A�V�86f�d�y;Y�]��zI�p�����c�3�Y�]}@�\$.+�1�'>Z�cpd���GL��#k�8Pz�Y�Au�v�]s9���_Aq���:���\nK�hB�;���XbAHq,��CI�`����j�S[ˌ�1�V�r���;�p�B��)#鐉;4�H��/*�<�3L��;lf�\n�s\$K`�}��Ք���7�jx`d�%j]��4��Y��HbY��J`�GG��.��K��f�I�)2�Mfָ�X�RC��̱V,���~g\0���g6�:�[j�1H�:AlIq�u3\"���q��|8<9s'�Q]J�|�\0�`p���jf�O�b�����q��\$����1J�>R�H(ǔq\n#r����@�e(y�VJ�0�Q҈��6�P�[C:�G伞���4���^����PZ��\\���(\n��)�~���9R%�Sj�{��7�0�_��s	z|8�H�	\"@�#9DVL�\$H5�WJ@��z�a�J �^	�)�2\nQv��]�������j (A���BB05�6�b˰][��k�A�wvkg�ƴ���+k[jm�zc�}�MyDZi�\$5e��ʷ���	�A��CY%.W�b*뮼�.���q/%}B�X���ZV337�ʻa�������wW[�L�Q�޲�_��2`�1I�i,�曣�Mf&(s-����Aİ�*��Dw��TN�ɻ�jX\$�x�+;���F�93�JkS;���qR{>l�;B1A�I�b)��(6��r�\r�\rڇ����Z�R^SOy/��M#��9{k���v\"�KC�J��rEo\0��\\,�|�fa͚��hI��/o�4�k^p�1H�^����phǡV�vox@�`�g�&�(����;��~Ǎz�6�8�*���5����E���p����Ә���3��ņg��rD�L�)4g{���峩�L��&�>脻����Z�7�\0��̊@�����ff�RVh֝��I�ۈ���r�w)����=x^�,k��2��ݓj�b�l0u�\"�fp��1�RI��z[]�w�pN6dI�z���n.7X{;��3��-I	����7pjÝ�R�#�,�_-���[�>3�\\���Wq�q�J֘�uh���FbL�K���yVľ����ѕ�����V���f{K}S��ޝ��M���̀��.M�\\�ix�b���1�+�α?<�3�~H��\$�\\�2�\$� e�6t�Ö�\$s���x��x���C�nSkV��=z6����'æ�Na��ָh��������R�噣8g�����w:_�����ҒIRKÝ�.�nkVU+dwj��%�`#,{�醳����Y����(oվ��.�c�0g�DXOk�7��K��l��hx;�؏ ݃L��\$09*�9 �hNr�M�.>\0�rP9�\$�g	\0\$\\F�*�d'��L�:�b���4�2����9��@�Hnb�-��E #Ĝ����rPY�� t� �\n�5.�����\$op�l�X\n@`\r��	��\r���� � ���	������ �	@�@�\n � �	\0j@�Q@�1\r��@� �	\$p	 V\0�``\n\0�\n �\n@�'����\n\0`\r����	��\r���\0�r����	\0�`�	���{	,�\"��^P�0�\n��4�\n0���.0�p���\rp�\r��p���p��q�Q0�%���1Q8\n �\0�k�ȼ\0^���\0`��@���>\n�o1w�,Y	h*=����P�:іV��и.q����\r�\r�p���1��Q	��1� �`��/17����\r�^��\"y`�\n�� �#��\0�	 p\n��\n��`� �r �Q��b�1��3\n��#��#�1�\$q�\$ѱ%0�%q�%��&�&q� �&�'1�\rR}16	 �@b\r`�`�\r��	�����d���	j\n�``��\n��`dcсP��,�1R��\$�rI�O �	Q	�Y32b1�&��01��� �� f��\0�\0���f�\0j\n�f`�	 �\n`�@�\$n=`�\0��v nI�\$�P(�d'�����g�6��-��-�C7R��� �	4��-1�&��2t\r�\"\n 	H*@�	�`\n � �	��l�2�,z\r�~� �\r�F�th�������m����z�~�\0]G�F\\��I�\\��}It�C\n�T�}���IEJ\rx����>�Mp��IH�~��fht��.b��xYE��iK��oj�\n���L��tr�.�~d�H�2U4�G�\\A��4��uPt����谐����L/�P�	\"G!R��Mt�O-��<#�APuI��R�\$�c���D�Ɗ����-��G�O`Pv�^W@tH;Q��Rę�\$��gK�F<\rR*\$4���'�����[���I��Um��h:+��5@/�l�I���2���^�\0OD�����\rR'�\r�TЭ[����Ī��MC�M�Z4�E B\"�`���euN�,䙬�]��t�\r�`�@h��*\r�.V��%�!MBlPF��\"��&�/@�v\\C��:mMgn����i8�I2\rp�vj�����+Z mT�ue��fv>f��C�T�M.�M�3Pv'kt�dO\rd��k���yW��߂��V6�U�ʖ����-~X��������BGd�\$i��%�qj�E��rLJ�Pr�%n=��H�\"\"\"h��_\$b@�t��\0f\"��n�H�*��Bv\$\$�B��@\"@r��(\r`� �C�X�(0&�.`�Nk9B\n&#(���@䂯��d��^�Z��� �@�`�I-u�0��\n�B�u�4sGu���tN�b�u �ub}�O~)uB��w�{��Ł5=w9[ɫs��	8=�\0\r��%`�]x&^�3sc݃.\$�̓�Z4�4��u`���Ǆ�ۅ �8;�wT�M��e��х�݇8X��zl�K�U��`�������^XO��m�@M��⋀W��X���j��߈ؽ���XG��T�E����H��x�Y��a�,�Í��Ŋ�o|��t�%��U�j���q�7w�X�=ػ�d��xU�8�\r��O������������iy��c��.&Y%�9A��k���d�Dz�9D�ċģ[���Y��<�x��X^V�ς��DG��g�wǏ����C����I�`Ƨ��=ٗzYO� 6�|x��)���ߋ8#�ل�e��ٙ8Q�x�Y��������ߛ&K�����͝��(��%�r-��ٝ��J���� @��Z ��x�����Dz!�Wǝ�ۣy���� \0�rYy|b�|�!�Y��y���9���yzC+���=�٦�ç:]�s����w���a���x��f*�qz�ӧ`[�#�s�y���+u�XT���ٌ�c����࿎C1�8U�9��5�ݭǖ`��ͬ������Z�yg�z�� ڧ�����࿰������#�e˱Z��+��Ր�p>ǡ�L)����ű�O��+�I���x�R ˯��yB�y����I{z\0\r�ᜄ�{k�^��=������:��Γ��A�2;������7��\$�;c�������;���]XX��kY�#�5vT\\�Q��:��>��ɓ�k��'����[��a�ħ�0�xI�[���;��\0[���A�Z���e���?�ec��p΄�Ճ��:�#�fCZ��SDv��.\r��#�ߔ�U ");}elseif($_GET["file"]=="dark.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:M��h��g���h0�LЁ�d91�S!��	�F�!��\"-6N����bd�Gg���:;Nr�)��c7�\r�(H�b81��s9���k\r�c)�m8�O��VA��c1��c34Of*��-�P��1��r41��6��d2�ց���o���#3���B�f#	��g9Φ�،fc\r�I���b6E�C&��,�bu��m7a�V���s��#m!��h��r���v\\3\rL:SA��dk5�n������aF��3��e6fS��y���r!�L��-�K,�3L�@��J��˲�*J��쵣����	������b�c��9���9���@����H�8��\\���6>�`�Ŏ��;�A��<T�'�p&q�qE��4�\rl���h�<5#p��R �#I��%��fBI��ܲ��>�ʫ29<��C�j2��7j��8j��c(n���?(a\0�@�5*3:δ�6����0��-�A�lL��P�4@�ɰ�\$�H�4�n31��1�t�0��͙9���WO!�r��������H����9�Q��96�F���<�7�\r�-xC\n ��@�������:\$i�ضm���4�Kid��{\n6\r���xhˋ�#^'4V�@a��<�#h0�S�-�c��9�+p���a�2�cy�h�BO\$��9�w�iX�ɔ�VY9�*r�Htm	�@b��|@�/��l�\$z���+�%p2l���.�������7�;�&{��m��X�C<l9��6x9�m�������7R��0\\�4��P�)A�o��x���q�O#����f[;��6~P�\r�a��T�GT0���u�ޟ���\n3�\\ \\ʎ�J�ud�CG���PZ�>����d8�Ҩ������C?V��dL��L.(ti���>�,�֜�R+9i��ޞC\$��#\"�AC�hV�b\n��6�T2�ew�\nf��6m	!1'c��;��*eLRn\r�G\$�2S\$��0���a�'�l6�&�~A�d\$�J�\$s� �ȃB4���j�.�RC̔�Q�j�\"7\n�Xs!�6=�BȀ}");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("':�̢���i1��1��	4������Q6a&��:OAI��e:NF�D|�!���Cy��m2��\"���r<�̱���/C�#����:DbqSe�J�˦Cܺ\n\n��ǱS\rZ��H\$RAܞS+XKvtd�g:��6��EvXŞ�j��mҩej�2�M�����B��&ʮ�L�C�3���Q0�L��-x�\n��D���yNa�Pn:�����s��͐�(�cL��/���(�5{���Qy4��g-�����i4ڃf��(��bU���k��o7�&�ä�*ACb����`.����\r����������\n��Ch�<\r)`�إ`�7�Cʒ���Z���X�<�Q�1X���@�0dp9EQ�f����F�\r��!���(h��)��\np'#Č��H�(i*�r��&<#��7K��~�# ��A:N6�����l�,�\r��JP�3�!@�2>Cr���h�N��]�(a0M3�2��6��U��E2'!<��#3R�<�����X���CH�7�#n�+��a\$!��2��P�0�.�wd�r:Y����E��!]�<��j��@�\\�pl�_\r�Z���ғ�TͩZ�s�3\"�~9���j��P�)Q�YbݕD�Yc��`��z�c��Ѩ��'�#t�BOh�*2��<ŒO�fg-Z����#��8a�^��+r2b��\\��~0�������W����n��p!#�`��Z��6�1�2��@�ky��9\r��B3�pޅ�6��<�!p�G�9�n�o�6s��#F�3���bA��6�9���Z�#��6��%?�s��\"��|؂�)�b�Jc\r����N�s��ih8����ݟ�:�;��H�ތ�u�I5�@�1��A�PaH^\$H�v��@ÛL~���b9�'�����S?P�-���0�C�\nR�m�4���ȓ:���Ը�2��4��h(k\njI��6\"�EY�#��W�r�\r��G8�@t���Xԓ��BS\nc0�k�C I\rʰ<u`A!�)��2��C�\0=��� ���P�1�ӢK!�!��p�Is�,6�d���i1+����k���<��^�	�\n��20�Fԉ_\$�)f\0��C8E^��/3W!א)�u�*���&\$�2�Y\n�]��Ek�DV�\$�J���xTse!�RY� R��`=L���ޫ\nl_.!�V!�\r\nH�k��\$א`{1	|�����i<jRrPTG|��w�4b�\r���4d�,�E��6���<�h[N�q@Oi�>'ѩ\r����;�]#��}�0�ASI�Jd�A/Q����⸵�@t\r�UG��_G�<��<y-I�z򄤝�\"�P��B\0������q`��vA��a̡J�R�ʮ)��JB.�T��L��y����Cpp�\0(7�cYY�a��M��1�em4�c��r��S)o����p�C!I���Sb�0m��(d�EH����߳�X���/���P���y�X��85��\$+�֖���gd�����y��ϝ�J��� �lE��ur�,dCX�}e������m�]��2�̽�(-z����Z��;I��\\�) ,�\n�>�)����\rVS\njx*w`ⴷSFi��d��,���Z�JFM}Њ ��\\Z�P��`�z�Z�E]�d��ɟO�cmԁ]� ������%�\"w4��\n\$��zV�SQD�:�6���G�wM��S0B�-s��)�Z��cǁ2��δA;��n�Wz/A�Zh�G~�c�c%�[�D�&l�FR�77|�I���3��g0�L���a��c�0RJ�2��%���F� S� �L�^� tr���t����ʩ;��.喚Ł�>����[�a�N���^�(!g�@1����N�z�<b�ݖ�����O,��Cu��D�tj޹I;)�݀�\nn�c��Ȃ�W<s�	�\0�hN�P�9��{ue��ut뵕������3��=��g�����J����WQ�0���w9p-���	�������'5��\nO��e)M�)_k�z\0V�����;j�l��\n����x�Pf�-�`C�.@&]#\0ڶp�y͖ƛ�t�d�� ��b}�	G1�m�ru���*�_�xD�3�q��B�sQ��u��s%�\n�5s�ut���{�s�y���N��4�,J{4@��\0��P���^��=��l���`�e~F١h3o�\"��q�R<iUT�[Q��U��M�6�T. ��0'�pe\\�����5����pCe	ٕ�\"*�M	����D���?�h��2���zU�@7�C�4�a��iE!f�\$�B��<�9o*\$��lH�\$ �@����P\rN�Y�n<\$�	�Q�=�F&��*@]\0��� W'd� z\$��j�P[��\$���0#&��_�`+�B)�w�v%	����LcJ��RS��i`�Ů	�F�W	��\nBP\n�\r\0}	瑩0�Z���/`j\$�: �8ie���φx�����a ���Gn�sgO��U%VU��@�N��ϐ�d+�(oJ�@X���zM'F٣�WhV�I^٢�1>�@�\"���� ��Q�R!�\\�`[������.�0fb�F;���Fp�p/t`����(��V���b�Ȳ�(��H�l����ԯ1v�����H��1T�3�q���1�Ѫf�\nT\$���Nq+��`ލv�ǜ�\r�Vm���r���'ϸ��g%�\"L�m����(�(CLz��\"h�X�m=�\\H\n0U�� f&M\$�g\$�U`a\rP�>`�#g��h��`�R4H��'�����GK;\"M�ۨT�h�BE�n\"b>���\r���#�\0�N:�#_	QQ1{	f:B���R�&���)J��Br�+�K.\$�Pq�-r�S%TIT&Q���{#2o(*P��5�`�1H���'	<T�d����s��,N�� ����^\r%�3��\r&��4�B�/\0�kLH\$�4d�>���/�ඵ�H���*���3J�А�<�Hh��p�'��O/&�2I.�x3V.�s5�e3��ێZ�(�9E�g�;R�;�J��Q�@��vgz@������'dZ&�,U���F��b*�D��H! �\r�;%�x'G#��͠w��#�֠�2;#�Bv�X��a�\nb�{4K�G��%���GuE`\\\rB\r\0�-mW\rM\"��#E�cFbF�nz���@4J��[\$��%2V��%�&T�V��d�4hemN�-;Eľ%E�E�r�<\"@�F�P�L �߭�4E����z`�u�7�N�4��\0�F:h�K�h/:�\"�M�Z��\r+P4\r?��S��O;B��0\$FCEp��M\"�%H4D�|��LN�FtE��g���5�=J\r\"��޼5��4�K�P\rbZ�\r\"pEQ'DwK�W0��g'�l\"h�QF�C,�Cc���IH�P�hF]5�& f�T��iSTUS�����[4�[u�Ne�\$o�K��O ��b\" 5�\0�D�)E�%\"�]��/���ЌJ�6U�d��`��a)V-0��DӔbM�)���������`��%�ELt��+��6C7j�d��:�V4ơ3� -�R\rG�IT��#�<4-CgCP{V�\$'����g��R@�'��S=%���F�k:��k��9����e]aO��G9�;��-6��8W��*�x\"U��YlB���������	��\n��p���l����Z�m\0�5����Oq̨��b�W1s@��K�-p���E�Spw\nGWoQ�qG}vp�w}q��q�\\�7�RZ�@��t��t�;pG}w׀/%\"L�E\0t�h�)�\r��J�\\W@�	�|D#S��ƃV��R�z�2���v�����	�}�����(�\0y<�X\r��x���q�<��Isk1S�-Q4Yq8�#��v���d.ֹS;q�!,'(���<.�J7H�\"��.����u�����#�Q�\re�r�Xv[�h\$�{-�Y���JBg��iM8��'�\nƘtDZ~/�b���8��\$��DbR�O�O��`O5S>����[�D�ꔸ����_3X�)��'��Jd\r�X����UD�U�X8�x�-旅�P�N`�	�\n�Z���@Ra48��:���\0�x���N�\\�0%��f��\\��>\"@^\0Zx�Z�\0ZaBr#�X��\r��{��˕�flFb\0[�ވ\0[�6���	��� �=��\n��WB��\$'�kG�(\$y�e9�(8�& h��Rܔ��o�ȼ Ǉ���Y��4��7_��d��9�'���������z\r���  ����v�G��O8���MOh'��X�S0�\0\0�	��9�s?���I�MY�8� 9����HO��,4	��xs��P�*G����c8��Qɠ��wB|�z	@�	���9c�K��QG�bFj�X��oS�\$��dFHĂP�@ѧ<嶴�,�}�m��r��\"�'k�`��c�x��e�C��C��:���:X� �T���^�d�Æqh��s���Lv�Ү0\r,4�\r_v�L�j�jM��b[  ��ls���Z�@�����;f��`2Yc�e�'�Mer��F\$�!��\n��	*0\r�AN�LP��jٓ����;ƣV�Q|(��3����[p��8���|�^\r�Bf/�D���Ҟ B��_�N5M�� \$�\naZЦ���~�Ule�rŧr��Z�aZ�����գs8R�G�Z��w���N�_Ʊ�Yϣ�m����]��;ƚL�����c������Ű��I�Q3��O��|�y*`� �5��4�;&v8�#�R�8+`X�bV�6�ƫi�3F��E���oc82�M�\"����G�Wb\rO�C�Vd�ӭ�w\\�ͯ*cSi�Qү��R`�d7}	���)�ϴ�,�+bd�۹�FN�3��L\\��eRn\$&\\r��+d��]O5kq,&\"D�CU6j�p���\\'�@o�~�5N=�|�&�!��B�w�H�yyz7��(Ǎ���b5(3փ_\0`z�b�Уr��8	�Z�v�8L˓�)��S�M<�*7\$��\rR�b���B%��ƴDs�z�R>[�Q����&Q������'\r�pp�z�/<��}L�#��Ε���Z��\"t��\n��.4�g�P��p�D�n�ʹN��F�d\0`^����\rnȂ׳#_�� w(�2�<7-��X޹\0��s��,^�hC,�!:�\rK��.��Ӣ�Ţ���\\��+v�Z��\0�Q9eʛ˞E�w?>�\$}��D#���c�0MV3�%Y���\r��tj5��7��{ŝ�Lz=�<��8I�M�����G����L�\$��2��{(�pe?u�,R�d*X�4�����\0\"@���}<.@��	��N��\$�XU�js�/��<>\"* �#\$����&CPI	��t������?� ��	�O��\\��_��Q5Y�H@���b��c�h����뱖��O0T�'�8�w�����j+H�v_#�����06�w֎�X��d+�ܓ\\��\n\0	\\�>s��A	PF�d8m'@�\nH�\0�c�OwS�����Y�`�����R��Dna\"��~�?�m���|@6��+�GxV��\0��W�Ӱ�nw���.�؃b��9Í��E�|E���\rЈr�\"��x���-���\rN6�n�\$Ҭ�-B�H�^�)��y&��ךW�ǧ�bv�R�	���N\0��n�	T��`8X��A\r:{O�@\" �!��\$K�qo��jY֪J�����h}d<1I�xd����TT4NeeC0䥿�:D�F�5L�*::H�jZ��F�R�MրnS\n>PO�[�\$V8;#�K\\'�B��R�د��R�_�8�j��*Ej�\\~v���v��p@T�X�\0002dE	�H�V���D�\"Q'EDJB~A��A�Il*'\n�Y��.�+�9��pg���/�\"�1�8�0�IA�FCȨ�V*a��P�d�У5H\"�A��6�s�Y��;訞�/��0��v}y�\r����ץ1�u\"ˋ�m��_�0焄`���\\B1^\nk\r]lh�}]HBW`��0�꨹rFf�)�W,�ҧ]sm9'O�xԽ�,�9J8��?�4�����\"҅�۽�<�-S����M�;�v��6y|�Z����%�a�#8��TC�!�p��\n��CZ(�w��a������?9|��0<BL\r�\n�]�PB0�&�+t�H���օ�Dx^��,�L�}[��B�x}��ru��\0��\0005��S@\"Uؔ@��\0�\$��ސ\"Ҡ��]l/	��I�B4��.�6���d7��\r@=���߬���*G j����f`��:Hn��bĀ71��)C<@A�Y#�����e�o��Y!��I�DM�\nlt����/)�\\43)��2��ɸ�)���f[ ppp1���#��Ð�p\0��œl��^{��A��TH�6�����\n\0P�H�.\r���|�T�FD0��S�y����'1���K���d�����B���C�&�)�W�s Hee+@4� r���ۚ*Lp1<�f�N�Y'�-	XKVa��L���\"���\"�l��q��.YJH�m HV�/�lC�&��H)o�&\\2���%���z\n^Q(6�D� ����Jq���\00a#�6\0vr,�M��&A�������9%Yd��B�h��!W\0�b\r{���@�1��I�22�A��)�H�a@r�0G��7Dd.�LM�<��2���,k/��Me����}Ғ3�=\0�&��B��\nPd.\"��F3X��Sd(*�J6 ���F:��)1�1�?lQ&����h<J͋�f�d�Eպ*�x\n\0��.\"B -�#��Ηt�IΫ���	I8 ��8dh	��x���~��	L!K(�BX��-��h��c/�r��P�I���N�2�|��׶��|\"�M�'��K,\\H��e5*o]4��FP	2��<)�T���o��\n���I�ڢ�!�(���_8Xr�;u�����NJ�����[r��DC:�@�ͳ�l�\0�e\\*x@Aȡ&�(�5��,����#1x� �!T�D���(Q���DJ|D D:\0�A�й� �baE�?rn��Wkx��X=i��,\$3�[�r�9B�Ʊ�d��\0��H��4���<(z���?�sIbJ�g U�\n(}���J\"��A��B�19�~�I�#�\$��%d  e\"�`���t���'O=���@\$��O�\nmT�o+�Z����-�����PF?�_�I�J�X ģ2���-V�;�?2���0�*P3����_T<E�J�\\(�2����)�IQ���鬩���R��L&��!ȯK�iц�t����K�HRl�ȬEs�������D��xǴ�i���!faB���F��e>�V����-Qj�I��7���\"%Rh� g��M������-�b�58R����*��9��ꊰ���9�2Q0���IR[�Z��N\0���20�����\\[@�Q\0��Jx�����EC{���\$lp1=\0�Rо�>E~�������:0���%��R+)\0�	ƑQ�@(\"�_j�T�X\0����\r1�\0P�9#\0����H;B�|���L�Z�����6�/B��\nB�{���|H�,�	*;��(�`�2@6�>�	�?P\0/���\0|\\�eB�`��jq�U/\rc�����҆�6(N\0�/\$�\n8�j*U�\$��y*�=�;���\$�f��8X�BCE��r\"/�����kځ%\\9k���B���0�F��(��'�U���Ʈm�@k�T\0��E��sEhy�e\n�)�)��b7��(W%,�J�r��2D�rhE��\n0Q�3� U�9TPO������8j|�}�R<0���Zl ��T�������*�\$��U\r�\"�.� Ts~�~(�3�a���@��+���l�`:�`�:O�i��BX�?ʄ��7��Lj|�:n�K:ز}�\0��UMc`P%nn\n,�4�Q'%+H.�\"#G��3`�����\n1fg\0�М'�k��qxD<\"��,a|{~���C<S�i�B�\nkN���G�}���k:��������g�)�JD���hÛf�\"�kV~��mM`HO�kD��^�0/tj�l�\r�!�f<��G��T���v�#@�ek@2�w���0�ܭt���į1�u�yvː%8�?1���l��xt��mp��fK3Z�J�=\0@�^p��ۑ����]Ҳ'�t١@C�b��\r[��V��-���o�-��ݠe�}��Y��	-�-m�I\0+��V�D�[B+��(�-�4�>�q��i>=��/0-�cL�pJ b\nd��)�#��G�s����\"�Q�N����`.�ȍ�yȐEtP�q�I]��J8���rWT��I���f�aG�.떄7y��l��A��7'�1�	�S�-�xI��m���L:e�ΉA�W��ζEI��Wz��3W���)*/)C���x*c]�%�}����_��IvͲ�'�\$U��S4k�5WʏJC���7*�b%<WC@�	����c{޴���3)X�&&��eL�I���,N� 2k#p5���f4���Ǻ�z�#��\\����N�b�U��oy���S�4�`q�~1�=�8厉�*�OOJ�C�����'Dd,@kL�������\\�j2ͩ����<�@_q�2�\0�ձ�)`�������s���F\0�����\n���F��<*�x*����`����-��\r���|@����7�H@w����H]��\0�����_w��h0!�s�1Ϗ��Ǭ�hW��.��=W��R*�A_���EDԷ�?1,Ub�9=t�4è��W��^���;����@��(1<D�ÊHx�T()0z�`�_�;��AL��)\n�K[f�H���Wo�@bBK�iM���d+�>�vI�(z:��.݀��9uiѤDY����O`���]I\0��R�Ć,K,���6L��\"\"�1g�(���|T.,�9vb+\rk]u�&�|��b�S��d[�,g��aJ�(C��k��\rF�+	��9��L��))UA�B�U�h�g��c3x�-n9�����x��2��q�ib�rY7�k�y�f�,������)�٪�J:�N�8�Rcly\n��2�W�;�.>�v6Q#A0��{έi��7~@VX���^��11-�+�v|��]Vf���.�{	���\r��;�1lp�/��uF��d�\$PЮ0=@kS�0h��Ɉ@��/*(O�V.��G>�(r��!�6�����Y=XZ@�:�'&0�6kE|���'|H;���N�g�%�W�+��4�;̓��'x|�f�9���(O��d���w%9]��f}��G���s���¾�����XM0����gQ���8̄�+O}�͝0}�9�������Nh�/mgD���s������\n�74勳P~}O)�Ug�9���j�8P��ݸ�(�%����j�7oAB��i)��K��u�� �}s�1�=od�V[Ĵ\n��zl�Mзr:F#{��*#�x��ܰ�<Ds��k/mw :^����1��ύD��2�z*��n��%�����i�Ù *�!8-��tH�'����\r�к�4����8`��\"�����i]�ZZ�>Z\0ަ9����+䟂~��\$ޭ��L�P\\쇁�XA�������i���z�h�\$�SM�T'���1���D��	��5E�\0Ğ\$�ttԮ��:\rMƷS��Ӗ�ls��Af�K�k,N�l�D^zz�dS��/rt�N�>��o%i��\0J�B�po��R����/֘٫x\ny�+��,e4��q5Q'JD�]�B@m����R�Ski~����t0�[ 1�z	���&��^�\nO����V����GV@T*�H9�ωG0\0'�`�Ѱ\r���bQKsLd�*;\n����.ĔUNp�,L�@TR�e��b��F���y�n> IK��rG�	@��?cI�ݓu%G�O�1���C�h�5T�y��I��:\\0��X��>�ʊ�0�޾�QB���EI/-LBT�!b��6���k`jp\0K���>k�d���/���ISk.+*���R�|gR���W\\w���t�.)�^Zc8�Z�~F��Sǵ�S�m̕;b>\0jz=�T'�>��q�y}:�u��&��W�DQ��c-����6<[��e�x�ؠ���[���L�\0wm�l�t�z��<S�&��db�x��oi�gK�\r`�µ�?D5u@b���N��O�𤷤���Y�[�����{�Nr鉞�t���\0��tMs�cBW?�*D�.p���'2��Ge\rp*#�e�����C���\"�QI\n��hi�Q�@���\rl	����_.���t*�^��s�9���Whq���~,��Yθ��dQs¦\r�Bj��D�ǡ��<<T)C�\n�����&�D{\r�l���-R��\r@rk��Ϣ��+Z���P������u8Ȩ����s�و���o�#��g��u\$F�&\n-v\"P����j�nnt�1��V������Awbx߄�D�5��-�0�a�\0\r�/!�I����|/����h��n�Gf-Mdna�^(e�a��¨�Y��Z,�S�E�N��\\�����=�4~Mʹ�\r����Ft�Ŧ�u\"|`��E��R�z��D�`�{��@�k/K�Y����3sJ�䃿5XGͪ�%�9)Q�� �Q���1t�h��!TR���H���Q�\r�C��E�0�#w�G2��/���/��=^ �/Ժ�ΐ����E��\0{+���t�+��q�б��I�t�|����v��q��Ԉƌ&�\r\\�Vߠ=���Eb��nO�rn��X({�ɹuzK��`=:�\n����\0����[�%�:p���q+��R�ldY��\"��[V�u{H-��H�_��8j��V��5����\"\0\"N?E;+�O~�wN�];L�'���SOF����䁻��D�-�!#sN�<��� ¯��mu����G�8���Tn]�����:�zIMn� O�8���z5���o\\5�7�<��Ų#8���?sN�L��	}�x��&4�?�[�z���󳷶����<*W������e}{HZ���,(<o�o�xW�t�2���#�A*�����o\\�R�}xH>NP�|Qɚ|x�'�-� ��2\0��?ƾ2*\r|]t��p�\"�ڲJuuXyb�D\n�Z|�H7�_�W���GuXyH>T\r�G����Ql�������n!�u'�*�C5��>U�2!b	��9Pw��4�����}y�W�|���a\$�g������T�U��&~9(\\*�!b_����w�7\\����]=�\\*���@�#N7ͪ��5QN`@<\0�6!�9��l��\$�wI\$4���2��\$�&���.RZ����Y��uyᤳ�p�&SI��@�EJiL�c���V�1F�1��Z\r\r���h��k���HH��˿�����K���?x��-0\n��d�N3K��C�59)ľ:B#���dN5A1�Ɖ����Od[3ڠ��h�[s~)�9�DN�y����>���X��'Ƚ�ϐH���,��)ڂ�\"�e�0;\0�qeo>��=�|�2�G+B�@z�������@]}��rQ��� k/�|�G�:ѯ�W\0�a4>��^|���g�o�XE�9p���Lrg�A��6��p�e����1�*����7��[�>]�#�?jB�~�/�}�3�:��U\$�?�<��G��a���\n>0#!i�>.{A}'hQ�Lw�~�W_��Th#d��û��d��FQ�����*{��\"�\"�P{���}�4�N���i��\r_����e?l4�2�?\n�F��	��q�U��Ľ�_��`_�����j��{_k_�o�~��c*#�(�/�!Dn�F�`��?@s�B�!�?;�E��������\0k�	�*N��D;���+d\nZZdB��� ��`B5�P\n8�������c#ou��k�ˊM�ݯw�.��F�J���!|�Ĉ2Fc�Y).����XHy�[��~����#/�&����[�����Y@���(|\r\0,O��0Yb��βŬ�\$0���aˑ����� �A\$��0,�@�Ӱ>>9��\\t�i�<�\0�q\0�}@`�\0fVj����dߠ'(����	!_�n��0+c���iig8a]'=-�B!(��8�_���x�j�����)\rH5H�Yn	,f�r��}-d\$��H��2n鴆ܛ�=�-�d���FE-d��a��N_z4@��[�n��\$x!!i0T����u�8�ɸ����\0PZ8Z����c����+Њ�AAF(����`mg*�vS, ǆ��KcA�۬ &��9������c�0w�+�n��=��)\$���Q�~A��a�\0004\0u�{�(��\$���y	!��B�� A<�a��Az ���ZA4\$ZY9.aX\r��d�A�L�v|oOz|�Z�(�e�Z�Ć�");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0��F����==��FS	��_6MƳ���r:�E�CI��o:�C��Xc��\r�؄J(:=�E���a28�x�?�'�i�SANN���xs�NB��Vl0���S	��Ul�(D|҄��P��>�E�㩶yHch��-3Eb�� �b��pE�p�9.����~\n�?Kb�iw|�`��d.�x8EN��!��2��3���\r���Y���y6GFmY�8o7\n\r�0�<d4�E'�\n#�\r���.�C!�^t�(��bqH��.���s���2�N�q٤�9��#{�c�����3nӸ2��r�:<�+�9�CȨ���\n<�\r`��/b�\\���!�H�2SڙF#8Ј�I�78�K��*ں�!���鎑��+��:+���&�2|�:��9���:��N���pA/#�� �0D�\\�'�1����2�a@��+J�.�c,�����1��@^.B��ь�`OK=�`B��P�6����>(�eK%! ^!Ϭ�B��HS�s8^9�3�O1��.Xj+���M	#+�F�:�7�S�\$0�V(�FQ�\r!I��*�X�/̊���67=�۪X3݆؇���^��gf#W��g��8ߋ�h�7��E�k\r�ŹG�)��t�We4�V؝����&7�\0R��N!0�1W���y�CP��!��i|�gn��.\r�0�9�Aݸ���۶�^�8v�l\"�b�|�yHY�2�9�0�߅�.��:y���6�:�ؿ�n�\0Q�7��bk�<\0��湸�-�B�{��;�����W����&�/n�w��2A׵�����A�0yu)���kLƹtk�\0�;�d�=%m.��ŏc5�f���*�@4�� ���c�Ƹ܆|�\"맳�h�\\�f�P�N��q����s�f�~P��pHp\n~���>T_��QOQ�\$�V��S�pn1�ʚ��}=���L��Jeuc�����aA|;��ȓN��-��Z�@R��ͳ� �	��.��2�����`RE���^iP1&��ވ(���\$�C�Y�5�؃��axh@��=Ʋ�+>`��ע���\r!�b���r��2p�(=����!�es�X4G�Hhc �M�S.��|YjH��zB�SV��0�j�\nf\r�����D�o��%��\\1���MI`(�:�!�-�3=0������S���gW�e5��z�(h��d�r�ӫ�Ki�@Y.�����\$@�s�ѱEI&��Df�SR}��rڽ?�x\"�@ng����PI\\U��<�5X\"E0��t8��Y�=�`=��>�Q�4B�k���+p`�(8/N�qSK�r����i�O*[J��RJY�&u���7������#�>���Xû�?AP���CD�D���\$�����Y��<���X[�d�d��:��a\$�����Π��W�/ɂ�!+eYIw=9���i�;q\r\n���1��x�0]Q�<�zI9~W��9RD�KI6��L���C�z�\"0NW�WzH4��x�g�ת�x&�F�aӃ��\\�x��=�^ԓ���KH��x��ٓ0�EÝ҂ɚ�X�k,��R���~	��̛�Ny��Sz���6\0D	���؏�hs|.��=I�x}/�uN���'R���n'�|so8r��t����a�\0�5�P�֠dẘ��̕q����5(X�Hp|K�2`�]FU�~!��=� �|�,up�\\���C�o�T�e╙C�}*��f�#�shp��5����mZ�x��fn~v)DH4�e��v��V��by�T��̥,���<�y,̫֞�2���z^����K��2�xo	� ���2� I��a�h�~��c�ej�6��)�]����5�͍dG׊E�t�'N�=V��ɜ@����b^����p:k��1�StTԙ�F�F��`��`��{{���4��7�pcP�ط��V��9�ىLt�	M�����{�C�l��n47s�PL��!�9{l a�������!pG%��)�<��2*�<�9rV���\\����]�W�tn\r<ė�0�vJ�栱I�i��1��Ys{uHհ?�ۖ�����U�o�Aߒr`S��Cc���v�˳J�c�����=��-H/���q'E���w|��N�{\r};��>�x�r���u5�B�*\0����M�����a��\0�{HU����C�W�廳�yB'�<�6�[��s���y����@��{�Q����>?/<�K@� ���B�|aH\"�� R	�@>~@�BhE�L\$�[��Sa \"�Ђ0�Fe`b\0����@�\n`�=���n��.*̔�O��Ϙ���n��<jO�lM�\"mR���/��*�&T肙�T� _E4����8���|R0*�o��Bo>S%\$�� �N�<�|��ξ����y�7\n����޴�,鯢������쐬�Pt��\"l&T�o��E05n����o��r��v�������֣Bp��p��\n���P���.-,��q����3\r/�p��P���b����%m���P2?P����@��0(�/gpz�0�`��gυ��ϑ�\\嬳q��>��p�@\\��u��@���\$Ne�Q������0(A(�mc�L'`Bh\r-�!�b`��k`�������`N�0�	�ЯnN�`��D\0�@~����`K���] �\r�|���ʾ�A#��i�Y�xf�\r�4 ,v�\0ދQ�ɠN��Xo������ q�'��t�r\$��np�6%�%lyMb�ʕ(�S)L')��ޯL�M�I�s {&� KH�@d�l�wf0��x��6��~3�X�h0\"��D�+�A�\$��`b�\$��%2V�L�� Q\"��%���R�FV�Ny+F\n��	 �%fz���+1Z���Mɾ�R�%@ڝ6\"�bN�5.��\0�W���d��4�'l|9.#`��e憀�أj6�Τ�v����vڥ�\rh\r�s7��\"@�\\DŰi8cq8Ğ	�\0ֶbL. �\rdTb@E � \\2`P( B'�����0��/��|�3����&R.Ss+-���cAi4K�}�:�����\0O9,�B��@�CC��A'B@N=�;��7S�<3�DI��MW7��ED�\rŨ�v��@�DȺ�9 �l~\r�d���5�z^�r!�}I������sB��\0eT�K�!�K�UH���/����2�i%<=���^ ��g�8�r7s���%N��E@v�sl5\rp��\$�@����P��\r�\$=�%4��nX\\Xd��z٬~O��x�:��m\"�&��g5Qn�(ൕ5&rs� N\r9���.I�Y63g6�]Qsv�b/O �|��@�y��^ur\"UvI�{V-MVuOD�h`�5�t����\0��T�,	(��q�R�G�.l6[S0@�%���C}T7�85mY��)�8�C��r�;�ئ)�M+�4	� ��4��|�Ϊ1�ZJ`׉5X,�L\0�7T\rx��H��dR*����JЦ\r����52����-Cm1S�R��T`N�e@'Ʀ*�*`�>���\0|��I!�E,�ag�.��cup�Ý9�`B��aa���p�`�m�6��R~�\0���g-cmO��1�\reIN�QN�qo\r��nq����R6�n�Sn�t�w�æ\r�]a���-�a*���\\5Wpv^ OV`AF����3#82p�H'J'nM('M=j�9k�ZbBn�<�@�<� \0�fe�:\0�K(��N���v����-!�1�ލH(�Qg��µ���y�<�� �d�\\�c\\�s,u�˃q0�~�i~���e�Ѷ��*�~��Ƞ�~��M�m���}Wؘ\r�� �@�\"i�\$B���c�g��5b?�6!w��+xl1�`��`��	s�� ��������.�vCnhEd Q��id\"6���`�\"&f�x�(\"�2�Qz��\$�[0%�0lw u��>w�%ر��%�w�Z�\"-���u�%�����Y�g��>x\\�-��פ���-v�\\��x^'M	�P���Y�P����)�8�%�C���@�DF ��\r@�\0�\\�0N��.��S\$��YI��C�I�� �i�>xP͸͒�:ͷ�=��T,�'L��ٞ�q�Q2͌�\r�����d���Δ���@�ђ���9F���`�O��f�O�w�\\h�=�}S�jGGW����A��L��RJ\$JP+�7���L�v,ә(̵���ZP�g����&z+����j���˘7�ͷ��-�vA��w��h �^9�T�OD���Z��C���m����`O��R�yӒ��!�Gvzs��G�\$IhY�����58��xF������Y9����i�ݍ8��U��C��[���e���Zq�uA��1���?���و�9!����:�ړ����b0��{\r�Qh`Md7�{2� ۲8�H`%Ƹ��{-�l�C�Xk�H��Ӟ��|\0�}�X`ShխX�ց��\r���O�y��X��� �:w7�����n�鲌�#�/�:4�(M��;���c�D��z;�Z3��������]��砛�?�.�����\r�o���bO�^`Ϻ�|��������/��X׎�]�|�����^�!%Xٽ��8���\$�;��z�T�xK��-~� 8X)<!��y�x�9�����:�� ىF�������x�z+U຃�����A�E�;��'�%c����Yߪ����w�<{��9���V:��`��ʇ<����G�ء�Y��\0�Z��U�Zq\nmx�)_�}�YǏ�_�z�����y\r�Y��,ۚ3�L��٪�Y��ٸϻ>�M��	�M���	�)��P\0u8 S!Z{Y����9θ���fV3�o�Oϼ�E��`CЭ��࿿XU���}�lw��0�}�����͙�7�Y3ӬӔ��4��G��J��&�ä��ͭ(���-A��V=f|���@E/�%\0r}�ޮnn�\0��Ly�����<+���_��|��#�A��\"C[y��EW���rW��f(\0��Л�>�)�����_�U��,U�\\�#��e���*r�`�N�Y� �*�=a�\\��&�^g4�mü����e#��^�|ނ�QXN����I�>��\0rƉ���4��^Y�V#�)��k�>�׾���Ι�ԚF�W^��%�ݒ\$+�ՍP�kY*u�~��,��M��W͂hhG��K��\\C��7HmZ���S�Z_U��%�\r��b)��gg	q�������@@�����΅t�\rJ���۔��7s������U�K_1��t�j&S�Bi\0��� &\r���`�:�j�F�~=T̪��g�侑��!���^h�^�ו�������/[{�B����(�/�|���g���j/�d\\ޖSɗ�9���G`��u��1�M��?���3}�Q\$q�I�m~����G=��oVz�\0_p���!t�r{��^Z&��	��u�X��1@��G{���Ь�	NI������\$=0�Bu82�S\"�6��Qpj�ov\r<��ɶU�\0.�����E�M\n8�V�oQ\\�`?��L6���=\r�l�����������\"�����B2pu�&\0���5�\r�j��0V�A�����;v\0eH;��ʇTJ��6pH?/\\�H�@!pp�C��+5�\\+a�8;�\r(*��T�Ƣ;�O�|���^Ld�&/��NI�T��|#���G�`j%Ǘ��D����Z�ġ4�ni�i��4��]@t��#5c�ľ��	�Z��R�yR`@ँ\$I{z����胇��4|� ��׉�܀@=hCE��H��, ,Z����i���K��àP�|,g�z*�����E)AjknK\n��C\"J79�}4�f����*�4�65����׏���Q\\���c��M��\r�{��*�1j����lF��m�4��M�*�`�X�G�D�A-qqab���1�9R�H���b��g8�+�l/������ń� (�ʀL\" 8���0(Dc��#ihc���`��8���A1�\\�uK(�4!�������d��3�8����ш�Ʈ4�j�;�#��Ø���s8���5,ucnc�F�N��pPa8�G8�r�K��������ύ�k�i�˕4�A�	�8TҨ�26 ;*i��X����2%M�BJG� &�C*1T\n4	-#�.�%���'z�#�8�A+�@S.0�׀���II`U�Q��U�dd\$)��*]���T����C��9M*��	\$b+��ѽΑ�ydt�\0-��L��8\$��e\$���<Aɍ!�d�\$�p@]�d����&��M+2E��y߈((_|�Md�vU�9!�eD	�(��W=���#���_�'�bN�;��'��\0�O�<�L�iA�� Р�T�����\0�Q�J# }Ba(�/�u�GB���%-)��h��u����~\0�I�U��Pr�+1�������%51��ɒL`ܞE'(�/��Q�Ô��%T�)9�Or��T��],�?�<�a�	����/|�\$O�@Z��I�XN�|�%�,�SK:]ha��%��)k��P\0,���'�0J�:��	��&����V�0����jهJM�*�x���P)���j�K��R ��\\\r�u\r�(ÐW���F: k�����\0��NJ��P!�Q2 'H� *\0�g�T|����~g`D,�Ͼ\0#�	�;(\0�� ��L����f�5�'��`'���&t(��L�g�A���\0��'��ksi���&����d�m���P\"�Ng`O�&����� X@�	��%sh��g_�sb��f�5��M>s3�@T��77�+��nS��dӧ5'�6s\0\\���\0O:��NLS@ P�{;9�Ͷp�F��@�78_�l�9��\n���)�Rg�9�@a�:i�\0�vS�D�g��\0�S����\0�s�M\0B�\0�+O�q�`��>��4	 T9��7=�M�v�=q�'y;�'L�f�F��f�)�ϖwP��T�f�>\0�O�|��?0)O�~�|�����`#N���\0��>�'Ϫ}�ՠ���>�~��e	\0�?�*P��3��\\��@�͌��5\r'�C��P�� O�E\n�MB�#к�T;���=jPރ49����Ez#NƉ٢���FY���\\��\0CA�QJ�TV���������7 \n��v�0@��_��Q�L�RRc!��V�|�z��6��KKю��eS������4��\$�aI��|P��A+��.qKD-�S �EvbCO�>��H����<��\r#��LPܘ�s⥺P֭2�0� =�*��WL��2d�t� \0�!��<	�b�q�\\pa@�Rd o�fKM���p ���\0}����z�\0�����2�Ձ��3\"� �)@\\*g�r�M#!�8����dP4�%>K�mA��\$C�jtqP�9��Ƹ�Y�jP:vTu� 䆀��T��`=�p��cj��*�x���d�m\0���MJjFm�p���A�F�QR����6�F�Q�lDj���E�MSȖ�4\"\"m�@J�Q�H����@�(���h`O��f�8�>P8	�{;57�,)�䌆mSv�g�Aᓋ����|���P��d���O�x2��.�S�,᦯8���6q��,�Nz:��L����\n(%>��O� N%'��>\0�����U�9��aÏ����P�I�OH	�9\ne�5@\0���ALS!m����qv���(�N�7=�=Y�AN������R��)ϊ���4��X�JgSmZu\"N:�*4�*�,�:�	��	р������L���5Q2����VXR�5ש%��a@�v�J�򋈵a��Xv�(�u�j��T��6\$�X胙V�ا&�����H8z~�y�^�k`��?l� wuuz�@�lS~�@.\"�E�S��*�����ebM5��Z{l{a�/��X���U�1�֡��񎅦a�X�Ul1�ʢ�\\����6s�����:�§��Y}��ި���e<,��s9�.!�SV��\n�b��\nhK#���l%g[;̤��X��>˙gQ�\0��ӳ�l��v�D���Au���X=B�*�d����s�aڊԕEZ�Fl~�b��{\$_�r�\0Mkw�/�~�y��|C�j���^�5�D�2%�[D��u�xo{Dڶݶg��1\0Ƭ���>���/����Z�ҙa\n�!�E� �A�d*�e�@�}U�0 7}h\\�+��1��U5��\0��9R��V�anh���m b	��  =�έb4��IO_��[@J����u�`}��N@�ܳ()���xS\0 �z���\r\\j�W 'M��w>�[��.KN��x��v\0� \$)�� z}(�Z]b��Ẽ�+Xz־�G��h?E�Q��b����vK�WQR�KqE~�I�T�5�)��n��\n�T-yD�K{��`P/��V�:��I]�n�i���3�X���^~�����L�\"(S���2���k��\r?�c��l��U,;�M�\n7ꦖR�f���R�y�ԔzV.�ko� >�b��s��(!ۋ^�=���F\0.סMJI.�Hiً8A3����� `(\$ړ\0Uр�?�(��\$�~�D/�p�a�����Tp\0�C�Z2�.,.�}�� �Ѱu��D4�X�	�p�3��x+��i��\r���Ex�	��l����ј2)0�pr\$�����>% �z3��!P�(1P�p��L\"\r�s\$��	�7%Ɍ���6��12����B��l0��|.Z(?�Dr��Z@<���m��{��fC�,a�n#>���2���A8` N��\0�U��f1�<A+8�Zq�ja?}�Fp�:�\"8ɇ9�`�0݄a��\0nB7=n\"�o��.���i��J0��G�����b�\\l:b�kdXP��ˊ<)�\r\"��K;1Udb��8��L��V�� ���7�0H�Q�*c*˙WY��X��ḳ�-ѱ�7|R��8K�ܓWtL2<{����5ٍ�>���e���{�ʟ3��\"Jā*�R�BcлV��q<�+�q̅'##>�2F0��\"X��fE�{�|c�t��M�5��ȷ>D\\X��Mg�c��	g���U'���5�\r9%�Q�W�����'�d�NOW�����#���~�u��e���Wߧ�;���\\S��&����,��}��_|���� ��!�vx� ��]m�1�|��Dx.�Bo�,Y�	�tø ��]�Y�l�/�;�YA[�˄u�`7��q���?�F�\r�v-�@٘��\n3��h�j#���K 6N�^H���\$��(|��\$����e�'�H��%�p�ğ%	l\n�K �����cg����B����\0%�{E�z���Yjic&�5�nG�g��/��Z���} 7G�\\K�K��-�Qf���pl�����㘾�w�8�a�L�*��}�]�@�R�}JQ�qg����^a<�\\ �g��C�[���PR�*4_Y�Vv�\"eq�0?Yw�V\n�ݛ2�Z����&m�2��@hn��\"&�@���H��4�O�U�,;����˘#L[��(T�����].���v��{|�\$\06{+\0\n�/\0�tI��T��Ŷ�1d�I��	����@��*96�t�Szi��Mr�숁�(���\r�ӱX�\":�A��ބO����\0(	M�wӆ�4��J��K�V���9�2jf��~��@�L\rCjyz�\n�����^�KR��԰����WVڸ�7���W�Ћ�F�5��c�GP�=n������;�&�8�+-C�\r�z�qf��T���@SАC�ͅ�5kyk/�bEŠ8}t餎f���o�H�{內����I%����a����o�d\$��qzJ����N!oP6�dF�H��\rq��iv������c���E�P�E��	����4�p)�}�+f���wI͓U�	f���{����Y0�u=�Mw�`U*���Nci�4+�. ���m+lL!�\0ro}��;a!���'��l�]bY��v��%�����\r����Z�}m�\r�'p�˷N�i��O�IW�Uay��\r�sܨv����n+��+m����dL��p\nU�\nC\r�wqc>�Q7c�\r���ۙ����BU�Ϛ�v[�7�Ŵ`�Q\$gY�T9�PU��@�v[�ܦ�����ōL�PNξ�n7p&\r/w�=~�혃rp<@e-�K��/e�V�=��*��_�a�;ڈ5�e5�y%��JB��b-08 .֦V	�� Dg�\$U�5�4�Am?@��\$���\"���'{���h�85���c���׶B�P\0����&L+C�\0P0'�0�P?&��ϐ���#͒\n�B�\r�X'��s�`!rNhx1d�B�d�ɿ�;����rJa�+�C�F��.�6)����},&����Q��/L�?�	�ƬW�k�p�`�Q,UF�5�=h�{ZO��e�W���f�����W�e���\0�ѯoPi<�Q���&\$0��7{�����J��ebw�4�,��[j?Y�\\� ]�#K�.���Z����=�\0Z�%�&Q2�]r��B����m�|<��>���/k��/J���Vk�l�\"�������A�a��o���۫�s�u���o99�c���G��\\�Ξ��m�p�_R��V���E� �p���R���@\\^b�mҸ&�����g����_���.A(�4��0w���N~�K�|�x�����r(r|��'#�G���D���k���W�B�\\���[�=��ScRc���[�7�8i�1�/�m�^���\"�w}��z�y\n��p`�6(�m���\0u�#�Ne�c��T��\0x�GZ:�87W������V!��ˮ��hB�E�B�eے�/�&��,Gڍ�Bf��t����쎓��耷z&�b2֐}a׏B���ގ��܀Կ ��|\nt�\0t(��k��Pp���Wi	Ͻ;�4��v�Nt@�q�ʣI\\՟?;��=Wt��V��H)\0'B�q[1�v���3��z�n��#��N�c}I�S99�|#��3�\"43��p6�8F�'��9X�}�^�ov����e�6����C뗎�6��B[�9�B��1�ŵqN��y&�rY\\\"�\"�v;���p��=�&�a\nT��\na����C\\\0002�D�H�0�<R�������\"����R�c��=.�7��U��|FS>i�Z1Lƾ���_O��!!�D4�.f�e�����౷,��Z���@�\0<F.�����c>_}�������ʠp�C<�I�=�Z05ь��)ގ������Nz,u�����\\p6ޟy�-�=5�!T#G�\0*m�����Inʩ��������:�*���i�`7�h�����罈���EB.֜Xʉ��`U��q��s����sl[S+{��	��0���{�7�<p��n�͹��.����]x�m��b�}���<�[ݻ��W����Vh��kY���>�e�5�\raa�F��Sx̶�OcÐ����[L�e�𗂤 7����>@����+|���;������.��@Y'������>E�@0��@@��H=C��`ր�b��-Oz�m���t>=�=��3n!�����8DM&��J�w���.]\0�O?�[�4D#~<�O�����\"�	o�t���BcLK1�	�YĉI��x���8Q��e)���`���ǐL�6�+�جB���wbo�L]+VP����B�E��幊�_V���x�r�|[���\"_~����HG�sp��C�\n\$��R`��Ǯ` �\"�@F?�	Q��q���^��`�W\"�;�\"IPD���ǆ�2������oC�n���}s��x�2��i�wc%������\r��N�\0I�����C�8�p����YP!�)�F5� ��	���c�.��o�7dZ��`<*7��������4w(�O�r��0n�������9��'���t�X�6g�6�\"�V:������V�`\rZ�Z��A��&!�_O\r�O�D�	���� ,��34/��o��m)���#}����yĤ҈[n�4\0���<D��.���� B��>\"\r�C����;��@�������\0��D0�Z�b\r��V%\nRRA}����\"�.��P��>n1�4�=&:>�\$�^RMpQ���\$�L\0�1��𥀔���}���m�H�B��	��	���Ah1�V�=&�L�	A���T�!�\\)^�2è.�W�p.�C�Qؔ��\0�\n`(�.	9�@���`(�|\0ʦ�>����#�@2D@֒�\$�E\0f��r�v\n�*`��.�W�s�\\�|�>�H��*��Ar��Q�j���P�;�D<|�I�N��0UAX=)�k���X0��v1�ݐ�A�U,#�DAc@(P�AZt��p[A��/����	0�0_B5Ik��4�d��bQ�g�T1��%{ѩ�=\$�PI=KH���\"0\\A;	aҢ��]�&7A�\n:Y���\$)��\n�.�k§	�Ps\$�\n�Rp�����+Ј/�'�O��#\$,𡥰*dЀB`� �B	����AHTD1)I�QtLN�C�=\0���e��\n{,���<4B��Ii%���\"P�\$BW�h%S�P���30MAE\n(�p�A�|c�)���\n�#Ǯ'\r8�X'�[����5C���0��B<�BS0iBf�L�x	�1f	��@�ДC	�;��C�U,8�b\0ޖt)\"2A��iRC�\n�/������:��ì�;	_�X(��\rC�\r�;��C_(��B�,-�dC�\n\\9P�C��.��=B���-�t�]P��o�\0��N	��ֳH�h��^���F@�/�<��\nDj�`����れl����|/ !��*���G�3�^�\n@��'�	C�����(��H��'&��\"���\rLF���2��Dx���!jD�I@<�vQ��0�� ��C��XH\0002�^;i�~���TH�6�5  C��H5(��49�I �,SF�_TS�F�B5\0Cq!�`�����\0O�P�DEW�Q�PEE�?�Y��<S1]EY�Q�_�H��KX8|X�\\�7�QqO�x�����,G�J�\\I2��0SQ#���a\n�,<\\� �=\\]�+�%�I\n���\\��\n�\\FiTĪ+�,D��K�/���1�\$'�Z1T���U�PE |R@/�({Q`0��\\W�E9�Uщ�+�c <�9DX�^E�|R!lF,� q�\"�H,d�bŧ<eq�F]�ɎFk�UQ�FClRq��(	���D�g�F!De��Fw0ܱ]��le1�F%\$e�Ÿm�M�]ğ���ۓ���ۀ�x��x\0�����)�Xm`�[�K`����]mP�:i�SM=@9�pSFĘx�B.�t��\0�p\0�U��\rNA;�����h��x~� �w���҅x�8����s`�!_�k�\0P��1@�\$4��w�����1��nª��*\0�#R��0?�	�'\0d� 	��(Hx�G��\$��\0�H�`(����x�GD�tH�!�\nɁ �Ǟ�FJJ|�6�>?�XBQF��Q�\$`�\0>06�T�\r��Z\\�:	(+ �FJ�Q���df`>\0��d1��h��P��pK�\0�T�@0�B��H�>5 �i 6Ɩ��j��B8��Z �?�����4 7꼀���D*�<l���H1 ����7�5�%�?leQFȝ�\n`<�bĊmr���d���\0�\"����ȼ9��1+�V��G�\0ɒ1�?#l���H���Al\0����̈'�3i����BD���٦o��c��ZX��MJ\\�#2�mbJ�\n�k@�G�ikQf)(&\\~�k���������!*E(�B�&�T�-�`�R݃\n��\"i�H�\n���\n=��W��<����@ *Jz�7,�z��!�&��\$C.�H��\r��F�`+?�������t��֟����u��]-����~�b%x�d)�\"|^BW����L3S(\nb��#�A�����R\"��&H�CTؙi�W�f��IX!q����D��	^H�T�	9(̚��\0��҇�����4)) �\$��~0�6#\$�*�t��#;<�D��ڤ��Rx�}*#��3ʐ�g�C��c4������`�@�&������[��#�da?��Y�n�;��x�:L����F-�C�_���rk� 	�\$��2��#\\K\nH�+����\r�T��;�+�TR�2����\0��r���*D<r�p��!@I��Z�ҙ��(��o���ChO��넚`�����2�\0����,]��\rx�@:@����\"��(H+R���-ܡ�텱+�b �Ib(��aHH�# I@)�ҙ\0��X��.@Ɍ����\\�i���̵�3-`���������<��&��� �Ҟ\r�#�`ҍ*�H\0�L ��K�.	i\nv\0�/Xe��0��\0��/T�@6K�)���\0��́�!��c�힬����\n5��E�v\0��\0L�Ҹ')�Vҍ;:&X��@�,�\0�Jo,ळ��1L�b�ʎ��s�(�ǓK:ɴ�b#I�-؉R�J�\"@��J�W�s�:��)Lt�ʁ6̬��*����\\������;�!F�9	0�V�G;�,�S����o]L�3�4�:�53�GL�1h`���h'��ÿK�02Cjo\$N|�HY�1��#\$��3��I�\"�Ԛ�KJq1Ժ�J�0�BW��1\$0���伮��\\�\$&�T��Հ�L_5\"p4�5H��H�0�ҌMR���[��6\0i7�~	\0iB͇6@#�͎�����@`��M*��M�K�LF	%A�Yh\r�!j��sp,)-(`�,M��}�#>�¤Q��\r�Ԍ�WTҐ\n(�M��A����i�l><�ދs�{(H\"�M�萤������i�SN�� �M�\r�+�������6zZ@? 7M�9\0B�����K�������J��Ijl��q�*��RM#T��'�n�쇒k)�9��!���\"��D��������/�JO�/�+3�\r˗.P[�H���\n�\r%#X8�m����1�ZX6��6z�xn\0�HT�|�J4ms���)� �K<�̜����l�C�����P��.�\0006@\$���\rKH�>�K�����;p5�D\0�;t��-#\$���I�0��f�8���3�;���3ʦ/=@�?g-kA�\"�i4H82a��%R2+�F����pa��@��pm�I�>\$��*?�����(\0���|�\r�ϩ5 1�(\r��2�˶`�OqmMJ�\\��	�>|���O�8��,:�8��,���c��r_����Y���c4D�&�\0���d��B�e0\$�T���~S�&Z\n��R�\n	� �K��r�:�<�����%|�����9��oPM95 6PQ=������:�5����1�@9�m�\r�E�`,��\rT�m��F	P2Q��+}�3�^f� )�Lnd�`�\0�+Ь���\$D�R\0���'��J\rd~�j\0���қ��:\\��\nJ�[�?: ��L����:�/+�>(!%1��f�g�/�;;3���v%|�t<M�C���DLC������Jo:���� �\n@9P�+Ȯ`��ջ���/P5t1J0 O�Ȍu5H�R�MR��ղ���:D�*�ȞD��T�oD\$�3�6z�=�T��FT졵�R\r\\��F\r@�<�)�o<S\$GL	�\$t�4-�XZ]Έ��f��2i�s\$Q��%6���+G�cSFz��4+LlA=�W�.lG�,��\re��R\0�˔�)�3e�Qf�P��V���.�x�y��H�bDI�H�x�{��G��4��G��ԎR\0�� T�R\n�%@�\nKI}%T��S3\0��M��A��EI\$���Q��M't��\"E'A��I�(��;JH�b��wH䂡��9I�T�G�J�T�\0�J5%��QgJ�)s.R�Ju#t�RE�%Q��q.��c��Kt�4����`���˂	U�NS\r'Ն�F�E�6I�K�(���\\\n@%H<��IL��<�s\"(%@(L	�Pq�\nC:aR��L�3��&rC�&SFZ�Y�0�>�ĸ@:53Md�Ի���R-4x 2I9G9iaGQ�g����)(�T�\0�FQt�K�	LDeӔD�kq�A�rAN@w�DB&5l;�ۉ8�sA\$�,h'�!U��\nA��\r�`(\$#@N���	��\n�Jx�04����O|�o��\$�Y����D�\r)Jƌ�Ϡׇ�\"(5����B��D���'9F�0��`�I��5��N��c�?E/���`=����K�0!c0\0Ҽ|��\$�H́F��0I�FJG&�\">��\0�u!�p�4m��\0F�r�L%HO��D)A�\0@�bX	b��d�/A�kl)А��OU�@6cM�b`�:���U:�ӲO������8�I���\ng#�T�� )����O\0�\0�`	�\0�(�i���� \\��D���\nu>'�T�� �?j��b~`&\0�`4�IBu	L�SAz�C�����i~�8z`!��?R�K-%��;53T�eL@�T�,9qU\\�� )=\0�D��A���`ɏ�<���&�@Tzc���(\n�;�\0��4Q�U5ԩU��+Բ�Wu.�KV-M5��`'��IV�s5(��e	�alUd?p�U_X\nZ�YyU�J�t�sWeK�^��[\0B�	�_f�MWJU~Cp��_5T��2\0 ���yX�;iPB̕�'qD�W-cQ9�*�LF�^��>p<\0�Ć�6�f3\\H,���YQ��}��<Ju��Y�f���%Y�g`6V{LM�M4�)0�C����j`9F갡�լ�Z�x�YV�Z�i�<�oZڜ5��NH�j�OV��m����[a�HP�Tmm���:j'\0<V�[�^ռ��0��!?\\ou���[�g���^mmUƀ�[C�u��Dmj��V��R\$��zga��Z�sࢫ��n�\r��&����+\0�.��]x�̆�ɽvc@Wk[�u��\0[[�P݃�]�v׉]���Z�:+�V�ey���������^�O�hV��<U�L�^�tM�\0O��	%\\���\\`�Q����[T��5���|5���]Aj�2%[S���\0�m��T[P8�o�+u\n�MV�UA�4)\\x<5�W�&�Z����)4�U��O�\0�]��,��`�C��Tppd��? ��7\0�\\x�͢\n�\r����X4>}jJoXf���W�S���J�it����b\r�v�n����ɀ�a{4@�Ta=vf�\0���E�a5�j�X�a\r���س`틑u�gaE��jX�Ռ�mX�`ŋ�Y�v�h]��XI`͍-��aѓD�\0�݊��X�c�V5�~2@\r\r&��d�VA��c݅�Ɔ�c�6G�]\0�5��D�vF4�aE�VLW�b��JX�aU�6���gi^�MdX���H��o��YGd଱�ȷe����X�e�vY�%[UgC�\n�N!%6\0G�0e�aM	�(�g�d�UvS�9d0\"QyN�_���g�Sf�]a�W�3�+��af ��r��)�M�Y�[�xa���!������zR����AY�\n�v+4Y�g�9zL�ݠv���6\0��n�mVx�iwu�/�\r�U���b���P�#cꝖ?�af�v�X��U����Ag��)�h����He���Y\rfxCR���i����Y\reM�`2F�eͧ��V��*�Y�i�]aTړbͨ���j}�v�XY���fکj]��uٲ��6�X�j���\"@\n��B\n��E���X�	����j�gv1F�}� 7J��+͢,\0�Q\0�;`B��Z�m�k��Z�~��bŮ����m��&��l�V�Y�l=}���c���5k���5g��`�Y�8�O6���lղ���-d\\b��Z�l�]v��mv5��m�����ؐ�\r�#?	g�V����T��@�)�]��\rx��k��>�k%\0;��d����ٮ�M65bL��X֭��SshE�֛\n`S%h'��Z ���kZ=��5�jmf���Z|o�Q<|`U߂(�76,ق�:��֛]�dpV�a�����mm�!��l��\$�E�p��\0�֨6E�Ad�������/�5u�79�,mi�Z�pzȗ	Y�:�Ģ>����b\\ip�77�f�{�q���܃p\\����0�����c5���4��6��_c��v�\\;d5ė+\\.���!�۟r��5�ܧoʷ\"9�h�	XQr� 70\\�q5���3Ir�9�M������ �W�A]\r��\\�t|�o\\_r�ʗ!��r��WF�7s���6]%tS�W>\0�s��wWOEj���\\�m��hZ�Qʣs�WS�9q���]_r`CW'�^u�7\\�]�ժ]qn-y�(Y�t�\"�^�a�]���aVgrmط^]�sUή����O��ݣZ��w]W���wl]2����XZ�tu�\0�	�tl6�օA�NQ�VcpͿv��3pj �P�vd�]�w%�# \\���<^v�{����v5���]U;q��Xi�j��^���~W@��l1�S�R�v����>�\n@���`ɞ��`�,PS�f�X*�\"��V��#��?�@��B��W^|�E�\0\"��y�	)���z2��\0�@:f�^Oy�3r��:n)���h,��D�\n��.�yr�����8�C���!^�z=귕�ƻ����f\n� ���Qc��q\"�\n�,���嗗�\n�'���!r��(��«f>� -\0�y�n\0/��L���/���I����\\�D\0�>����z�0��ս|��7���y�����y���_\\�U��^^\r��Ԁ�{\ng \$�	}����_c{����	S}�*�\0���8{}m�#��{y��ס(�z-�\0�{	 (�z�`&^v!r��TzW�^�Zg��\0�~E������n  ����7�ލ~��7��[}���_�}Q2�#��|f\0��_�\n�n!r�Ț����ެe��^�{��`�^�}���^��(���^�z6W�`~m�7�`'{���^�|��@��}���'_|]�_|���~�	ע߽z%����ꚨkX#\0��7����a�U� kC��������\0�|��\"�=��8\$ǩz���ˀkX��yM�7��6������}\r����zv §Ky�P�D��z@)����uI�}T���'ʞ�	�U/��*ɛ�n`kC��y��8N_���	�*��������y�z7���}MZ�#�\\%VXU_�	�uar���	U�N���C}M�W�a�Bz8`aW{��EaTv7ԧ�?2��ea@��X,^ܜ�fU�v�Ea��o���W���W�an�I\0���?����Hy�\nW�ǩyjf�r��?e�xz���������~�@_� �O�%���&c�T�?�w�M�}=�U<�g{@\\��'�y}�J����	x�&oS�\$\0)�M��Wݏ��Y\0�U����� �	�P�{\0���&��a�?�8���? 8�__�E��>bS���i��Р���?��HC�D�?@�@(bY{n���?��*���oy��8��\n��j��/�\\�bߪL�*X��m��I�ق�؀��Fm⋈>.��`�~/\0�\r��/��� �jɬ&z��R��=Ox��ޭ�f����`�������w�bӅ.J�.�X	8��\rTw��*{x��yDzx�ˇf68��鈖6�r���2�����XLǩ2����b}��%���a��8���QV�N��c?�b?\"t��b7��p)�_ܚ���m���~��&�?&9��`�z�* �~�P5A�B?�˴�0?�\nS,a=T�*�4����w�����x=ǩ�����(�w�U-�Ⳙ�����H��X*�.�L�T�&�V?��i����ⷉ�B��G��\$y	d3�FR/���ND��aߑ89_n����\0V?\0�X��i��2 *du��5�^����!�}V��aϒrj�*�C�8n\0���f��d���p���ݒ^I�\0��'������M1ᩒ�\0Y7d���/��d����''��\0�w���)^i�c����b�{�M\n��������_��1w�.�&0a�UV�f�B*�yB�	��K�\0\$�� �	�eE��[�oe����Ĺ~&X�AɄ��Ab�T��b���Iب�?nB�\0�^�B_��X�e��\r��'�ݖ2�	����e���/@�;��*������DU=d��'�i(u�����_O�X*��_ƺ�T	���	�J�˒�	��嗖[�jT�{�@8���7�����\n���0�\0&�T�7�d<�zc���kI�*�S�[�leZF* *\0�-Z�\0��^i�fG�.1i�fP\n�g��\0��l���ޥ��0����2�e�ۀ���kY��/��B���:�����dJq�Kf�?�g�L��j ��{Bj�m��)�f�.e͜+h����8o�v\n9-����\n�֓(?p\n�/�\$?m��_<��%9�����Nק���\"�/ǯ�oi��H�nJ�g�x�!���oٮ\n�(�_\$����B��~��|��͜L�@Hy�U��*zX��5�rfND�	��N?�5��'�>A�=��?#�a��TE[Ra-�N�S+q�����-��z5=呐ҹW��5�\n�8�bx~Y�c���ձ�fF�,\n����)��|��Ǟ�g	�+k���\0�H�*@ ��@Vy�����|ז\0���[���~�)c�b�yF~J�,?F�X�h��zq.����V?(�yRU�V�y�+j�\r��n�?��� #�V���h3�h	��\0i�f4�*\0q�f{��\0��>��\"���bjX�f<>����(b?b��'�zH	\0/�z��)�(b�~\$�՟�}�')��~c��͢�������n+�bp��.鞨b�\n�i�g��\nhs���zh`������f����h���L瓢2�j ��z-��(������h�L�����?\0�c���TY�⁤���͏�J܅@\$��\"f�dg埦�9��{*g�TiW!S�9QH���_�C��.��_E�^~x�������䡦�\$�C��B�d'>�	����:~y�ã>�n&p��B�-���c�_�~�{Xޏ匎��k�68�򀉃&m�R?v�m�3V�9�q��0	)�c�#:�#�d������  �	��[��iS��}����Vu8�US�<����N���ynt���{�j��^ِ���i�Ϩ�O�'���@#���ƀ�\"��gY����c�{撣�_թzp:��?�V��(?�jk #�����`P�~I�+kV���U'�*~Q.^��U��`F�����e�]�8�\n���قj�����aK�����ǫn?��'p�µ��ga����������(e��v�Շ��<�1>���9P\"@<ш����\$`d�9���g�\0��F&�\rq�\r1b\r���\$;@ڃ�-@��I�L܂�TP#�;%��aj��\r}2rM��eL�aR��������Ӄ��L��3I�����k�ard�k��zs�#L�IS��V�z�\0ۮ�i��k�B&��ψ#X.����l���f�{F :�S��0�3Ζj�`�W�濺������k�Ce��f*8�i|��أ}�oY�㧘��`\"\0�!P)��!P����d�\n͜hnFKc�^݈H����́>�)���	�����R�&����zXK����Plq�UR���F\\��u�BxR�O�F��H�v*}��lo��;'l������l�@H	)���J)�^{�%���D�O\0Ø��>�HJ�0�>�;���hUTBP�#��{8��\0?�:kqIa��]��Hк��H�{4�Jj]�\"��&���F�)\$E54�!e	��\0�\$����J��ޕKx�0���C,�RAK/˿�0��%�Q6y���r���P���،���\\���%��R	01��Έ]/(8�d�F���\0ƀd�ؙ�^�TۘL)5s�L\n���m�G#�����#\n+ 4�kM�D��9]N	�{R��*��>\0뵈5{U��kA��ƿĳA�9�����T�����T~\0�O�\0asπ��y���*ȕ����\"|r��Oc�y�:G�	��rz><�D&�\r��2H\rC\$������rWm�)�R]��eI���k�Z��a)����L��0���Tؤ�&;�8��mI�.�}��I�E����n�+4@�Je����MY��򯄔P��1݂Y����\0��IT�/����*�Mha4z�\r��[�낉���R��!on�/v�`4TDQ��VW��T����M����)��&�ۖn��Z��ϼ��Ik��}��Vg�Ƹ3��#9^��D�Q9k���k��f����N�\0�o9JD����g���Y������G*�՛�n���5�����nú�����k�kB���E�{�RHkZǌ��<�F�Z�=����j�K�/%|�3}��'R���o�')�Sۖ��i@6������f8n����VZY^�\0�?�8��o׷����W�\r��M0�\r�� ��Xb�ށ��LL\r��7�0�rDW�l���L�T8��0�k;����K\"+Q����\n��\$��u��y�=v�C[��1��� �%L�m���_�� ��6�	!.���[[ʵvL��,�}��	8�raxg������%��\$v�#�5a�����6R\"��!pO��6z�}I\"��>�ҿ�ܙA��O�q�9M��l�k�TԢ@\$��ȋ�tF�D��mb&|IDl��@�Ipo��W9uرF�5A��[�۴�&�Z��n�I{��8����5qe4��Yl�¬h�����@�qb%[y���C�c6�T'�6t�\\Zk�����0�����q�)/��q����:��;��AE\0�֫|qőƶ��Ηf�@�F�6�:\0��3#\\F��Lcn�m���������b���(�-�Q�l�`2k�#Tm�G%{�}=��k2�'\"�9S���2\"��+7!!,�.�|�#\"W�����U	�\$7�>�frP�&6�k�m��{�k�l�'Z������a����r��\0<��5�����8@2/�g)\\���ʏ)��k�l�'6�qO��\r��r���+�5Љ����r��E}ܵr���%|��ˏ-|�\0���*<��\r�t�|�r���&�<��pd�Hs�����S��D�����0:�I��)<���`kB�\n;@��WO-;/�x�N��5y(�N�E���õ�y\\	�P&��3H^���w?P�6f��uC�.)�v�ͼ��c���#�Y�u�'��!Z���\0�¡�(��p8������`0��,o�sy��QE��':������������W�r�qO���r�s�!_�[�Vaz#���:	zM�q	�9��kT������� ���w��R�2a	�W��������u� 4]�\rf������\\��\ntC�\0I�����!���Ϗ=P(�'��C\\�s���ӕ��M~#�D�(!�+�����X�\r��]��gI��I�|5��s��_J����GK;\\vN�¶�t����lG@Wm�D����OA7m�8 \"\0���Q��|,t�� 5=3��Գ��iU��>�}E7A#)D=�a	���\r��{O��BOQ2+s��:���g��=J����6u�M�O=��t�	�>��i������Ѽ�\0�b`�Y����[�Y �\$&��i��~���\0�e��\r`1bX�����g�5� ��bG)�GD{���0o`7S\r�?8�%����ѝf\0����qu�X����ͿY%5��y6�pe�8�脀�0`�e�:8xO����9d\n!.��~F�=jo��%����O֣�;PP�֧V��ᬐ+F;V�d*�rX�Յ���u��Ѕt3��Go\rQ�g\\��u�b�>�qs��1m�5�LrCt�҇`��vֺ=%�rK�vo\rgK`���?[Q�K4��9�|��m��Uڀ<���0/Z�%�5�8`���5ïY}b]+�Y�FW�\$\\C�Q5\0q�bp�pj�u��dн�u���i}p��#'m�W�8�oFW���qQ|1T���otd�AG�\\�&&07�Eќ��t�}�f�)Uҡ���,l�=ʂ.\n�uv��n�=UW��p�y�!�s�%wu�������+�ek�t�vvFW�]���wU�<���É��u_ek\rk��	���P\"\n�Y=qwy�`J�4Pj�T���5���qG)gp���R��gnbp�&җzP(п=��7w���I\$��!��X��v\\Y]�{G�ߠn��]��]�����;'X�4Hy߸Ϣ�J8'nrvg�'p��^({�>	\0�bW\\E�v�H�qV�,�y�b����^P�\rЇ�W���m�f��l�k�A>�(�3��7R|E�s�#Q��;Fr��2xresQ8A�@PtR	��]bmq �uժ�ޕw]qpL��Li\nEօ>3G���y������}�����N�lw��<��3w�ݵ�jF�0p�*u��,}~,�h��W���XT��s�8��}qs�/wU�Y��HR]�\r�Op���LQ��v�C@֘��s^<�[3��T#.��A|^��j~�� �\0����`i\0�Ǟ�i�+l�d�xMm�I�<�H���OI{C%��h�`t��wu%�Q:4��\\8ݔH�u>)�/u>�Z3��@�oS�b�@��/Ѽr����ןx!��v_\$H����(��I]��3�=��Ii�O�q��Y\\�}BtG6�\r��p]Ҷ�=,lf�\\����+�P�ݺ�v��7��αpDv���/�y��oe��e��Y�&�ba�9�#�O{S��i�wo���TL(�ot�^7_T�[�Ηi�N�k�]�����D>�	�謑A.k) ����Yi�K�m&W����Ɠ��xz������M4̂[�I�%M�g���wX1�7J�؛�N��mz��Z]��t�f����X�-���ui����͞��pd�<�ə.I��d�M.�66(bUv���\r��z��p���)���O�(�N������M�Uz�h�Y2����g��;�?�<��M��<�Z�?>J�q짴>�\0��D՝�TEߗ{b��-t�2g������w��߹�P����%/�B���o��T�{�Ӄ\\{�x��Z�Y��K�Y��[!.�:�ހY�(��.���h+�)�]|��Kv��.{�������=��t�?gK��z���4w��>�e�l�W>�ƾ��?P����v��b��냵吤�\0����i�>�>wu�;a6���k�����)�?Ž�mdm6��S��U���anC�z^�!�4�=���|~M��?���K�?#����O�O�M�8�3�ۯc�mN6bgI&tO�\"�,\r�9=�Ap#�'��^w�M����)�8T%w�v�^����<��Ŷ�\\O���}��\n��3�?Яh?E�Yє�!�����EaQ���C�3�o��^���gA,��WE���1�0%�XK4L����.�	^�|�)�o�auS�o�=��i��?@�y4w�4>\n��M���[�lF�cx~տ���E���}��2���:�4	#����,|���tqa�^�!��̘i\"�..��r��bg\\�����K��|�#g�}v�YX]!w,r�^�v���ݝI��H!�;��q��J�긒?z�Wח��{����������`I���7D�}��\0�u�Ә+�2~U�,~��~]�O 7ܜ�3E�W�_K����:����^s���_��P~=�ʵr��������`6��-T�a�H���	t��OS�1Hyn��\ntw�K���=���p��&��?�vu���>��M����2n\$��?LO9_�2A���ⲓi��I2�|��WK�уw]eϿ����u_�]?�������=�]�Jv����\$��E�U�#����ܷ?�Lu�f��i������\n�l����pm��X�>t�f\rx�������s����.�*O�(A�P?4��]�x\r^�E8nJRo\0¦�%[�\0004��w%_�K�[SJ^����n�OK�VU�TP��ޅ9܁����?uF��S�x �D��W��&Cx��r���;��.8KyUB�\0CJ	��!���HeW�J�If����\0���o��/��V ���5Z\0����U�K�Y;E��j�wD����%`n@��4FI*o\0`��� �V��q)8c5Wz�EF�\0��B��~��DF���ŧP�A�Y��A]�f��*�-+Yf<��ŷ���/�_�°:DP�y�A,�m��b��q��8��X�Hڷ���\0�@u\\��!��d�^Oڄ}%�l�>�׊�V��mY�\rڽ21P\$�5�rH�D����H������h�	E�e�!@�[Z��4��(�`QF5�\\(`O�*@9\0f�D�~k� \"J�Q��BD�\0@\$�DN���\$��k1�	�}`(�R�|`P�����6\"KX��5�*��\0Pԙ�[(\"f����y,�1\$��;\"8\nL��YX7��ƞV9�gX\ni�HapSI��Y�,��!���V�3�����\0�C8|�����,�N!�Iq�j���)�����҈ZX9�+jȬZ��s,FI��g�Ÿ�K9�Q�I˜9c٫;M�[����0�U*�����D��r�0h����R���c�a��)�L�&pG�F�C_\0�@94��̄�F3�.��}�{5f^�T׿0�l������A���2��l���(+0Y�����ь�2�,���x��ȉ��B��]��vd-ݟ�0���ނ8�m��%�g=ٓ�&�-�#�,Z�:����c:x/�e��9d��͍Xe�`@(*݃-F��E�����e��A���.�`��X(<�\r�<U���UD�J&���#I��\rF	�/�cl��~�����Aw_�˨�l��Z��A�\0�����20Q��A�'�W*��xY2'���٘a\\�<��	��A��ԙ�P6tpg�\0B�&U��>��A�W���3v/pz�7���\0�V� :k�C�A�'�2�O��[\0Eex�Q)[;�	pQY��bR�9���b��Y_&8pA��#\$0]!x�@�͞�\"�xP^���2'��[\"qPh�3��T��|��a�[b�	\n�F���H Բ�B\0�\rXH���&�τ���<'pH0� �ma�T#�]����0惊�U|s#(LLO��5g��x�hE,P����i�	��Lv]P�!<V��	���8PrڃA ��<(f�l�!A�h!�x>�`��5��}�2�@S`�0�\n	�C`	��!B�\0�&	 ��0�Q핈�9��94ƙ����8g��I�c\"z����Sc\n��D\"�)�J1�c͋;X/�~Y1���~\$\$1laa!������\$�G,aa*��^���f00�aLBㄱ6#�0�X��_�pŵ��\$��qcBhdb�B	|h9��!bBq\0�O��+�N��a=A�.���0����a�B�c\n�(rpz���\"�.�>(X�}aIc�9�,)� мC¡&�\n� hd0��1I^���d �)�aXð[c��?95�1En��'�VͣB��n0VarCc4��K2V4�\"��Kl8��?�/�<,˚L�2j&�ؚ�8	k�y�݅�P~F�,v`1�_Ӎ���@�ACU��ETiCf=�{X��Zd\"¨�(&V�װ�DfJV�����]��胓�; �k\"��B;`)!��!�ql:��m��)T\nz�\n\0��C�z��c���)˔ضK���[| ��ټ�\0�N��i���Zv��陑[Vl\$�Y��*fHU�+5���ҶZe����Ws\\��k2��-K�ֆ��DG�7@l��ˊ�f���5�Xf��Н��c���f��_����:6��@,�'<����2�Xس�l'���<��z,I�B�g����\nFx̯J�i��C<�'�����N\0������f��3s�(���Avop�\"\r3qgu�{8`���KhL��yc\$mYҳ�h �9�\n�Ƅ�	��46hi\r��{C�d��J���h�]�)A���K�3�i�O��#FR�,��ߴxf4OA��R������\$i�Oɤ	x��C�3xg\0���+9��-R��.������G��ݗ���(B�ݣ<G \$�\0(&X`0Oɦ�����`�4�i��,��P(npW�'\0_�JO��?��p�C��Zj;�?�Hf)MS�O�&�����Uu�ڮ��d,Յ<BR����r�g�Ε�/E[\r^W��j�١B#f�|�%b�n��2\\�IV����z���%�TkT\r7!5�(t��F�)q��ˈ�F�%����̔��c�6����6��G��r?&�)����2<����H�7�����> m��)�K��`܏�6�R���4�a��m�[o��G�ߵ:�Mt���Z\0	D�tF�o�M�9=�KL	q:�]W������(tP�7�@�B��Mq��k�M�Ts\\Y�2%��?58��6��\r\n�M���ὁ��·ok��N�]��o�T߾��t���J�Ms����J�!{�8u-�]�-4��*Xh��1Iۤ����Ӏ0�c4�8�\0�9���% �&�R�v+#n�7*�\re^:��ۣ����?���ޱ,�]��wL]�5ȠY9��Io��(}> ��(���&`����	^�Ŭ�_�0\"{��HN'��_�2���m6��Bb�\$~���\$�v�����Ցj���|�T���'\r��E�k�Z�g����Q���丈�s�G�=�*SS�r0��1q_2<1��\\8��p]�����X=�R���K\"�%�p�����}��Q�;(d����1�D��\\E��G�Y���ĽN�:��\r�d(�`�~b�vp���TC�1\\]�VQ�TM�<����F^�:0@0�#�yI��@g��g��\0:8�N�	�f�A�\\O�rn��/�����n^�=���e���	1�>�2tr�)-�x�A�c�t`2���c�	��R>�Qm5Y�%7kq�\\�lCX�Xl�\"Wc��-9���r-K�d�����L��\r��1x�p_��Pmn�^3χ�VB�?S���3\\dŧ/:#1�����z3|gh��H��y~[632h��Hk�<�\\��Y�]1ԈkF����(jѶԡ��DƐCY�ti0�q��E���f4���E���J�\r[9�4�X�6�Ձ��]�x�t�Hk��}�_5�zxǲ�#\\8J�T��P�GQ�_��\0W\r�5���K�c�č6B�6C⤹�C�6��YPBt���P�'lW^S�6�m�f���w�8������`��l�tep>'�D�V�x����jDoↅo��pM5�oӯ��5�v��exK�����\0<:Kmt�\"8\\9�ᮔ�@� ��8�wB�A��W�3m-\$p���\"��.�I��J���N�ĺ����\rdg�c����T���n�r�\"O�EE\r~;�� dP��&>O��R: H��*�ɿ4o��TtU�Q�E\rE��*:\\\\���\n�GI��ݭ�Jbx��ԟ6�LQ���:�h�qң��f��? ����:�\\ѓ\r|��W3����7�6�t���wתK�ջ�!�|	c��M������a���7cǁ,��A�߇#��#�E������w�����G��-V1��v��4_ǜ�f<��x�.���)�G�<!�?1�m\$)�qB=0d�JOJc��������C��g��_i:\0Kܨ�Ia�jg��F�@&�Q�fu��2�'�-	M�����c�G�wI�������V�=�[?\n+s�W���c�\0e�d�y!LD�Q��\$)SY<�*��.��Mqآ�Nʇ�o�l��%l1�6�_��q/]Ѷ�Ip����1DR�\ny���(��V��f�\nY\\�鵄9�����P-��	�;uV�KD�<��0��N�@@�&-�z���+����Dd�+nl����\n@J��*l���7DM���=q�\r�!sqQ�¦��8^xP�T�a���I��\r�7h��5�ȣt�`yN9MA#�d��ң�@�Nܢ)�/\"T&�A��`�\rig�!H�Nҋ(�]������\0�ϟS�.����� J��� ��O��BD��w	N�n>�y0�)2�u3)1��\n����0�0�/y�ہ3H�}�Ԋ�n��ȯ����PLI`�dZ�}�iO�6����S=�{B+##_��Kg�~?���2�Q`�S��'l\0��![�Ƕ�R�	�ב���Q����@ݸWI��l�Ċ��p愤ǧ]v�|�(�O�_��Zu<�E�`Q6.�h,�&N�]3K��n�[ȅ�LM���Nj�:�Q���*��YxG3}@�6���{\0hbQ`�	����kNS�Ƕp>��4c�0\r�c��v��=R8�e�@I#L�=�k֨�(�G��\"ҁdav�`|�s��ԒU��	^��+TD�.7��D�2T�=t��.*�]�ϲTco+3~��!���g����MD���5*��G��u\$�t��Kl�J\$R�� 0Q%1\rc��!���>~9R�D�Nϝ��xT��D���IgD\$D_��	�J#���i#��u��������a㠫��%b2[���R�[7�&�U���f�~���)z��Κu�����|�\$�*������Wm+}����Os��R@�A��#i�Y+�##��U�ڂN�d�\0�_�5�	0�6�F���A����)'ln�Y;Oە��w���m���<Rw߷�u4��N����vd�I�Qm'����;0*�\0=���,JS��?�*�:�SJ0�~IIA<A�d&-	&����R��j@�59���+�C@�}�\n=cC��A�(��<�P���OX�Ɏ�Nkmn���M�Do��[�0!q�\0��E\0���9���R���=�N�ݘ2Z'�5\"E���z)-��o�����a&g�����2����Ǿ<�TқV���QF�,x����`%G���I�w�\$���)��_��uS!P뺈��d�5ϏQ\"O��F.�?�||\"�)d�PJO�5�~�;*FjLt!c�J��&����M�ޥI��2�=M�IB�g\\ۂBuI1՚J��3�?*�c���aU��!u攎U��&�Aw��F�JH��R��i\$�ց���~�	C�l�E\n3��Fs���P����8\"ǣ.��'.T�|BQ�٥>��s�2�4S����I�N���\\�W���%r�u��&��U}��k��>���:޷��=J�sn�������v�W�\$Ri��RJH0Ɂ��CFK��Hj�3?�\$Kpz\"�\0		.?�1,�������y?�I\0�����¥�@��X�uV���Uc,EXD�Ea걐�\"%D\n�<��Yed� @(D�\0�Xȇg��ѕ�@�V�,�Z 4�e�B��D�R/�E��`\"�0��-TC�u� zA\"�+W�-�H�`���Ae�\\wJ&[<�`ê�%�Kh:��aĶInF���+���0긥mK�ƲXP��[h0�9�qeì,�ڲ�\$��p��d�ˑXܻ���j00e��_V�\"Z�C0+��eˮ��Dz��\$��M�楥�E.v<�	t���+�Y�-�]Q)0���;@?_.��0U��_�#����T�|��\r�\0T^��f<0W-؇������eP�!����\r #�2�?Z1�c����[�Á\0��+�,�\n��\\\"\"��Q�&2ˇ�i{�J�DW�K��2���J�%�l�\0000�a/ŀ+5�s�*�{`��6��f\n���CB�-06J��P\\\n �h6pҌ��@�.�3�3�gJ���#1P���pgZP����s�P��^�Jg�N K�I�\"Dl\"�=��ApQ���=�q�>�Bh�LCb�h�9�y\\�g)���6�b���C?��lxZ1��oݡ�C���X��A*�ʍ��>b���Y�xavVԙ�De�Q\0'sc8}�CG8���'&XcF��\"�G���?�[tf��#LFr���)��i��H��f����Dyi��1��<枅�\">4��e<Q#�~�Hi��Nt!���\n&Dz.��H���\"��)	���(%\"�0��m�u�Y����z�g&���E�6~[2�b\0U	�\nFE�J�VbJ6�2k�0�Pȑ<]\$KZAs[C�l�3	��g�\r���8.5��H�����8�����\$�D�r&}�.k�ܭ�|L�QE&FLI�\"���0kox�#��7D��!V9\rq�����\n�y�[���Z��*�mȔÚ���\\�K�	��dzd�o��*�\"�����y�Q��ٻ0-#��+�'h�]��/��Ȧ�F���Ċ7y(S�\$aM�I\$�\$uMI�+93��/��ʎ��\r9�N��L�!�ː�* ���B�����y�!�4�c��\\��X�8 u�_��6�0��;����O�&:�&.���S�����d�0����0�eE�ѵȗp>��Fa�Gz�	���mP�=t��i���V}��|�}MP(�%��e8�u=6�2�I��q��f�f�^MK����>��В\r����^�7d�vR�m	�I�H�9��>>]s�R� `�s�gU�;��԰q��%�!��8�����r�D�+�,�nx͔5�Ȁ�]�:J�Դ�I�v����Vr�!ͦ�3����Vm)��\$@E`��,�\0�\0���II��؜\0��@s�f��8\0p\0���󁍷\0005\0d\0�pd�\0�\0\0005�2\0�pD�	��\0007�2m���	��\0N%�38������\r�N&��8p|����ۀ\09�f\0���)��NB��\0��`���\0d\0�k4��ȓ��&��;8����󒍷N;\0o8�p�T0s�'	�R\0g8�q��3���\n\0s9Fp<�P���d�)8��9�3��N4�d�9�s����}9�i��g2N��\0�r������\0NH\0i9�s,����L�1\0b\0�t<��3��;Nf��94����S�@\0005��:�p��Ӓg%���\0�p��	��\0Υ�q8�t���3�g�Y�^\0���I�3�g&N��i9:p��`\r p�c� \0�rL����Μ�g8p��I�S��oN\r��8:q��y��f���\0�u�	��g[N��:�q|���S�g\rΔ��:2q����Ӯ��^\0s:�q��I޳�'E\0006��:t	,�������\0�\0�	\$�Y���N�\0i:�w,��s�g\n\09\0i:�q���eP��G\0i8*wl��ls��O2��9q���S�g�N��8�y0i��\0O!�Q8Fq|��ӓ@Ω�=;�u\\���3�gy�Q�\0�q��Y�S��N���:�s4�)��'�4��8�s�	��g��\0i8s	������;�y��	�3�g\\N���9 ��9��'�?\0i;�u�)�3�gi�V��:^{T���3�g\"�c��\0�y����3�'�N��+=\"w\\�yɳ��S΢��=�r|����g�κ�;�q�ީ�g5�o�=2zl������N�q:\"w��	���%OB��;rq��	�s�e�5��:vvL�����f��#:Fu�i峥g�N���8�{4�9�S�'IN �:�x��9���'/�Ü8�|\$�9���J�@��<�x<���3�'DNn!=jq,���bOr��m�t��)��'0+p��8�{d�����%Ͻ�I>nu����s�h\0P��:�	,���s�g��&w>�v�����P\0�7=v���(�9�,\0�xt�y�f���Ϛ�<��y�3������;6�\\�Y�ӣ�O�a9Vut�����(!N��	>{,�ͤq�\$P�Y<vs��i�3Ч�N㞱>r���S�'�ϫ��@~x��	�s�g�π#�A\ns\\�Z�'����?J}녒4��N��9*{��I�s�'Tϛ*�;�rl�y�t�N�!A�vt�9�3�g�N��IBZx��*��EP}�,m��\\��Ӗ(U�L��@�qL�����VΝ��>*����s����r�;^xt���3��3�.��AV�\$�tg�Τ�\rB�L�:�gг�;>�u����΂��9.�|�iȳ�'OZ�Q@�tD�Y��@1P��>���i�s�'iи�8�~u�(eл�)Bʅ����f��'�|��>�vt�Z���K�B��?uE)��h:����:����Ô8g��H��@fx��3�� Ψ*�:����YƓʧ*�_��9�pL���%�P�oCZ�-*��OTn!>.z��y�)��Oh�3:fqD�����=��7C*w���!���O�_DvrT�y���Ӝw9�����s�hM�7�Q;�u����gNʝ;8�M�\$���ZP\0�h\0ƀ��(��'����[>Rt4�	��'����>���-��'�т��<|��z�ԧdO��9<�r���(�\$g^�a��DV~u��3g\\Q@�%@R����S�(,Q�YF�}�T:�[��O��B�rhY�M(��i�)>�{�	��HH�P.�GF&s�i�TXg�OC�F��sب�N�)=�X����Q͠8um�;3��N��?�pL���3�'�Q;��9B���0�g~QJ�5<V���s�h��;�|\\�:����N���E����>�6��\n��>�r}����֫k\0�C����S�'O��9.�����gi�	��Fp\$�y��g�OC��<J�j��@ϋ�/=v����0S��4��:�~t���T&'R��:	abm���gxN[IC4�5Y��h�NO��H�w���;���N���9���**s��;Β�e=&s}�K����I�':\n`I㳓�0��I�zl�:��N��I֎�JI�|�yOϞ@�5��3�'�N�EV�����(�N4��=�{���+3�h�ғ��>:�<������\\QW��<�u��Z�b'�5�Fn��:�v�Ѡ��?	\$���49�%�p�?=�\$��s��jN,�:�������Q��Am��4��Pģ?*q�,�B�0gP���@V|��\nW�R)^�؜I���t�i^��=�t�%�\"4��)Oo�\0��m\n�G��'^O❟>�|�J\n��h�Ѯ��Bړ��zW��'�O��-��9���Q�=8p��yC\r&O̿��/:��Vљ�\0	~�BY�S#e��-��7f�L��P2˦Q	���.V��ɘ�2���&Y��I6\\��ِBfc/ޙ�%Yj�[#��f�͚_�.�8��!ޱ�cfW%��?F6�R%�2a\nښ4�@f)��v����;�k@R\0�L�\0���{6��,�%���e�\r@��y\nV鱁���\0�L������/��=M��c�24��\nanN\$d>�2�̚=4�_�N&\$u8Ə���y.���+.iPVi�1��nŞ��9��l���g�ʁeL�9��E��@o<(B�l���n��\"��_�\nҝ@���mn��`�\n�	�;�pM	�H~͘�i9�T���iU*�n+\0����0Z�OA��-zz���������\rH�4DKc�M��3��D�I�Su\0uO�\nt3��W�0�ftɬ�3��r�\$�����?�jNMѶ 	\0В��5��Vi��4b���T6�0��	�T\nd�PY�c�kQA�1X0����K�T4��\"eB��<T\$�I�S�]V--��]p)�!*�g&M�?��qA�1�fp\0���0	��!�5����R�Xҳ\0jL�(��&i���6+e@!��w!䭒TCRb}P5���v��^����f�̝�<[v�mmL؁���P��}8&#��*8��� ����ډu��\\�5Q�H�#X��7*�`+e�l�V��d�Lŗi8ꑌy�1@�qQʙ�I*�\$��T*c�MٕC�0�Ya�eq�����h���l��[,U��)�GԨaǵ��2\n�칃�)D�^�UE���(j35�YO4l���	f@§+���{6����Î�0\rje�5���Fd�%w^\0���M�^�����'\$��3)P0�9Y��Y\0�P,���-���^���Pd`̷����j�O)b�%R�%Y%���A�9y�5���e��Z\n�OZ��\"���n�MTN��8��5E�\0BԾ.;I�̃)�TF���3;�sP���/8��T��|*rh���(6\$\0�py?~�L\0�Ϫ\r������`��\0�L��LuO���eTB�\$#�0�\0*�0[��U)��-P\\�a�T*��M����(jt2�%M2��Ƈ��`�����U�c&0�m�*��ff#T.`9�L��U<_GL���3�I5&j�B�T�U�, ����&�_�]Q��K���X�Ջ��	�eS�a��*�3fORU�Iv?��aՑf�N�z�F-,�Y�� ��Vv#�Y�<uO!BU���X�TJ��]�rUC'���V�Tz��]�EU�`3V�q=(>Um*��7�7W0��36��i�8UԘ3WReS��ui�!�<c�.]@�d�`X��_�ȝ�L7*���\0G'�F%P�Ot�jׁ��TPmQj��`�ӈ��NF�}_hX�G����h����(v�����S˅��B�U`�A�KK��/�W�r��z����d����=:���V��Ȗ�[����j��H� ��T����J�y�F�Ϊ�}��̏��UW�aW��-�d�����Ĭ���\$%c���[*�2���X��=d��,�*��7b�Uª+(j�������_�Yr�ueʯ�\n���:�mYB	#��L���\\��F�}dZ������Y��Y�˕f�;���=	���Z��em*��h��V�L�h&K5k+���\rj�%e�oU=a��8�����[�\\���۱���W��U��u�k>��6���(�c���C��Y�x��0�k�խ�j��<�{�kG�ۭWv��]��,�*V\\F\rYՉ�^�l�]������lڿ~��A���W���`5�a�4ƪ�[m�%`J��W�V��F�]b�T_+\n/��r��S:ÕM��V!f��3x25S+OV+^�X��e���+V3��~��z�̴k}1���&�nv#���Ug\0�\\5�%qI��+�W��UȬ���Z��W�gYV�&45�*LVg��V�Z��אs�*6`�IRڹK%��e���9Va~�s�ϕ�+C���RZ�S�����ևHZ%���� \$�+{�ޭ�݉�����*��>��Vƺj�����kLU��T˚}i�,��V��\\��t��̄+�W-����}wx3�����׮sZ��l\n�5��D��g%\\�8���Y\nV�_��i�P�t��C��J�Y��/��U�᦯�g!^l��:+ԃ�\0I\0�^�����3W�A�_^�iZ&b���U�+E^���Ba\0�\n��#�^�Z�c2g�ښS{\0�Ę��7D��P/�hum}ѯ2Ȟ\0���|�Ҋ�����5!�����_\"��V��`S��Ђ�59f5�	�Ua*|��A����Z�ף�10��ez����)Će�^ѐ�@X-��k�Y&�á���z���*�3\0�β�-|ʅ��,Th�1Lb�-1����*�\0_^���.f�����fOF���9�QbKX*f�Z� u<z����(�AiON�}�5}����k1:�%q���X��y2�������XGU���Sc��	�X;`�\n��\n����S¬hP�emzg��+x��az��>�d�,/�j'0��m{j�T�l2�Y+Ea��=_k\r�aS���j���X,7,=uj^VΥs<��)YP4��f��;�,<�5+�b>��5��@0���͡��@�n5�&ءd���TsV�V(�(3��X�٭�Ƒ����X��d )���6)ړX��&ò�xv'�a����c��W1,\\�bX�h�ae��@���X�&ocT��)vlШ��W0a_P\0?%P\\��lqV��(ˬ>�=K�+RXب}��<���W�S����ҝ5VʁD�z��'���';k��5T<�&Nx���5*�{�	�r�\n��5�f�,ܙa3��6 %�P~\0	��I�X�e@�DA>���:53q���-��c5	�6�V�٘����l�+�0��eca�͓�\"V>��бQb��5��7�ٚ�/�f3_��;��l�YG�P��3*\nv+���\ni>��t:��V,��@'d�	w\\��YKVO_F��+\n���f�&V��EP+��³�l`L��\"�U��N@+�8����0��j���/����z�R�k��+\n����ʞ�p(7��Y�/sl��v̑6k\n�P��Xɳ8��%��VfI��س?aˡC�J;+��X���V���	���+�*���A3���ڙ�U�=f��z�`����\0��\$�;�aZ��(�Mc��[d���s�X��`?�'�Qv2@(\0W\0�f�c{;�&�s/�?c%S��V\"I��?d��ĭ�{F25+�sT�eP�Q�-�rp��`lWA��WCR��*O��`�2��:�`��0�b�͚ͥ1vok�k��@���u�=�k462C�AʯgT���v[�HĒ�ah��%�:����N�~a:(����AZ06�k��mB����!��jy��:��	���Gn���+@���l���\0�M0�	�I�ͫóʹ�T�C	�RMV��0�aMih����:vh��Za'�^��+IK*vq�A������Gʜ��N�r'�\nӅ�P	��ت׹��ęHͧ{N� �HX��}d�}2�����W0�н��5N���WI�Zs�i�tZ�L�MM���µX�4Ub�l/�8pM2�5�ʜ���V���ev������+,����I'8C��T�l���F@��m��\n�r�8X�Sj� ����X�nh�� ����XB�R�p��MՖg7]��ĮW��%�M�hU<`���4p���1�\\��*�]�k^�cGi]��|	\$�*p0��!Qx�\0ؖHy�w���\0002\0^���Yk���\$�F�K���3�n���,�3lR�ݱ`�@\rm����*�,kd�_�[\0ol��=���-��(J\0�٢��c�I\0�[9^:���g���:�%!^Z���b��Q,[H�Ml��-��i��-�[A�ImNٍ�eV�-�[A�_mr�U�\0\$����[?��l��-�C��m��-����m�Y��š[I��m��m�[i��@/΂��m�ص��n��-��f��m��յKb�������n�͸KqA��À4��l��=�{q6�m��[�7mB�=��s����ۗ�9n�E�;pӲ\0[��-J��pc���m�[D�)n����r��-�R��q<����+f3�-�[¶�<��%��v����۬�����}�Kp��([p��l��e�+r`�[��m��e��z��([���m�e�{��(۸�Yo&�=�y��-�[η�Hn޵�}��-�P��>����k}v�'d[�kl�p��W-�[��oz�=�ˁ6����)o���k���(�\\��l����K�6Ũ�\\�#p�	-�k���l[��)o��c�\"��n\n�(��o���������.��prvE�+�`�O\\&�Wp��U�����n�D��p������\\G�y9���S�.!\\V��:��ěf3��&\\C��p��\n�����T[ڶcB�����\$�n6[���B���\nn/P���q�ߝÀ�f���5�;\"�]�+��܂\0�r�ȫ��gO۸�	q������\r.&��[r0�țj`�\\M�Iq��Y�v�.R\\��Sq��u�K�6�.R\\|X�pn���{�vӮ]\\]�uq��«�W-�,[��ys�m�[��!`F���s*�-Ȼ�74n\\˹}sF���W4nb,���s����3�)��4�>��{�9�/τ��sw\r���.v'�	sn��ۜ��u\\4\0F�z���7�	�~�~��=bp�	��-�A\\�>b�u�v�Dnv�)�)s�v��p7s��\0s��s��}ϫ�W?.b�ƺ;8����;����χ�[s��]�{�w6n�� ��=�m�K�w'���*�t�p���3��@�iu����7P.�]D�yt�,䫤�Ю��ҹo:��+�Ӈn��I��:*��ۜ�.����s��,���P�s�_��u�m��s�.��b��=6�<��7Z.oO��u��m��7\\.��r�=8����k��ۮ��c�u��t���`.{O&�v��j�H�vΣ�u=cX+���.�τ�KvP\r�K�F�i'ݥ����2zW7in�,XO�t��%�z=n��һsvڑ��;�o&��ɻ�v�p�+�Wonڬ���v��m�˔7h�u�*Y=b�D���7q(��Ի_9>�ܻ�Wsn��\r��tB�=�k��E��ݫ4�H���ڙ�h�3����v�{5�;��w.�]���>��u�)��~���8��w�}e�{��O��O�Gu�m�����n�����x>�(0>���P���w:�X,[�N��3^�Cv��*;�w�)��Qx\"x��;�Ww.�^4��w:���K�7jn�^4�_u������w.�^D�!v��U�K��[�\"^��v���K�^.�]~��w���[�Ӈ.�݈��v:���{��d�/���-y~�u��wg�/�\n&Om�����#N�]�;x�5L���3ܯ=ݱvv���ן�f]=Yr������tM/ܡ��w��7�nP݆�Cy�5L��78�Hލ��zv�}�;���o9ޒ�y������=/U��/z�����3�m��S�k^^EoD]��%���%��qפ�\0%����Yƻ��5�X\\Պ��(��\"��0p�3C_�B��|&X^�q�k�6��Y�=��#�+��\0�b��-g��0t�*2����b�ME�{� �2���R��������Y���{����B�k�W|����5�Z���k����r�������G��W\$L�8j���*�\"_sN��Zi�Lv�X�|��K	V'O/_U�N��})3ڕ�H/`A��|ѧ�6f���/b^ƫM{\"��\"��p��^ΫM{@��W�*�^Խ�ٌ3#+鷶��^܅�ȅ}S���*�4g��|���,;��/sW1d\np�-Y{�ui��U��ƿJ�]�\n�U#�E�C�aTJT��Yl\r�}���V֮COxbv�!C\0P��\n��8J֕u&�~Uk��O/�_`����E]�E�w/�Xz']O9T\n�6��+U�ʭ[Xb��k��>o�֏�[:��e�0�Y�BJ��~�?!3��u�\"^�b�Y*���z����u�E�x��E�(]�����;��}V��x*̷�!3�`_!{z�����L��X��}������U�k���)��u�ᕤ�{_�U{��������_�Z�ˌ2�����C#�k]�Z��ְ�/�\0D����3K��ɯ��d�ڟ�8�\$0Ro�ؠ���r������*�k��R����V̨	�V�lnӉ�E������T��bR�}�j��ܙm����^\n�-��u�P1�`R��}MJe��j�#�K4��,���t\r֜:� �k .lO�l�(�8�q���%rY��FO��tN��2W�WT\"uj����}T�@���7k�S�Vw�ڀ姮\\��G��<�I\r��p:/��'�0��s{M�%\"G%:�ڔu��Z�j��Yg���J�>��,��W��T|�&�5�����bX���3���X��Jv�s�TS��I6�M FI&�h�Y��q蒨PY&Ƽx�!I6\n4!��)&�07�Q10� n�ъ7�X�3H�ru\00053��Cڊ��`��@<S_p<�j��\\@��T�Ĩ���t�*�����G�+�P@M{�8C�t����GMV&����ڭ��z�0�@��;�:Ł?�4�Q���a{�\r��H�7˓H��أ`|�uL\"���s��\"\0f���PTlF�G.��\n3�u.X+��TvND��\r�\\̇*tb}�݀�3 l[�����\0c��!a��g�u�e)mF,��Y=Du�-�Ӭq��M����yͅ��7\0�0<��w�nEF'K��>ab]���\n�&䮘Y�|�Zv�p����Z��c�uT���[�.Mx�7����O�+N�k	Ki�:��05��b�\r��w'�2<�A3\\��%60��V�u7�ͦjk�����|w1�r'��um��%@I:d��l\\R��	�5�@֦�p��i���)�5��W�;H���`�Ä0����pǁ��Z�d3���s��*mV�_��:�s���R��i)oDp���ol��qf��H�a�Qbt�x�� �5\0rG���/�_����`����4X��-Ť�9�����<@s;���{� \"�jj�£0�a��h6LFy�%���\n����孾p����8ی^k�:c��V\$�2V'�\r�A?8��X���=���CG����ζ#�c_��='�������@Vc�bB�,��(�\$�I���(J�WF��%\\+����`:�n���#�Gч�1��\"g��m�ba�x{q5�mm����S��؉�8�u��Bh&POxV��p��ݬ&&&��`V�<��Q��*�;�����E]݊N'� �6��T�H�Xv	Ȫ-��aEBv���Q{�������>Ciڝ7�Top�f��#LV�0��H�u�>)�E�����]�4��4���uB:[�p�R*T:0)x��M���=������J��b�#*�쪠8�(@=;V1cSk�P\n`a]g`P��Sh��.�U�q�����X\\:�`��\0v���|��M��`ֱE+����>�_�J�v�Ť\n�V�0l`m����N��*�H��F�H�T���\0��?,b%ұ��-�6\n-ld+ʬ���T/:��^R�f�K:LXBm���r�IvKV,�R��e�pq���D�^&\0Ea&�.�\0��B]#b�������\$�@�6��E���f��o�9�L��,	����M\0SJ���gx҉�cYY_�{P)�\n�y\"�Y-�r]�#8ۖ�cd�4�^3�6!\\�(ˑ��w�א\\�ۀ�捰\rjf�Ɨk`�\0�3l䙅���kI/݇��n�N@:��'�p��\0");}elseif($_GET["file"]=="logo.png"){header("Content-Type: image/png");echo"�PNG\r\n\n\0\0\0\rIHDR\0\0\09\0\0\09\0\0\0~6��\0\0\0000PLTE\0\0\0���+NvYt�s���������������su�IJ����/.�������C��\0\0\0tRNS\0@��f\0\0\0	pHYs\0\0\0\0\0��\0\0�IDAT8�Ք�N�@��E��l϶��p6�G.\$=���>��	w5r}�z7�>��P�#\$��K�j�7��ݶ����?4m�����t&�~�3!0�0��^��Af0�\"��,��*��4���o�E���X(*Y��	6	�PcOW���܊m��r�0�~/��L�\rXj#�m���j�C�]G�m�\0�}���ߑu�A9�X�\n��8�V�Y�+�D#�iq�nKQ8J�1Q6��Y0�`��P�bQ�\\h�~>�:pSɀ������GE�Q=�I�{�*�3�2�7�\ne�L�B�~�/R(\$�)�� ��HQn�i�6J�	<��-.�w�ɪj�Vm���m�?S�H��v����Ʃ��\0��^�q��)���]��U�92�,;�Ǎ�'p���!X˃����L�D.�tæ��/w����R��	w�d��r2�Ƥ�4[=�E5�S+�c\0\0\0\0IEND�B`�";}exit;}if($_GET["script"]=="version"){$p=get_temp_dir()."/adminer.version";@unlink($p);$r=file_open_lock($p);if($r)file_write_unlock($r,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];define('Adminer\HTTPS',($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure"));@ini_set("session.use_trans_sid",'0');if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");session_set_cookie_params(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",HTTPS,true);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$cd);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("precision",'15');function
lang($v,$Jf=null){if(is_string($v)){$Ng=array_search($v,get_translations("en"));if($Ng!==false)$v=$Ng;}$wa=func_get_args();$wa[0]=Lang::$translations[$v]?:$v;return
call_user_func_array('Adminer\lang_format',$wa);}function
lang_format($cj,$Jf=null){if(is_array($cj)){$Ng=($Jf==1?0:(LANG=='cs'||LANG=='sk'?($Jf&&$Jf<5?1:2):(LANG=='fr'?(!$Jf?0:1):(LANG=='pl'?($Jf%10>1&&$Jf%10<5&&$Jf/10%10!=1?1:2):(LANG=='sl'?($Jf%100==1?0:($Jf%100==2?1:($Jf%100==3||$Jf%100==4?2:3))):(LANG=='lt'?($Jf%10==1&&$Jf%100!=11?0:($Jf%10>1&&$Jf/10%10!=1?1:2)):(LANG=='lv'?($Jf%10==1&&$Jf%100!=11?0:($Jf?1:2)):(in_array(LANG,array('bs','ru','sr','uk'))?($Jf%10==1&&$Jf%100!=11?0:($Jf%10>1&&$Jf%10<5&&$Jf/10%10!=1?1:2)):1))))))));$cj=$cj[$Ng];}$cj=str_replace("'",'’',$cj);$wa=func_get_args();array_shift($wa);$od=str_replace("%d","%s",$cj);if($od!=$cj)$wa[0]=format_number($Jf);return
vsprintf($od,$wa);}function
langs(){return
array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hi'=>'हिन्दी','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','lv'=>'Latviešu','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','uz'=>'Oʻzbekcha','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);}function
switch_lang(){echo"<form action='' method='post'>\n<div id='lang'>","<label>".lang(19).": ".html_select("lang",langs(),LANG,"this.form.submit();")."</label>"," <input type='submit' value='".lang(20)."' class='hidden'>\n",input_token(),"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];redirect(remove_from_uri());}$ba="en";if(idx(langs(),$_COOKIE["adminer_lang"])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ba=$_COOKIE["adminer_lang"];}elseif(idx(langs(),$_SESSION["lang"]))$ba=$_SESSION["lang"];else{$ja=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$cf,PREG_SET_ORDER);foreach($cf
as$A)$ja[$A[1]]=(isset($A[3])?$A[3]:1);arsort($ja);foreach($ja
as$y=>$dh){if(idx(langs(),$y)){$ba=$y;break;}$y=preg_replace('~-.*~','',$y);if(!isset($ja[$y])&&idx(langs(),$y)){$ba=$y;break;}}}define('Adminer\LANG',$ba);class
Lang{static$translations;}Lang::$translations=(array)$_SESSION["translations"];if($_SESSION["translations_version"]!=LANG.
3533312954){Lang::$translations=array();$_SESSION["translations_version"]=LANG.
3533312954;}if(!Lang::$translations){Lang::$translations=get_translations(LANG);$_SESSION["translations"]=Lang::$translations;}function
get_translations($Je){switch($Je){case"en":$f="%���(�n0���Q�� :�\r��	�@a�0�p(�a<M�Sl\\�;�bѨ\\�z�Nb)̅#F�Cy�fn7�Y	�����h5\r��Q�<�ΰC�\\~\n2�NC�(�r4��0�`(�:Bag8��i:�&㙔�y��F��Y�\r�2� 8Zӣ<���'Ha��2�܌�Ҟ0�\n��b�豌�n:Zΰ�U�Q��ŭw����D��mfpQ����q��a����cq��w7P�X3�t����o�	�Z�B9�Nz��s;�̑҄/�:����|<���4��j�'J�:0�rH1/�+��7(jDӊc��栢�0�K(�2����5�B8�7��\$B�/�h�8'�@�,-B�ƎQ��E�P����#��O��7�Ct��\r�`�������j������[z0�c|9�h��\$>�\0�\r\n҄�=Û���\0x�\r\n���C@�:�t��\"��~��8_)���9�xD���jΘ��2�(�-xx�!�H㌣��.-D�;����W+�8�63��@Ɍ���^F+���u����\0�ᠡ*,1,�i�8��cxؒI¤f�ۣlZ�*��/c�s�.0�0���~0���YWB0�7U�\"����:�3�xuc@�#�пC`2'�3X�Il*8��3�ʮ�߷����� ��5��5�3�#\r�9��{5��Uw��xj�0�B�͡�.'(��ǧh�\$�F�Jŋ��ļ�C.��!n(��hڂ��߉�@�����N*㢺칈��0�5=R��t�P�5��&���ĻɓEĄ:��e�w%�8����beU�z�+q�3�d��ɓ�*\r�|�7(��[�Ӱ�zʲcw<�]��0�|]�G]M�vX�l�̳?w������G���핷����W�:*1n�gQW��� �2��<��1_OlT�@PT%�PwQ��G��\"��p/'�!R��D�[	9�U�f���i*�<�&�xޫx{A����p���E�h�����*P*\rB�u��k���I)G2��z�S�j/�i�\r�Yu��LOjPJF�\n���zS	�m��!&h���bd]����I��F���\"�,C3DwI�Bܜlcg���A��lW�\r!��+���O�z=G��\0��\n@QX���j\n[�1�6\":���9�\\�5reH�_qIy9�s	K�n��4���lL�|�L��@F��L�����Q�H��7���J��1�2��h匳uDX!�0���O���)�8��k�x���DI\r�F'���F�8d&e3�[#���-k���^�Y+e܋r	9�ɠ*��ٷ�`�+�Q�����D��4�ʾwb�KL�	�L*4\0���*V�v1�0�K�1��?R4s��	5�0G]#4o\$D��T��HSfDe�20���f������Fh�H�)��vbz7F���\$��p \n�@\"�@Up\"���]�J�\\�0��PbJ1H�&26J� ��<�Q�樞�LT�2ЋSd�_N�l/��Ś� ��!�L2�r��_j�#KB��%�I��(�(+\"	r��*3g�6�y�Ӑ3�:�p�#���sP\\���#Oѻ�Ƌ���kl\ru���ȋ&Aɶ���\$`�l�Y��J꛰�J��N%�ͩj˚}/���\\��`E��\n��`޵�,e�x}tbX����Z1-xy�2��5뇈���J�0g����6&�ZܷSW���Z.�r�a�&d*�l9���(E#~�Qկ+����Ff��rKd\"��`��I�d@�P�C	\0���(L�1�K�a��\0�v���ͨ�l�AsH���_@�B\nM��(���`�����D]�_HZtA~v�,1��A��0�P3ih�`Y���R�N<�:�3ޛ��v����&l�9�h�k�ˮ�y,u--AI�-��Q#l��D�fp��ݞ,x��	�G�(+�PŶ��,��)/���P�9r'd��da7Xl�y�!\0����>5>���U��[BI�\$�,����D��%��(�l�L�<,6��	��ɻ/����/���9F��*q��½������l('㬶Ŗ���,1^��mQS�l�I_�%��D��2T�|�R��-a��\r�ޞQ�F�\r�<l\n�\r����J�-�cw�	��˭�d�\\�Ե\"��W�q���~���}�}��p��I7*�!M����{����G���F	�O�I���WR[�~!��rU�L���Wip�������ӓME�4������^��m��*��V�d�:������O�幑�����VP�b�&m��Z�h�{M.FH��K��&�y�}b��o�e~ł�y��(b����m��G>����O�,�J���\\��:+(f��I�&X/��&(�0V�~�ND�*��b��ll\"L����.�����;PS�#�BW��,���i˔/�D5�\\�J���9.2\"|GcN��B�0.�(�	Cc	�V�0&#���O�ab2_��ŨP��d*�nlgv`��(2 �L��W+>D���e�ͯ���Up�p�\$un���aN�\n�B���/+��u��p�0�,��\rC:\\f�ǰ�(���Z\rp\"�1C���d�hǧ^��c	�@|�`W��W�(�1/�3�|\n�/��\n�y�NG�K��0�H�	�bd�\n�~E*�]\nb�މ�\0���L�\rb6!c��0ظ,��+�M\"'�qb.\"�	q���p��mL���N����t��4\r�V����\r�MNz3�d�`��j/%�Ћ�\n���Z&5��9�^�O�\$L��\$�� �a%I�\"q��mk蚐���\"�⓬�,�/1�(r�J����\"�,�\"g\"'X��<�l�	��c��:):�`�N\"Z*��W�,.r^!�@V�\0�.Y,���B�k�,�*5�3.�.NA�-���r6\$���g,���+�lLP�������4�������2Ka�\"�^�#\n����H�+#00b�-��&�=�5�i�7\"G\"?�|���	�0���,�v@����6o�&�\r��\"�-L�B�Z";break;case"ar":$f="%���)��l*������C�(X���l�\"qd+aN.6��d^\"����(<e��l��V�&,�l�S�\nA��#R����Nd��|�X\nFC1��l7`ӄ\$F`���!2��\r��l'��E<>�!�!%�9J*\rrS�UT�e�#}�J��*���d*V́il(n��������T�Id�u'c(��oF����e3�Nb���p2N�S��ӳ:LZ���&�\\b�\\u�ZuJ��+��ωBHd�Nl�#��d2ޯR\n)��&�<:��\\%7%�aSpl|0�~�(�7\rm8�7(�9\r�@\"7N�9�� ��4�x�6��x�;�#\"~������2ѰW,�\n�N�l�E���Rv9�j\nV��:Ο�h\\p��O*�X��s��')���ir�*�&�V�3J;�l1�B��+l���>�j�\\�z�1,��t����*��4܅N�A�/�ډH%��-�=lLHBP�G)\n�\$�R2�E�t�,��]4��R25 ��k��(���3\r��1�C��3�5�1A�(�4���.0�0�@9�`@Y�@�2���D4���9�Ax^;܁p�V��T3��(�ã�?��x\r�KJ���H��\r#x��|���1mNR*))��U8�I�\"TL��\"8I�[R�3Qӌ>��,�j�\$��W�B��9\r��\n���0�!VP�H9��CMyR�SDBY({*�Q��T����:����0�����E��\$���D���)*0�)0��kZ��JJ�I�16�HR��Y.�\nG�������K���k\$#kch�5� �0���5+\$�&-k[�9�6]M�TlZT�=&�g��N�Ĉ�X[���1�r���/t���ّQ�!�oݏ��#��ۦR�J��BǕ�{!��L����P�!N}�s��Yt��h�9����k���i\\����C�`ā�0|�f\r!��X�� =h���(i_�	@���4�(x7a�_0\$x�΃RPA�:�g�34��3`ث�)�TJm\"Ę�E`\n\n���/��A\0u���]����\0l\r���5��H!�0�8&�����0RaI1cSr��HΌ�}-���CD�\r��Q%_�@�pn@�H1�`���4+]l�����\n�\\��@�`\\��j�BPp:0����`����^�9aF���&��#\nH�x�|��2�ȋ�:S0��*U>Hj7q�x�5��C�p\r+]-5�#��[ˁq.@D�]A�v.���t%���\$���k�j��>Ε��M��!�}��\r�S.��ʑFR��.d���#��\r*���,p���=N�rC4�C5yD�%��X���P�gH s2u��	ѩ\nF⼈�bDBhOA'�`jC@p\0���ZI�#������N�� ��A9;���5���Vr��a�7�Ue�����?a����|��N&hБ����ٳY����\$�\r��\r��1�����w7��4Fη���˿0�O�a@�!�0���7\",��GE��*(qh���ĭ��Ij���� %\$ʚ8�R�b:F�:޼�`L��6>g,AK�-M�Z3yI2K(�I&}X�z�At�7��k���\0fA�?͕a`P c�HB��4:lm�h�F��T\"ř��j�`�.\"�5>���sZA3\"\$��({�R��d9�1�7�\\��Y��pD��4W����. �(��gn�@��).u��X s�2���@kV`F\n�A�3��9��Ƚ7��#H��q�G%V�rJXj_yLQ�p�p \n�@\"�r�a�&\\Ξ�K�e\$a����K6{�)¾\\N��I��\0�T̶y��j�X�\$�~�Ih�.�T� LQ�>�Լ�K�[ʹ,�����#l��T��Di�`� ���r�,=ؾzdu��-3]��O�{�0�lc�B�ցF/+-��|c�~\0���D]�Li'g�{���nD'��>�v�	uo�����m��^�q,m裊���8S\r!������S���U�CH�\n	��s��R�i	t�2�Ѕ��x�6�W;K0\r���߂3�ZC�(-́��cCu5a�<޷�6#��GY���4Gz	��Y��g�S*L@�t�,��J4)I\"�*9�c0�@PC��5�P���M*�a�;����Њ?�'��������챎F��Rr�p��DhMA�ڥ��ך��+�2\r��as��u���I��,�C	\0��r�)����ݢ\$ʥ'��%�<�����\0�\0��\\φ�݆U�C�,�?~�B�/q�}dA?2\"]]��yz�\0�a�kN4k���Xj���HG�F�+o|�v�^Y`�D�\0���SV��?&�~�j��~LO�2�o���.\$��A\0� �\$��T(bB��*O�V�-�,C(��-����OP\"#g�%IdOB�\"R0l��\"M�V\$\"`0k�%���dh��)AV\"'�c���\$��/dw�J&Gt3\"\$!\\xM6�h�D�T��B6�fT!��vN�S�Rq������`-���ac��(��d�O��\nb]C�g�w�ĕg�\$SB���Fb�湮��#�˂�ļ|��Bx�&D��·Gp�M���\\���Q�P��H���d�H\$�N�@�\r��A%�\r\0�� �k�ڄ��ϣ�q?@������\r���`a�`�	Tqb%R�T!X�Q�F������0�j-q��!0���LA��א���P�E����qO�?��z�dH�Oة��b�lCZG����X�6.M�����l�η\0����Q�cqRv�#DhH�8R1��}#�\"�)l� ���:�e�pEH�\rX!����P��8�fp��ZB�'�C(��d����jp�In�q�'c��t���,�\r��e��a�+*R�Ί��U#.�.rN<�������ar�\nEF�N橌�)�=2@��\"c��\"���rR<2V�S ws%�<�b,M6S�\$r>vs<E�A�U�K4�s1#�3�,|2W5͖c��h��2%#�;�:L�8��� 0�F-W/ ��C�h�9�M2��9�SS���.C��1G/��2So6�;�%5�:��-��*�SK�78вyD�޲%23�:�𠏯9��?T��3�?\$���A3�8��hd�?��)Q]5sE>�<�+CN��cBA�\"��&�o\\�@��B6j\"]�rk*�E4@4T]D�T�Z\$f�KEn�B�S��4\$\"]H��:s�H��)��:t��sO:��NphbR-\r�>�\"�TP!H��O��N4) �L/:�\rt(�:��&�	'v>���B�!��<M���hlC*O�i-	8o޷M�Eo|g0n���h��PαOO�>Feo�\"�\"Bn;�p�H�\r�V�@�E�Y��k�x����̉�\$\0����\$�`�\n���p�i����{���\"�3ܷFzH�Smh�K�	�^\r5bg�rj'c���/s�Rr\0E@�2M]�/�V�M�\$&���Z�8.\$╄=��\"����-��,�/��n�\"c36JGq�����m1L0Qa�I��('HS�Zs�b`���f4CIDt`\r����\\�{v\$u�.F)Nhm����c�1���\$1�/o*w,>v6�P���\nF-��3%��Q@�W@��r}�F1�B\$gtI���/�a��MZ:c#K�Rm#��Pn\"M#b��3\r�@�����f�F��J�3.N�n��&Dt?�\$f\0�	\0t	��@�\n`";break;case"bg":$f="%���)��h-Z(6�����Q\r�A| ��P\r�At�X4P���)	�EV�L�h.��d�u\r�4�eܞ/�-����O!AH#8��:�ʥ4�l�cZ��2͠��.�(��\n�Y���(���\$��\$1`(`1ƃQ��p9�(g+8]*��Oq�J�_�\r����Gi��T��h���~McN\\4P��򂞴�[�1��UkIN�q�����呺6�}rZ״)�\"Q�r#Y]7O㬸2]�f�,�������D5(7�'��1|F��'7��Q��Ls�*n�����s����0�,��{ ī(��H4ʴ��\0\n�p�7\r�����7�I��0���0�c(@2\r�(�D�:��Q��;�\"����>P�!\$�p9r���낏���0�2Pb&٩�;BҫC���2i�zꤨRF�-�\"؅-�K�A���O�łJ<��\$i؃�,��ߚJ�)�(f�l� Ě��hQ̴-�r�:Hz-��;RƵ*4l\nԍ�K\$6h�=?T��av�W)\n7(OƁ\"��O�L��f�\$h��ii�̝;�P;l# �4��,g���w��\0�1�q��p�TgEфd;�#��7����H#��\"Ɂ��4C(��C@�:�t��,6����@���p_��c���J�|6���3ElX4��px�!�\\���&��Nz�e7�iCT.)�>�6��N8:����bz���t�jJ��h4�S�b�ʰ�(��(��B��9\rׂ\n���O4��N�%�*M)�뎕TH��hp��ңH1 �)<S�H��d�6�t,m�?\"h&��I�%�.���g���х\"⊿	�qYK�o<\"�U�p�s�봷4I�r�A,4�K�-ht�z֋ �s��;����j�)Ϋ�;���z�%�v|����k��չ��(��İh�9�25������=md��Ƣ�ZwBgT�u��Z�k�@���T\n�s����V��`�Ԅ���w��\$b\n��9��B�A'���4��T�<A;�'	�<(~������ BVP���6z�!8\n+`�6�P掘3*a!�:�Ԉ�xr!図�gC�>l�3��C,mɔ.ʊ�HsE��E�P�t����CŰ��!]��3*���O#�\r��98RPcy�%ɭ�B��ޡ�p�a���E��;;@�taHq(���s�RLD#ihʤ�Se�}1������}J�u*p\\U}�]ʕ	g-K<�T�����l��ɘ�Jc��{2�y���nI�,J��5��ʘ�'-܉Xr��]\"|L h(y�\0�\"��uo���\r!�q0`@�Sa�A�1F,����t91�BѤ��ё }LY�n��\$����9�QX����I43��2��>.B��)�HIIRdZ�=>�2\"��A����\\(� al5��&�X���q�2E#�n�tՕ �&i�Q�J��>=;'L*�=��LIU\\�T��A�̰�����K��T�8#�-]�Nw!��-D�X\"�Q�@hFK���P@�`l�KC�hen��3Iê�]��:۠��<~_�/�e � l&��fCd� ��2�A��'(\$�����+��Vi[)hdJ�P	B�3�ХS�l�z�g[�\"��9����:���� ��L��	�#�o Q�o_���#�S�=d��\rT�T��@\rO��Yr7_�� �����?��\$\$�ɭ�h\r!�4E��í�2�!�0��ˉ�6)Ti��%�[W�k��h��EY���}T���*dM�TJ���!�t�Q����Y��lHq9�;\0�j�.o�h�G{8b��k��hI�%�c��H��+eyǥ�\r(�T��L��0N��uΑJ�z'J�,��)�S�)�iP��N�E��9��Մ�'WF�i�+崲)��Caq�B֕�-CV��KE���R�1�t�(�e�FÝ(o^�3YW��\$�M\nj�ڛgV��yI�)n���J�i*�V�\0�/�3>��[h,X �q�	m��2�}E�;R�����no/�`Ql�L� �ŕ��+�sk����88B�P_2��.�u?�ˁ)���B!<FO�7|G	�7�t��&B�[�=�����iA�J:ʩB��ש�FY��A#��q�� ��ﭛ�ŊcZ;J�u�Vf���י��\r_�F��>\$�Xe�6t�U��]>���]?���^��dĠ����ų��	�Vb�@A~�㨿����\"\n4�0�&�bҍ����+d��w�����<��B/rx���)Bt^p�7���B�!���O*ы!07��8`u�5�;�d���G<Uh �C��@�-^�U�z��h��B�����\rzO��\r�d��衤N\r�v\"��ݭ��P���/u/�-�0�K� �L)�~�(2��P����(�8).Hkd`� ��a\$XFL��tx)��P\\�(s-�ţ4\"%n5�_��0��ho[�\\{\"�(L�q��+�j4h~��8�\n�Ȍ�\n�O�h�HƎ�EtR��(�~ �\n��`�\0��J\r\$l]F�\$t��I\"H�2(jgɆ�-T��F��AK�8��n�*�O�<��u�\0C\"w'֕�`I��j��\"(�	��C�0�QT�cl(�aC�T�ڙë���B�K�9����f��#1X�Oj91<�q/ѯm	ɮoq��\0�q1�0����� �6'.��#�g��'�A�<\$p�*�\\�PR�qQ �P� iJpEJ;��'V����-+�V��r2�ǈ΂�L�QZ�G�!b��G�A.�#�к�(�u��b��Ƈ%�\"\"n<J����r3eC/�|�`{LhiGT�`x��\$n<B)�mD��K\0�͸��@B�BI�*ʵ+\"��όQg�+�qi����z�����6B���b�.no�vю��2��/0,rv�*�*��0h�ls\r/�*w/2p.��bhF���Ɖ�D�b�g>t+&���!huc%e��N�1�\nH��(�v�K@���HDs4P�6P+7p0�m\r.���\rI�Y�F�n��O��\r��E�\r(�o�\r�ؾ��R�6�~���_*h�hd�O���+O.�g����S��r�1��ǈ���3�u��?)�?d�h+2��=s�3�0���)^�T�h�/s�,�g����z�P�+%23g2�C��T��;9�/ �H)��X�J��;!���f�\r+4i�Aq>��Qm01rX�!Gj��-E�}4���R�-�>����h2N;CT[C��C���C��z:��9SB��)��LTK#O8�,q4�LJ��O�<Pt|c���D������^�'�\$��pĘi7��œ:0>�g�!��?�֛�(Pf�I����/A��@��K�%&2�1��%����+H�����8�Nl��\0��M�B�L��Q��F�[L��YU�Y�!N�'OC2P�)�;Xp#�R���Ռ>��>��\r��|�CuAE���uԲ5ؠ5�A5�Ar)F��Rw0�u�Z�4��\\)�Q��\$I\\��K�r7�7�>���J/��^�..��&���4LIIu�0�F4{dT�d��YՎ�T�T�\rt�Z�Z�ePV�2vm�?2���k��XvkJo[g�!	hj?V���VV5�lX���<0βu�Qc�7�|A�K>�eA\n�4{v��|1�>�Ɩvgv��V�W���v�C��Y-h�5_͉o5opQo�~h���97m��o��cr합m\n\n#u�P\"�s5K^�MgD�N07h�\">��rY)�FPq@֣�`�&BFsZ��!vpuv�n��r����e7j�W��F����˵y����7p�\$4�,����e�Mf1�{����t��_R�_�uP�z�7q��`�|�bU�Q��`%g�}ah��Im7�Z2e�0�Ғ�s����Kp��x}Vsn�O'�5Vie����D����g9\"1�������?���B�!�q4��1�l�9)�-Xe��p=)��Ҡr��맔'��x���,�HԷtiqx�*���1�<���&��8\r�V-d�#��N+47S���U4�	p2LJ��,&�P�b�FN\0@\n���Z��,�u�g1���8��z�	�z1���8�:�֮\"�찜J\n\"g؈g]c\"�p��o}�uG̈́\"w8)�Q�>�3(�I✀��`O�6��\0N�4]h�8�M���<��R�YlM�;�@e+�H�VN\\7�LX�z!Τx��2>բ�,V�uc3s������D�1�1����ߒ�����\$��3R�����i�\"q�����y՞�\r>x}�Z\n��.,�a.��-y�y�׮Y\0U�{n>x%mbcl�t\r�qVM�U��V�4���p� ~}�����`*3�:e\\Q�b�y>�OE�({�)��!Ġ�TQ��2:%������6䁠q��\rx}�:\"K��Q��D�����)�гN Oho�	�(//�֔kOC�\"cn\r��D��\0�m��q7+qw.�V-֑!jV9}��;W�A#l";break;case"bn":$f="%���)��U���t<d ����s�N���b\nd�a\n�� ��6���#k�:jKMŐ�D)��RA��%4}O&S+&�e<J�аy��#�F�j4I���jhj��V��\0��B��`��UL���cqؽ2�`������S4�C- �dOTS�T��LZ(����JyB�H�W΢Jh��j�_���\rmy�ioC��Z���N���r,��N��%Dn৮еU��8�O2��n�ŭr`�(:��NS7]|􆇵��8�8:>���n<L�uC�O觽��g�~S+�~�j<�.�����yL�/M��0NB�S:��l��9F�'�1P�B�¥4/�jr��.���.j���6ԫm�T���d��\n�7�-��D-�I�l�j�'��@Ep��\0��3m�P��0� �aL�?	���2�4̙�oKa3��P��	|�2jp�LJ�`�@��}0A/�2��\r,S=���j�q\$�i�&����&�1\\N�,O+��c���m�F�J�z7VHp{~���;��#s�0����P�-�0J�6���SMo\"v��s��K�6���|SS��x�?\r�h��S��S��t���M.��.��J�Nͦ��\n<uE7�y_BH���ڋ	p���\\/I]O���?'J��^V^\n��xz'J��?\nuF�y�e���lKر���TO�N��v`�;B�6�#p�9R��-oc*4�(tm5#*UH�����9�%nĪk+`U+H_�\0x0�@�2���D4���9�Ax^;�pß�:\\7�C8^2��x�0�c����xD�ȍ�\$*�=Ei��x���v�/=4��@�+mN��i�vPTlB��N���}:+�m��O,;TC��_N\$��ɋ�u/��>��U��\n���'\"�9kT�;��'�:]�O�ﭫ|��%˶�_	���*���es���8VM�	�q�2�9�*e僋�N\\J�o(��#��\\]Ct��b!�L����\"ϥ ��͊�;������\r��f�\rv10�J��P�ȖC6��\r'J�.y ���	��fa��_O��t[�\"^w�-��TP�=;AL(��Z�B�d���#d�KYD/�F5\"��1dc�I}<S����w��,��\$Q_n�:��~���V!2Fr�!�QQѼ��(��\$Q\n6E�ۊgfEYa�U���:V�Ji*b��=dl��4K#�zN2J:�.���M:���BZv��[f�6��B�AB���vH���*TF*dĤ\\˛0s<9��g���gi��!���(sU���̙�A��I��zv�4�]\$�|�\nh��~zU��'�fN�����R�F�Ł'p����f|��D��T�mf�\\A�ٛb�@R\$H��6���x5�,F�{1R��2�����e|o�}Q� !;�W��c��~����Y���y)Ri) �� CXx�	�g��4E����\0crAM�T�;)��������Kkm����6����{����8'� o\r��:��1�G�}M����Z����-�(IsT�[+�`�ֳ.Wba�#s2�����[e�S�3�uTP�Ό2V��V�=5i����7i�Bt֬�{]p�J�'j�/�詞��(o�S˅�_fshmM��7���x��VV��\\���:8@�c�+���2�&V]sQZ{\\�B�m	�\rqP5�WC��%h�̸���\\�+�q����\r6^)�)4_���;A�VOUuMNY���0�M{����@A\n&������2�8Q0�ӏDUV2�g��B�[�P�(����5_E^���bpX(,�����.�r%5!l�(����-8rUN��*1Rς�L�	{)fP!M@�\\���iҋ2��2M���y=�/cT�2��7<�y�[]7p���x�ek����ٻ�f��@�N[\np@Rǡ\0�s�t����sL��Jאd0Qz]hLNj��=zJ�V�yS�)	F5r�\$o!SS\rKXv��N���#����)3���#P -&�,�L=O�M\rco���������uű�B7fⴖ��ghO�K)�gM����%Km�\0�T#l���d�i'�F5�l����\0�Of:���0]Q�jmm\0��i󕝿h� �S+�LP�Ut��Q�i�H���L+��G4�T�]l���)�p�+b'ቫ�\nWx<������iN^bC�v���\"VU*�.�Ϗ/�Ʊ�e�\n=��k�.>Y�Fb�q��#�sY	1�6�J�kF>��ޏ���5^v'�Иd���R�����<S\$K5n9�+yv��0��z�ڛv2�,�_,���u��j�M��꾎�+���8��*�Ξ�(+ۏ��ɑ+����F��??��L���+ht���b�b��o\\'˼w�v����F�r�H��4��@`L|���W����'�z,�t�*��L��L�h|�㠴�@E����6��D&@���al\\�\nP#\"t��\"ëF}n��,�fJ���A�p�O�O����hQ`���B�����\r��I\"}��,��,���Lgm*�\r��6�T�*Y-hᏎ��CബP�j@|���)>�NB�pY	Ad'G.��b�~�j+m�J�\"fd#�l���+nn\\\"L�r��O,��C	��������'F.�,\nN��1T5Owd�\n@	�hL*D�\0/�D�G�9\0�l<�|�l�C��m�5N����JC��p�l��T�������G�^�����@�-	N:�Bw�tǃ��X�*�QH�\\��O�����\0 �\n�� �	P��R�h4��*�^-�Ad\r��EL�h��D���A\$��G�{��z��HUG���[�~(d`��j�〨R\\�R`�g�Д�*��-�\$�#j���/>9�tTr��e(V���]2�/�x�뤢,}*���/J����JΌT\\4�\0Yl�N�.�L���lV-Ҿ�ʣb�Jү'̏%�A.�3/R<?��dL\$Vœ�Y''�*�k+�,�������.�Ҹ��B_21�����C;����6	@��N�����&�*H�LT<�q�\"t�%�8�Ƥ%�,�i:�F���Ū�M.�c�l�8�2T��fI�@��b��=E��ΗN�c�vX��_F2�-g����8P�6�q,Üc��	G�Q#�g����\$�P����[e�A'�xǪ��&]޹L�,2�3�eB�kT4N�ф��-#DS=B���C�A��B��4&�I�g){�aBS;1�	4�P��\"�F,�'�)I3��p^�d��6�\"�fO2�����N)츧�K(�P5�E��evƋw%���r�k{M�]�c�`Pq�	�JLt���G2�\r@��F4CJ2�8I��/�B�Z�`���O�hN��1�?`~�CK ��@�\r+�P�OȒ�qB��Gk3G��U�[\0�1J�y�JA�հ�FT��0�ñ!	oQ�]JT}F�\0�ՓHGqCL�]5kH���)��M5d�3�G�%[sA[�T�t� �~���Fj�7u�P��t\nT��LO�Y���;p�>C�XuDa+N[&&�QP��̑5+�(��\\ҙS�wv[+Y����<P%{bbU_b�^��V5�Vu�[5�V�丑�I�	Y�G�������T4�H�kRf�옺��=�?\r�LD�ζˬ6�U\\�&T+���H�m\\evjT��+`E�aԢT�=\"���EN���Kbx�,?W.�c;r.�(j*�C����#�[h�����jb�j��הlx/r��v�p�_|ψ_4��'kZ�xw4�\\��hWIf��S�c�l�GiYRo]�WX�#u��!3XfB�j�j��f5�v7s\\ԵxT����`��9y5�Ҋ����vԝ_5�z�#x*�4W��.syw�{7{Yj�?���ON�n���6��Jn�~18x˞]�7��ĄD��a%Gx�_B7Uh4i=���yH����ei�!`7�v�g�����#N'sV{���	�/d�5��t�7g�5���%F��}�Ni%w~�-���]wه��8t�V�\"jZ@��6�]u�ufu��6X�-�@�݉�6鷧l��vx��m�Q7�@�q���wX�/X�|u�Qw�D����lBX���}��՘��a��YXЮ8��#A{���x�a%HwQ���fU*DW���>��z�f���Ã����P�\r�u����\\�=yQ�)9��_Xϕ@�Et��tH�\\H��}34s��f�J���Ligy���uti���׆؃���vy�����x_��o7���١��*�l|���{ J� ��\n��zT�����vjhOy;��aN���G���hY��2�9'i8�%�����M�63�-�\rb\$%~↭RUa2�BP'vGMn�y��\"q1Z9��k��q�3'd����Kj٥�U�/3dfM�\n�2*Eb�(,yD������vAB�oAP�A�X��R���i�㝴�Ty��g键�j0\r�V�Q�w~Y�\\-�>\n���Z�3�K����l��8J��s���a36#b�����O�AI�Z�,(���o�K���_��Hn?���0���_.kK8]��9��E,ǲ�5^�b�C�Lc>�z���H���Kc��Y�|�3��2^h�9���¤ʔ6�(��P�eXbf[����(J��j�2C������P�լX+h��IbbN��8�)�����~�<㧱�ػi���Sަ\"�>C;����إ�����y��=�|������Np���a��G%��:�v��W��r�@T�=M�@�H�W� �</#쨵p�.�T	Tc�KC?o����5h��;.\n�x�SAa|?,Z��@��O����(K�u�d��Έ?ާ�,��'S�ri��o¹�E��U�l�v�V�(��pO��\\�w�׿���Q+%�����≆RE��Cj9���2*Ԑ��";break;case"bs":$f="%���(�l0��FQ��t7���a��Ng)��.�&�����0�M磱��7Jd��Ki��a��20%9��I�H�)7C�@�i�C��f4����*� �A\"PCI��r��G���n7���+,��l�����b��d�Ѷ.e����)�z���Cy�\n,�΢A�J �-�����e3�Nw�|d���\r�]�ŧ��3c�X�ݣw�1�@a���y2G�o7�X���搳\$�e�iM�pV�tb�M �U��k�{C���n5�����9.j��c(�4�:�\nX�:4N@�;�c\"@&��H�\ro��4�n�\r�#���8@�@H���;���*�\0ߨ���\r�ò腱�P������.\"k\$b��#��{:G�s�h�l5�Ϫ�ҠϠ�6���J9>0��Fî,�&%i���J��3��*���5'-��I���)#�U.��AЀ�1�mP��S<P(@;�C5IB#�'\n��\0x�����C@�:�t��t4:p�˘��x�	B����J\0|6�hbp3.cj4��px�!�=/��;��=����ʃ��C� ɋ8�?�C;N2^w��|6���'2�LQ9��\n�L �,MN�C�������!>ãdv��CH�4��r�4#� �kkҿG(�0��d �c�	p��P�:��\rpb^������p��5�8ɤ�&!\"��V:5�;�#����'��֜��M�5�T5�H�C�h�ӱ�fӠ�JHJ��nz��]�_^��:=3w\"�9�|k���w��j���ĆF)A1�<z��s�����ખ�O*X��#\n��/�<�]GkCM��g�\0@6�P�Wg2W���Kh�m۩�9���3,�g�EmZq�m����1%�|�g���#(��\rԽ�9�d�f�C2f�Q\r�3B�H{SP�7�լ��~��J)`��K\0o��9���CM|o��(�TA@s\$�*���zI�%PfX�C:~\rZ�QDiL��o�4�����V\n�Z+ep����W�%`�%��L�1>�ef貵��\$Yu\nj��)#	�5��R��Qcn���.r��X�d�g���ʩVD�b�ժ�W*�^�\0�b�nX���?i\$�^�InƝ��G��R��D�A㧕���r�� :!r�C��,ĝ.4J�KE��F�\rCARql�*\0��J?���\"`������̂=�*�/���;��4�w�^K�*O	�'r*2��&�`��H\n�Ԓ�PPI�0䨦��H�n)!���3Xh���4�)�j�j���;�\"BL�L;����0��5lc�S�\r��\r���*UN����s��ue2f�ldj���B/���aL)g\0���\0;S�GC*kf`u\$\r)k9��F�kR�X6f*��S�%� 4�r���&�lޝ�4��8I a��؊�Tq��f�ՙ �MR�\r��~����dz9ͳh�MM[2D���`�T�N�����C�\$)��'��XR�vb\$1N��S\\\0n{����%���\n�4���?����0oW�i��P@�� {��Ғ��'ۂM�D�ث/C�g7)P��h��	� =aL��biA�	�8P�T��2h�Q s\$�1B��\n@U�\"���~���=�J��l\r�	z4��Ғ�p�vB%�)�Ҽم�v�!���V��!�2u%s�#]8 �G�eŎL����d����m��t��ѹ3.�s��lͼ#υ�+;x�U���4�v^ɩ�'9\0�ql\r�W4.{a�q/�d�#�j�>P`�����I����fP�\"�~AWD3;\$0����P0N����^��e�Q�\n���7�x�v��ȿ��y�A�I�^�3DǦ�s�2�UD�Q���c.e�t.�}P���2i	�\$���	t���P�wk�_�t5R��ݓ�A��*���/8�5��b^�Dn�!��n3%,'�>=.�lz�V�\r����P�a��TO�䒮�Fͣ>Z�<&T���7m\\��e'�L��MG�y�@�BHq �`Z\r.dI\$��(QQ�A��y1@^\0S�L`N ��'1R�5 \\05�	U�Sеq]N3t�\\B�L;�uBhz��sừ�n�����l&�v.��!g�d�����L��s��?:�upG^v�Ӂe�AD�戀Ξa����{��O)��e�=������dj�ދ������'U�O��!\0�)�\$�4��L�k�|Б���́<(��3���\n/�}9�P�x:N\n\r��o�Q��Zf��q�K��?7\\ˠ��\r���:�G�\$C���O��}�c���L�3�Z@����&+�\0OT�O�&.\nb��TxόX�2�60�o5\0�\r����؆�C���@�f�<\r�\r�~�i���|�hG�&���+�\0�-Pd�	l<��N�<\0�\0�C����;,�0��&j\n�D�ĈP���m�\r�{L:~��P�I4����N�x�����@��u�����J`�\r�������ɐ�pG\npTtMt�p0���P,��AQ\nBaʶ%nBƢY�8^*.��P8�g,���qB'\"1���&�T뢡�YQb��c�(2�R��m�C��&�E�-�������Α�����S�b.b�:��%�c�>!��O�6i��8���B�dQL�\r�'1���S�J����.�:���Roq�麞l	g\$\"�5QĨ�!��-�R٧�J��,a��^O��DMѩ�Ap=�>_q��j�)m\$2i��8�\$��Rf۲EQ�urd�V�b@���%R~kE%Ҍ�f��k�rc�O�E#��R�\$d�c<��h�+�3\$�.��Kry,r�(0U(����\"��-���E+���IU(��m��/_�2b�#�*-���F���&� \$��s��1�wc(o\nۢ,v2����3fC��K����ۤ�+�d'\0�=\$�dM���3���#!�z#�jm�6�V0r.���}6��8p�M�撆f���3��.	SG\0�:��2��2󨈣�4�0뒊�s�&��<��P�0�'Ҙ7�6�-93����K�,�-�;?C�<@	�2B�,�Tuj�=`�)`��)0#V�Ĺ#�Z�\$��'T��*@�t7B�l��ۀ]�4&1F�7�(`��%C��\0BQ��<�¤�`��Q����J��h�@.	Pu+P�\n�g�Mǒ��\n���Z�\rȆ���\$�\$/,�j���CT����1�����>x�43kPxFxLgsE�0��&�	b�=q\n��>�z/c6�1#�H3�j;�����)��`�=,�N`�R�L���)�e	f�d�� f�)\";G,�׮��(ِ5V\n Ln�k�kU��GF?S4Ψ�}W��ӎ�\r��>�\rA�m�n:��\$�iK�]l�!C7 G�!�`����\\LR'\"p���#��D�C�+MĜ����v�u�x@�\$\0�g��&\"h�R��r\\��n-��2L|C�37@�,̺r6�V0��1b�]b�L���C�1Q>\nC�A͖\n���/��) ";break;case"ca":$f="%���(�m8�g3I��eL�����a9����t<NB�Q0� 6�L�sk\r@x4�d�	��s��#q���2�T���\0��B�c���@n7Ʀ3���x�C��f4����(�T�P�fS9��?���Q��i3�M�`(�Q4D�9��pEΦ�\r\$�0��ֳ�X�~�`��6#+y�ed��y�a;D*���i��������+��p4(�8�\$\"M�<��k��X��Xē�YNT��^y�=E��\n)���j�o���M�|��*��u��4r9]��֡�횠: ��9@���9��Ȓ\nl�`���6=�:*��z�2�\n�&4�욊9�*Zz�\rI<H4���H���*������̈��;I�!/H����Ȉ�+�2���\"*\r#�&��!<&:�Oh��\"�D׌��06�r��0.�P�ʯ�<�\"�.(r\"\n\$��H�4��b���f�QM�&����P�2%4�34�C|	7�<0�c7�����>44�Y�����8�ʌ��D4���9�Ax^;�r%L�Ar�3���_!u���J0|6�Ȃ�3.ɓ���x�B��R���� �j:�`N�ʣ��:-̍�ǣ�5ꓵ��7�\n��Lc0�]I��+�\rP��� @1*���x�9���ڽ�RĴ��x�/8�+�\"0�З=��2�����2ш}��\"2+A�((�3��%E�i\$��6-c�ގ\r�`ߝ	�����0ܝ9�a�V�4���7�4�#��KK]�P�l,H�� �0�l�#*\nb����Z%��81Oj\"WxW�Ӏз���H���ϲo�=+?Y`x�2�sr0��6dh�!�.���C7v�K7G��,���J2Q	��ʹ�߃��I\"/��<ܷ:I�a��7#�k+���[��(�i���r�/|'���Q\$LCi\$	�q�Pؕ@Q�4�`�����8�1��&�Ҹo*\$�7����*��-z���d��U���3����+S(h2���\n`�s���I�O��\"�*C�P�Bgx)u���;!�茫����XKc,��zY�=h��^�K����F��w�d\$嬅�3NT��iG��e�tT\n�#\0�I�S�O�U#+Q ���*Y]�Ȳ�V�X�%e�\"G��;P5���]*�}���E`ƃ�!�o �\"�ȱ\$Hdq���^��D�T%��\$t������ �#P U�1h�I6cA�3H�H\\#l���\\n��8&�pʶ��_&bC1����`�х0��'��JP	A�%�AF%\r�o���Q2X��pld��w�	�<D[o�F]Nӵ ���Ĺ/�3�]�h)SC	\\��rZA*�Gs�A(/��\nng�k���Z`�F�T���@#�'FA�ב�4R�	�IH@�����_���Œ�^LS�!�3f�	;� �<�ZƐ�mfꎙWHU��M�:ON������u(lݭ	�L*E}��\$�AIW@�\$ZW^�a?�^���\"�.�U�Z\rqE/�~�5^�UH>�ٱ%T�Ìq�����@��RLh��#��5�P��Ԓ4䅢BARd\n��X�m�	�8P�T�\"�@�-�Ms�µ�L��\\#�(9�ZeI)�P��������Ű�îvNr�i����I���<&���d���y�/T�PR��+�T����1�]-bQfS��C�������S�5��D��S�HŜ��P�H�H�E`��r�W�%�qآP*Q������-=ق��Y[���K>DI�=4F[N�\"fh�T2ŉO+sH�i\n�XNAaѕ�j�J�� 1e-\$�4�%�3�5�;����k��~\$X�0�kkD�ń9�W�o�F\\#'FvZnr�D �3ej��g�v�\$)��[,u�.���cAM!ɧlc�EH���I�(�s@0nl!�a�y���wĩ������D\"��,�2;������|B�Aa :B�l�eS��RB�~��v1I��@��cO8ІV?���%e�7��%ֆ����0a�!�A��[�:���|FD�1�Vg��\"���p��F�t�xϻ�təND����FA�:.�_������>����>���of�]�\\��dBa1�'�;��&EH��'�49RfQ�G(�0�\"2�(�8�\\Ĥ��,��Rjȼ��&�v�C��a��w\n��	�{5lğ�1�W��Вr�KJ�>��n\0�����J�C.N`a���)\\`f�z@�و����w\n�/�w�r˫!�:d�*��E��ώz����IgRa_M�g�_�-��������pMR[�b�lM��D��e�h��?#(���f���i�暿b�P�(PL�\0�� �Դ�0�#mr�v����\0N�Bt2��\r�0.�\\\r��d�N���#��Фp�&�#������j�̊v������N#�n��nv���Ќ0��v0��0�.�琸���J\nƏ�um/	��\r'�t��3nv��L���&JJސ�fM�����B���P4s0�?�}��7bQ\01��R�\"�n�����/�P͔4ȒRP��0��,و�/p�qH�q?J6h+K�M��/40G4_�Q�O�(�BPӫT=�VC8��Nv�=���(��De��.b8�V(K3L&2�ܐJ��Fi~����ZJ���1u��Hj�Im��]�b��#�,�gb`��5	 A�B���������3	���{���\"S ��\"ͅ�2�.���\"�bM�؃s��0�2��#.4��Pe��!��\"o�P��\r�k'�7�h�q��<t\n��eL1�\\�2�r��2�����,J9�TKg��/�����#�aQ(�{H�����,�o(R�-R�,�(-�v2�.r�*r/2�.�	&o��\"w�'\"��0�Z�����er��e��\rcN(I��G\r�B���2�.��4/�3�@0�0�^�n-i�ڭ�0P��	��\$?R%.h�m�1�6�ƻ�r�O8n�>�S��fRt��,�E!�����ssd�N\0�7��:��\$��?ɜЭ�'��NR�Nk�i�_�d�(X0F\"/W>-?%L!b�F�e@�Ib\"��/W:�?J��N{>�c��@o�R��B��\0�J��k PET��\0�'\0���\$�6~��z���\0�\n���p*1�Q	˪w����&4T!�vA{g�&�H��!�-lx]��PǏ#`�-�#f�2�w��=��=���Cݤ�*ќ��t2+h�7\r�E�Un�\r�\$;�\neV�(�e%<DjRGn:ꐲuHt0�J�cfa��P�\"B���sQ��Q��R�yR�1B0��Q�\0D���(C53D>�8=�R�5L1lU!h\nNF�'+Z�I�Q�i\0bK�쟋Xs��U|n�HyD0F�\r\"�h�VH̠�L��\\C����@R��C��2+N��\",�;\$�RRKD(����Ȑ��\$x&��R���56.���l�2�/�H��H\$�/[�h��*	\0�@�	�t\n`�";break;case"cs":$f="%���(�e8̆*d�l7��q��ra�N�Cy��o9�D�	��m��\r�5h�v7�����e6Mf�l�����TLJs!H�t	P�e�ON�Y�0��cA��n8������d:��VH���+T�ت���X\nb�c7eH��a1M��̈�d�N���A���^/J��{�H���L�lP���DܮZe2b��cl�u:Do��\r��bʻ�P��.7��Dn�[6j1F��7�����761T7r���{�āE3i����Ǔ^0�b���穦p@c4{�2\"&�\0��cr�!*�\r(�\$B��%�k�:�CP艨�z�=	��1�c(�(�R�99*�^�F!�Ac���~�()�L��H=c(!\r)���<ia�R�B8�7����4�B���B�`�5�k��<���<����񌣒n99�Z�BD�Fo��\0B�4��B9����*MC�������I�� ��l�4��H��h�L�\rx��[f��!\0�2ÐLb�~���0z\r��8a�^���\\0�4�B��x�9��r9��\0��J8|;%�A\"���1���^0���0n=EC{��P#��5���7�CkH77�L��^w��޶l�:��[�\\d+0}�P�(�S0��b����c*:.o :�(�\n�\0%�	��F P��\"\"L>9���Ŋ�z�^�d�\r�z��W@�:��\\������HW�QCX�&#H�4!�#A*C�FM�BbNȈ������@W�Zt�.z' ����LB��&%̹[�@V�2��3�:-��{4���;�#Ӝ(^���?6<�����\r�Е/-C;O0���@�6��X�<w/wJ��v���bW�����r=\n8@6����WZC�� �x@�o\\	�9��p��H�:�п�D����B�Ɔпڧ#�`6~�x�v�P�Qĵ� '����\"��1?��������\"D�\"�O�E=)�ZNN��h�����˘ ��)?(�L��'~��CV���RA��`Id &���S��aL+!�j�a��4���\"F'́���!B �	'�.%��C\0�{цdF)�Xt�M��1����\"}\"!��s(���,0��ߐ�(nZ��i�:��\\�²V��\\+�x���Xa�b�p^y��P�\0|��Hs�=����6g��5��%	6L�F��«%B}!�t�Gd +P�mA��:4Rz�%�%��UK�tY%��U��H�5j��ʻW��_�&���*\\7K�ܴ��ɝ\"��+�z=!E���\0It�!�E2�e-����x�<��Г��{&����RH�vT�խ�bn��	]J�Hv���1��LX\"�X�RQ�>K�q���T������H��{���\0\n�\0�4u�\r������a��R��S��H\n\0����\0�h((����3hH��5�C=UgԨ�74\$��i/�����Ci\\ç\r\n�1Pʃc��BA����'DC��������B�JNdM(���~�L�5�ĿfS\nA0N�2~�d9=Z&a�E���!��8���c8J�z&V���:&w�m�O,�?b�1Г�s�\r���\"_�tF1�\0�\"%*O%�9�2)aK����|4'�ͦÇ\0��e��t��3�xS\n����&t�_����LHH[�1C|����KMK8^\rz�?\0�N�	��<Sl`���؊�r3D�ho� �#J�o�;�8�n0Y�\$��a\"a�=V��p�]T�F����:�W�4��=�CˑkP� �> �:xN˄������#m-��Ę�z�u�f�eH�a#x��0H:��ɰT\$Ő���|�Q��x����U�T�����]��=�F9�4�3�Ӫ�4L�1�(n�9(/r�x��_���pt���\n�j�/J�Q�iG���FFp�Qo��'�+u2Q4a� *<3c	�:'�,)��K��	�����1���\"Ŗ����*b]N���*���/���RDI�SP��b%�L�\"�j�k.��i8y�<.%�5����#i�& �xjA �=�r9����Xq\\�]��1.7~���2A���%0��Np�'w>n�� �d�)�Bÿ��S�1��������zyA��*\0o�3Ln�?�Pm�s������C���L��F=`� �@�BH)�x��\$\\��#?,x�J��#�Y�G���S�����&[!��Lh�&���!>9����o򋵊�Զ��]��������G��.�\r�ԯ|:��Ʀ�����+����xbF���痹c�:�d̪��]���=�Ia\"ck�!Ϗ�=ˏ���g@??����~�'�D)�1��{�l�F\"zm&�#oDM��̲#�N^G�M�hLL((R�����\r�DB&PL�^B��� ��>Z�Z���`���ED��G-b_,�?��e�]g4�`���l���#bJf�#�C\"0���zq��^f7�N7���운9\n/t7��5�J�\"�&'\"aG�\nbl7f�\r�6�hT��^������K��\nK|:�H�0�3L�`#LJH7���fzg�H円��,P�]�07��-@�^�\"'*&���M���H>`��h��LN**\n\0��x�J�FRS�8* خ\$��� ��dl�HN��f�qB^e\"%��FN�����p�?�`�P�� �gP´�@�yn�- Ѭ}\r�G�tO�1(v�5'�q�\n�\\��^�b�&#�Վ�°���\"�L��k\r��oZ�ψ�cQ Q� �� ���~��2�h� \",�r+q��O�!�R�L���^�u��^�U�\\��%��&rY&�\\��u �n@\r��|>�\0\"	���%Z'�.�|���D�X\"��)%��EJ��H9�zBZ�BV\$�%�\r�-(�<��&�)�NELw'NZ���r�<1	�����#�,FJd�8j�q!P�1�|���&N�_g�&e��_(���%-�%&1�4.̙��!K@\n��\"U0���'*#j94P��B7�s5#~C���e�d��~�����d<ܦ�<�K 2A\rJ��e#����� 볿Ҁ��@@�&�9�M=K�:�	7�:#s�iÝ>�q>2>`�@z�[*��eH\rbnC�Ӳv�A@�Z��6j�A�EA�7��oRP4*&s�?MDPT\rCÝr_As)D�}BS4rs�+-A>�bgnw<�a;SO8�f��WTv�Q��96�70�sF�b`���)21'4҂紜E}'4����!YJs�6���ΏF.p贴M�\\G3Q6tMĳD��GT�J� Kq1��Nt�N�WH���аCX��=<��c\"~D�s#з�~���N�r o_Q�R	Bܲ3?��U\"544u\$h�WSϬeb �G�ol@g#�R##Q�T:���R#r51V�r4O|�o���@��\"5uՅ%Re�\r�V;�tl�X��c%�vU��M*�?�\"t6�MR�T�|#h�K�f�\"%��\n���p���*�-�r�U.҅�w��r3Xo�W��_�t�rM#O�U\"R�!� ���i'�\r�	K��\n��/��FI	c\"	u��K�h��K�&B��.\$9c�\\M�8aZ�㰨�fm�*#�PM`���!\$5�bq*��ho����bm�-�|\$P�pt�\n��xK���֝\"�vXa̛V�j�r�6�i��3�F<�smv�ZƮ��j��?Ñ0\"2?\0a55M�'vl=>'7�r�*B\n�b���'��/03#�	\r���v~\$=G�F\"*�v�=ef&�j-�����M(���.Od�3�l6�tmsb��DtO2\n1�^��p �";break;case"da":$f="%���(�u7��I��:�\r��	�f4���i��s4�N���2l��\"�ц�9��Ü,�r	Nd(�2e7��L�o7�C���\0(`1ƃQ��p9gC�9�GCy�o9L�q��\n\$���	)��36M�e#)��7���6�遹�NXZQ�6D��L7+��dt���D�� 0�\\�A��Ηk�6G2ٶCy�@f�0�a��s�܁[1�����Z7bm��8r����GS8(�n5���z߯�47c�No2��-�\"p܈ә��2#nӸ�\0ص%��0�h���&i��'#�z��(�!BrF�OKB7���L2B��.C+��0��2���b5��,h��.ۀ:#��<��0�����-��܃\r��5c�	�2�\n	�\$�\r�&����6��@��>O���#�1�)��4�\\���H�4\r�D0�O��9�`@P�Bd3����t��4\"�B�-8^�������xD��jЅ�����\$�x��|���(���X+(�\$V:�c���d3J���H�;�Vm����x�<�M�\n�&��(J2�2�7=�u��Xމ� P� �א��L7\0 �Q\"�1�W�\"�0�:����uzSW�P��Y#Ml�7ځ��u�����;-��ͦ��r�aCcP�BbC?^�Z64�>h\$2c\$�b����������\"���k,�5ڤ*�'�v��24��+�V�懲@P��F�&�0ʏbk��;`���+���	#k�9%Q���l>����x�!E;]���I�@�A4eX��p\\��#�q]#|��u�03�c/6B�<*Ǩ���ԭW\\��ݏ2�	PܐV��l�D8lB,�-L7��6���0�\n�|I/�!�Ns�͆�9�Q_�0��\n��]��2��R��-�/ʔ:#b��ɣ��bS��L�x�����CI'\n0(��T�tR�]L��:�U\0rTJ�5��j�P>���r:r6��;L�<�x.������@܁�)�Kd0đ�:��Q�����\\K�.Qj5G�(���q3��\\�U w��BV���6%��t�ѤB���+#@h�9/k��!+3'!:u�I�88�[�\"1!a͞\nV�g�ɛ4����w?D�YЃ�o{*����PS�\$�(9����a\r%���\"�\"��J���ȳ�BȖ��0g\0P	@��d�J@('@�R3E2-�1К��	*\$:����R�	�X���0�_H�U�������\"I�\"����9>J9������\r��A(UN��@w\r�1��Z���5R)���:�a�4A)� �K!(0��OSPD�5�p�DI��3ᘙ��XoI-��6�f�a�8A\$荄�^)~]	�����I�qb(\$3rI\0�ģ.�����|��s�Զ`��ɫ�����8�|+�М�zj\rk�֓��/I�2��4�X��˄�l7�̛�\"DR\\�BZ�B�N�9J�@��PD�1�2��C��IƱf%�X��T2��M�O	��*�\0�B�El��\"P�n\nP^����𠸥3}I�<&Wv\$[���Ș��3�J��l[����2�0j&�>�NՀ�����4���^P)�:d��,5}{��5l͠�W�����oN���\0���]�:&�e.c�N�P:u+EBL)�1�L�B�43�8u<YPm�D��Rfx)�(TgF��20�k\$��\r!�:����`�\\8<�*_O�l;�~�ʂ�����i�7��eZǋ�h�7����0&l���oU�	#�k5����#,�&�1J[�i2^�d3�ՙ�y}�6����G�PC&F�S�dpN%(��6g�q��Yj8\0*���\n�]�Ɂ1�p_�\r4,X�+@�A �K<�z�^p��/�C	\0��[���]LN�\0001`����VG�8G\"�-j��5w�LR�j���4������|<%���cy���D9��B^���n�ݸ��Hڢ�zoj��JQ_m��C���]�A�n��BX.� ��npɿ7_ �ɚ�sDuù'�|��2*Ů�-��6Bgf�UC	=�\$բ�CI6n������E%�8?JS��z�>A��~���ih!�ؗ�j�_�v9+!��-�q!��#a�DRpÃ^(����o��z[8��K��;���#Z�kO/o���{c���qdD(���)b�K��\n�-:I�jK���B���ؚ�ZH����}M������5��\n��I��:��./.L�'\\����m�Į���{D����G�N3�9W���,]\nGp2�3�|ɛ�|�n=��w���_��]����ٽ�Ͽ��j�b�h���.��z�-����ޯ\0-`\$�\0��&\0�\0��,���^�FJ�n���t� ��p<�/g&=p:��o�	l��f8���梹b�li\0d\n �::\n�4%�QH��>F�L4��Kfu\0���؈0p\r�8�� ��7�(�d>C=(��y�5PHE����&f���(����l[�Zo����������O�%�aŤZ�h�I�����1B��d��fֱ�q���!`���pf�q�(o�R�C	�Xl���\"�C�.�D0M1��Y�%p�P]�4Ƕ<�#�:��+���Ef2V�t���/�J��hYd�HDR(d\nwqso���/��H�\rq��� �B7�k�#�Gv^���迥�HO��ѲEј\$�nm��ڢB�k��HM� ����>B��(� ��\"�ʫm%M��)2��\"��\"8�� �KYpN^�O%����#U&\$C m2�DB\n�qB�D�%��@-zE�t�2�)���3c�\\��'��'�ƙ��J���1��M�A�PN��c�,EN)��	e�,ȦOp��0��[��p0�����q/���E`�`�@��	��	T�h�)#N�nV��(�0�Vx\n��\n@���J%�#m����)Bp.��SJ1��5+M�\"+堿�T\r��/�P��\0007��G�8���1h����2bB�/�hC���XOZ���\nlB��9��&b�h����K�&����7&������̯�()�4F�W=��>.�/�4?O�4N�\$�\$@�\$�,¯�FˮRd�e\"p�h	���F��F|�� #�@f�4������b\\\0�>úl�-0\0��Dp\"ڼL�/��&DB �=���+�@B����HŸJ�0\n�@�̤\\H���{;�\$i����@-jp��P!@�";break;case"de":$f="%���(�o1�\r�!�� ;��C	��i���9��	��M��Q4�x4�L&���:����X�g90��4��@i9�S�\nI5��eL��n4�N�A\0(`1ƃQ��p9�&� ��>9�M��(�e���)��V\n%���⡄�e6[�`���r��b��Q�fa�\$W����n9�ԇCіIg/���* )jFQ`��M9�4x��� 0�·Y]�r�g�xL�S�ڸ���@w�ŎB����x�(6�n�Bh:K�C%��-|i���z9#A:����W��7/�X�7=�p@##kx䣩��*�P��@���ȳ�L����9�Cx䩰�Rfʡ�k��1Cˆ����:��)J\0�ߨH�Љ\$��������6(��R[�74ã�!,l��	�+8�CX#��x�-.�+	ƣ�3,q��=�#(,���6�)p츰�th����@;�C�o��&\r�:�PQF�;O[ ��j�9��.^C-sH-���3 cꁴ�\$\r�B�������hx0�.\0��CD�8a�^��H\\�SK��z��	5��LcC�\$��4D�Gh��|��\r�����\"�:C�t:�p:����;����K���`%&�K(�2�*=B�?\r̘J��C�,�a:� �BV�`�r�1Los�ƃx[p\rn[C\nփG.(H҂��l�A}�H�\$�kt4�ԸΜ�:+�/n8�ⱘ:�1&�ժ�K��~,�>�76��\n2��ف#�����,/�5��N/�����3�3�N��-��&�^Y��~ô\"�4��\\�	�QS��XNϭ}\n\\�-���*T5-X\$���\n߽(��D}���:-����� V��F#k�9�ݶ���:�ȌcZ:���EԒzC�}�\\)��2�A��SJ����X��,�lb7�M���\r�'�9K��o����tzb�,(4���ުb�\$�1&0�CLb�\"4���七`g\r��؂��p-\nΝ���\\ȑ1>oὮ�Hh�?F�&�4hO�q\r������L\"~�\0��Q\n�a>��CC�\rҢR�A�@P�!���ł�Bb`n��n�\0���4W8�v%Xk���'�af�bD���|�]��ʯ�\n�X�d�u��T��KEi���Ȓ�� �B�Lke�8��>b�Hga�U b�GI�\rƵ�F(L^ѡ��Q�G�I�r�Ek�\$tn�UR�F+Ž#���c,���\$�.ZH2���b�L�[O�������F��Lt���i�H��0�J��B6���5�H��t22Č��@P�L�N�1A{�GqMI�ƃ\$s!��4���}b\\V\r�=���0��x~*���K��\r���U2:y��\$/*l@Ht�I,e����e*#�S�	��D(�F:0!��@PQI?(-9&`�\"\r�f ��v2��\r/ݠ&�+Й�@�Bb`L�;20E~S����\n�\rT�W����q���9/��O�A�c&�j�5\nke�Ѐ@�*�jPZ�k'H�@�FP7�c�`����B|�u!i�v�fP�	*6ڐPBNJI]~UD�A���K���g�����b\$p�_#\\	�k0a\\��l.�f>��,&�C�\$�tذ9h��\$4�C�\0�m��(�kB�������O!�����3�F��;'�����7�p)ܞr��)4b���M��|X�^O�P�@���al\nY�^r��`�\rJ!r��HђEX��;�w�Ff��6�x�+06,��H A\n�2�@�.k;,���Ɩ3��(x�&5<�ۂf	��r�\0�Xͱ�2a:�+��#�S1��������h�ݹ� �� w_���4����yj�L����uA�����\r%�X�0�EOθt�Q����AR� ��@u�[�!����-�ر_{r7f����B�+6z��\n�l\rw	�3\n|udL�SS�2Y'�@6*Z���h�C7�����d�ϯE�n�*#����k����;�\\��=䘝�d\r:Ӑ��h��\n��Ϳ�4�	\0P����e��ds,\r!U�&�[� �\0�!7��@T.�<���nGN�;m������*q���0�c��^��|�[�?ȫ�\r��M�8��)���1>��\r��&j\n�!�����ah�rS_R�Tе\nTX� ��t�\nyx��AyUd,E����L�5>����{O̍A5�mD1#8�����'��Uݻ�#�~��;�#\"�F�����@�d�Ѐ��OIࢬ'�m@�{P/*Pd>M�{_�C�U,=_ZG��G�Ϲ�S�������&�U�����N\"\$M˚In#�΄Hg,�OB⽀�6,�b��\$p������CD�C	��@���(l�GDD-\0�ZR�:��o��F&9�F'�p'D|�[�DMPd�:)�؝&F0r!�����D�������*��I	\"}	k����0�aM^xh\"\$�Lg\n�m�L�H9I�҈`L�r�fv)�|g��j'�z\rJ��-��1F�������,Ze��Ȃ#�z��Jm�Z\n�T(RDC\r�d�0�n0�L��\"C^�-]\nP�	��sp���|=�~���OqlsE_\nQ\n���JW�l0h*C>��`�IG]�c\nqD��EV=\0��dvVp�����t(oy^/�b�BF1�푩1��%sD��6���)��\\˂@�b%�E	��D��nn����wo���  P�BH\n&0 ZI @HH��!���H\"\$��C�4�.�\\ ��5��y�@B����(0-%��G\"��\$�e|�9\r����3!�)l��2��.^0\r~�\$��Ni�f�M���_��\0r�-��,���+�,Gr���,1�+�r���1��(�#D��&��.�-��,Î��F=�@��\nш���or��\"����1GbIq�2��+TD�4�����iM\n�\n\rg17/��4͉0\rd\r�:��6QDz\0�{��\r�\$d��&m��M�8�R��?8s�9���:S�5���8�q\$qzm�XP�<-.��73�w�G6N�{���Č�S�Bs�++\\�3�<�>��=f\n�n�-R�	@��3�A#�4r@n�@�\\�Ι6��=��sM.R� ��M4��ID%8��D�?�H\$��C���'3r���\n��EE�@d3U6�+\nb�\r��Џ�,�~ֈZ���H��/VlB�k��� ��d'�GcL%���Dle�\r�V	h3>lI\n:�Y7`Ab<��q%�\n���ZJ�y\$�?G���_\nBR��yH���O� J�v���޺��\n2A+�\$��.f�#R��=T:��EK���H	��{T�0�V��R��N@�\$��#dV]��1��!�ȫb�KJ�L��b@�:N�(�u5\nb�)�@\r��A�S	���GN!(xFР�pb!�TYcY�.=բ���\\�C\\%`ЂS\\��\"E��J��|C��=0�ن2Sn�'\r�'��D��~dH|-N�31�\rC����dvSM�5C#G��%d�ݣRZ�\"=\0����Zu�\"�R�)�EC,ue^��|ke�[nv�q���˽gH���:t4:)�@d�d#���BC`/b�";break;case"el":$f="%���)��g-�Vr���g/��x�\"�Z�А�z��g�cL�K=�[��Qe�����D���X���ŢJ�r͜��F�1�z#@����C��f+���Y.�S��D,Z�O�.DS�\nlΜ/��*���	��D�+9YX��f�a��d3\rF�q�����ck[��)>�Hj�!�uq�����*?#B�W�e<�\$��]b��^2���n����>���z<� ��T��M5'Q+�^rJ�U�)q�s+4,e�r���5���-���3J7�g?g+�1�]_C�Fx|�-U����tLꢻ)9n�?O+�����;)�����I�j����t��P#���0\nQ!�s��'�\n|W+������I�Hs��H<?5�RP�9�~�%�3���ٞG(-�4C�OT\n�p�7\r�����7�I��0���0�c(@2\r�(�K�:���9@�;�\"�P#�K[�Dr�())JN�O1~�+LR0�=�8��*��ªqt�.�:�M�c�δ�izb��m\n�������:���ĺ��Q�n�����Ir\"MUq�љĤ ��E>FH	�>�!�dh�����ӷkA�F�v%��P�Q�wK�j�O�zިOT:gE�[��4�L��]DӃh���T�Ar,�֍��	z�]�j�h�2��N)�u�w.�Jb�6�#t�5ͳ|�9γ�@0�c�9�#>g5̓4�5�H�4\r��0���=ϡ`@i@�2���D4���9�Ax^;�pÓ�2�]0�x�7�V�9�xD��l�5e#4�6̃H�7�x�6+��]���|�\"��ᇬ1A^œ��E�z/{&��D���TFͼ|�/t^�'<��	C�[�j3W�(1;�r|�PH�+�#�ݜ��(�C��2�>7��Mإ�\$����^�d�����=�b\$��}��V�v5���ʍæ)�v�6��ޥ��۔F̊\"���\$ap�\n'|h�e��]y�(�A���M�)�:�E��\"3�2vfE'/�hL�0�G�M*2.�\n��7�8�!�\\,\\��=J\$Ԓu`i�[�!°�1(fP�{�L(��\r��~K���d@�Q�uG�ϠgB�ȳ	Y��ՕX����UG��Ć�IA{��R�L#a��f5������ZH�%�҅q��(����\"Fq�Hr9#�~D�����x���� BzQ�w�W���9d�:�4���S���34��C�a.��i`��Co�4�yhe�>T����T�C�f\r��U&����M�ZUP���s8o�����b�8l�Ʉs��g:�&+\\Ϝ��ňsu�5:������6PL���%�}*ȕ8c@����)qr5*��z���Ӝїc��I]�j��OQ�1�L�.�Q	�r.��\"������� bh����ڋ�zȧ�\$u�}ƞzDE�!����VR�J�E-#b�Y��!RJtW�S�o\"��Cɂ�&�P4����r���L�Pri��q����ڀ jMQ�5����`퉲W���Kk�lF��>���7y�Yĺ!�؄�,O)�i��\"I����\0����I\"�W0�z���b���!I�jq��	I�i�E��V��Z�]k텱׆��Sl�ӂqY��\$(jQǡ���|�1Q*�=�L�����v�5E�T��=\n5?��f��ɓ��^�xν�����<a��6��5Z2bB����4&�ie�� h!�6<���q\r������s�՛�`�C`o�5��0@��T��`�1�:���a\r��g,� D�	�n�k������QR�|�*B�W������sY���=e��\0�\0(,����R��Q�M^%P�(�.-ɴ�\r̨1�k;��{IA�;���cIN�h'\0���\"YŎ5\$b �)H*]zN�޺3�Éu�&����6��o k0�њJzO�����D���cc�;����#)�4P̹�S<�0��3\nd&,�\$����\$%�km�8�.����@TI�	��vS���p,1-g���A�p��;�l�(Z��r�=Ԛ�Ҭ�B�A�p�8��<�k�S0\0�����\\��ƥ�V|))��3����z*��\"�GUC���*�sZ�\0�¦څJD��!���me!G3�xb���|�F��F�)�.d��>��!gc������V�w�Б䘨�,0R�x�DG[�=?U�0&)L�I\0F\n���#����=D'����6P�:�^{ȍ��cT�w�ߕ�{�+\0U|č���rZ9'\n�N�b���F�_��p\$}Pδ1�L�th(}<!�����\$�<o_'�r��N��2cp��/|�)ʑ�^��s�e�5-����t9}ݛ�~�Nt�+	\$)���<~�b�AXEؑ��<���>�h*�ܧ̐��ML���\$.�W��g�}�qJKE��	22B|�P8��5	�Rˎ�Cp9\"���Dn\",�\"6�OL�����bx2�u�t�Ϡ�A�z�D*����zL,q����\$�W	�N��h�~�OF�\0܇'fPh�bx�d���D���9+�0.=V�n�^ w��8`�\r��� �\r���i�@�Ƞ�m`�h�耨���Ԏ�|m�Eʎ0��Jr�n8a���Hu�;&	 �í��K��Z��ʰƋh�e���F\n\$p\\bq:�)]�P&�\\H�u���G\$�O�>�����pYbD�::ª�l:`� ��jd�MM����b8\\��iÒ�Q�5��./bp\"H���c��c�\"�*��2i�*�j��\"�\$P� π2\"6vp�[l!���w%�9�<�0@&E,_�О\$ �\n��`�\0���\r\$�ff�����FbG�OǤH�����-�0X�47g��@G��b�)!Xy��)�u\"�'�(%,Sé%�5�-�4�\nx%.���D?��)�D(�Q'�]*q�*��ۇ��?+A�+��.��&0s�,�c)'����̾��b+��3�.j�2�.FH���T�-�\0_g��3%.��.ҹ-Bq*�1*��3s\"&3,p++l��쪵\n�]E\0�H��(��-�^�pb#�>���|��-��!kr��r���Qh=~*��\"���d�8/���F\$����\$�O�C�b+�ԥo���@�Cy62\r�Y/��o\$.�X3�������X�:��@\\'o.�\0\"�Q�*�\"\"�Q�D'G���� �2RN�ZC2ɤK\0�i\r�*�B�6�l*M��\"�INW,�wd�w�2�\$S)G}/�j�cF�9,�~�v\$P\\*�uG��GĊ=*VTc�=BaH���F�x��&?�����C��A�K���b8S��#h8DH��e擇eMI��`��9�L����\n2~ϠC��K��T�~�|��-󴪔������Q��?��D�\"�`5#��*?����z�X�U@`\0 ���h@�����g6^O�R�v�@�hK/F���=T}S>#@�PWk�_B%/���H�X���܎��T��X��(�<�T՗Gh1�\$)K#G5�U!���R8C5�NR�A�H��FQ�KN5�1�(>�'<�����a+X#�(��)թ+R�,���ca�aB�a��5s25�\"u��b��b�)/�2�}�2���D&Z!_Y�YU�U-;r��gP<\"t���\\�5�\\��\$�1�h�f��.���Wi5�S�zv��2>�\$8DH,#�]J\\UQ���D�\0B�%1C�Z\",�c�Be�<�WmK������\0/,�Z�\0����d��&3�lvړ��/�i�}i�>�F�#X����F6���mI=�9S\"q,8Q������\n�FH<�@�U���L��G�k�OF�+Y5�iWh���u��[�{��M�B�אt�6��y�!\"��g�Kw�_b�wC�7Wsh�ygb�{W�{��z5�j��]�T�!��A��S25~�#�-7����Q�),&����4@����@���f�w8s�^�\$tAkv�:(V<�|�c�9!�?|��_5����Q?_�~�e`�d:�r:X7�LGZ��D��HCh���zX\0d,,��!	%��~8�F؈��|����\$#-���\$uUov��w�B�5�xvsx�J�T�.�.�Ն6�#�Y|8�z�m�xӀU`7挖��qld͏�9����W�ze-�8�r<��ьG?M��{��.�Ìt��ؕ�6������~�=�d������n�c1�\rkMLmd�QQ'��l���Q���ՙ}��o�y�ȑ�&�mV`șk]#�,}R��GI��Y��9�Y;g��DY��X���m�s�� �	z�����\"[1aX��\"W���,_��]9B^8ۛ���@�=h��wy١z��5��i�e�`i�xk!�O�r��8J���4�\n�f����CY.�Tx�9�V?\nb'^�pMdvS��S#�n5��Y\\F8��6.��N�/A��%�	\r���v',Z|��i|��Io,�:�����H)0���}e�r:�<1���`�`�\r����R��P����(�q�C�:��;s�'7kmwr�\$Td�����R\0�\n���p&�I,�V�J�UI�X�t�\$�AHÒ����B��.s/�0�Et�teÔ�u�Z]��5cާ�Q�ÒX#���}�{��� 2�m�/�[�B�㯹Ţ%\\�����O, �M;<�@�B-'z��'r���A!1t��~b�T&Nh3S\$@ϹO����*�Y �\rT�AԽCSD�N`��UX��J3Z0b�[�Y»r��2����5�����<�Z������`A%8r��K�ֱ�J�zS���)v�^�T\"=X�d����bW2*%�|~�BSOb��T��Va�.b��uxS��U��\"��#,1�R�G��8�E7#�5E5C��cKuvЍ�T��|]O�:ӂ?���3mW���S��p\"��ۏ�Ao��]%)HA�Fr\r��K�� ʁ��W��U\\Oں��ǪtK�.�z��tG6�%�]N�4\$` ";break;case"es":$f="%���(�oNb���i1���g�BM����i;���,l�a6�XkA���<M��\$N;��abS�\nFE9͎Q� �2�NgC,�@\nFC1��l7AL%�\0�/�L�S��~\n7M�:8(�r4��Fd�J��x���#&�̆�1�*rL�+Z�	�oX˕.�ifS ��{4�g����C��cp�t:�\r'��*O{0�dd}��Ɏ�E��!�(o7-[�NNn2�\\��Aj����H}�C�2��f5�Hl�\\���S�9㈧+/js1�\r�3OFF&5�����~:5L��7���Z8/Ø����3ȷ��\0���s[��� ���B'��@���+Z��,�F'e��2��P�2��k�4-�!�)�DOP��\nL�2��(�9el�*\r(j���K�����<9��x���'D,�<Q�L����nD��r0��� � �`޹\rΛz��H�@20�2\r�Tx�!\\ی#ƅ##�DN%\rD �R)��,:5�C3��:����x�a��M27G�r�3��_p�(�I�|+Si�N6\"C�x�!�F+F����8���1:L,ڲë^�H�°�L�ެ�#+�J��*s(����K�.�\$�/�PJΌCʘ�uF,�H�x�:��\\���ے�MBH�1��4��B\\P�O�\"���6����ht���3� �S)\$Γ��\r&gF�.�&���{|�1ϽG��J`&=;��-�;�����Z��gi3r� ��>�.�)�\"`ܮB��1׵�|�s�W:qW��8�x��r|���r�*SB�\$�C΂�JӬRz\n\$����<u�G.2�;�\"\$��:�������Ds�ik1�lD�T���\r�}�p�~8�i�*�I�^�}!l�����^�#>\nP�C�҅�\n�I�C1�_�.y<�l�>m��z= 0�0���a!�IF���Yj/*��F��*�dM�1���Hq#\nd)���l���R �a��b�	T\r�7���-A�)u����!���+@@��ʹWj�_���*�SA�eu��{UP��j�r�[ބP�D���HaC��\r�B�a5��W�ETg�)!B�E	��@JM�e2�4�3�񕪷�J�_,��4S��1g?3\$�b��z�8&\\^����X�� ��:�G�D�#���Jk7���@���m1���RPd�\n?�#�B�K��� 3ҡC�p`�|�ó|N n�\$�XB�}ѩ)!l��0��]&��gK���t;TȌ����0HXP	@� ��I������(P25!������A!���HHAri�-�Z��ʠ\$�=2�Ayj�;�bBQ�y����N3�!HA����H��ZF���ƹ��� ��d?MB�o\ro�!�0���nļ�Hp��Cc�FH�����\$�#p�3�LO�£0p����D�c�/&.}�W[E�si?��!s�P�adu� ҧ*J����T�z�j!�bE:|�Z+?�\"/�V�)�P	�L* e='�: ���Bj�Q��=T�I�I+!�Ş\n���*@}��H���#-�3E0��*�a���/N\0&[E&ե���0`�?&�A��V{\$F��w-��>܏?(��70�wBC\n�V����B����'� ���mF1�_�@��>(b^��Sc9ɵ\0��;�1&,Ƙ��^qp@M����%=/-&:'YYo1�Б��V��e@�r�1�&�r�Ft	̂�<���r�ln��C�K�(Ve\rݎ���r����DkS�[3R�y/	]����7il��3��� �8Pc�����(*;b\n͙�o�I�B<�u>K1A����E��cG��It�˻5�����H�F\\��Nu�u��ю�2�ѭC�7,��1��A^�\0�%����q2Rȥ��ڿ���iX�:���XC��u���Ӹ�)��(�'�9���	�;����:v��H\$���9]\r%��6F��R��6_0je��@��NJt��#�`AIK�|9	��\"c�Ca�T\n�\$Y=?�a\$>�\$�̹�vԏ\$�H΂��]�\r�`��~�gs;6����ԋ9��Dp3\\���KN�H�ftX҇y�Jw�3�&4o��z�6�S��ftT慅u�\0Aw;?/���!�	a��A������3�	Ǧ}����v��!�;�����!׾>c�X*P���>������R�6my�c蓷��Y�I���A��K{�^�_���x��@�/7.4-�p\$;�\\�bb \"��)H+w�%,~���K&{,���֋+�;�k\r_H�K7���G���?^���4�s݄�M`I����.��L�[KDMD���,��f��#\$�/�t	O��碚�����\\6\r��K�r��Z��\r��-��\r\r��,.LFm ��\$1��9��ǧ�#T����,��T1���O���ʂ(s����g	'8sO��Ͻ\n�<5��'u\nФrO�	�J%'d�n���7��&�@��h?Σ\r:�.�\r���o�5P��BH�XC\$����*jq��\0005���q\nv����j@	�c�.D���|C�>���)h/C�P�6S �&c@!�:&�h2|��C͞��(��,d18�	�c�L�|�EnG��i�\$hڣ��	r��ܾ����D���6ͬ�P��LX�1vIeȴ���k.�=��e�����n�\0�a.\"�ϸ���e��\"ـAd���ע�h�|-D��\0�#m���#&�/\$x��ʮC�P��-\"�9#1�o��20���\0���ƌ�q�_,�\$��m쬰�[�j!�<�rf:FG��'@���hF��p�(�\nei������\$O�%�2(2�)č'2�)�  �)O�,2QM��v������,M`�@�܈��Ke.2ܥP�.\"P�\"2#���&n݉C6����s\n8�����]2�%1�8�ޑ�is-0�#g<d�\n��.\nHM\nM���E/L��\nn`��b.n��R*��>13&*^P��n�<Ai�7�EL�7C:|D[ie\"��#G=P�bD瓤e��O�3\0�J��jV0��q}(\$12��k��6�\"9G�x�N?1��..\n���p\$n�\r�`��?�5Bdu�D �t�b�����R���ׇ\"/��M�\$D�9K0��Z߉Tt>���=G0���/�T?�ޯf�k^�D��m�%�Pءtg�dJ\r-\0=� m�07�!hg�g� �d���LG�<���3�D�B����,T��E��-����A��S �3�����\"D>_0�9�h/�l�I������\"m���(\ny4c���@�T �dL�6mH�@M�DTP�� 1���hSi�O�C��S�ΐ�\r���Ҳ�+F��sj\$�����	\0�@�	�t\n`�";break;case"et":$f="%���(�a4�\r\"��e9�&!��i7D|<@va�b�Q�\\\n&�Mg9�2 3B!G3���u9��2�	��ap�I��d��C��f4����(�a��L�A�0d2�ࣤ4�i�F�<b&l&+\r\n�BQ(ԉD��a�'8���9�\rfu��p�N�I9d�u'hѸ����&S<@@tϝN�h�g��P�9NI�9�;|)�@j��jC�,@m��\"��ٳq���|�����F�=ZqF�̶�`�*��y㹸@e9�Rr!�eX�\r�l���#���8+��/��H:��Zh�,��\$4��k�§C�|�7����[־Hē�è�1-i���5N�;:*�-\"��#H�Kp�9B�B9\ra\0P���<��B8�7��走\n�0�)x��Q� ���>�\"�x��H����H���.1���>H��2��:\n&\r�j���P��¹*�+�2;�@�?�[�8@/��1�h�X�\r�X��\0�4���p��|4C(��C@�:�t�㽄\"���-C8_\n��#W�v\r�R4��P��\r#x��|��ț��R�'8j+|ܦ�Z��-j��2h�����\"��죷͒��䚭`P������5�P�!���΂���>��8�A���@��ˊ��\n��*��4�1����\r��h�B��\"V�뜣�^*%�L\0�^IdՌ��z�H�Bx�L��}�j��D�k�#,�r\nH�90�y��cH�5��J;n�X�64�<9�lc(��h���@P�v�f��-h(��7-�b�\r���3��z��\$��^xm\0��8Zm=�<�5�cha��bq�#l��B*Wݭ8@��+��\"LG�H��&'n;�X�6�j�OsP�#�p\\I=ei�v���V�\0}��2�b\r�5�O3�}���2�\rh�ӟ�'a�����e��C#A�3bF`�!d�RÀ\\SQ�1������fhe�	?�`���a� �>�Dv8e��C��\$R\$0Z��2nI�'\n�����N� *@�`��,,���j��ʻW��`�5�V:�Ya���2�V��љn��mT��[��9��΃\n:�@��BB�i^u0�!BRNJMʒY���Y[�UZ+ep���X;�H�Fc	֌k-��X\0�V��=�G����\r�p�A�`�P�[de�����l�GIXt���(�	���r�ol���C�U+��3بM!��M�6BUL�\r<�riT5jX�i\$�iޔ2�^��B���މI�#�D��P��Q\\\n (O�(��I�ID�����,ω2�8FiL{`'&�B��xw�N���ԭZi[s���D3����@�u���^��q�@j�F�r��A�-��jN�4�]��\r�m�`@R����8�L4��j@�9J�b�%�j\nC����\r!���4s;V�6?9�Hy2�MRU,al養�8�*\$��m�R}IS���)��T��p�T��X���S#�\n�M�Wj�G�[���k`H��<�u�����L\"��V���j�,�7Ʉ3�\0��	��#��`�CWC�wM�\\\"A'��H��#�jr��(�3���R�e�m�\0��\0U\n �@��o�D�0\"����\"��!���^\nN�ɺU�IJ;b��x����!�@�5��;{8����ʶ�a.(1HL�f����L���X�V�Q\$?�T�P��I]�O�:�Ln�q�h>M^8���[[�<���#�̊3')��-�t�U�Ns��ի,�g'fB��Q�\n�\n�2��B�p.Z1 ��_+��3����^�\"�P�������S�V��T�F�U1�sv�0�y�j�N�+��2�t���k�.\$75�����TZа\"\$~���_G�� ���V3����辰L4����\$,��5��J貵>�?k��p�=n�pa\0�iC�P�f�8nI��PT\nA\$#�p���xd�^`&'/	d��\n��hA����I��O�闈jev��\"�`���SJ�md�RN\n��0�^��@��@ ����@�ΐ`�nR����M�e��2 ^�\\-x˚sk�Hh�@j�6�\r](H �a�9���RI�(�x��-��bN@1m5��E]&[!1�#���Ő��f]�ԫw-\$���������ȉ\"�S���5\\��8�q6:^�Ñ��rN��!�!���4�w,L�D�/k�a��?���iM��S9���b'KV�Lӕٮs��\"�w���\"�O����%�����أ�=ݽ�>���=���3���Yq�Y%>��;��(���������MS��:J��VJǹ�6j��N�X�H:��E��>@�C\"��B�̦2���������mv1�x(�4����o�h�j�.�א64�V�Zؠ�-EPvGʏ���	 nf�	���*�X���O��ς�8�~����VRL�����BBO��0�ǧD^'J!pF��v���6��t���0�Ȯ���a��	)���\rGI\r���\"������\0\n��ؾOn�鎜��GΨ'B�H�j�K�!p�쏿	�m�j�M���=\r���n��-q8�P��Kb5�ZF�XWC8>��I�.�D�\$J[djf�l�c|���e��VV�Z:��o��.i�ԃ���؟\r���2TDGΣq�2qd%�h-e��ڃW@Z��v0\r�#�P;��_D�_�\01F?��,>�B4_��`1�+�&�֭����\r��.>�q���J\0��% �#�6�95r\"���\r2+\"A�I�� �;\"��LG����\$���.\n�6��t	�B��t	(Va�j���#�8��%�H!���ml�\"nʎR1#�p���)�#2�-�&�߆��G8���)�ɮ@�C�,����2�)�ąn��TP�(7�3)q)/9+P�/��/1�*��+���31&TK�U)Q���S3\$R�.�!-�0ڪ2I/r��*Rp���m�30~.�B�Jo4�O3�T���5��g%\$�:����JI2�2/���7�����X�,��-��+ �F��nS�]2Q-�7m�\r�ލ���GR�\$ ���r�*N�/�!<����>�rA0��=Á f �\"Ο\0P	�k`��2�a��s,\\��*�q�	�'@`\\,.��A��B1�#4=��\r�]Ϊ�#�sQB\$b�|�m7dv�<�z���J��`�\$�F��'˥\"��.�z� ��Z�*;�N�D(�dN�ԯ�І�!Hv���\"P�`������c�k\0�b9OR���Q#�9n\r(\"���V�'D��\"�	��kn�!ûivb��]��cNhl_*���Г�0P��b�6�4*��������� ��=>P��ɬD��!U8�u'\nq�o�o�L3C94�\r��d�.�H�U�j_3hj��+�:�}M<�IXB���z_i���Dn0l��H�Bj�`�\r^u�j�v\"�P-\0�[Į#�ObI&�O�m��Sd���4�\$�xMATF]U&\r���nb�/��0�V\r�:���8y�ȟ辇`.\0�	\0t	��@�\n`";break;case"fa":$f="%���)��l)�\n���@�T6P��D&چ,\"��0@�@�c��\$}\rl,�\n�B�\\\n	Nd(z�	m*[\n�l=N�CM�K(�~B���%�	2ID6����MB����\0Sm`ێ,�k6�Ѷ�m��kv�ᶹ�![v��M@���2�ka>\nl+�2H���#0\n�]SP�U!uxd)cZ�\"%zB1���C2���o\r��*u\\�o1���g��{-P��s���W㤵�>�--��#J��K����<�֋T��s��F��T����/\nS0��&�>l��`Q\r{US!\\8(�7\rcp�;��\0�9Cx䗈��0�C�2� �2�a: ���8AP��	c�2)d\"���rԢŒ>_%,r��6N\"|�%m�T\$͊S%��楨�J>B�M[&�%ES��<���H�PW;��'ﲲZ%n��S�,����+>�'.r%!�����R�@��ȩbҥ��ҡ���'�,��2Ϣ8�N\$#������F��0�Ғ���Ъ�@X�O,���P�2\r�\\\n���7��@0�c09�c=o\n�Є%\n�H�4\r�80����`@Y�@�2���D4���9�Ax^;܁p�VU�\\3��(��ր�2�d\r�T(���P�\r#x��})ǒ�����CHIAh��HS,��s��H3\$̻8�~Ƒ	#\0Q%��<��^\n��7W�(J2<n�T���SB?9+�2K�ʨ�L�Z�)�����3T����D��%�D�2嶘��H�Q,O/��,�k���J,��/E���M\r�/,��.��j\n����+b�MyjV�.��2�E˭���<�8�ڟ��y2oA*(p�(��*��Ll��3�#��u-�'����N���X�dK�-�-��'⭦0�Н߇�S1s��a���%���������3���w�Y̐�P�!x�7�ǸZ &A\0�:�p�{�����.d�y`���p����3���\0��F�# ��ЀlB�� `�`����2��軕�H���\$B@Pr���D�C� \$�4�T`����0q&�4���WQ&8@�r(�J5&�y���H�Ee�l�&TTB�{cɵ����:g5* �2X� �y�jDl8A��V�hW��{��ab1�׺4�;)!�ѐ��c(\n\n��0�2�C� ~��*�Z�:�p�4�E^��[in-���� w\\ˢP.��p/B�|:0����`�����37I��b�~K��eУ�%Q�Q��&�^��2\"�!�3�Vp�|Z!ID�HTX��GR�U-���V��\\k�s���Z�]���S/׻Y%5�#;�{�Lb�tVB0x%�H���O�aFEL�Vό�Q�d���K	�.�A�\n+�z���\r��\$(<�\r����	��s��]�`�O`o�Qb�p@�Ф�`�1�yL��a\r���'f�d�cjG���\"�*N��+�������t�Q\n (L�>J@F����d\nd9QI�Y�X S�/�!�P9z{*�oY��4��4�\"�D(f��޲����MJ��6�଍eD��K�_hef4F����8,���2�!�4�0���bܧ�R�0��-�\naH#Y�ֻ�Q�<��.βW;Y%!P�P��R�\"u(I�EԲ�]�F)&6���8��28��U5\r��3��!�I a�d�YKi��\r��c�U�C�C����;-}X@����:�s�#�\$�6�\r��b�=G%�0l�dR��`�=wfn��E:t.C�k_��ɢFh��r\"��M��&H���уA>�)\$��J��fB\$l��i�|N�R�ަ�C��K��wѥBO^�h�E6!)[��*I�,�qQ\0PO	��*�\0�B�E�:L\"P�t���ֆ����|�Q��,��V���g�WL��UMɅ2��\\E\"Ձ����➥��Ɍ����������d�R�S�L�7iţ��{|5���`���DN�i�����뫅�%�\r�PS��qG����\$-�#?G��WW���G/n;d�1�o�TT ���l�㘁QL< �:*�ty�G�;H>3��i�D�������f���=��:�:��]��dG���~ռv�QH3��oM�go�k\0�����_���B��vL�ִ�y��a�X��R���v�q��:��y�I�*���Mk �\rk��)s�/�K�FE�Qݒ�x!��?j�*`�&We�=F��-񺨈y�����`'y�R]�P�כ7W/|婕�٦�Aa bP·Z�aZ\"ej��8�܇'�)�c�g\0��ESLCY�y����\r������Ͳ>v�b����u4Dק^����(�&�T�k��=��~�����o����p�ԑB���6#C��L�sP#\$�#���M\0��T��>��%ORO��?D������M�L�l�J�!<h�ϰ(0O� ��.f:�phS�`x��N'/�{.����I�����em���90�eP`2I��L���~2��Rԏ�<P�1fH���c�8�7�w0�ꭎ݋�*�s�.#\$�EI�|pǐkbBk��A �H�~��0Ṟ��4�PQ#���i x�xF��L��w��k\"颢�q*�teT\r��AE�\r\0�H����^d������Ѐ���v��cp�0���ty�p�c7m��%8�.�e���r��Sî���p�wG�6�k�^x.����x���p���!��{,����b��P�2o��xk��\"�f��Q��bb�O�k�\"��-e�5���M��r\$�q���.�|N��og����.B*2��j����s��G'FP#j��BLм�lF�_\"�A#.E\r�����lo�LԤl�P�#p�3�p�M#��I��++*��L�\"��\r��S�3�,�o,�}1�*�,�j�ќI��?fO�c#�n&K���&��p�☥��?Q��*�� �K�9203-�I*R������L���lP�G	�ݱ�3�0I�D��Hy��O�`:�n��2<�\0001�2_7Q�5�c�)**e8q�7SO3�h�?,Q�8�o��7s�7W+���\0\riRBK��\0�J�E��3���2����J���=�=n��o\n��� ة\n�;�Q�9ѠG�\0�S�j�򑤏�S6j����\"4C�HM�.���\\��x�T8Q����fХ4k�\$r���p̈́�L���'�ل����EAt:gJ{&zޭ�N��1�]@aT��6&,��zR2+��(³G�򊰢ԃc�������QT�!����5Dr8O��u��+���\r�Vŋ�;�ࣰ�J��3��&r \n���Z	�,�#1���P���G�:�\$��\\Gf��\$�\r�&\$�R6��@�PlDV�\r�A�8��{TSA�·��MP4?\"���LC,Sl�����*!AT�\$�գB��YO\"7V�'7\"���ChQ��	�c�Gȉ`��(�2yZNO�׳/\$�9[5)Z��kQ��Je\\u�C�;]Rd\"Cz�U�5�\$��:r�O<MXm�VF��������\r/c`�.�u~��,�G#Y��m�S0�J8tU����d��,tш�1'4��|u ��0(�wF� �/Q����b<*ؖd��W#��mN\r��@���@�X�^��[�4�.LT�-��c6";break;case"fi":$f="%���(�i2�\r�3��� 2�Dcy��6b�Hy��l;M��l��e�gS���n�G�gC��@t�B���\\�� 7��2�	��a��R,#!��j6� �|��=��NF��t<�\rL5 *>k:��+d��nbQé��j0�I�Y��a\r';e���HmjIIN_}��\"F�=\0�k2�f�۩��4Ʃ&�å�na��p0i��݈*mM�qza��͸C^�m��6��>�����㞄�;n7F�,p�x(Ea��\\\"F\n%�:�iP�n:l�ن��h�A��7���*b��n���%#��\rCz8��\nZ��#Sl:�c��٨���&��0�p*R'�(�B�J�m�@0��@����L7E�^ԥ���+G	�#��zJ:%�#����`�#�N	K`�!���\n�B��K��JI ҕ#�\$�;���<��`2�P���I��<�c�\\5�3�D���� ��C�93I�\rM�'���&Hز&,	!`@���~�M\0�G�4C(��CBh8a�^��\\�Q˘\\7�C8^����J;� ^(a�ض\r�`x�!�R+#�;�#l@�'�λ@݌�S�!�r�5�2������^ر��\r&��\\[O:����x�:�8f�M�U�*2���II+�+�-�æ��`��\n��H�	p�7h���i�X ��=j3�LY=ݬ3?B#�P�\n��N�9�+��Mb�*���q?`����Ұ�v�i���d�d�5�X�T(��j{�!�s��#�cm%��2�Nl=ݼ��6�İ�;��?s���1{>���Sܠ�\"�	�*�� �[�ÁN�f��q���V#\r�Z���`��c��<�v�SYZ��3\r#:Z2���#�\nR��u=�[!�r�׳w��5��[d�<,�����<˻�E���;�\0�3L�(Z�@�3�B���/�[4�=���\nZ��7��h��:E�7(EMNB�%š�ELOM�@D���7`ĔsyB��Cd�I������!\0�\$\r� ���S_���,<�5\0{ �<\"&vX<P�l!4P���cfCa����\$AH`u\r(!����{�z��(ŊK�b�\"��Ԃh��º��_,���rX�%e��^B��6���kP�\rq-DT����j�\$x\$�\$œ�O��n?��H/_�6��ػ�\$H|C�-TI���DD��\"mq\"h�պ�Wj�_���ly�k)fP�|Cr(+Mj�DhH��x`�%���D��Sj��ŵV\0��v^hjJIb#L�![!��CRsaFk���3	��T2<Ɇ�@]�!�Q`��eO( ��&/�O����a�&�q��b9)/@�\n=�fx�q���H�ţ��H\nM�!z+I�AC*FW���\r2%� (,���\\�&�T�'��B ��L���Ц�%DLɩ�[��i�U\"�:E'\$���*�e��3g2�!mM��@r�Z��E;j�#\r���ճ�Nc&)� �ZyEH�\0�[�죌��?��I�HnAݒ����I�w\$��ůd�k��3|a�Ƅ�HvW�-!ρ,½G,�ぇ�H/e)Z\rh���G��M=�b��P4������%�H(�j��JP�ͱ�\\�=�`�l}�!�<���x�3S(x�� �#(�8Ԗ+R`�cﬤ�`��00��T2.A,�I��x�\"HH��[.l���.�l8���@B�D!P\"�P@(L�����fA9��s��q�jE�d������f���@e�-���\\��rm �\"�v��a�\r�y8�� Q�<Tܚ��`��ۊh�k37�Z�Ϊ%S�m����p�t�L�̠t��M+�����ǆ�+����%[49Crʴ��È�����q#4p�hy34H�5���C��\r�3��\n��.��4\"�];��\$Y�SJ��tdf��+�{\0��)6a�7&��4\\� Ȭ6�P���\n_\$<���d�M�k�rC��ǒ�I!]�^��hg|+S����\ro�4������\$|!���S\n\n\n\0<�*8K��\$������K%�\\ܑ�t�t\0D�n��d�c�XT!\$6�m���Šɪu\0H��=)��|���ϴmq1�H��L�ib=B憝=���W��� �~��z��%�%���֢�\\T`v��:�c1����}=�A�|{\0ے�\$�:Oh&�o��k��i2��Ә���|op�n��,}/�|F8Q1�v�/���&b��Ņ�+v�16Z��C�����h�ێ��D�ؓ���Rx�DU���&O~N�y+�-�l�&t�?g>�t�}��\rV>�qD���r{ɸ-4x�qӊa�3C�âf�������Nu\\��J3�=�U2p�M�/�ҩoބ6���Xo*�\0�b�\"�A�����,v�!�\\�XB(�L֟#�,�,� g�\$�J�+��&tM`��X����z( @8j�\0ͼ��Nc �c`�\r���`�ۧt/�ڙ J�jk@��Gt��Ng�����O�K�y7Lt�k,k�H�P�o� 0�����Pt͐&s�o��M~��\"�����\r���D���H\nT��κ���bN�@�0�\"B�U1�n��n��4ތ:F��r�6����q�x\n��D�:Bq0��HݠZFBzݤ\n]H2k�/�)�2@�ȼ�J����-�:Ǭn�� &�N@Nr\rʛ�\$7��T�ׯ��8T��=f3gQG���#����bbbϮ���1O�x���5Pq\0��\rq���d��'\n�r6�L�00�2��������\r0\$0G\0005�#nY#�.� m� �^.Bj ��NBT.���>�>�.A��y����'�G#P��m�f�l9R��!+��g2'��)I*%))��lx#%!��c`�j�B�&�\rr�\rr��R�2�-d4�r�#��-Mw.\"�*��.�c4\"Q���+�%/�Ϧ�0�*ьcm�����XLp�W\"%3#2`�2�ph��3m��S(F3,��r���SiP2N�N��\0��6���'.�b�o�	#s#�7��\$.8b�\$k!RF��I�^5S��:�\"�2�1\$�J{1�Omx!2o%ܯ�b~bL�me)�؊2U�)���4#b;�A�(&���hG)�13�N����\$od��2�fA����d�\r�V6�x�K�C�o#������Jd�q�\n����p��'G���RD�\n�%1\rS\0#dR(�&��&f�^T�|�#�0��<#]I��\$&�	J4H0�L/cX�4D|+�9�c�E8%K�O.�\$�LԅV�mD/�D��H['��\"�-Cl�p(4L�CL�O��O�p��Q\"��7��7P�H\n�b'\nQ�FR^ϼ\$�fƤҔ\r�2� �B8k� �i�L%�\n\\�`-\nN�1̠\"�\$\"�hӊ@#n�eTMf�N��OCwV���T!������M���c\0�i#�&��-��djsd���Э4\nM�\"";break;case"fr":$f="%���(�m8�g3I��e�A��t2�����c4c\"�Q0� :M&���x�c�C)�;��f�S�F %9���ȄzA\"�O�q��o:��0�,�X\nFC1��l7AL4T`�-;T&�8̦�(2�D�Q��4E�&zd�A:�Φ脦�\$&�̆��fn9��',vn�G3��Rt��Bp��v2���62S�'I�\$�6�N��\r@ 5T#V����M�K��xrr�B��@c7�i�Xȃ%�:{=_S�L����\n|�Tn�s\r<���3�6΄��3��P�����\"�L�n�����7;�N15��h��#s\$����88!(�V֣p��7���F���P�2��Z��\$�\r�;C�(��2 (\n��)�`�E�p�6�L�\n\"(ê���(c@�a��\"\n!/�L�\nL��0��P��I쒜�B��8C��V�ʲ�)�.q�T73�2�6�l9ϴK���dXP�T2C0�\n��˴�J����\r@�-Z2�0�hʿ��j� �\"ҵ\$����A��`�B��9�}4�2OH\"���N42�0z\r\r��9�Ax^;܁p�X�n�,3��(��C�,2��`��\"cp̋%�@��|�/�p��ŔT����a�;�����^ılj5���1�Hؓ��x'*#(��#c\$���P��v6h��� @7�h������ ��6C5|�<K�~h�KbL�9�A6�}B8�\"�e-Dh���?Q���!���:3��;4�Ϭ��)���M*)��y�\\Σ��l�H��!vnj&\"��^&;0�2�D|�/���)�vlU�ƨ�N�8�~��eT�)�\"b��N���>�vI�#p�-dS8�����A��2��h'���� ��E]]�a�׌\nR�>\"��8�����ֹM^!����V6ۚ�\0ھ���^�Q��#0�\n	!�0bI\0��>iK�����!6)�d�C6~�7�,���\0����n}w��PϙfFx�%�w��\rX��	L�0���B�TBG��DvT��&�0<���o�qP5	����l�U�#\0��`��J��'�u\\�U5F��E���C\$^H��0�����-)�ꗃpk&������\n�nQ�hF�� [�m-ż���I5ֻWz�oK��TxO�\$�N)�\$�2Z�!Eb�\r��d�v:E�Z�3�E�iN���X:�fM�պ��\\k�s�L�b�]���%��C2k+���.�_�r�h]��<f�2��حV�ga�F��BhD�V1���!���	�J�S<<Dj����X�xu�kA2Ml�4JM�k�7&��r!�ɜ�T��j�2���8\\�H\n\n�\\u�\n\nr4�(Ň2�i�\$���*��j�ɵ|D���6i9JWmp��Z�&��Ѷ(1HYxyk`��SX[\"�C%�-H�ՌuJkX\r�4ՃoD͝��}պU��B�o\rk�0��2*H�D^�IdV�e�*�����TE�:�(��y��\$��N�q2KH�Y�hh(u���T�ae�64��++��i)�J�Q�C�|�6�3x9-Be꫊�Ih��ii6\n<)�BQ�wY��?��*\\�5N��Z}Kz*\rn�\\K�I�ۛ'��=XӲG�`H���Bhͱ�F��7�w�f�\n&��@��A\0F\n��B�b��˃W't�]��H\"�KT2uD�RS�hgPi������c4A<'\0� A\n�%�ЈB`E�l�'�����n\\��q��R*\r�%s'qD�������u6�՞ԼS\0T+����nk��^mY�>�BN���?��)G���M�&E�աǶl4�&�d��*F��aSRͶ7��'��R���!��D5S��D�����\"��E�\$4��\n��jE�ʟ����v\$��SC1�`ʣS����;(JJm�;��d�=��`(�A������N��u�ԸL�lml�S6�6\n�)O��P����I�>_7�?�al;f�Y��7�\r�`&I�i:̋�T�-Y,��R�xm1��<\0����L���ĹTXي�g@ �-�]�G�iʉ������}�O95�f(�^y�\$=��o�J�7z.7#��(�B�	<9�ZYD��f�\nj�:7.��SGQVda����#;�:��j�q]Z�:�(C���Aa!�M8��#��gE��I�}t\r�\0�P(g0��y�Ě-�J���J1s)1�W�jy�|D;\r(n2w�<D=#���B�7�m��@s��w�ҎdG�Y�d`6��/=ɂ�đ��n��/����_���}�G�W�zg��}I������O�c�����7�>r*E��#''��s>��.(��� ������� ���\0� �Q�I�6:�P \0�����J��q`�A/n)#0t��#\$:�#�X�:��a�PKB\n	b/F�U��?,�:\"F���Oࣦbfiخm</qJR\"���kBO	0�ڰ�\$����`��=)��gX*������\"Mb9\np�	Oc\n�Ve[��q�\$������U�O��!��m.ߐ�b��&p��ց0��\"N5�TQ�FGЪ�R���B���`�\r��/E:�F�_@�2f�d�I�P;#�TP��-2{�9\rм��Qj��Yqt�i�jQ|xJ��QpX0��&���p�p��*zG�z��	Qx�P����~�Op�R��JyQ�%ѻog\n��D\\� �Ekϰ��t�b6�����\rb�OQ����/v���4DϏ\"jBC��P�笄_I8ё��P�猂����%\"�A\"�G#I�!���C��i���6��:Ő'���e0�����^̊RCr%�!��e�~'��4�ސ���Q43�L-l�&�0��`�d������(�ŗ'�P�(�I��K�-\$N}%������N�l��_+#	FE%��\$ѡ/��#��0m�Q�N�b\r^d\$	����P�0�Q�	��2S)2ͳS3&�a2�]1p�.��3�H�S�3Y2�J>��%��V]\$�K�rj# �B4l��O�R\n�\r��31�9p�43�9%g�PE�Tue�A���\"b�o\r'8Ks_1�tM[1�pZ#�;�4N��EH8P�=0rA����9�)?�?S�&�@�?p�\"0�;f,2S����=�	A���X��3�3Q�)�@p�53�Δ0j\"z4J���	4D���	�����E`�E�mE�(&M��i7n�G�F^�|a<;���+Xꎘ��5CDA��BΖ�ΝJ2]4)�I԰l�&Dn�KΚO�j�/�LԠN�`[����Z�S\$OD\nQ�0Ar9\r�N��O4�044T�O�D�\n��?q��2U���jo�Ҳo.�C��1�\n�3Gd��9<u4g��S�ES�:ǃ�1Ɗ���%-�5<��.f�4��U@h��DR��s\n��b�\r�V���#U*�\$�\$6�p\$�L\$q֑p\$؄1(JvK^����(\n���Z����d���T/��uK9����& �*�P�B��f�<G�<dt��o�N땦:Oe��gT\$C0��7ȼ�BlcoF�|�4�r�e57v76fj�'�q�2�~M63�>���8~U�ӳ����v�H�mf�Ifмq�\n�b�g�}g�N��\$����k%�\r\r5�i�|���a�\\���VJ�֎:�� ��o���-h¨x�PO�0?��lŎՖ�sD�1BGâ���A�\n=-i!�\n\n�(�l�r�\$E�(�b�\r�dP#��(1��g#�:\rd���\$k�_��b7/����*'p�B��,�B��D洣G>g; ";break;case"gl":$f="%���(�o7j���s4���Q��9'!�@f4��SI��.��i����Xj�Z<d�H\$RI44�r6�N��\$z ��2�U:��c��@��59���\0(`1ƃQ��p9k38!��u��F#N�\n7��3Su�e7[�ƃ�fb7�eS%\n6\n\$��s�-��]BNFS����� ���z;bsX|67�0�·[����Vp�L>&PG��1��\n9����llh�E��]�PӒ�q��^�k��0�����&u��QT�*��uC�&&9J��Ӑ����: ����@���9�c��2%��#�&:��¸M2��2CI�Y�JP�#�\n���*�4�*��\r��?hҬ\r��!�)��!:����C*p(�����V���҇4��@7(�j6#�ç#�B�`�%�*~Ԩ��������J0\\�6<�Z(��C�o9��+dǊ	�[@�i�@1�@�#\"�@��M��:�64L���0�Ƞ�G��8�A�s��\n43c0z\r��8a�^��] �i�\\���{\0�Ul�JX|6�.��3/)j���x�%�ʉ�c��ү�n ڏz8�J#�d�=�h�ƧM�R�W��\r�B�=�<,�\"q��?B�7.0((J2�8�+���T�6�j�J�v='����#7�O�\rU'�j\nˬ&�)(�G<w�s!x�\r\\�\$#;63�1��lz��qjR�zp9�.~R2�Bd����b��x������D�N����\\�8\"y���`lNOC�☢&U\"�7j��\r7�8!OY�u ��\$܎#��4�l۪9��صt�o-R���n(5\rT_�(�6ǈ����#.޽� ��u/c'���b�\r��	YZL�f9!/\rB9<�ͻo���P	���a�L��*[�T���	먒)��~\\>�\"DO���Xg�q�n�F(jҐ��0�h�4�p鈃Q4�u��ғQ{JVQ��nE\n�0)�)6f�HD��	>�@����A��`�\$z��M I\"\r�`�S'Q#z!\$-�vHa��[q*\"�C����@��d���W*�^�����:�d,���)}[q���S�%	\0002/(��KlH\r���d*���JC��7�dQS�/��ӝû��U��0:��b��\n�WJ�_,��#Y���-�����o�~>R:�Z~m�-t(�S>(\r����i�;tD��1B5�n b5F9���H�	�\\��S��)3fSF�P0�b�qג�a���μ�U�l�j���8ap�6?��\n�xD��4a��O�e`��\r���\0PR�I�`E!�^DH�{!\n ��VG���\"a�%�7ԸoS�x7�t��ɀ\\��QdĜJ�/��@��\"�FN�v&a�.���Oα���)D��赃��U�5��Њ�`i�劑@�6�D���5�0�F}(P��B(n�B�=����H#ӈ�'I�o�M#ipM	��j���P�l�BDrC!b8YcDˆFj�	�7D��L�zإ�W�%Y���|H�u�̾�q`B�O\naQ���\"��q�k�y\$��nGŔ����DZ8f��v�q)�/F�_P\nBM}�(�BJ�<#�&9k�i	-%�z��P�(��v�e�Z�G��rM��=�@�_����7�x>��y���(ɽ@)i�� �0�BL	!h �*,�p \n�@\"�p�A%A'� ��q>)�&\\_��<�o�Y��<�_A\0P#d�(f���uIa<8]��^Z��;G*�����z.�{���^�E��LǹC����<�:�f�,uə&;\n��*Xb��jy\rɹT���й�@#s�j�M)\r�y����X�jQ����\$L�9�<�(T�@�qI��D��zH�[����\$�c6��pX��=��|%��\r�`7a���(T�\$��1���*nhJ+�֑SsjH4��Y�����:<G<�MKK��+?ט��6�	�?�H���2��)`���9䅎��\0G�S�l��HTVN��������r�������2F�Yw��E��֎(�M�g�e�8��QM�(����z��Za��ͮ��eu\0����)���tr��V*N��@��B@ t��\0����#4ܴ���abٞ#@)��@�X�n�P�l>��v\"]����aVk��~��(Pt����h<\$�-P�!?���\r:��%�_@|y%k���A�<�z{��I��m\n�4UFz��KO~��;��&Ae�������F����%J�9�S*g�?Fr����SpF��I�`G)�bD����2v]���!-T9���i�h��vb\n:#/L��c�M�1�8�L��⨈�n\\ih�P�h�9xa(*%\"�\$�#d��,�Rp��`�^�\"\$0>�B7�I�7g�4FPr�\0`�Z��M�rL\r��\$���͂� ��\$��D���ZЊ\\�0bo���%� ��3�~�'�\"�Z�#SɬJ��i��������c� ��\r���F���\\9�����\0�0�X��I\"�F�OM�\rw�b�ѧ��[\ru���#8��}�(3��e���!�L���M�<�0N-�����n�5OΏ1JZ�T�/	ʤ��0\r�2\"�/�9�<�т�l�Y.JB���q�i�\r�@dO(�����vk�J��!,�G�3��%p�V	�\$�9d4!AZ�H@���\"Gk\0�\0@V��\r�w&{*��c�\r)�dpR�q�*��\r��wZ��ȥ��u��#C�#�.3r8��_M�P�B����72\\��1��&r`���&pV7��������@����\"<Q�.o�pP���=�\$�04�Ъ��N�M*�a&�I*R���'-z� 	���:7�,R��k8i�.N�r��I,�Ptg�,3��2m��HY�����&��0�=-#Ru2'��0�\$�RA�!��>��\0p�3�d�<P@�G�(��F����!!Y5���F.���V�p��Fe�|+Sk*�'nA*'��T���Ҳ��bM�C9�R<�:g6���SQ<�;��d�>d�/U:�~er�=ΦH�%��>�	\$`���n�ҨMĒB�(cR���>\r�6'�4.�@�Z�b�A�2c��1�4�d�#D��R�C0\$�+N��+�wD��d�\r�Vj�j\$C6���go>ICLP�bz�J�CpQ��m�\n�@��ZG��\"���/]I�(\"�(Ap`!BK\n@\"��ڇ���fpSJ���6#� �teD޺ʘ�+l)4t�.by�),��\"�o �G��{\r�O�:�KxH�\0C>&����)fa��'���o)!����P�4�0�@�DACS��S͑#��R�;Lt�% �(b��UG,�U��Sw\$B\njmqKiV̽�\r̢O��̠m��En�Bn��ޣ��O��\$���ʕ`6�xobL.��)'[��bM�&\$�^�ʐ�N��]�~d�Bj����l��3Jw\n��9�\n#��!����B�\r�";break;case"he":$f="%���)��k���ƺA��A��v�U��k�b*�m������(�]'���mu]2וC!ɘ�2\n�A�B)̅�E\"ш�6\\׎%b1I|�:\n���h5\r��;�*���bJ���u<UBk��0i�]?�F'1eTk�&�����G���~_��&�0�E�A�d��4�U��¤��M�B�����i~��ŕ�\"U �hn2\\+]����[��v�G�b�ҥE������(��ŷMƳq��nNG#y�\\\n\"N���e\r�S���t�N/���c��2<��\$\rC��6�\"��iJ\$�\"�k��'�*V��*Z��9гw3�r�k�(�@��s��5K��%��L�-LR�k��{0ͬ�<Z�\$��\$�3iH�/�4v�-ry���0b>�%�zZ�HiR[��!��1������S3i|ľ�# �4�����������\0�1�o��<���=�s�;�#��7����?���\0yK���3��:����x�W���<<As�3��(��4��2�z\r�+�<�(��\r#x��}�z6�\"���ݡ�RT�#�Ap�+��\$��4ɲ����#J��9\r�B\n��r�!MrO!��B�&�hBH���J�9f��9/��s4(�%z������	|dk��w!��S�#��\$�)�,\$ˋ5�E\n�H�0�P�,ȢZL]�JJ�d�lN�]�6ͧ7R�,H��(��L��7�������mJ{�\"#��\rs�[c7�8�R!�\$�2K�f����\"�z���^�2_8q9C�jI���[t\r�I�@6����O�u�:��{�C�hZO?@9���3\r#?H2���2O��\"\r#��6>�����������<��gp+,�����:\r��k��\$�f������#�ۿ��T��飏,�|*\"�9Z8�\$e:Q���%�(�d\"��'.	�	��0hBp!���\$4��Ȋ	GI\$��d���ra��d���Tj�S��V�UxwV*��`��/>O\$:,�v��!,F0N��X���%F\$�2�M�����3�@P��Z3m����N��SʁQ*EL�R�U���C̭�ʻy�D7=8~��i1)���7rDI�}\$ԉ3�rXMKkk���c��Q�:d)�.VlG�Q%���@�|=Y��H����d� �W�a�F0�0f��6���T��\nH�<)^������Lqv��Tk�3`E��|���(��A=2%��`�ryp�7(����r\r!�4�@�,��>���-)���@�����̛_��\$����<x�9�R����Wxx&%\nUL �� h\r!�49�j��A�!�0��ʁ_�(@�8�����_�N���,t�\$�E�4��C�N8 �x f�Z4�8� ���2(�@��t�L�qbAT��7z�b��-N��='�nIy\"�h���N�L�C\\�%ҎI�am-	?\\��\$\n<)�J�D��f12\"����`�|DJ����f�i2`���38d\"}	\"�a��8:���\$�8KHCnoq|����%�t�9�5H���fHQ�!M�J3��9�5�ce����I+6	P�7�T�Z0����NB&��3N ���jHRa�����1#�Br!o)��۲A]˛xL\"�240D�Q!7�U�Ԕ��m35n�\"`���Q�J�rX�A3����|g���2}QỀd��3��nf�꛳~Ғ��_�,CE���̆�	��\rv�fO]�d�(�\\��b9�.!]��&�e>�l��:���2C+�Raќ6���)/��9t�\nlH� +��Il��BHn���:P�yl�#�)\"\"E��ˮ�%oњ���P�mL\$���%p)�|5�O�0�AB�=G]=o�S���v��NI6(���Ô�X,N�'L�4��Ю�9\"�L�r�c.k5��6`�6vSW3�@ �@�BHa�}S�TG���[�8˔y�`@/�P#[���gbk#Y8\"��D�d�S��&Z,b���|+\\�8�*DN�p�ٸӛ������^�]���4\$0T���KQK�BhW�Ԡ��Q;�ᖭ�`u����J7 C5���2�w���+��uҡEn�ҍX�J>�%�i*ܑ1*B�ĭ!��f��]oĽy}d���#bR�l�W����đ�4C8���d�o��}�gHdu���=��Z껝����BX�k#�Ɍ�4f���<����!��H�H��%Md�΢M�m��h�rѨo\"ج�tm���0A\r���Ѡ]�Z\r�w#^/;9�pdR0��`;�������Ρ&�D�_���♯���:p�8W�av�꾡%��|�y&\n��nk_z2���s;����w��;c#�S��}��-��/̉�\n+�T�.3K�\0ȜL����Ґ3�\"P��b���\r\0C6.�6��4I!L�TG�(r^g����\"�n�ʄ�K���h΂�N��J�l8K�\"\$n��J�p�D<)�I� �F@Ȧ�%�D�mXH��iF���H���p�٨����f����͚8�ͭ(��K�2\"�B-̘�\"��\0�o\\��q����#�~�� β�.���@���ې\$/�\"C؆�c8ґ:�'������g��嫪]n���o�e�F�K����QH����\$\"à�o�\$�.�҄�eq\0�N����qCL+\r���f�Q����[C^1F��,�\r�#��Ӡօ#ܥ%t>/&�d	mM���S)����=��c��\rG�d������MaO�!�(��)\"b_\"��dP��)q�#Rd���PI����2-%\$�1�n4:o�m��/�6\n�c�جBB�/���Zi�`#�xs.\"�G�!:�)�^^/�\0n��:�`��V�����8�А��|�7*��4��x8�R�l�d\"R���q*�ڡ0Rq���\$r-�8�x�`7����ViC1�_&��q&�ē\r�@�*\$-4)3^�Ɣ1/��oDDHĢ��<\$�E�J��b��M��\$<���0�t��c/0��n�7#O\"77�T4���r�͈��T�sH�X6�9\r'\n�F\\��0@̋7\rk�Pdل=L��l虜�7l�/�Np�f� '<�g֧.��V��q��,������Bs%9�\r8��\r��<@�π�g�;�9\$�~!�.����>!�";break;case"hi":$f="%���p�R��X*\n\n�AUpU��YA�X*�\n��\"��b�aTB�t��A���4!R���O_��I��Q@��q���*���`�j:\n�	Nd(����O)�������!�\"�5)RW��	|�`R�ő*�?R�T��DyKR�!\n�D�J��C�u\"�)�)Q�:����PT�i�5@�ݫ����-���u�e���Q���I��[�W8m�R[#�kn�H��U��)�a���%&�;�Rd��E\"��q�qo3��/%+��������x/���!��>覭T�o�Ϧ�#̣�#���o[���S�䧎B��h�(�������4�9�<��|6�B��A�Q\"\n��튜�:�bAí�k\n;h�N�G��+�#z��jx�9��(�/�,����	\"�zRCL�<�\nJ��ϻQ��7)��T6�@�\nZ�L�F���)H�E̢sB��	��[ȊΌ�/2��5*��e):h+IS��2ĨM6���*.ϲ��1R5豢���R�Bւ��s�O���(�J����\nr�Pɣ!���)%�Kd{R���E͚�;��(J��Jd)�EK���RG������=%��ya\"ى����Mʓ^5�szV��&�ݩ�O����N�����az�ED�OQj|�@#X���dH-9 ��4�d7�����\r:��댹�ۏUӬ�:��w}~�75�F@ЍAi.z(��\r��3��:����x﵅��6�#p�9�x�3��(���9�����J�}��q+���@��^0�����O8ԓ.\0�Im>�W9�_d×-=/�Հ�ȓ�6��}{���7c1\\�:y͢����n��'j�s\0O��������A�_V�����D�2�YF�'��dE����)Q��`*ix�z�|�9�iIͳ�<D�RoTf	��8���[d^������Q��R��v�҇u�5O\nv��	�:aj9���h/��}l�?s�r`�OI�m� V+���N��wh�9�4\0()���!9�\"ćP�)��F�o���E1>*؂��;ˋgf =HL͎p)�q39t��ک���*h�\"KG0���\n��9��&v�\n)vj�\rƦ]#s�O1a��7�\n\r1HiIYM=G�֜4�<\$hH(|�#{;I�5X�掺Q4IT��\0���가�\0R?6�E���d9��PV��S��\0����%L�Q�L��1e+9�2�%�ѐD��q�M?7S��-���H�8�r=�t�>aH����	 �C�ʘ`�3*�O�ӆg�jg���Ÿ�>SO�\0d��>a;��Xy�ᚥ'��(��j\"����'9ꐔ=<\$\0)]ob�5۱�)(\"H�K�D'F_G��^J�W w�Ϟ��#Q�]�V��Zk�y�6&�ٛCjm���7&�ݛ�z�7���Mep����V���s��h0sD��)�Ԯg�:(�bM/<ma�)v�g��+R�?FV�g�\r�����S]�gb����,s��������Ϭ��d���![�2���G�I����Rk�}��6���Kk������[�yoa�<F��K{p�����g}�JaW�:M�P��3�\\r!\\{�����,�ztY�A��͕����S ��ﻷ�1CQSc�!g�|�����#[+8�U�����4=<�F��S2�՝gj-w�\0��D�XjW�T\n\n�)#J��t�e �BN���Wg�@�����K8��+�M��I�(�r�9R\$���S��\rz�z���\"S�ڕ�r�a��.��3�ڪ&�r_M!'8ē\rX��(Ԓ����	�����0��1�ad��P���뗒T��,��<&(-�h�<��6Kʔ:��Sɤ�\$LM���ד�N��:A��w�(�,��5�MX�@��S�W҇i��w1�g�j�#�Ny�����I�r4Q3�Phy̴��[\n��z�\r�*�����<)�D���	�.d�ꉤ�i=�z��7ωqu�j27��6-���:�a��U�8R	��^k�xFB0T�5�G�VQp%Ƭ/#�%\r�m�w������vδ����#6����r�X[�Ľ^����9oD2=�19{�����h����h�{3i�)|�Ik�%=��s<x�Gg���/]�!���c �G�_���1�Q��}��o�i�@��W�ⴓOky����\$�E5*��^ww�_�����,�w���27��L���t��L�y3 !cO]���]�As�ZS�b~7��[қ�}[.:S�����M���NU��TI��\\�7U���I��rQ\"��h8��{/�q���u�K���\"MT��I�!��}�l��^��%�_P�d �*�M��l�).Xbh��R�N�w��M�JPV-n��`�	�'��F��/nj�.�8�HT��x-�\"�H��>�\$\\;�Vz���jt������FW���px�~�G���8x�d��}�	���ܙ��w���<�p��+V��Z�'���_L҇*LE�tBxE��?��� �0��\r�a-jae����^�oj����W�.\\\"��,DM�H5&��,x�Ny�|\\/�Ǎ��,�����@y�>\"؅dy�BO�FM��ﶦQ*6L\n���0�bS�f<�DKO�:�&(j5�0�<�J�\$�)�j��/��!(^��hͱn��K�9�z9�~���_��x���9���\nVx�I\rZv�J�Kb=�����-�:�T�<�@��U�`F� Yb�hk��d���M̅�\$����f�N^U��!QwC�yQ�f�����1���V�%R�����pW\r�8.Dv�,C�,�nv��?�jP�烑#.Zh�.�.]�[&��+Rty����D�%q��C��6b��+�+OT���t��D4D�g\0)���\0���9��?.�ns�J-�t�T�M���V32�(Rz�d	0kՌz�xJa\\�D�)��0�X�d��]&ę01�2Gd*�s<��>�o\$9�I0�#3�}5H�:�_3s\rS>�.�:��1�Ξ����ﾙS\0��H#Zu�l:�#Q��P��D\$ÇF`�8O�mD�sY\$��3O-2.y<0NT��F�_�E8�^l�E3~�h_?'�-��;�C7�j��ҭ\n�c�O99k4fm4�H�G,�+\\�o�b��R�BBS8�4,hB\r�mB3aB�EAt.�94<t�A70����3E *��T��:��I6�����G�OG�ٔ�v�����H�B;G�\rhu\r�	8�6%�E%L��Da:�\"`2�e\r�zԳ7\n]���1�=�LQ�XpvN��t��3T��}'N}OT���_I�uJh� 7΁GT��UJ/m1����FЎ�?s�C+�1'I�⳪ܽ�F��	ư�_�WM.�T#���8���CpX�����Z9��SE��Kb�GH1�zCM�UI_X�t��\r�R/]V\$�S��b1��w�����z�0(�Ja�a5�QM�zuU�/5��C�SH�䵌yRt�_5Xu�_�L����^��I��6*Wg{Z3WC�a��� Jv%_ûR�c5bgn�6AUoI`��s��`��VJ3��c4���D����>�/o����L�O��1��a6N�~zT�<�)^�e`L֔��96�!b���U�5LM�2�&hSӹc���2�v�ӻ*�̳Ũ�v�E�����/�0U�^�L��l7��Fvn�pSdUi�5j���w�Qlh#rG9o7mMqUOGmF7h֣Ls�>���t��n�]q��sӥ`����.���<�Wf�KIF���q��p�/w�ij��r��w�x.�Z�>�!G71�Y6P�4W�i��z��w��z{M�y�oז�P�{w`w��7�s�^�c���aE�l���Ct5�|��t�h��fa��Ipqhv��e������e�7i���e脏,�J�ah�s>���F2��\$�9e{3`9[P{Q�!�gXY%��Uj��c������FS�>#'�e�.a��m�&�)N��N�xB#?=1%��4K�9�2I�g6R������|�@�� �x�qK�Z��*C�\n���Z�������L1/Zt���\"w��R�wxq����U���)�x3)ܡ.��ȅ�S*g�BlT�(&8\\͡K(�T�/�S3���!�������j-�Rq9W�X�eՋ�J�P�Ūhi��7����X�Gox���d�9���D�-���\r\$a@�B�%s� Ӧ|c�?9:�M�	�aG0Lx<�+(y96o�D�m���p?�\r�s�^���wßYݟ��0����͠����[��O�so��:`.y��/�H��>{ӾD	{��uy8/7C�T9�\"00-�9���T����H#H�'p�dXU�s�:�g&�U=����Ht�g�3�H�9�Y&��(��V�n���6�>]1�4���7��chFfٓQqY���0X�T���D�P��Ù��\$�iG���pD�:P�?\\j^�A&�D`z*\nط&�3���g�#fv����yJ2��f\"�\0";break;case"hu":$f="%��k\rBs7�S��N2�DC���3M�F�6e7D�j���D!��i��M����Nl��NFS��K5!J��e�@n��\r�5I��z4��B\0P�b2��a��r\n!OGC|�� ��L5���\n�L��L<�n1�c���*)����)��`�k����56�L�ԁ��:'�T���d���2�ɼ� 4N�Z9�@p9NƓfK�NC\r:&h�D�7�,�� �*m�sw&kL��x�t��l<�7�c������V�Ag�b�=U��\n*GNT�T<�;�1�6B��5��x�73Ð�7�IP�޸o�X�6�*z9�C�����;��\"T����ʑ��R�&�XҧL���l���R��*\n����h\" Ȣ\$�\r##9�E�V��/�Bح�C�a�c�z�*.�6.���51*e,\$H�Z8�x����-�\nձ��2�R��Y�BR4��{{93���\"���=A\0� �m��k��\rI��1�l(��\$t� 1BA\0��\r5L���\0�2�\0x�\r	���C@�:�t�㽜4ґ��8^�����!xD���l�.�46��H�7�x�%B��R�#b/����5��c�')�z��h��˯n���/�&	�a�a�CR'�@P�y�#pη��#Γ��NC���.OD\rC�'�װ��sk��2�8��>��]��6���V�-� �3#�6ר�2�B[d����ì1�2�֕��:v3��>����9V�\0�V�@��z�l �%�pb�P����5+���k�tr�8��0����&W�0��L���E��L�󛃇����\njeЂK�1�G��H�_#-j�u�D��:=�(6-��3�#�ű�#mH��kx�<zxZ��GJjw�� �ܕ7@��g���\$ڞ��v�PG0��C�v��W���C]a�4�p�N��>E�����M��h0��\"kl}��<�ܪ�Xs%A0��F�i�4�������H%MYF(��r�4@��!�P��3N)A��A�z�C�#���NK�?��9��\0T[` E���/R�ɪ�P�U��@���W����8��B�X�d,������ZD0-U��y��	u��} �K�'���dJA=6���*Uze\r��RjT��1t���?��\\-�tȠ�p\r\$�+��*�Y+-f���c�~[rB	\0����HH̉�!&���H�d:9�6��H	�e@�hEET��r+\$��ðS�\\Z#H�L��|�#r+0؎d�Q�Ȳ ��\$>U+n �ȉU��7��@�a�\r+����yFMh����E̔I#E1��:^�K,�\0�(�0�gT�Vȉ*�A��O5XY\r{�6�ّ=2jpU�^�ܹ��\"C��&��I�F�z>\n�h���jI�U01���bW(�Y\0�\$Xǜ�Vj�i�N�J�TRČ=.�Z�Ř.,���ȏ#����Ɵ0��+%����3 S���+���2tS�k\0p�8�8��6��:��(\$�0�i��I5�]���NËSd�3 �%�c�� 1�jqo�����ţ��hP	�L*UszA\0C`�پ���?���<�����z�Y�E�s��s�Rݹ�0����t����P76IjP�`�#J`�0zs<��eB���.s����)	g5g8\\Rh�ݹ�p&4�c�t1[/f!�8p�j�:��b1��pPze���6&�щ�3�%Je���>�(&4�L����]���TJe}�שᨒhP���N�z����sC��ȵ��&��N�̹��=���PF:��G�ڲ���,�(Y�1� g��\r������-�?W��(i���0p5zy�%LQ�+:�D�0��bj�	�E\$~eg�r�X1e@޴K��\r��\"���D) j՗e��vk�wR�Q2f`���܇� |^��	!��\"��q��n.a�mn���-��\rq)v��1�v�ɭ��6H\"�&��-Gp��c\re�!��zk+xe�G�ضR� ,�|'pg��BȺ4�#z�tU&a�h �LR0\n\nL���p�N\ryxMq25���2c��� �@�BH��o-ڡC(n��V����\$o@���Nʣ'!ɓ2.��U\nʝd�u���b�n�I�;���Z���PR�r���p	ʡ���Ī�'rA���p��I�f���k�b��ݿ�6��S;�����y(��No�%TxǵA�Yi�#��ι�+ػ��6����+�EO���P�\"�,��xF&䔍bܲr��C�yK�X\$�k)����&a�g\0W���U8Q\n1?k�M����Ku0������L��7a`�	���p>,\\9)\"al\\i�Ŷ0C�0@�0���49*�b�\\#��5dm�4¬Na8G���1#��*��H#MyBX/f�i�30X{�z��l��c�#��\"�Q�N#C\"`Bz���0���Ƣ~-N@T��l�m\"j)�@��F���|j��	��%*.�֛�D}\"d�c�G�����M���A�hHH�`ڃ�B�� `�Jv�^�V�,�x���\rK���8\$���q(̌�8,��y�;�����\0wQ\"��Tv'�wdv'qF�1`vgXCRf��\r.?.fhDtQ|������(�/\01��������n���c%���\"�1�61��-�6�:�QZ���8� آ�sL5�ܢ�C�l�M�9��i��Fd�(,��\n@��2��1o�)JB�\0�W�I�RG2 k�\r�8���6�u\"z<O�j ��\r&T�� �t)�ܝI�%Q��=��d/��L���e Lh�.:wY&u�2��]r�(��#�}ҡg|��R���1���1�q)+r�Qi*K2��#,�rˣ�-��'�x �)��'/�j��#G2�22���o�3��*4_Q�+��1Q��r�F�A��2k��r�.����;�6�-��G-���\r�=sM.�\n�NKC�R�\$P�)�`A��<ҙC7Se4��G�s!F�As�-�Dv��R�5ü>&k��7�iZ��U:��9��;Ɖ.��x.�K�L���\0�\nbDQ�3�?��~�>��u>CQ>���\r�����H�.'.*�S�S��)��%92�|\n��s�\0t+;sP�D�.R³L�O�~��{�On|J�iA����O�-DF?�5/1�Q�<��*>���b5P�mFN\\ðЩ\$��B���І�!Ԓ3�I�HԠ���d�@��#��dd.�J-(dPM���d�������U�\r�V�����U���j�\"\r ̉\$^%@��)��j謀@\n���Z*��c�U(zD6?��S%SbeS��S�KS��\"\$\"�,\"G�}B�sD\$�nH��P5�JF.FO�CD��?��W��<C�\$�P;�J0D6�S\0 ˢw�F��D\\J�N�	��=�:�x@~:�P����X�&g��.�4N0�\"�Ԥ���/��<g3I�i�_-__��&\"u����D����5CY?�Ɔ��\r����_c�(��lr�-�E^5� �V2	�&�@��]�8q0xEBKEa/3���T��ẏb��,C��	30�z��G��5F��^�kim���<V*+���V�6�G�� �m@�O\0�6\"�8������\r�z8�\"�XI#8��m0T`t\r��";break;case"id":$f="%���(�i2MbI��tL��9�(g0�#)��a9��D#)��r��c�1���M'�I�>na&�ȀJs!H���\0���Na2)�b2��a��r\n ��2�T�~\n5��f��*@l4���ц�a�\$E8��S4��'	��l�����d�u'c(��oF����e3�h���tƝ\r�y�/s4�a��U�U/�l'��Q�!7n�S>�S���/W���9�5��&n/x\n\$NX)\n3 ��Щx(�6ǝ�ӑ��\"\"C�i�ߚ��yӇ�!9���c\$��9:A*7;�#I0���X��\r��|��iR���(�ڑ+#:>�%�:068!\0�Amh�ɬ�j��BS�;�8�7�QZ�%\"m ���N�}��kZ����(H�)��\"��8m���	�\0�5�R����ڗ�j��6��������>���1���`�3�X�Ǝ�KDâs��?�`@-�@�2���D4���9�Ax^;�ru4\r��\\��z&�o��2�~\r�3���4ƣ���^0����\r(��	���Er�%\n�5+�L��d�����tt���+��sx���\"7?9�X�6G�z���į%	)�w\$H@'�����B%0��b ;@��%׃@#\"�:���Z1��q�����,�M�����X�J�(���Q\n���:��}�i�#.�#ㄖ����4)�\"`1Knb�׵��4�J����\rr+�!���mn��i�%~(2l�/=�BKT�Z�s�%j�h6_���C�'苨�Q]c�\r�O\05�p�o��|!��0Ҋ�|0}	�	�&�/+�/�<�'�1��;���� �,���3]�V%0�BNƍ�0̴S����P�7�r\"Ϝ�:��At��CEc�r�rܵ����aJ���K�I����D*1I�YX��x3<�9P�R�MTCEѴ}\"�Ԫ�S*m����U�@��7*�}��rE̒�c�ʆ|H�%��^i\"Kƀ�*S���vQg�C�������R�YLu4����T\n��WNK\"�Um�8u�䜢9\r�q/�0�\\��#���CЖ�i�OhH�1�X�Hf|�Ɔ�1�D�pȑ��D�au���'C��Y�oy��>�\"� a\"@�1¸�P:�:�b�R�d�H�E{\0�\n�0JA�,\0PO�L�/�@�8�ܧc;��H�c0Wk���&����C�8�yFI�Dc#��/�B��84J�73�H\"�Dƌ1���ԁ)��41����{Q')� �(�L���%��&^!���7��\\êya�+��P@ c�1��S?���JD̚�y��\n\r!���v�@�ɇ&+�7'���\"�,�C�<��MS,�5О�,!�d��@xS\n��9��JI1睌��d�NR��L\$r���9,!��9�E���6ut�r��@	��W*[�0T�	Eʶp�D�&G\$)�Ȱc^�Բ�x��xNT(@�(\n� �\"P�l@\n	��W��d��\$�2�D��\r�Re�*H%�]\r9vH0�2�X��:gUz�ʏ/�I(V�+5���Q\"R1V�]0���OQ#j�A��k���y�<�lc\\�*!�R��\$O�Ӕ�\0�2�%��?K�h����/\r�\nf`����_�%�n�=0wj��G2�X�w`o'R�ȾX�AC���L9İ���͸�����IZ/��2��;��l��^1���:䑗��A�zӓ\\dAK�m8�6������9�\r�蜧cz� c�a\rE����R�LM�mZ\\tOQ�S[L�������<���2â��Z�!�()bj�a�=)^�,4~E��\n�!��AH��vf87�\$�[��\n�a��K<o��\r&���`�L��'�e�3�0Zf�gr0�f	~)%�1��z]R�1e&·i}#�>��!�Y��j����X)��P�AN�\"'����(�H��Ӥ���:&K鮜Oa�\$�R�K6�ID��	�M�2 �\"C�Pյ����D��OEQk\nA���.P��h/��k>��Z��Z��߾\"cpΡ\"Z�_\\�cR��i�\\,4��+Ò��/z�җ;��~B����~,����|��r\0��y\"�����\$����^�	�ЈyC�+�p��&@�p�;�Yu����J�,�X��8��,�,����y��hH�1��\"�me�`*S%(H��G��r�r�wr�[�dc���(r��^���]��<��ܼ4��R�߂�7y.P��qs�>3��+>E�q�ٕͥ��j��'ˋQ�HI��Ω���o5�|�ȕ�y�Na��}��ܷt����I���lzN\"��\")^���]��21λ��N�\0�d�\$�Z>���薣��kE~�_)u޼����H\$ϮƂ2�z�Č���6o~�MOS� �im��nl�,�\"��X��N��'�,�PB��4i���06s�\\	���\$�h�b�:Fv���j�k���g,��&\$P�'����Д����s\0�4y\"(a�2BĖC�aĦ�k�i8IN�GĀH�-��k�\n\rw��\r�E�o�L�ƞ�f�������0D��%�T�Ш��0_e��\0��C(�9���~?���'�&p&�q5\$|\"S�\$��41B%	�,����n\"gl�,8�@�q\np�E�m���E�E��I��@�hB��H1�	oM������U	�����9\r/H�M��\rJ&`z��J��ݎ\n/����8����	JE`�j]b,��`��4'����zD�\$@������r��\n���pṡ �(\$MD0q=�7��\$MDo���z4��	���͆j^�>n\n,��@�*2L�-�`.�x���#p\"�N[�x^�j�E��E�U����'C�:\"xx@��4d��g��:2�R寘,\"�g�\0n�^�R�揘\$�p�nM�G,��\r��(��\r�H揪��<��M�z	�*5�N6�T�c�0�R&��sHi���+�����E.�/��9L+-�c�b�\\��CúWr΢�����(s��2�d���I �Ŧ�\0F@�D��d�D�1HBR1�";break;case"it":$f="%���(�a9Lfi��t7��S`��i6D�y�A	:��f���L0č0�q���L'9t�%�F#L5@�Js!I�1X�f7e�3��M&FC1��l7AE8Q��o���S|@o���&�dN��&(�fLM7�\r1xX(�-2�dF�}(�u�G�&s��4M\"��v�Z���g�Z-�(���J�.WCa�[���;fʒ 1�N���̧��ƭg<	� �g��J��er�K�DSd�׳&Z���QT�\"���H&�9�:�o�S!�W3�G#�s��ѩ8L�g{A�L�%,BR����P�%��&��J\"t��jh@�e:��H\"=�@�7�c�4�P���B�ʦ�B8�7��f*\r#�&���rI��`N���b������������(��?���\rã�2�#�^7D�`޵#���Ll�2\r�[:� �����#�1�Ȍ*��\"=%/�i(��`@%#CH3��:����x�K���7Ar�3�� _A?o�^'��la�L��3-	���x�\$³�޺��\0�=�%tí�M|�����:+͚�/�K0�Y���.5K��ى� 숢�,�7���/ġ(�Cʚ�Weܥ �x؎��Th�^�jX�K(�\\1����+-�B4���֒\\���Y�\"3�0�@�1��J!�+�ޱ��4J'�N��\$Hr'5;3lX&1<Ic�ME� ����^��Z�9%-]�~�#pȈ�b��,�ﶶ��l=�{�Y���Ē0��Y��l�,��I̻2�	#k�9.N���ˢ�Mkf\"J��#8��(٧�\0ڐ��8�T��`�i,��0�5�n�QH�����I����Wt�0��.h�H��3���5=��#\\L���JL�ȀS�9H��L	�ޓ��������7l�\\3YT�ȗ%A�2P���{�K-��=xͣs��\"��g(}��-~ŗ�����Z�	�c�ɾb�l�!k'˭���|wL���3\"���M�H0��<�`�dCpkt��9�\\�8 *m0%y�q�� (�&�Tz�RjUK�u3\n�J����[\r�T��#�P�	3&����T0aKF셇'�^���yd�@��f�Hn\$g�1SC\$W�:��p���R�aM>؂��t�<\$��:�n!������4!�)��\"���.0&�͘АJq'#G)��n���8��֝W�(IA�c��\$�!�(P�e;n����r�߁F�괸30eM&�i�0�α^bDw��80È��)4@D��	�A\0P	A8�6�{��('क7t�˱'3��r4�O�m�d�N��G�t�L�׷�^��,��������An�t����f��oP��U���f�)�E�U5'Y!5�P7��S\nA�L@���*-f`���كI��o�ɐ���	���o��0�_K�H�(ș:vOqq�x����PV��h�ȍB��	C�d��|:�*OS%C��Ѭ�:y8BxS\n�曕��\r�3�=�I8^��Հ�Ь�f�\0PP�F��%��rC;DiDh����+\$�h#I��L�G���{�+*�&u~�4��)�o��'��@B�D!P\"��z E	���a3��[�>�V4VsY�(f��0��52e��1�XL9[�椵P�Z�0�q�SZ�s>\$�ՃX�_mw魷�����!��4���S!2��7����t��H�ww���'�b-��nHn�lhй3f����_M��C>uO�H�#�lY���_)�MZ�S!\$F�����=����a��d���@C�E��Llk\rq~\rȐ��HFW�nb/D��-e���^S��;8,V�mj����E�Q�#Ը<�dH�l�I�臞b�:JϹ���ۢ�w�����'�U�0�.�����u(R\r�904�6/����!�[�C	\0����B���IɼN��x�Uo��Ӈ-\n�Ax KĴ���J\$n��1�Yf�\$� �'��\r�Y)hT��!�\\^n���Sp�Ź741L��4:SLq�98�4Lc�.e٤\$��{��th��q�n��w�z3�qM�4xy�f6�}��O�b�'%����\r���,]�����\n\n�1[\n����|���\0��JN�4��d����ίI<xT�S��d���k��f)ɂ�y�Ue�H�Tg�lH�}�q���qOV_����(=�	Hm�ؚ���q��yp�m�\0���Q+^�&4L�r��.G���0n�=��L��{�CpiD(������5\"%�5�`��t\r�!�Z�ۺd5z�8�����\\�_�F�J0���*߹��>&=셞����\r��qG�w�����k�B�Մ���d̶�^,o��������'���n?Z��`ŢO�݃��\rL� ��`��/��^��H�@@Ї���\0p\0�\0�`���\r���(��n\"b�:���P\\	�<���I��#T�Cn\$iN@�V#C����`��kt�G��좂`6�G�QjL\r�7bM����l�% ��� �� ��vcf�hP����fʮ�N��*�.�\r0�0��e�n�����n�y��\"/�Z#��T����e���F�)0��M4\\��Mˍ\0�2\"�����ҽ�V��\r0&���/O\r1@��5�k��b�e%+���&�Sp��Mf|�bY��Eb�#��#8H�M	���^bQ�W�N���G\$Oџ��4��)~a�t`C�5�~֫�\r��_b#� ��|�i��h��ch&a�G��΍f7q������͸��\"t����~f�M Bf]�ʥ�Ȥ�� \r�� �=RK�3�\rm��K�~M 3�����--\"���Ҳ[�dIFP���`�RH=RwRR���'��	fD���������/��D�����,]r��r�+�P:qցB .B�/��l=c�l.��\"}M�\\&��-�{-�`���^2�H(�\$��\r�Vc�\"��\n�f%\$���.�;�<�����~\n���p�o�|�Vد��\r��3H�&\$�Њޥ�\n�\$\"j���\\��6d\0002�*:�COƠS�Z#�d\")�aKd���UeZ��\r9�R!�3�U/\"V6r�0\"\"0R�԰75��m� �^ ��,���Sě���%�BI�>)`#O(����7\$m=s�>��>�'��=��<��C�M��\0N䛢5f>d\"RL	�@��N� �g�\\��߆qD��#&:��E/����\r1f	�X˸s�+�\n&FCf�:7��n���m�r���kt�\r�^��M�ƈ�l� ����tZ\$�g&��HZ��b\0#�";break;case"ja":$f="%��:�\$\nq�Ү4�����(b�����*�J��q�T�l�}!M�n4�N �I*ADq\$�]HU�)̄ ���)�d����t'*�0�N*\$1��)AJ堡`(`1ƃQ��p99U��B�[�Hi�[�x�9�+��A�����FCw@�����~UM�����^�_�P�PU�!�� ���F^�!��UМR<����I'2mh�K,/P�[�P�t�R��W^�X��E�v��u:�k�L�[&|	��W�~G���*)A�����m���4���TO;%�~s��C�\\�10G\$%R�eK�8myC�d~����\\��#�%{A�	Vr����_���L������(�Ce\$\$��i	\\se	�^�1R�e�&r@I	F��d	��	\n@ư���'H�Fĺ-:�´@��򘱜ĩ`���y.R���\\���DN�K���,�U1	)�dDK��)<E�p�A�F�%U%J!1�<A���M��SO��G\r�p�<A'9PW%\0�'��H1f[���Du�_5l3XVP��NA�iy`\\<g95�H�k'VȂ2\r�H�2�Q�MD����-�K�M]Y��@@���G�C1R1l_͒�x�2�\n��@4C(��C@�:�t��L7E�v�x�3��(���9��p��J(|t%��Z�^0��M�W��9t�z��e,2I&dKzZ1\r�nܧ��I�7�Q�P�97{ҁ8s�V��)\"EA(ȤW����'J�hM7�ѻ1\0Q��2�U9�@?GN\0sP�KS�a�3�.�s��Q;%�vs�}+'W���F����[hd\"^KO�i/?���*[�K�J���O�HM�eH�)�\0P�(��gO!<E���2����w�9\"zηJ��NO}[,I�W����=�n����;��\n���������P��n��+�n�spX!>�􍻚r�e��5��Y���5�3�%�Fi�B��L Na�2fU7��J�\$HEÒ�n�\0sg�V�xT��!J�,���a�:7c�B\$a��LO� ��2HII0^�Ht��B����	�{b�IJ�a-#�,��K\r��9)U2BЌ�([a\n�JT5Zk����ED�\\�u�Ab�D��1���B��5oI�CQ|dX��\0Sh��lO3�j��#��^+����uҺÒB\$\"Q?����t1Mf(@cW��lMA�.��Bb�]���:��#d�����X˙�2�7���L�g� @�p\"b;J!�싐ǈ ɫ�`BpO����w%��I���څ����:;����Y(�y\"tR�(%\"T �g4��Sm�1�8Ǚ\"d��;��U0k/f,�2���̃��fl�!��]���E���A\"�0��)��8�UD	CG.mΧ\"'1�zn�b\n~(��Bh	&�+Ղ��e�u_%�b�	� ���'���(�D9�jSa��H�ů@���DR�F�\\�u��I�\"�t���BM�3%�@PHQ��F;2/K��(���Ϲ��+ů+�@�%U�t\rq.�\$\\�d%�!!`)\r�0j�:@��=QJæ��bE����I�,���%\n��D)Oi)��B4����0B�s�����*b\$�<�#ʮ�Ф^\$0���#���q5 �#\$�o��:H�X!TR�%G*5��Ih�M@@�B`��U�W*�Ur�}�A���B�C��\"H�M��-�]~�T�����(�Ђ\\�%b**��+�%��/U;�4y\"xs��!(����	� ��R��͢��}c�L�QBτ��ϓx�@�Y< e�2H_9�~ �	���%���bI��w\"\"�Wӝ3�Kș�X�rfR���z�d���	`��P(qj# ���Ƴ25aVdI������H.��v4K5QJ�w� �\"\r���!E;�v��]:���\0U\n �@��x �&]����.\"<A9励�K�x�1S�S�{Oy�o�J�f%�e����W�uF��L�ϛ�X��}�̹;�������{��\"�؟�P��Vo�IA�b5zԟ�����L)ˋcs�BHe(QTR���5�\"� �B�F+0�c4�Z�آ���BEd�S��}����ٰ5��*O�&�0\"�߈s�ØØ\\7�����?´t�y�0��BWir�a��ɷp�.�Z��\"�����'�P��1-L��clb���P�u`��B�\r!�`��i��D^	_E�خ~-p�;6�U��]���F����j��x�` ������|��o��S'�.���b�!�<�/x�HJ#W�(A%>����}�%EWܟC���ׄ���H�r���k������C*��|��ڠ� �	~� �\"�aD`�Kn5��)��ϤC�vD ��&o@@�@o&�4�+\0��Vk.���K�P4���C}	�ĐL2\rG���P�jN�Dpoo�\0殨�\"M�3�.�J.�46Gnw#K�l)ծB�О&�MXQ���\$��້<5�f6��\n��!	\0���W�O�����<L'�\raR�.BoT�L��!�&��QP0�A�����bOZk�����v!�_�3C83��m&�}.�\"%��f�6cvkc�8QS\$pqY�^4�xBƼ�tkO��hyc�m���h.:�(%��p\"-��(RǺ4�L�\$r�:���?��/��YN��������\n��g'&?GNH�lQ�pb�OG��p`�\r��e�6\rBx��H�.%� �>i��6�O��G�Q���,_n#��	����KBB�QT��H�.\n��r�`�Rf�m�C .��/�?��������=ҍ�~�zkr�.!\"��(\$�1f6���f�*�B�Lw�{�OR�&�Ȯ���(/1�-N�\r�-�G��'�p�-�.���<ֲ�-p ��H'��\"�mZ��TP�\n�߅�S��_�2d��å\$�G1�3 EQ���t5MC2�J��ML�\$32\$37s=��/͌E�|bSq�lj}hK)G�jA�0��#.N9R��9�-:F�*oj��0%*'O���(���-_<�����&��=�V@/�l�,a�i���t3����D\0.D�n)L��|��+��/�;B��T�t%+b+��;2������S��	h��f�kDOm>ʻF�C�H�4L!�PHS�nFQ� �@��f�O�㓥���n8��0q�G�H�HS�;T�T�C��HԟI�T/�T�JU%VRr�:t��E�!�J6�OLS-8��BT�T�����?GK�GMr�L,NRt�o~��#<t�C��C/��H/�L�-PuCt#H�Qj�P���8�O�.�R\n,¨����Q�0�T���r�IuS�YS�)EG��5K�nOG6s�&o�OE�L��TO�OuO9��XT�R�mX��f�2��D�����d���[�y��.���B2��GHAx�?�����-`�R\$��Z��]�w�?�<&��x7�c*`����l�o����r��䆺�f�P�L�\n���Z�Ac��(�pzX\"�r�co\\�c��.��P���<�.tX:�u;�b�V(�,�J��O��u��^Hh3�%a\$�bC��j�JB9n���~>c�!,�D�^&-L���j��8�+֭�c�fl\"\na�x�%81�{B�)Yq�걃HrAn�-p�Ň,Ua�\rq��B�#q^t�Oi1��f[3XCM��O�J0#\$��L����\\&�*�>�0�g���rrM�QO�Q�\0��X��EUuR��#�p�Gn|�w0���x�z����w�m�7�X��JԐ��U��W�V3��Ĥ�D�f\\";break;case"ka":$f="%���)RA�t�5B�������Pt�2'K¢�:R>�����5-%A�(�:<�P�SsE,I5A���d�N����i�=	  ��2�i?��cXM���\"�)�����v���@\nFC1��l7fIɥ	'��\"�1��Ud�J�	���.������e�iJ��\"|:\r]G�R1t�Y��g0<�SW�µ�K�{!��f�����eM�s���'Im&�K������=e��\"�r'����Q+������˿���}��-�����<�^��}nnZ,�:�K<թ�;��SV�\"�z����q=o�۳*#�\0�LD�����ζ�S����:�-JsL�\"���4M�i(N\".�@�9Z�7�����B�Ŵϻ����&��V��l��7RR��r�F\n���K�t�-Y(�˰Kp�D��LΣ*�x�#	�������Sj2S!��R�L,���*�ʐi��DO/����ۊ��j\r�1��Ч��K���(��N�#VJsR��(T�OTS�)HH��E:��1	%i�R�Վ�M%jtf�G�,>�C�*^͵�����LYP��\\�t�6\$�\$��5;���b�6�#p�9J�:'T�t������Y�Roe\\�]J�[����@4C(��C@�:�t��D7��{��x�3��(���9��P��J�|�(W�|�|�M��Qj���x��Tӧ �dwm��N�	=kR�z���M�;cڮ@���C���M��Hh<��M�cJ�rө*m����\"+q(�!�1lmN�Q���/���O�.��U�/�]03�a\$�?V�ͭ��s�Dj�6���j7�ZN�C-�]�%:o���;먿yo�G�ں���(Ḩt=����I������,�	��Bh�!f ���������ĥiE�JV�{5f�о��ꚋtz�ܥ��Bb�-���<u:ގ!?<+�\$L�\$j(��6�T�Us샇�j�f�n���Y�V��S^!�+�q�5��|�I2#%	^�7&�	[�Z�-�,̦�!8mF���X0e�D 7\n�Q4dBT�\0m��:1\0�Θ�t��7\0�CrA�<��LX�:a�7`��e���1ꘒI4Q�<�%�mi�+L>C�X��]¢+E���eV�`tNб��h}��d(](�G1 !4xf�H&�D�^1>R8�\"N+�K%gܕ��e ��T\n�6����|CWƄ*fW�� *N	���Dā+��\n�ro)a�n}\n���8i�)�vJ����{��Q^K�{/��3�l�?ӭ`���JN����D�M�\n��>�LE��V.�X�c셑�Y��S,e��2G@�Ltg��· m���m6=�c�%�b�-Q4�M��S�iz،�v�B��+�p���ޥ!4�,%zS����z�4����h\$�\"F(���L�ގ�\0��6�1F,��ć�vHɧ�)el���P�ps�,���:Hީ�C�=����b�&�R�b���y�-�ԙ�Z�鳒SY��g��fI@Iũ���B�C�T4�˧�g&E�&��d�N#xY��qX,�-�)�x�Pxv=��\$��L�I���M\$�3�H������	4G������t�㐶F�`��2�O��\0����L�_�bm�ۻ�C��N�뙪��V��\"�+�M׼uwj.���\n��i�n���zs\0���L��'[H��?��`[�VOv�����܉QI�>����&���jiA��C\naH#/�T �{�#6H܋'��A7��W^��%i����ڒ�����x)�U�1�5�ymE��\"��K?�v2�X7P[�PG�B@%�{R��-Yp��\$�0�^x�ʽ&�����l�{	�Ph\$ַs�?� �¢4��(��\0ɭjUt,bKt�S�Wd�J_MQ@�e%O��e+sձT��S�`��a^�mD�9�:�\\�?��JD3M<&B5�oM�7M������A(�`��ޫֹ\\Sa%�l�IK�cc+�zI�4�n�Q��k�Qw�� �ʽ�뮮�2oHS>�E�	2��Y�\"p�����'%����\$��x����������2.~�DJ��К)�>�t<0�K��ְ�i�U���#XZE�|P�6��@>�����0�SH'2��X����u;^��઄�w5Qq��ߖ���0uB�H���o;����n��V�]B+�j�]���|���q�l^a�+�|Z��b��	#E:��t<�`od���\0�C:� ��1�Z�xt�<C	�Y�\n�^si^Q�L�r��R1�����S�I\r��{����\0fA�6çaM�wc(~&v���*�f�'-�G�H�Jj��-V���	4��/��N_B�a���6*���\0��@�&N>(	��Ǘ\0��,L����*��!�i\"�Fz���\n�B�ɶ򋌄��C���Z�bd����Gv�|��u�X��\$�mW����JV�rr���N��ƪ@�\n�� �	�´�CVyI�Ĥn��Z+�n��;�ֲ���	�\nG�@DhG\0^-����\n��m֐��8�@�Z:�2���)���J&��Sp�7,'�T�'b7H~�k���oK>AS�@��'�.��|i�=�n:�.ۈ�+�K���BN�nb�<L��Vf��dz4�Q`=���f¸�!C��ht�V&�����-�M1y�UoL��hͦ�/����K�����1��C&��΁�ȆD�n`I�*�����np)d��ʆ���4���'������4��(� �C!�r8��F�� D4No�\r�d	#c\r#���l\\ƈ*�¼�'U�L%gfU�l��u+:Ƣ������`�l*����0�'�K��\"�è��-%�4�M�t��RN�꺃������4�L���\n��#� ��T���������\r�\n�D~/�,�TH�\r������b=�3(D��jA��Z&��.�0�1#�Q��11Ms+#%Op�,'r4��:&��n�Dj����3b�2���X�N:-M`V�W�prj�+��B�� 3��A!#q\$�CI��2�1�x�0@���+��\n�:&�}0�d�	Z�ӪD��(�;O�\$��\"�7R�4s��&I�F��T/�v�#u�۲h�\"3)��n�Z'�&�,�l�*�3���@�+?Qz�ϸA�Qf�,0�}��\"��eEd�?�m�&�k�J��P�ʣ5S�%S��q؜��A��?\n�����0S����('�چ�ʰs+8�/6L�����S�'4�H͒񇰂�]=�cJn����W�phv =0�@&Tҳ��a�S5��N4hrlM�ؽs�T,�NEO�O������	O�UQ\noQT7':Z.,��TR,\\�>o�q���c(�4��a �D�I�8��;��8UZ]4�\$4�s�-Uh�]<\"3K��B���u\$lTUEU�|l�L%q�S��C�\"�\"2��R���z=�~�u&�ҋ�=\n�GA�&4lݧmUlcJ���b��7R��X#Ps���Yu����W2�v��AU�Y�Z��a�\\��K��A'!_/��?`�]/K�5R�U#Y����;b�[�L�d� ��f&f@@@�e�@��\0��cfd\rif�p)2^�}/P	fo�h�����\0\0�&2Я\0�\0P	���R^75P@��=S-5��4��Ke7d]=��k��5��Kg9�e����Q�kQ���4����X,5k��c�q��`S�3T�����m�b�F��X/9VS�:ռ]2�̦�'���=�cI�^0���u]�z2�L{u�U���wJ��M2�O#9f���3ll��.-J�s�Z�2�k�i4\r�Wf��F�|��\"�:o\$�����T0\"��7:p�H\n��Ƞp��\\��ZSD��B!�8ѱ(�PN�'���\"�4¿M}a�b����5Էe�i�t���4�'N3b����מ=��zD��J�X02u@@G�Qd4Av��V�\"n`4Z`��l�t�嫇���/{ox��[A:tu:F�R�ȍ\$��;��+�[�UG��1\$n�i!x��L�Z7�vn�c�G�r�_J��\$w�\$����hM�D�W�c]k�ָ�\"�q��AL���X��F��X4�x��|�!�YJ0z(��:�U�CT�DGٓL�]X�EQ��O@�O8Bef�+':lzX���0RS���n~�sy	f����t[7\$�ج��roE�&q.��*\\.�̥!��\\��U���{ ��������`��^�#u����!�SST���4`";break;case"ko":$f="%��b�\nv�������%Ю�\nq֓N�U����������)ЈT2��;�db4�V:�\0��B��ap�b��Z;���aا�;���O)��C��f4����)؋R;RȘ�V��N:�J\n���\\��Z��KRSȈb2̛H:�k�B��u��Y\r֯h������!a���/\"�]�d�ێ��ri؆�&�XQ]���n:�[##i�.�-(�Y�\nR���O)i����gC#cY��Nw�����	NL��-����\0S0��&�>yZ�P',�l�<V��R\n�p�7\r�����7�IX�0���0�c(@2\r�(�A�@9����DC�09���Ƞ�\$�����aHH����AGE)x�P����v	RX���3bW�#�gaU�D�̸=�\"�V3d� ��b�S��Y���a6�'�0J�I�`��S���A\0�<����7D!`u�j*FRO+9:���e/�T�-�M4��[�Di0�t#Zv��B���k�*u��:�I	�Z�v��(����d�# �����;�1K�Q�1�p�����\0�\r�1\r�H�4\r㭤EC�Y�\0ym���3��:����x���\r�dB0����p_t�c���I�|6���3Bl(4��px�!�WR�5=S �!@v�d�E��\$�:�aB�����/��i;<��\0��k�h:e��ei�U/!NF\"�\$�:�n�@�#�X6e�wZ�-E:�BQ���G�(!LN��p�y�#����:���W���Q+1NH�p��dJ�U����Y@V,Ļ�D?OÈJ�\\�L�b@�VS*δ�`P��\r��,6CC��0��x�&<�R&P<�\\年K�U4MXEQ�V���giRe9��7��{�����UC��O�V�o:�.������;��!�Z�^�̓Rj�M�\0�-/]�q�ʙb�'��6�P戗{^A�:�\$��!史WC�>lt3��C,%��4h��Hsv�j	���4��L2����V�l��E�ÑfI#�JA�Q��5G%`��_�؃AP7��(�� ��-E��� \r��3�0�C�r�!�3�m\r��>k�2���\nY���V02�E������.���hw������� X�7 ���Pi�%w��ת�_+�~����X�`�Ƀ��^�\"\0tc�(��Ϥ2%p<͈R�k`�mPH�/%J��%G��u�\"�/f/ܕ��1��E�9��W�/]��y/E���_��JD�3aQ#�Ɇ��I\r����!�4�ˌ7�����kbȥ��J����4��ܘ͢@HB����*���m1nL�4���6;PĆ�r��9��:tn]Q���8��\n�O����᥿D��Ni�5d������D�RiSX�(�j���ʁ*iP�°�)C�>��3\0�O��ᕯ-\0��� \r�J���2��:B�u�	�\\b�%re�d>�Ú*Z���6,���]�u���Hc\r3�pAO�wpX2ً5g,� aL)b4!�X�7\"x��p]7\$�h&@A�ԑf��9HȘ>�>\"���#\$Țb7��G����qf/\$�|�d��R:�@�H�S axRI+	\$<�T7*��\"C!��[�>�������3 ��(��ɵ�,1�43T�*�d�(�\"�y����AJa�\"��]vH�ɹ9'x�\nB�kGP�P��@��(/!�XN<B.� \nn��ذM�0T\n��2�i�a\"dT��Ĉ%�LRE�K�5#y�`�3bc8���61�f\"�u�k����s���sxo� �0�<�	��:��� ��u���)ڰ�\"�	�i�!��aER=:Q:#u,�r+R�#]�W�(��ͮ�ݝX�T>�V�����:7���3\"�>����i���#���/h�[8�@�|̛cl���ګ����f(��L�\n�zN �1��Q�P|�k=i��R�B�7uz�W�T�NoD������J8cZ�B�D���lL�X�P����sW��N��9��\n	���X����xsN�yD��5���D��ǵ��\n�Ӣ�������ݞ����\0�A\$7Skc��ޢ'��>�Yf�-��҄�=zzBhb5@�=Z�!�`�'\0PC^HR�w��B\r�':�����O;��=�v��s3���f��+�����f�XP�Σ��U�i�d�&ـ�V�����A\n�P �0�0�\r\r(z����2(��_��\n�\"I�&@��@�!�#%��ϛⶍ� ���mZ�f	�d��=�4O͠]�#��?�!(�^��W蕵ߴ �����&/�-o��/�v/� ��*F����Ϗ�� �E~ͬj)N������ �c��O�v�o�R-�ˤ��%�/��AJ��Vid�n҈�{f�B4gI�L�49�`?'&r�\"=�;�p��j^M���#ƚi�0�#�\"�ep���V�p�\n\nRR�@����>Ӄ%\n0�\r#V��6l�hO���IP�2ڥ'��k���90�i4R�.2d�N��1c�HA��F���,�1�.&-8�a,숳��ip�91B���@�\r��B�\r\0�� �o�ڍ�u������Ęm�٧�ێ�\nGE�ٍ��Ǟ�+���l��7P���q���4�%\rQ��M�̏�����|\"Q��0h�.�=���q�{Q��{�Tn�?I��a)*RTC6�q��\"44�Hzq��Э��?/\"2&���r!�\"N�\"���\$�1�G��&�,\"# �lm�2%Æ�1�P�a:QC*J`�ǭ�g+�u,� �\"��['G�\"�)B��](jd�7\"�����l�b|����1���Nͣͩ\$W-l��<an'���#���%�-2���M.�ICb����K\$�TH�<3��B&�m>z!d��2/�\"4cjy��2	 �Bפ�0q��OX��0W4�_��6p��,�8��1�7A/oq/��7�����0�b@��}7a���/5\".�:r-,sk5I�;��]5�<JÈ��t�Ӳ�ӎ�A8ed�\rя;�g>�;�lNs|��.��0���o9�����0���a\$7EE���C�A����@��T)AlH�h�BZ�u@��\n���#�6�E,�#��6�E�,��6�\\Дa/Q��yF�1��(��`?��LTW:��?�m��#�iIT�I��j�\r�	0���4�X~��C����L�r�np������k<�7:��FC� �(�T�)�1:t�1Aj�\"@O��G�O�Os-P���\"!p���� �lJ� �\nt[f�o�4��(�����\\BV��w(��D�l\n���Z~�|>���-E!�ERg��B#'0�6���e��ԣL�jh,�>s���:�	�\$�����sG�#][�>�q-�V����J���&�eL�\0��/�\r_O� �o[i�L�܁�({'\$i�*c~Lh��6O�r���/���6.��b0�6�0��!�;�>h5H3mYR�>R�J���d>�@�CT*A`�	�X�BL=k�<��c�仲�܇�G ��)��^�R5��Vg�ub�\"@�4o�C�M��?\r�Xʾ��H�8�Af��-�<�,@V0Ґnj�R�\r.�Q��<6&�V�POhPa\\���li8��<.�It��!*�t�M\$�";break;case"lt":$f="%���(�e8NǓY�@�W�̦á�@f0�M��p(�a5��&�	��s��cb!��i�DS�\n:F�e�)��z���Q�: #!��j6� ����r���T&*���4�AF��i7IgPf\"^� 6M�H��������C	��1Պ��\0N���E\r�:Y7�D�Q�@n�,�h���(:C����@t4L4��:I���'S9��P춛h���b&NqQ��}�H؈PV�u��o���f,k4�9`��\$�g�Ynf�Q.Jb��fM�(�n5�����r�GH���t�=��.� ���9�c��2#�P��;\r38�9a�P�Cbڊ�˱f��i�r�'������5�*���?o�4ߍ��`���*B��� �2�C+��&\n��5�((�2��l����P�0�MB5.�8҄����2����!��,�,��\"�)�#��b��z_ �r��.���\nH�5��\0('M��T�kX�2\r�C�\r�1�p4#�ϤN�@�?���������#�A�xX������D4���9�Ax^;�p�JRÐ\\��z��u��2�h\r�#,��\"H���px�!�: �������\$�S���]���b�c���/��x���2_�>�.+�&�͚��1c\n�����B(�=�t��23�9&?������\r���K�X�(�O갂�#�B	#p��OC�\"���`�(�2�We���(�1�c~x3��F�*�#*����:9B��4��\"I:-�RF��(�BbG�G��#K<�2�ÚH��`�յ���1�#s�(��\0�:I��d?�J�9:�T6罸������ϸ���8h�4L�ا}��d1��k�\"uS��?�Gg2,T��.+8խ9�l,�b*C���q�.�L����y��%�	�@6��Msm����r5�0�7=Ҏ��|�(f,��2��|���&����!�-.6��C�t\rĉr�S�r�aDQ�\$��o��6)e�	��\0*�Ipyr�l:�%H�Yp\r�\r�u��Ah�\$͏�P�σ((`�����J�1P���h�C��L�h��C(|	B�7䜴p@��q�V���.�L��W�a,E����Y��g-��y�-+�D }\"��߀ȸϵ�P�!iDR\$���ǊAp yQh���WL�#�yD�u��������C�I�ka�U��V\\q���h�81��[a%���BR5	���r@��K2P��Hb�HJ9*��ÚwrE��8�B\$��\0c���V��@e��jJL|0�b�o��>A�ő��=q���)�^��a\r�x��d�\"��7��,e�#\r%��J���]\n (!�>��(&�P@\0�O'�m��5���^�R%�M�ü� ��F�,f����m�Գ�s�1�[�`��G�B�\r���+4,�w5.���e�=�Q�r�2��TN�:)� �5H�iD��!9Z�\\r\"v\$]q5����S��,��:��H��\"HI�Aqs�а�Ժ�ىuK�a	B�	y/�����L�,s�\rN&>j\rQ�-<�s�c|�R���26��Q�!4���._\r��	�L*X��c��m��%�k���#\rdA��glo)�!��u�V�����ND3ma5~�����N�5�r�\\��%d��-��i�)�q��L��ו�Ȓ��\$	N�\$�Q��:�\"�\\�i]|���6`̤ʳ`�����4��:Yi!Ü����3�����<�F���;wY��9�+�r+��*\"(E��d.ID1xZx�Yt���'�~��xe�����˜dP��>�,�j�nb�5���Y2~|\n7�0�i�,ش�*� B��ȱ>��C:�jQR�]�u�&�GE��J�_�Z�vb�\\`f'ȅ�&=�2ASzj�E�\\g�{�y�J�@��]@�дWq��sU���K�9\$#�~� Ӱ���Y���Xu9���Xa�n���:foCv�\$\$�Q@IQI*��&���uc���k+�Vy�n�1�jq��rぬ�c���O8�����^w�rh�(��g�C?����\\B�U\$F*0�}ށ�!gb<\n�v�8��-C�B�T!\$���(��8=���|r�a�r��(/)���p�ʎ�!\r=㺘�f{�c�VDC����k�A�]��i\"t�HU�\$����\na�4��6/�w�!���O��4D�TL�:H�Q���iJ#r�������/��F���Q�Ǻ��;�{�\r>����5��/��{A'�;��TC����\"��4�~�m���\r���p�rMp}����tt+},FӶ�A��c>r\$s'<ߥ��b��n�-`�o�,Cp`��t-�u����*��Cĝ�0oί7�/��S�\nz�<��%fق�(�����VoP��;F��-�Ό�ǌ�n¬��\n/B�+�|x�f�r��&�wØ��H+D^7Æ^�\$�a�B3\"�dBȰ�\rp�΍�ߊ�)A\r�Bn�jg����P�(\0\$�ڃgD��Qv�b\n��^����[L�GM+�OM���{+��G�m\r�q0`\ng�\$�Z�l��Hw�e�:E�J��D��t.�/k��J�/;�hv	�1n���O��>�B!0j\"�!qr����N��f�>D\"P�6!0]�q+��j������<Q�]���P#���p~\"�I���f���d	�\"�~!\"*@B*@�p�δ�P\"H�����\$&M��-6J�7�\0ON�!��'�m�:1�q�f���0ta�VO���,�TvR\"\r������į'���R��z`���O�Ѝ\"�'��B�R��=)ñ���5Q��&`o��n_)�+�lP%����?��,C� �����Q�F6c�&-��K�?�1��R�.�-�^(/�jƾ;seީ��/�9��8��>2Υ2S���*����L�a/R���S0�YR�#�8�V�s9�dGö*�5R������<�� ��SpK���NF2j�Bz>��\n�dB\nk9�(�������N6�;9Ӵ.J��:��\"�.|�:�[*���,��*�Ϋ���(�=6r?.\\{S���&��GB�+\$�K�bn(,g��A�#b�#�v+/A��A���\r �B�-q����S\"�F._G�c�5.�1	�E��b��B���6s\"�KG#>K�yF��6B6��_A�Dj:	�}H�BQ�����b�AT�KC���]��k�\r3�\\�O��e�%�̇C�&�}��:�\n���Z\$��d�;J�&b�\"�ρP�B�,�K��\"�` � ��VC�jb-%�r ��N�D&�\"���`. 	��-��R����8В'|2\$B��T�3���\"�N�,o-����U�XP�<\0�\$��I\$ЮMH`�F�?��\r~d\0��KB/B\r*�U�	���C0e	��!�hP��]P	��ƫ@C(Hi�<��NF��o]r2i�|<��lfB��S�~j����p\$�h2.p\0��2u�%/]0:�M�`���	�\0R��=��6<��-([e��H��t �\\\$@P��],��*C6�Mg�<���C�\r����j\0�Gǡ4I�*��Jv0�\$�M\nB�=\0�";break;case"lv":$f="%���(�e4���S�sL��q���:�I�� :���S��Ha���a�@m0��f�l:Zi�Bf�3�AĀJ�2�W���Y�����C��f4����(�#�Y���9\"F3I�t9��GC�������F�\"��6��7C8��'a��b:ǥ%#)�����D�dH�o��bٸ�u�����N��2��1	i�@ ������S0���������M�ө�_n�i2�|�����9q#�{o�5�M����a���t��5_6̆Q3��2������b�)V��,��H���C��%À�9\r�RR\$�I��7�L�����su		j���Cj\$6�C���\"\nbf�*\r��4�����0mZ �	�d�\r#�֥ �����P�bc\\��7��(轶O��5Lh�׷�r.�7�\"L������L(�	²l:���&��� ��H̢H�`7Gb�)C�AЂ��L#�N�b��\\4C(��C@�:�t��\\4Zڒ�����p_	c���xD��ò89!�Z\"7��j@��� ���x�!�.=!��(�P��NP�+(#/p于����(��U�/\n�	���ݲ�%.Rr��K�!YP��a(�A����؂8:\r8����!��\n%�ʞ@������c]C,��0�7�C��̡��9)�\\x[��0�%NP�h�s��P��v�|)����C(�5��˻-!�P��3����A�	C��V*FLp@3�q�x90���(#�U�ȶa�J�~(����8M����v�n3��_��qG���xCW��4L����C�@I��4� �<ѐ�����#h�`�*e�睥����~�B ���Ϣ�К\"�����=bT+�����ď6����c�|!��`�3��/�E�\\[�}5��As�A>�猣��I��E�İTv��@H��1��\\�fkm?7��B��=9Cr���ihܸ)�Z���4��rڇ�8�e	�����p	���4��6C�|/�A�(HD�'\"FJ��^��1�lV/D��ў�\rND'�!���^\$!4��T,p�DEc�m��^\n� I��s&����Dj;(��A\"a\0Әl2�l��tz�\n)FE8��K:\"�;�����\n�T��T��Z�Ռ�J�9+ur�	�c�a��eP�b}d�)�@Ҵ�	&DEG)`�%�sS����!\r��%�̧��JW��\$��\$�Sh�[	n\0�N�D�2�UJ�Wu`��l��������\0U��|N��Va5P�Z}d�7�dZ�	��>s����LDI9�#�dϙiy/�\n�l��H!��k|3��ځP�uA��a�)�IP�R\\J>7ٙ!��\"Q3�rk�\n%(�0���� \n (�uF���4\"DL��*+\0�����c&a�<R!J!�wKQ}y�U�U�c\0`&8��x�BѴK���P#�`��h��4(�܋�o����ҧ\r�Y`��/\n\ru2��3�\0�F7�7�y��Ü7C�49B4���\r�}P���/\r�m����5�Mͣ�h�G@ޥ�(��&�rH����C%,Z��*����1�8���t��Xݰ�8��a,�6 #C{谡<)�J	E]e�q,����RX��*�Eu�&@����O�������C3�k+B_�ۤW����P@�b1�H \nn��>HI%\$�j�l�ɍ\r�bCG�]#��%�bF��\\�DM�9%�{2c.��9�ܬ1�KN&�ef�k\0PGn9�'���L�6������\$L3�wE��Fp6��M��(����p���:z��D��!2��ha�.X����GzQ�}0��PB�9�,B�H*�/�����(V\$���\"�t�c5K��Z�Մ�x\n�\"w�.� u��P(�5�*Ӱ�N7����R�!@7JI��z�a�>��X�R�G�aa�P�\0ѳH>����3��*��J!&f��b\n���_��\$���I�B��͚de�׎�#%���&l�ñ��\$]drp����� ۖ�/�r\r\$tA��4��	�A!�����^�?ͧr�<.qά3=���ٲr����^�G�4v�qoNZ�ʮ���3F�l͌e�v���xx\$fg~� T!\$M�%wo�)�5�Š�ʺ-�^@��n���[]b���1SJ|�Ѥ����|���߀�Ը�[�9#��b�J��s�������y~\"�ϛ`���ŗ�}���*?9��\r(��c�ѐ�_\"�u�\ri`�rR�p�qG��G�\r~G��l3�G�������M}Re���5�Yz\0����jmD �\\�(C��Ą-�~��ȫ���@6f�\$�>��A���\0�MBN^~��2#b:t@�F�����@f�n�E&�\nE�r�,�@0,�-\"zĚ넠a#42�,�LN;�Jv�V���,��B�f\"ِn�Ot\r'�� �Ov�F���J����b\\�ʤ%0��h��CA	P�) ����\n&�\"0U,�f�n#��zg���Z.C�>b(r���xJ�˫��\0��di.\n��	Ћ�d%о�����G\0���#�ڞ�n��Q�\n|�LG\0�|�xѤDD�ڮ�:�-��be��TAQ\nm;�3Ѕ\r�\ng�	F��8�𪣧H�g���r�=��c�D�����`���\0�F�{�u��!1�NB�1�oZ�@�PQ�l���/k�q�ǌ|6&r0l��b]D!L�उ�����{�-�}���Dę�X��,#*�\"�VS�BC\"�\r\0&r%��g2\$ee�������� ���e�え�		�*�Nv�\$D싄F���2���O=(zyqb�g!b^�D�z�q�����s E���A)��(�)\0�κ�F�2�+GD\ne�n@��0e�-g΋�\":��q���#������#� kR�!N���Ts�4�I~tS_g.��]�z�s\rƏ1��)S#/��O��ib\$B3��H(QI2�~;�P�sNH�00��\$�3P�2�5ĎGfBU3T�s*���1+�tSY4���nj\0�o�,W%�B��*%.X�]:�)g��I; ;s�:\"!:c�݄��% �<E擸������80�?q'�=8S�8��[s�?�72���\"�c������������\"N'?�Ѐt.d��@R��	�\rf\r/��q3@�FVO���D1�*����z�����,�it`|�0�:��R	c�-�0��ֆ����m?��(�8���PJ2�G����!�36����g���b7@�K`�\0V,�&u�����&.�\0j9\"JB\n���Z.��R<D.���#\\��J5���4�gQyQL<a�Q��%��p��M�&�(��: �C�1H�;1GvB>X��2�Β� OT���p�lrh-��8�d�!�\$HcOƺ\n�p\"3#n�R��!&{U-���,�>��\n��hcQp�[�8U�\r��cT=��Y�~9m�c��j,rxc\"���/�'C�J�� v���jㄒa*��\$�>��Q�b&&�̵��t���`0O�-U�8�jۓI%�ͬ�>�@\$B�K�>�V9Z��3U�:��{q�cu�5�\n��\$�fe�Ĥq#�k��\"�";break;case"ms":$f="%���(�u0��	�� 3CM�9�*l�p��B\$ 6�Mg3I��mL&�8��i1a�#\\�@a2M�@�Js!FH��s;�MGS\$dX\nFC1��l7ADt�@p0���Q��s7�Va�T4�\"T�LS�5��k�������i9�k��-@e6���Q�@k2�(��)��6ɝ/��fB�k4���S%�A�4�Jr[g��NM�C	�œ��of���s6����!��e9NyCdy�`�#h(�<��H�>�T�k7������r��!&���.7�Np�|+�8z�c�����*v�<��v��hH��7�l��H����\"p��=�x�Íi�t�<(��íBS�V3���#����ÁBRd�+��3��*��B�ʝ�L�ޮc��\"!�P���	�؄;Q�j��i��ꉃzZ��T�3��{1/�c �Ժ���?ì&���\$�bn�>o��;�#��7��T����@X���9�0z\r��8a�^��(\\�Ncs�=�8^��%\"9�xD���k���#3ސ��Hx�!�2(\r+lL��#\n��&��5�C����tF�����'@P��0�\n�T� �(�C˞�ׅ��J�|����R\n%�L��!�`�F��P�d���t��6H���I\$�H�0��l�I|P���)�L��\rë��		Ĭ2���X�9�����K|�r�Z�����9<\rئ(��S~��I#p�/V�ka�\r����B�!���{��K�<Ǚ�I+:ϰY�9�P���{�\\�[�m�\"H�������J�Ūݦ��<�v*3�a�����L�Lr��|��=��>�c��=�1u]A��(���\"�ģX&��\r�Z���o�t���0̶�H����hE�*:�&���|�9n�,��C��ɩj*��i\$�xp��')�P�w�SD��1-�w��]IQz���r��ރHo��!�F���rRolͽ��n�	�R��K��6�T��Tj�;�x ����U��B�BCIiV��C�H]	�?FX�����k�a��6>7���iJ鍇?�0��,=[�l�@\\���SJqO*D�2��*�9*�`�ú���̞2`] km�A�*_0'P�������\$�9%�\\\\V�i���C�7j 62c!�r3��0�c�� uO�\0003R&3�Q\n((��L�rS�7Rt��rB��@�{/��\n (�fA?2�G�ZcI Ce1c�y~��٘+�����ی��(�D��g#܂�F9��t��x��?��w+��U[(�I�Hc'��3���+dtr'H2�(�L�\0C\naH#N��;b��Aa���9@�|�>�|���FQr`�&=�*��(bbfZ�.��9]�h��V�BNbG�8���8�B������R�ɱ�P�N�_U=Q��0�M=��\n>Q0(�%k�'O\\�\"8����9����4'O��t9�=1�WL��*��\r���\nG�M;i�A#(��2�*LTNm呭fY)\$�W��q&�3��ƾ�ܒA<'\0� A\n���ЈB`E�l)(u�I��JH����q5Fkqd,��%�ޛ��O�#���HM�=1�[�4f�{3�!%�Jv��`P�2h�0�oKj��-o��h�D蹰!������ڏ�7��;�t�c��tT��(V:���ef�ٖ�\0�L9�O�S�M���b��\0S�VP5��[@S��������%�iIX4���t*������ʻÂ[}�娆50L���n���Qk�O:ځV13�#Xe��Ԫ	ug�f��Hn��:��{��i���Ol�AYA�:�ǭƸ���=\rv��@r��pcgA\rL��@�.�@�%��h�-��)K㤳[���)uF�d޸t�gz+l�e~B@PRQ���y�g���:r�P�N�yȑF�i��Hg#(�ԭ��v\0r )z��A�y�1\0+_��\0�/'d���\"V�׮�?r|5R�.%Ei,Gi�Ќo��`m\r�LC����|�`��&�L�l�\nA�M�!�#qC8��\$��R��\r�դ~Ά�sP��PX�%5��Ʊ�B::Z���E�Y�<��o�u�*.���a6&�P��!�rV�|K�9\r��q��}Hq�f����\\E.���tr����0i������k�/��g����!��	#)>�U×��'t����[~*s,�oP�#H��u�?��6��]�;��v��Q���^l����{�Hh;�ȓ��1r���%��ګ��/Ut���	v�|=���j\$���Hr��wϧ���~�~*E;!�_�6M�����ಯ������eO�W�����j��wqa�[B�O��g@KЖ������C��kD��������_iB�I@D�\"Ϧ�z�&3�\"2c*.�B�l�B��RcR��{d�9��.b�PՅ�JnǢ�4i�A/����-N�\"pR�B�����-��;e�g�\r/��P�����p�O�\0�PE�c�:ڜ/�	o~IMl(����\n�n���\n����:�v{p� �L:�b�L�9��\rr~CuB�FH:�`B\$l�-f���M�o�\0001����Δ��-������\\;Х\0�b���1,Z��H\0����0@�e�K������c���]1��Z�Rl#:����X��3��έ�_�t!Q��m�\"���&* ��@�#1��J� ʢt���-��� �����'�N� �M*��	�eO8���ӭ11q���\n��\"hQ�/�\"ְ��\$����0%���\"-{!���b�,�mh�Dx;��������h(��^��f�z�Kc��n&B�߅���ݏ�w��E`�`�-����\rꖣG�>\$2�#8��	��B�D�\n���p#-��φ�蚤��v��&����êY��c��\0���Q�h��4J�U\"�5O��'��(���%��f'�[�D���*��2dz2j[�n�fLk���n�2��L���B'��?1���2���6\$��3�N6��[�>��t~#zo�����Ļ8)��r�%fl%�FgS�\0�����\n� ��	��5�c0�܃��t1\r�;�-ӱ3bj ��'/|z��04��;SB�ǘ@�à���w�0��+�����7�꽠";break;case"nl":$f="%���(�n6���Sa��k��3���d����o0���p(�a<M�Sld�e��1�tF'����#y��Nb)̅%!M�уq��tB�����K%FC1��l7AEs->8 4Y�FSY��?,�pQ��i3�M�S`(�e��bF˔�I;ۍ`����0�߰���\n*͍�\nm�m0��K�`�-�Z�&�������.O8�Qh6�w5�����m�9[M��ֿ�5��!uYq���o�Ekq��ȕ5�����u4���.T�@f7�N�R\$�Y���8�C)�6�,ûBю���)ϛ\$�=�b�6�����h9�Øt�jB���ȣ^�K(��H�Ⱦ��X8- �21�b(ïC��,��7 �r��1k�N���,�+rt2�C2�4�e[��������Qk��c��2��P��8c����s_2����Ѥ�1?\0P��\r�bD�Hhԁ����=�j��Ԝ�?ʂ��:,3�ʀ��O\0@=Q�4�Np0��´D�0z4c�r�x�[��\r��Ar�3��^ٶ�,�J(}>ы��94\r ��|���F��ːƍD�[� ���o����+)û\\�X����!�x�x�\"r�:��J585���_�Ӱ��8B#�˂Xޏ̢��%m<���3��7�rY>��r�)����YZD	p�#?��d��L����K��0����p2\"̏�h�2�nLj5��\n3�S�m.f�#V1.H ��\nb��F� �9.�K\"7��t�N?���m�U��P��2;���\r{;�8�0�B��R2\"H�8hks\"\"���^mk��E�ͻ4\0Pי(���VTKI�a���ͩk\$�H�c#t�3�V��C�\nj����¶��Ш.����ް�/�#zүI(��?�X�s3ט3h�ZK�O�d��w���)��􌜂�\$u@��\"Tf�gW�/E�ᑅv�O�	\n�X��ⴟ��O�ك?�@��{�8��}���\0�����P�Șs:&�3(g�IB��\r�BgN��\0AQ*,9*��U��U*�4*�^�U��V��\\õx����XA��0�U@>����2gf����L`��#�[�AV�����\0q�6.?rNrN�3�(�I\"���X����º��B)傅��W��%۸�<�	-�|�J�C�h\r�Ӡ��M*�d�m^�	)���H�c�{\rF\"SU-�r�hq\"_2d1�8M\n!S~qԚ�	;/�`f=�-\$�B��@[M�I�_�~o��(���\$�@z�I�����\0((������ȼ&��|��C�i.E䲠sd���A(fvU�R�E�)&!�u�Ę[f�>[d�\"�dDLс�f�i<)LTʡmMN&����^D\n��\0�F%�(	�EI�-%Ag���Äp\$�����Zs�Tg}G�\"S�|�qn�D)>p�Pìח�]����U\\:Wj0��%\$�r�&/č��d_��Sf����eO\naP��+D��;'����^��h1�𴆒1e�[֏��LI���x]QX2�S2́��D�6�g�)#�x�L���0T�����W\rw�V54�J��e/Զ� �\$V*�'\0� A\n��\0�B`E�l���z�B�+2��_p	TIF�iP��КX1�X���k0m7e�7���j!ru�c�H�}���'\nC[�m���?7�r<�\n	�fW^}\"����T�ܟ,Ӷ��ȇҗ���V�����2,f�#�Y���5R��Y�[����L*wܑ�	�(Ap�_�`h�m� �A��Ep�ޭ�2�^ik#\$2�s��r��A\$7��\nf'��F ��J��u���/#OXD%��=�}:dn�f�p2��\\�Bim@4K��v�f0��r���x����ߗ.���P-ҦL�����1�T�f��o��ސP���+q����7���T\n�!��@C��3\$��EUX�\"�^���[��\na��p\"0eXo!�D(�嫞\\�8���U�A��	�bN\$���\n2�m�,D:	�ll��༸�̻��<�L�'\n��֘�p��Ó5���is���6�t�,)p�jD�k=)(��>HL�Se<��u�k�ˆz��l�Ic�����Cp�+K�a����cI�A� a���R)�	B,eOVPȒDq��f�IBO�P�3�����{�>R� ��ӈ���^�o�C��ۻ�A^��_����K`\$a��㗙њ�(��cCHU3Kd���L��Yv������2FX�z:E��˕	b@.8���߭O�ȼn�-�?a�������=��\rh+��O:s���&�n���\0�\0!f�o`��\0��I�جdJz�>T��Dzl�d筲�p.��v�#(��;\r��MX���\0n��+��`@���\"�Wp[\0�>���`�mF\rk�\r�6p\"^� �6\n�-`؛K\n>ϰKe>!��U�B�2b��k��Fش\"�ֻ���0���ĮË/�0fk��pjդ��c!��-�+�b��:�\"]�����������؃���2��\0Q���������90�o�AQD*�nn���g�P���m��Jid�\$�8F&�\0�\r&�*ۄy�IM��yqEl��f�[mN���6�Q���)1�#q�邞]C�\$���܅5���1���D����!���\$q���n��Qܕ�b���&-\n�M�#r;\"p-��'\"��&l��JK#\rf-h&Âh��E#RJ�jmn#N�����-d1`�׭��'M��O�'-�'��M��҉��)��%D�\$֛��\r�M��(�*�!�z/�6-\$h\nH�-�F�\\��g��	�G�(m�-�+�j!r����҅���\\�*hf�0E�L��1`�(q�A@�\\��k<=&ȥ\"j��H5	��o\"1C.	��AH�*\0�\n���q(~8�p�NR�&C�\$�*!�<#a^��.̳�C���8S��OR ��bke�(�[�\0ԱXqBd��4f�+� =͞\"\0O<\0��4U3ı\"Q� j����Ub�&G�Ԫ_?\r��r.\$F?��bb��C(\"`�{�F�L�7��.B`�0�:�#����Bc�6�{��)ю��9T,OQBCB�<!r�%F�(S�A�(8-�\ngr���v��d�pKƤ���Ҥ+HfLj��\n�*q.���]\$���`!�m0'r\\�&���M��LT�4���\0;	�Cf�f5��\n,XIT�7m�bTC\0���D2���K�\nۂ�7�`�\"2;�/bF";break;case"no":$f="%���(�u7��I��6NgHY��p�&�p(�a5��&ө�@t��N�H�n&�\\�FSa�e9�2t�2��Y	�'8�C!�X�0��cA��n8����!�	\r���࣡��\n7��&sI��lM�z��b�'ґ��k��fY\\2q��NF%�D�L7;��g+��0�Y��'���q�H�������16:]�4�0�g���ۈ��Hr:M��q��t������醡B�����傽J�G���\n!����n7��S���:D0�LQ(Y��e��9�3�^����;�#\":+(#pص�a\0��\rmH@0��j��&���i�#M|:	�(���(@�\$�H�����-�L܉� �;'��2��\"��B	��<��<��;9G����p�7B�����7Nc|���p�!Cs�69�h ��jڤ���@� �����c��\$K�&��Ϛl�H�4\r㫞0����`@RBf3�Е��t��L1��9�H��!}%JC ^'a�ڴ�kh̴�I@�7�x�@�|2K�P�� ���:����5���2��հ�6Cb�'.+\n��7-�:\n��p�7�� �X�65�P�\$�2��WS ��z�5�x �ǌ�0�:��x췎�6�P��\$#U�%#n	��b��&��;-,���&�x���5R0Xc&���\"'��h\$2c\$����\\Ah�1�l�&�^���SN8!@R\"�[�[�B��̂\rcP��Bz.˿{n�0˯��9�ۀ��[K����#l��0\"*C�����i��!g�v�g��I��/j�L�&�#͋c����v43ڣ/NC�48��˺�ڴ�t��qZs����(7\$VF&(ȣ�y���`Z4&�r,ѽ*3�Z�0���\r�xA4\\�C�?P6(M�g�KF7+n0���쪔pe��Ъ��7��q���T\r�ѫ�rT	�N\n��)`��qIS\0�M1:�â�Tj�S���r�\r�����>���v�2:0��k9�86\0�s�h z)&��t��\r���\$�j�@������Sp�P*%H����N0�V�%^�^+�y0�\\�P�^�q8vhI�Soݬ4Ơ3��`kj\0L�L��X���t&���ӈ���o��2/�i���O��D�B�Hr�ȝx�����Ro�6?D�P�J�\$�9�R�4�\r%��\"�P�r�1�Հ�b�\ri��B�JG��-�0�f!�PN�L\\E�q��]�5ጔ(\$TwK���O�F��oM�ܿ@`�CaPI���*ȓ\"\r҄��F��O��E���r�@HZ���Ch}fd痉w/ؙ6�����Fz�����`�TPo�X0�B!M�V(���3bӃ14e(P���&��>�/Bs��Z�ˉ/t�������Z�8���i&�p��� ƛ=b4ht1�JD�*�6,����O .���b����R�̜�r^LI�݊&����\\Z֭	yE���)�`Ly^\rn���tVEЕx'!M���5-VҐ�P(\"���Ĉ.�����PB3\r�����Pg�Ajea<'\0� A\n���ЈB`E�l	~&���WT�y�Y,_Vqoc����4�~�\r�RӇ�}R/͹u���?�	kP��7����\\'!��P�vH�Uck-�f��܅z�����l��Y�\n˪a�ĔlV���D�9Рt�m� ��fm̵N�!t9鐂l_�<�\"�´c���+�.��Hz`.��@��xD=�]0����C`u~���2��c���v���GH�Θh/)/��r�[�S'�4Z�	�& ƒ��6�����`�i˃j93��=]��-!��!���H@PC&g�_��Z�)H7ZR�#֌���(�(��`�\$k�(-\0���*|k���IGB��v:���C�t��Aa VRp��y���� f<H�7��O�l\\�/)��ņE�wi�	s�(��!�xO	j[v�&����\0'y�����ߛ�/�>)x#�8�5�L�\nI�����kG����&;�%���8���g��R\r!���\$j(➒\nO�a�������iI,����pm�P0!\\2�+�mv��/��^�2+^5\$��F|�g\\.!斕����&�m�XC\0Ng�\nYx�����s5Ӌ!פ�_c����A�]JOw��W>5/8�f���V�h<iy��)]��ҌJ��D������%����x��V�y^m+U�u˖�3�Ao�_s�Xoc��E�w[�Ck�lW���:��7�����O���\r�/���)�����+�	�C��W�}O+�L�\nm������������O��@��؉��\r��-��e̓�N�+0No*�`�����\"\r.������p)o�����m4&�\0�U@��MO�\":	mzkl}m �˺)),5& �JD�>&\0R��P�n&�-��p�zƵ �R�X�OvfC�b\"�&cF�І(b�(�f'�WpZ.\r�~����k��вXf�Y�\0Bs�P� ��0���-\r�N������O�\";	�{�\"�n���&���0�� �6#�;a��J%���h\r�D�%/.:�*M)�n�رu\0q2��}���>#&@����IP=�l��`'n��<ѕQ�;�</Ѣ��Z��I#(��CQw��\rq��G�L�%�&���Q�r���`�E�I.��A�N�1�0���mL��\$���5l���C!�&��ʙ�*)\r�Ӡ���#�\0�ԍ�26'*C#�N���x�P9��%�&r_ q� ���R:�9�|F`�EƎ�\$2`\$�,1	R��H��1<i�0�� ��R'\0(:ਲ਼�\"z��h�L>�����Wr��\0)\$)-�<	e�E�,��a��-��;M�!�\$��6���\0�F �`�Ab\n������C�\0���f<C�I2���\n����c�\r�Z#��BFq��15�p�(��p�)lVc���񼴭h:���B3�9\0Zh��3Q3C\\5�V�ʂ6�D�6#�\rC�+�y�	]-|���%��o���Q��kG�s|Cs��2�q==.�%�����,���6d7��n�s�\"�P2LB��7�ҁl� ����4�C䱂<\r��:�9��CCDF<-F�;N���a-����-�IF�!��-���b�@#�M��?��!M�2qt�O�H&_@����J ����,D\\�\"\"L��-�(E�^!@�";break;case"pl":$f="%���(�g9MƓ(��l4�΢劂7�!fSi����̢�Q4�k9�M�a�� ;�\r���m���D\"B�dJs!I\n��0@i9�#f�(@\nFC1��l7AD3��5/8N��x�p:�L���� =M0�Q\nk�m��!�y:M@�!��a�ݤ���hr20�gy&*�u8Blp�*@d��o�3Q�xe5^of�!h�p�[�73q�����i���y7pB\r�H�L���>\r���y\r�+ry;¡�������\\�b��@�t0�.��\"�D)�*a=K��S�����拎�;��A*�7�N@@�n)� �2�����M�����t'��5B�:����p�6�n3޵��藴�򂊌r�7�K�җP�)���#��|h:K�*#��\n0	�65� P��?-H��6F�N�?.Ȉ[�\$AH�޺���\rP�7��H�4��¹9�2�cU\n ���69?���;��+C��M�����pA�cX�x�ƌ��D4���9�Ax^;ׁp�H��\\7�C8^���P�;؃ ^'��b�mB�7�\"V�\r!�^0���0#��)ʃ����-Pʈ6�J�,#���n�\n-^L��6P�t��1�x�	�LH���\\���\0�:8�\$�⸌ω�C�%��df�J��?)a���#�z�����̫�z��#�zb���@6���[0��B0�7\rm\"� ��çIc���C8�=!��ؘ��]���iX��>��&\r+���@��y�����rɹ��2V3�)\rètH9�#��_�K��;Hh�(��P�:�V��/]��3�8�	?s��� ��9;��4��}Va%�Q�@���0�̌,���sx�/NX�\$��.t�B*Q�l�o2Y�W�\n!�������9�>��~\r�KMV�#��92C�Gc 1����}�|)��0ҁ���~��2aI W\"�	����ȃ0>b�ވC�#�.2�X\"�@Sl)&�6%C£�<R��37C�P\$B�\\gС#a�ҪC2d��2H�iUH~,��h�(��^Ŕ�.9\0��p�O�<Tg�#��r�^�\$D��\n1�EF(�����;��r2E�:�˜b���4��;.�	ő����-!��\"5ÐD�c@��\nǂ��#����UZ�Ղ�V��\\+�xe��K\rb�p��.��3��|h��0�&�Køyp\n�U��dp��i�E��>���N�0r.�\\!�3���X��\n�V��\\��{*V�X�dP��Cr���A���C��)�K~y��q�|����D\$O�YzKe%޾�0CIqGd\\����B�yL)*Y7^�a���@\$HW�B��#��0M�!�)4ZJ�t�;DM�%�����1?��C��r�)�2��A�4���j�\r�\n���Y���A	��>HK������4|��l�5Y�P(�A?*V�E6�/C@��ЧރBt���p�*5u?��2ΌHc�&!�;%�CjIs�3JD��D���`a�����d4BKݩ������/�����T/OQ��>����[\$l��\$�q��@R��8�jf\n�B�d9>P��K|�w�:����9%d���!A�A�e\"���\$�2H�-�\"\nV`�ɻE!SuPIR3���&'LE?!�5��ROT�\r\r�qFM��\\�v��|��;��\nY���8L���[��p�Wи/&�@����\$1���y�A��І��\"i��L|�z�b �B\n�4�9&�f��xF\n�q�1�=�`!����EY���,�l�#iI;�\n���~N͚{ ٱ,��&ZZ\\5}Ʉ'���#6���r��\$n	�T�ÃT0�Ԓ�8u\r�Pp�|�y��.��'yi�\",ȹ�Ԃ�F�\\����v�{'�q[�e\"�/<��*y�Io���9�'^��\$[�%!�`޵C��s�5s��AB�#���8�!�}'��/���k��� �>�	����d2f�Kf���z]�1��ߐiG�(��:X��� ��Y�b�[�G��K�B�����j�YR��^�05���2!K[�^��ߝ�6�,��_}]s�\r\\�4���Ȑ���_���J�.c%�N�\rw�u�ay�\ry|��j���l���{�ɁZ��~��	�y����bS�Mh��B���pu���#-�Y��y��ex�f��{�\n0葇B�:��N	}0�� �T\n�!��	@��w^�ǙX&�t��᧌�`^SسY�d��}��2H���<i�U��؍�\\]-0����B7��\\Q��g���D4/��Ha�_)�������8��ȟ�l���b>�S�MZ���>k��_��>��9[�9��/��O��B|���������/�\0��\0�:�\nb0f�m�j`������\$ ���6'K�I���)�� �֓N^(���pVD���#�JJ��25Ĩ+�V�����'`�>a2���\\�x'�b&�䁐�6��م�J��&�y��l�`7@�).\"ߏ���Z�d&;�Q/�LP�.�\"�]`�%����\$��`ͽ\r�9�J\$��/b^�*&����JA�i��I���%���B^eŘ=O����%��]�q	�4	,gt&��9���>�.'��\n�8�qG\"=�6!�b[�H���箊%1l��ĲZ�~� �\r�:C\0\r�Nd@�:��Ѱ�Ў\\\n�rif�D���N��̆�wM\n�q�1���\rlOC�1(Bg0X���Mq��\ngj���\r��� NBv�q-\n�����#`��������!�+��JR\0�ϲ������#���r3\$b��RM�S/�29%�'�C&2I&���o&ˮ��,\rP�׬K\r,�#.�Lk\"��\"�k)�)R��.�����2N���L4�O���1��B�tkж��C�2��hp�~-Vh�b#`�EI�p脄+�-\$�Z�؉��?�-�ق6B��!�`DfƬn)�����6��]���2���Ս&:�.b1�['�1�`�s\\�ҭ���_5����A+�!\0�uκ!�|�\n�K���#2��`�h6�0�C�f��9ӯ8Q0�N�Ӡ�;b6뇪�3�;m�G��n��d6c�7��mN4�8s�9�h�ؠ�FRL��2w#�a����4\r72� #�g@�;���gP�Ƙ�N�_�3A�fP��zg�CODS�z�?B@�_g�jd�	@�Ic\$@�4�)��Q2F�2��!�G��F�qAұ�T�G�QD�aG�nĆJ�A(�J���\r4�/3�-��>�G3u�yL��L�.�L��K�/C�<��9n�;.�6R�K��t��һ+�O\"YPRB�/Ii��nDm�Q��b�AC�=\"�\n��x�#J�w)�ISD*xi�/P�CSuK+�A��UFqb�@�&;�%/Ĭ�%�35W��D�!P��1�V�.��ba=�#X��YU���c�3ty�,�ü^N^D��\r+��-���(��嚍�g(�o]RN�U��r�+d�\r�V�b\"��`���\"�0�C�'��&�0̴ǵ�1�\"�,'�Gbb��\n���ZH���P`��J�ȩc�!)q��>y,�VVF�p°S���A`������D�J�h��!3(�j���<0���`g�TLl�\$�'c�[��rNn�\$;1Jo�რ�E�5-�\n��]d��0#�=5b�÷4&�*¼\r莙�)�����+Ǽ#i�V�nB&�`����d�M/wP�~l��p�#qÚ^��6�<�tj렳йm�IhF�O��6LH..FsX�ѐHL�d*�^@�v\"�m�|L�����\n�za\$��Ny��3K(FX���y���W����0u�#hT4�Cd�T-�z�8fN6�%��s�iI��-d身���	�r��|AC�#`";break;case"pt":$f="%���(��Q��5H��o9��jӱ�� 2��Ɠ	�A\n3Lf�)��o��i��h�Xj���\n2H\$RI4* ��R�4�K'��,��t2�D\0���d3\rF�q��Te6�\"��P=Gࣱ��i7���#I��n0� Ը�:�a:LQc	�RM7�\r2tI7��k�&�i��#-ڟ��M�Q���Hٳ:e9������a�l���])#�c�s�+�Î�,��q��X̸�����q9W|��=�:I�E==��\n\"�&�|q'o����<qT�k7�����N9%\"#p�0�(@��\rH�6�z·0���H���3O��@:��;\n����Z�*\n��'�\0ԙ���R��Cj̈P�&��cȒ�����錮0���\n8�\r({c!�#pҜ�#�,�9�RҜ��Cf�Ha\0���3o.<k272 ҄��#Lƹ�)|�6M3|p\"���ʰ.sӒ��S� ��j�@�|��c���cƲ�/2�0#�;�#�`:Ӱ�#	�C X�����D4���9�Ax^;؁t�I\r�0\\���z2��`2��&��@��˚Z�9��^0��H����Mp�)�21xՃ�|1S�j||�i��<7��'\r�%�͘+����3��(�Cʠ���4�Hx�:�����l��1�p��e-�@ Տ�f�k��2�C�����s��S���#���ӥ�(���w�8�Cf�J\r�{�	��2�Hy{`���h���	RX�&�d������ZH؋ԭrƍ�B\\����&L����_h��P7r�`H�a��\"過|�~\"�#����<��7r�V�4��b�	#l���(�۱��8�T�\$r!=/N3�lp��l;ֶ�8:^��\\�?��q\\�O�9������(\r����,�}y���1oߊ=�n���u��Vֿ�+?8�����0f=K\$��B̲I�\"'\\*�bK��2!�O�\0��� k��ȫ3�Cg/���Ր�((`�sA��T�6�,���@�A*4��ح�<�U�Y�Y��\"�Ԣ�4��]+�|���H�4\0�pn��.���d7���X&e�hp\$�0�4�PۚP��԰�aa®BHP��#8�U�����^�����*ǋ�,9,՞�by�Z�]ڇ\\�_;�y�D�1vdKCZU\$:��2	HA60H�5�EKQg8��ШIc���T7�0���r��ً�� a�?�^��P���>�زHy^Gc� �X4#	0D��N#!�:�G9�a�\n ( �xm͈(( �y�D`b��KDT6���L�TL�ջ\0�k�9�!�q�0X���:d��M����Qw���xIѼQ�D������Pn\n�A-9�n��.��c͒�P�Q%A�T���F�ԌP�RP!9\$�o3�:\\#�,��(�#���&DЛ:�c]����T���SK)�K��!r<��Q�Dm��MKh(��Ln͉�ke=�r����?�����To�B�<)�EIY�k�]��3��ܐ�K�Դ��zKIy\n�5��gPI�����,7>F�H+����ڵԄ��up���\rT�\0F\n�����҃�Xf��9T\0�\r16,�Q�AY�{�g0��P�*[�{� E	���Y��K\$G�\"��`�GF�FǄ���`L/hpj\r4�4e�C���dԛ����>,��]�!��0i	)D]�ꓺ�}Dj�VR꒻�K�`�C�\rZ*�98�ʧ}��:G���Vנ�8\n�\\��S0�L	9AX�N�PAԢ7�����t��%���z>��]m9&������^TQ�|A�0��`��\ni�&�'m�E*�\$�o��`o�,^OXHAC�fD�:<WER�9���phF.F�(w�fa������(U1�\0��#m9\"d`Ƒ�'�U�.�D6��]ˎ�1�;��xP5�%י{����+��Ⳓ@��Vâ!Ȃ�̄�7fu�t�a6�+VḮE�pB&m���7ũ��T9��dg?��{8��*�[.�&XE4�=���x���?c����גf\r�b���퓙��M]*�:+>LgyA\n��Ew�A��h�yf:�W�9ib��iֈ!�5Dw�5WpJX�N�\$8�~eգ��?��������}t��8�lY�c0=����q[Z�Ad�;�Y:�I�'����|�u��i�E�\$3�/#�!Gu9�H�cr򕸏p��s���7��ּ�э�	ܳ%�x`�Pm'���P��0�tg9����b��{ѽ!�c�^5�yO4İ�Xg9y�p���W��==��W�Ϙ�����n�Ϲ�a��\0(��|�^K�	5i2C�IÃ�-x��-΢c��D���i�.,�k�8 �n�&����@d�p@�~¤� ��UM��d@2 �f�./�d-r��^�\$D�o���o�d3b2J#g(�N�s�Ȑt���H��^�h�gLD&^�Ўx�C��-�m���B���6�l���l�%\n�b�в�nyCc�,�͠���(���o\ncP�F'�_o���^-���d9fF/r#�##��Ü?)n3C�nDlbn6D�\r�fHp�/�LC���t#�,N�dL���!NXfEp,�2]KGM���������w#���\"�l*��d����\n�\"S��ǐ����Gqn�0#��O��O��&/�Q������B<��H���e�&h��&Ā��]d�Qq�>	<烊ߪ�&���Bƨ:r�p��(� R��籁\"<i\"�\0�*r,0��a̎��#RC#��(N�C�y0��k�F\\#��q�& �&rj,q�'%�&RiR��sK(R{�)2w(b8 ���o�*��0��s1,d�J9Ҽ���4�F0q��K�*�\r�,�c,Ǭg�a-m���ܘ�l͹-p4�/0���.��*�(\n��#ѕ!�0�&�2�0��M�h�=2\0��b��1� ��%�sQ�\"�:��L��4S=4Ҳ@�0��Ѡ��~����I;!C�c���������)!\"\"�S}��f�]�c�6c/O�1�:U#5\rMD�E��N��&c�\r�V���kq���A(�E�!RV#�B:O� Zk�Voǜ�����\n���qFr1F&���+�����r}K���/�~J����\n�3(To�ϒ6/�ύ����ף��(�c�4���0�:%-\"��u��E�<�&hHG�F~&�X�'�Q�a�2Df\ne��\0QH�*hQ�cH��.bX������5�c\r��9h��Qx-C4��3B�}��4�\rK���RS�-t�9Q�0�\\s`�}���q������J�'[P�bN�@,��Z#�!F��8�T��D�N-\\˂�r%/�1ė=�0�IDC����P}����9V\0�.��(2�'�ʢ+OGA\0004��M��SJ�";break;case"pt-br":$f="%���(��Q��5H��o9��jӱ�� 2��Ɠ	�A\n��N����\\\n*M�q�ma�O�l(� 9H������m4�\r3x\\4Js!I�3��@n�B��3���'���h5\r��QX�ca��ch��>��#�Q��z4��F��i7M�j�b�l��LQc	�NE2Pc��I��>4����1��e�������!',�΢A�+O�_cf���k�NC\rZ�h�bL[I9Ov�q���Ÿ�n�����D�,���\\�(���ǵGM7k]�3���c/_4Iț�`���&U7���094ÒN\"7�S���`: ��9A��9���ȓ��@35���˄�V7����2�k(�R���Rbγ�:]\r�� �@�j\\9.��� �\0���Ф2��(#���ھ�\"�҇��h��(h��7#��\$/.�<�H\"�|�����1�2K����P�Đ@��+� 3B`޿���~�#*� ��\0ܟD�|������Ʒ�/@@0Đ(�<�\n\\:�(t'\n�C X�\0����D4���9�Ax^;�t�G'�r�3���_	\"5`��J8|��N��3/�Z�燁x�8�`Ƽ�(�y>Bj �:���T�6*�\0@��HM�zݭ-�y	�z�%��\"�+��t�� @1*�����lcx�:�)D��c1ˡ2/L���dC� ��b�k�������t��\\n{&#c�Ob�`ӡh�(��w�&�0I 6,�'ը�'&�����I�bh���JV����<eT^�}hb.�n��1�����!B��&LS�>�[& މ�;�mCtq�<�jO��*rc�+ ���s��d=]ZH4��b��#m0Ɉ��^�r��=�1�P�s��	q\\���\r��X�M�x��e?\0#ͻo��@�c6��x���|xl��=L��|h�&��L5�����r|��ƁW�4Եh��0f\r�\0��c2Jy/%���`�Ͱs��5E�y䁁�3������U�0RqC	7�<� ��dM�'\n����u�G���Q�9*�be��V&�Z+ep���X�a(���:�\r������>����=��DL)Se=�^���#�Y���@~˳)��4ƯUT�P���f��eU��Wj�_���0rY)������є��ҎC�.a̩��wJ\n_P�<�St_\r�2����k�q�5���\"o�A�SQ\\*V�%7G,80�h옠��d^>%K&M�v%Gu��ӠGc� �p4#9��yN��P\"S���@\$��0((ऌTfdC�*P�w�������'PmXr�6�J)��a'>\n\$4�����Q����Q.V���HH��i�������R<�s��C�/��`I��P�\n��O���FZ�lP��L�:�*a3VHl#����D��u�wI�2&����伡�BO���:��\$�z�G'�D�y5H����Fd��6扩T6i�l;��D�6��\$��BA��\0�¢�:�䕿4�B�:@\r�4��r#�%���>�QRS���J�s��gi�b����[�q�j����J߂b��܎\0�'q�;�y��wDU1�ZEQ1�%�22Vbܢ��	�8P�T�^�@�-� �IP��6�X\n9O3���1E&+f%�����+TY�g����1fLɪ�`JAMU�%u��\r!�%&f��\\�z�QJP �.;�`�T������<=��\";v�-<b�.A_��q���Av��G\$T�;��vB�>_\$(����oR)ePM�;'qGJ\n�FbMr�b/,�����)hk蔘����nĬ���vh\nLQx�@����s����\"\\2s��x�[��zf3hz�l2�r�g��(1N����\r�\0\nb6͆�8��Q\"z�W���hR�0������ w\\�������z\0005�W.t�n�!�5����`r ��D��	�\n\nt�`v.	�gQ0T�mS�\n�F[&�%��):�.�vG�{\$QaP*�R/�)�We,�(��@(��Ľ�e�&\ni���ɜ�l���S�\n�2��:h�! Ƕ˂��yF]���]ȹ��K��'�m8�ngo�� nxGI;���/ʚo=T�\0sH�ͺ�'f�\\۹�����e6�q�M6�c�G,P-�`�Ad��:����[�u�����Wii\0��)BH@̩���E�8� G��eO��w�\nY:\$����ޒc[I�<����攛�Ga!3����s4�n��P���A`�o��i�I3W�<~�|Szt�rҿ�s��1��3T ��c>&0\"͌���������}�G�~�nJ�z�����I�*3Y!�#nB@�F�=CL�.���#��k�pܬ�/O�/�.	�n�mhAHn%O�qN�c��mf�D�q\0�/�L\r��c`�2�:�J/O�oMZ���Lz�,\\�\0��O��K��4C�G,g0�ů�d�90wp{䀣πw�>T��8毕AO�	н\n�=/�0O��-�%C&\nM�0t��||���>�o�������0���6������5팳M�P}Q1ث��\0ʌ��q0�1؊��	����cF81��K?�F*�vO\"*-����rbj-f>U䚖�D!a[b0O�u��X�C�9��n�h'�2\\k/�*d�3)���q.^Oе����C\"���M���O ��9q5	/��\r1 �1�0���<���p��I9p��0� �����j�!QE	�]Q��è�%d1!�22��g��hc�Qb��&����p�=.+ к���Q2��9%���F)Q�#�&*&��Ȃ�I�i#�(*0c7(��e\"�J�Fq�����yB���MBD- ���&rs+��R¸�y	����-�Rq'�\$���-\$� /.��R�!lc&r��?\"0�ץ�(B)�m�m�5�P1b2D�\n'�.�͙2Co2��N#2\0�3�Y2����31\r�ْ����,l�0`�5�!.PA6Si(��o�1�6b��-o�7\"P4#\r��NN\"�6ʼ�ĩ�m\n�9��0�*	\r\0&�:{(^�)%)4b�����^��B���\"0�/�==�� �j��a�fT:�'�a��-��S�b��2ψH��~���\r�V���jB\r��Z�*�4�l�:����\$�D}������\n���qfb2-��0��/��N��������i�4�6!B!� \"I�\"�.Ʀ|����ă\"�*3�1�� ��=��(O���?#�2P���\r�*o27�<�����OC��m\rF��\nbP��at^�hîr���%&�#o4�>��c��D��P��:-�jM��G�AQ=3Ü�n#PԢ1�-��=��F�6�6�*\r��(B��S3Q�lD?MP�)�QQ\$�MElD����oS�\\I�:BF�!F��EJ�,�4�Dj�`��&�\"�4#�c�3D�D56u2e��@���G�.�&2����/��-��/\r�cy\$~���������";break;case"ro":$f="%���(�uM����0���r1�DcK!2i2����a�	!;HE��4v?!��\r���a2M'1\0�@%9��d��t�ˤ!�e���ұ`(`1ƃQ��p9Φ㡕��4�\r&s��Q��Fsy�o9Z�&�\rن�7F�h�&2l��A��H:LFSa�VE2l�H�(�n9�L������f;̄�+,�����o�^NƜ��� :n�N,�h��2YYYN�)�Xy�3�XA����K�׬e��NZ>����A���#\r�����y۳q��LYN[�Q2l��Bz2�B��5��x���#�𕈌S\$0�!\0�7��J������;�\"V#.�x掭��/qp�6�������JҠD�R`�*	���0�P��.B,�Դ����?JD���229#�\n�H��/q�),���#��x�2��h2���J�`�¸+��#�j\$-4�.ύ���/\0P���!0�3�@���Ή�x��ÂB���*�Έ)������y\r �<9)\n�9�o�BL*;�CCe\\��H9�`@#CC�3��:����x�o���uT�Ar�3��P_זX��J\0|6�	2�3/	��퇁x�9���1:�d�#�*:E1-���7�(�*��c��=UOɇ�#N&�2cbF/�X���K�Ҋ�ܽ��(J2~:9�k�,�H!�#�������H럼h�ƍ(t��3� �3j#b�;/��)�X#�#,c{�#;�Q�y�,�T����?���[��ƴ������3����c�ѳ-	�\r�#\"1G-^���\"`@8�Ð�o#���n���\r8�����c�uV�P������	�I�x�u�*�=���t��&|\$����ǝ�`�O&�J|4v�SB��O@�&C��g�7�Ƈ�L���S\0�~��]�yhr8�<�|O��1H	@���L��:/�R���ڪEgl9���Q�#Z@(ؐ�H�C0fOʤ����G�hT\r��T�\\h�cWa�3ب�z�N��0�4c\0���!��0RP�� \$`�3O�1+\n�����S30\n�q��v��)�@-&��V��[kuo�u«�\"�?k�7�._�u@�;��`���V&&��4|�ʀpKF)g ��A�v:с���fL*%a5\n���Q*:zIh���V�h[in-����z�\\��t��y���y��ʧ2���2N���ײ T�	��\n���u���`�u��/���'�BSi;`�b9�IWNl�0�i<c�������C�9���E����CI}���A�E-�(�,���o�/e��A{5�wa\0��уr��*�c1`�n�4y�Y��r�PT�QL	F�� K�!��5B�3j��h��w�x�Q<#A��X�`N:�\r�5,�B�C�&E�k�y�����%a)� �p|�0)Y�%2lN���iԒ�Q\$D���R�ȓ&5�蝡�_[�1_�?	M'Qx1&��M�\r,�Z�1NA<<nr���B�䱫�1�t*q�J!7�l��LB�O\naR���,቙��P���ZI�i!��T�N��zE�)���^�`l5��+4x�	)G�ݗ�p�8W�>G�72RQɻ#A*g�S�C�(�kNIÑ)\\����\"�P!ڧ����E,��c�}a�~��mj�8���UK>I�Ҟ]d��Y�Lpn\0�Ɣ�P	����X&�i.c�Z�\\rG��D���0�ùx��ŗ����%E�4��)�B,YHiĆ� `�ˮS�P�f[�K)�H�i�3b�e�Vi&I�4��\\������<� �(��PI/i��^l����A�1�V���F\r�&I�(60ўlCP�C�~I	�T\$���E=�+z�Ic8���{;W��I�8^K�զ�2�t�m�,��*i��g�9��֜�Y�[Y�c��k��XKl�4��7�p�N�4����C��	�}�t!����+�ɉ{{�����n#�A���fu��g�4p��օ��)P��Cc�u�23���ҥ��mEi��QC&�Jdm��rs�E%,�_f�=��6O��\r��C	mΒ\n�R,�C��#��2h�f5�V��>6h�V56	�3�i`[�Kg�E����ۀtY��2sDL�Cj�\0��H{0x�G���j�r\\�[����c�&����n���+g]S����|�e�������ٗ�^APWB����d�}��ð��!�bdc�^� M@����n\$!:0%�\n�>EM�TK��sc�(vko�� ���������F�S�G�Q��g崋s:f+�e8.�����*E�EYhL���ｈn��*�'ΰ\$����/�у�|��)�\$.�M�&0���C6�n��o.N�\$�\"��6�`�çz�DdF|J���K�����b�j�L�.M\"��lUPF���`fz��|Rd�NlNڣ���G&����n����&\"��P���/#�Pƀd@�4\0dC�p�,L��dJ@<)�\r�.�,б0������SK�\r̲�0�9\0BWlġ�޻#�װ���7�	�=��v��F����&qA�)�#O\n���T�*: �/:�0���a������:�1נ���ͮQ���n�5̯1<S����~��Bhc�1\"��ާ���Q/	�e�\r����@����I�--�!*�:��`@��>J���PڇC���;�1g^Q��5���F:ð���J���U*|�\0�q���\r�4��d*�;M��Ln���!\0�hC:M��i=05�Db�Hpј��G�% ��F4j1�w�b�T�f��ETp���!%��2�g(Bх�7(hc2�pm�F�7�).jz��GR�N��(��, �aDH��fn#�<Ҿ� ���^t������\$���%��/w/rL�0W0Ro�#I���aҴ=1u0�m'C҆�(��q2���)\"H}b�B�g��cBnf,��Aw/�%J�4�S5a75�_̙6sP`sm7aq	1��6�|UO�s]3s�7�U96\"ӖL�A6�(�8�6��+,&��;0T6�}\r(��TB�fT�L��\rs�'�'=b�Ls�<��6���kYjd@I<v��N���D�:Ҍ�k�-l3*q�\$�@�)��3���B��O�C�6L��z�,�\nO�P4!/��\n�P�W3	+N�� �u`�B����\r/C:\nN�����<@�m�\\mgS&��j��Hh���UL�hnU#�d��2\"Hfd�J�Y)�N:���2ԣL�gJ�|�#^g��\r�V��=>O�7�#�T��\$E~���H\$r\r��)&��@\n���Z;I0�\$f��&h��p��4�U8�,��!�\"�����0d�v'>M�0G�<4n0YOɴ��9FP��h<��T\$��8\"�\0A4�=:Av��>�%��Z&`RHzM \$d�&d���&u�1FG\"�	T�|�O�6����]\"�QI�α5����8d5�3�˲*2�x6�m>�ܵ��S�\\�s ry&f2�F~j*6ǐLL��f�J�I��c��c�\np|#��D0~�J�Q&K��H�`	��af0:'�N�����/�v��DF��3Ӓ��G�kGV̰�i�h�|@��@�	4��9�Mӗ/�!O�;MB\$��c 	\0�@�	�t\n`�";break;case"ru":$f="%���)��h-D\rAh�X4m�E�Fx�Af�@C#m�E��#���i{��a2��f�A����ZH�^GWq�����h.ah��h�h�)-�I��hyL�%0q �)̅9h(��H�R��D��L��D���)������C��f4����%G��f�\nb֬����{�R\r%��m��5!s��,kP�tv_�h�n��]�#���Pօ'[��\$����!&�c��h��K'FA�IE\$�e�6�jl��l�Ѭ�2\"��\\횩m�K�V�7�ťs6����P���h��NC�h@���zP�<�������l�:\n�,��c��;�j�A0����p�9m��#)��Đ��~ZĎc(��1^���Ӕ�0�7Ϛ8�Ū��G�H���E� �*��8�C��`�*�c�	���.��.���8��0�	��9�\"\\�ҫZ��H��8M���\"�?>jRʴ��vȚ��k���K�L���d� ģ��EQc*�\$|z��2�qR��*JC���<h����|�5�����J~͑o\"ء�(��S�ς�Z9Ԫ�#A	��� ��Y*W�z�i8���(vI>��6�\r.����ר��O�OJ/=N�9w#П4�# �4��(����B5'�k�֢��D_�E�R���s/C\rS,[�Ӆ�G��\0x0�@�2���D4���9�Ax^;�pÇb�\\7�C8^2��x�0�c���xD���M�F*+�~�%H����2~\\�x�-|�%H&����R��ũD��	p�v,Q׊z��ֳ��9�@����7&��I����K�.��Qi��P�/U�(ɑ�	0�v\nK�����b�=�՟�-O�zhKb��?I���x��N�p�&RӋ3yRR�Fr��h�q̷\$J+�d�)#�;��R\$Iz{�>u����Yf���j���[��9漱��J(�n�d<��JK\\��J\$���P+�l����\r�R6�����`��Q[01��#Yd+�]\"�pv؋AL(��Zu\\I�\"����zHDZK'�)9U��[�A�/�J�8�p�L�D��hM�s�t�r��m�4�jS�i�LK�-7g\r3�Y��v� �0��I�\0�IE.^��l�\$@�)��y�Yed�UmB�dZ��&�L���rɒlm����9BBA�N(�U������-#@X��d�?7'zK�psϤ�Q'aU�T�0O��Q���	���`tI�Ґ�ț��e��!6�U��\$F�e+�b�J��pQ2�)�q1%�)�h������)ҥɔ4;�-鸦X�\n�� A���gdŁnO3�Cg�Y�K0��\$Y9M�.�E��T����>�D��#�VY�*Ҕ�QtFgp��t�OZ@q��t�k�~�z\0,)Tv8�����Lg�顋z��\nuD��3���%u��;?�a���YEf�Ǖ0�8<e�̅0��C�1ID\\�G�`�68�p�s��H�3f�ݜ��z��Ch�����Ӛ�/��7�m#Zk��KG�j�]d�?�B:��gNr��Q�!Dr\n��f5��>J^�!�C��@��Z	ܱ]d��� �S}�4��3fpΙ�>h\r	�v��,Ki�=��P��s�\rE��6�oL�/'�:��k<����C�X-VYrE&��A4�ED|s)�������_��A���M��C��˖�M\nm�;53� \"ɿ��E�ʌ�)�du�-Y��v�!˙*ntbd�ƫ|���59����|%DKA�<v\r���Di�\"@,x��z�|��-�{*(�3�1N�=��D�l#UJ���\0C���o�ǚ��Ad���2�d����1���M��m1H��\"�?(�����D�����%�^�zaK�@�;��S��8�M4՝������\"�2�%`�%E|�h�Al�#���ZW-b�9bf��\0�!�0��m%KGƨ�ȂsvA]lռ�f\$T9��m]������m	⬚�9�&}d.�[���B��}˴�-c�F��?���Uy�4�>�rZn�2�\\�Y�>�m����~�~i6����A�.�����j�do��%s�H�� �(�!���5E��3U�F���PQT�|r_%2M H�c�����k#���8�����3&�l5���c��L�nS�Ƥ��[��]QM��_!��%E���0@��PU'U�h};� zq;�,�fAnɢP<��z�lU1qzN�Պ��q��1��<�aV}�~Εc�=	^�TdoPc�ׅ�,	����u����b���)v�Ft�#H�M�ZQ�z������Q��d�ǋr\r�S?XNQ��\"���\\�y��9Χ�,�G��>ē&G鿙;��d�&����dƮ)�o\"�FԷ�dw��Ug(W(D�:��_c(���h	nȀ�	\0��)�ʬ�Gi�,��V�|���@t���k�fF��ӯ<��Lq�FŔ?g2�0j+H���i��nG�G\$����D{�\"\"DR̞|n j\$(�`�f��\r\0���2�.E����썦к�G��D�Ю�z�7�OoS�JUp�r��Ϣ-P��	(	 �\r\$\r �\0�@�\r�%�V���r'��M[tr,}[�LZ��e�EL�-0�o�&o,Q���!� �I�F�7�%�'�-'�-��1C�tE����q�\$�oL.{�ZLH�.�.)&o0�ǰ\$���\"�iN��J��:*�P�p,8En�~)�'���|P��TȰɐ&-�8�Mhk�Fs�F��\n�� �	~�\$9h�шdͅ����bN�ivʦ�o)r�, �Gh�v��V\" wF��I&Z[b\r\n��c�:����z�p�\$t.j �~�,q\$�v�Rz*�~�.����w2���q)2�\"o��*R�(TL��v���)-�cj�d�hd�H���,��'2�#��.I�.����d�*-.�+����G2ʬlpl#�02�/=�]0�b��/�}������9�bV2n#��!�8�n�RC����SG\n��4� -�+�\$�C��\"�\$��SR�?�X���R.�Ri���I\"dG�t�����r��6�v_�q~��QRBxzī\$��\$���\0�車PlL.�C�q:\"�#5�D9f����JB�)r���fqķ>��\"��(,+��>q+��:��4��.E(�,b�!�uB��҂�4�1�B�i�\0�4�Or}#��E�xHGC�M'���;\r>|��b�WJ�O�(D0%�3!�7��Z��F\$�I�gF.D�JN��\\��o�B\\Q,��)*R�Ĵ!Fσ�|���\r��i�\r(`�\r��\r�� �Z�(]J�^�yN����o�oD�d��ôB��De�K��Q�P=SUoGG=?��O�UBȗEu<&��B�W�A,s��g\r�i?TT��K4X.������Z#b�c�D\$uDp�I��^t?Ab�YUw'4&Cg\"c0S�@�[Q��*s~��#Y�'ZEZPqn�Z��\$��P���.�))5�U՜)�9-\\�O]!aZ�:�;U�\"u�V*�s1����|R_'�3��#[��**�'���v#T�t(��e�B�.P/|F\$�ÀD܄g������`�V����\"��g��2�5�(�H�U���+�Uf�!������5��6Y�17�T�C�c��0�p�ebDZ�S6�iFo��#	Q��+s �8��Y0�V��Tj�^5c^qqo/]�%o���A��v�2�Ud�2�u;7�7��wC�-V��*�ʙs�]`�X��:WcYqL�wH�r�5Us�9W1|r�st�8��6�x��&a\rx�:uQ��AҚ���u|F��	V�\"��Z�O\\O�qT[{5�]`�_uu�|2'{u�|��vnuE���Q�~T&}Wmn71{Q����w�	~�	��;5�P\\��6%��:���%X4�lW�AV�NV���<��Rw�@U� O�=Jfs�5Uoh��Š�XG��s��8>�8B�1���DUO~qVC8^�xy>8A��\r��]r���x�Z�e0׈I:�jW�q�KT�{W��?#�W��aQ�燁N�o��ph�G�E��2�с���[�O{3���'�x�}�%����Q�wB��b��b�2�7p!�����sr�v�Q��-w���4\\��}W�r��цxAd�E��b�8���+Vq �g��Ty:�B���>`=��թ_ם�\r�R�2��X��C+�}]u����t�7�,�!��Ku��R�zS+�����@-�`�P�U��s�-�(u��+��Y��wX�ձ@��u\\�*����ۜ7S��埶[#|;s4�	�!@��@�a�1PW��zlb��G�z���8���DRT�6X>6�>N�5����\n���\0q�(����a%�=%ʠ��ũ(P���-4%�\$���o�ڙ�2jo\r����JE�S3�q�Ӆm��8��D������q\0�:�>1S����'y����f��k�rI�\$g�Q�C�d_��a��4�F�m�*u+y��4�b\$q�A	d}4'Kx���|E6o�{l�\nT�7D���4P�+=V�4���mG7��2�m���B4f2|��Ѫ��D�\$�;����{�G���v�SO����h㸇Mp�7�\0���`�e#��������b�.���V��<}��*�*��Dj�HO��5��>�^���C�3H0b3xϻ�	��I�'�n�[I�9�<����=+~P��]��|P����.��P�p����m��'���.�&븦W/��3�xw��{�&:CءI���O��%T�0|�A";break;case"sk":$f="%���(��]��(!�@n2�\r�C	��l7��&�����������P�\r����l2������5��q�\$\"r:�\rFQ\0��B���0�y��%9��9�0��cA��n8���y��j��)A��B�&sL�R\nb�M&}�a1f�̄�k0��1�QZ0�_bԷ���  �_0�q�N�:Q\r��A� n4�%b	��a6OR����5#7�\n\n*��8�	�!��\"F��o;G��A#v�8.D8�ܞ1�*����͗ə��\n-L6la+�y5�O&(�3:=.ϐ@1����x��Ȃ\$2\"J�\r(�\$\"��<�jh����B��z�=	��1�\rH֢�jJ|�)�J����	�F<��\"%\n�<�9�\n\n)���1��P�����)�,`�2��h�:3. �-\nn9�fR���<��ʣ3\r�4B��@P�7���[0���\$B���e\n�;\"�@ؔnC�\n���E��X�EQ��R# ں�*l�R�V��R\"�(��C,Q\n��`@!���3��:����x�c���>�Ar3�� ^8HØ�xD��P�1��̅�����|���Tz�U��-\r����<����!\n�-5	�\$4&���M'�������N���ȫ�0�xJ2�:8�;��99�7.�:���2�t��	r�b:J4���LV93ٽ�ɂ�\n\"cp޿�C���è�5��h�3�;h��X!|�:@P�2��n��7��Ԍ��='J��	�0�:Pyk!��\n{t;S���\rfB'����40[�\n\"eL��c��:%ȳ:���:uk\0�᳸��Q�\$�ݼ��}QR6ᢟetC�6	�!B�SOx�6�;��<x��]�:xS���\r۽��Tl*0A�*5��nh\n���\r�`䎏7EԐ���7��2�:�P}\\?*���MjPd�6����ɺ#Ca��v�j\n\$&���J�jl\r�q�� ���\$!<2)�B�Lb<���D�Kxk���2��0sSA�[&BTK�@\\b��[;��¡[.`�C@�\r�2�Qp����.�h�M(��RȢJi��:(E&�!�5��&-è!��#g�2�hД�t�p�:õM*�#1]����a�5�:#\$�/�5 �N��BU��B�^+倰�\"�Y)P,՞�CX/���ඁ�l�܆W�F�����5�,�_�-g��m#�#=ʙ\n�=:v=aѥ����I2.\n(�����=`��J5v�U��Xkc�u���j�K@1�0^߉��\r�in<0�LR���-��PJ2�0��M�.FIZ\\Ra�c:!��{p̽�����;FLĄ �\"4޲*bf���Ґ��S\$�V�C0t	Ze�~,�����i:���>HK̎2�.����t�Br�T�#�e�\"(Td-��!z�)�<�X��p@\n\n0)C\$X�8 �Ա�&���*rB����L����*L��t�h\$f.�j]MG&63Jq9P�DBih2*�:��q&d�ZaIΙ��8���A�Uf�A���\0�F������Qrv�l�M�B�|�9� F��z��!&%��#���3E�ա��y����_%��T=S�k/d܂G�o\r�1�l��&N�Y���r|,ɝ�\\z!��B��Z��f.(�S��\0P	�L*/@���\rǖ��b�k �B�7����PQS���0�w�Z�OtR\n�d�P�\0Sr\$<��0�(�Kf����R�Cz,(!*�I�+'���D�f�C�vM��nB.�j����ɤ���Q�5��يjTEJt�͌r�[a�Qe��1��\$a44���t�ؤ��6f�(xOl��9�\"��^ghT�hwBK�m�^��;�LC��A)Ѩj(B������ҳ����wJ���r5N���A�D��!L̬Ę�B�)FO�&\"��2uT�u^�\\�nq�';L�\0���#nN�o2;�̤i������u�i�/�0'�K�8�0d�x���_-��7Wb�(�ov�M� �CBp�\$�Й��_n{`��;������'7!R,� �m8���f9כ�Ȇ�P\nf���vd�r�yl��ܽ&��f��.���\\��E]T60�\"\\�:!Ѥ[G��,�\nu������B|�?��Mʘل�@PF\\�Dd�J�S`U\"�`�����WY�^L�&���Y���P*�|�d\"!ǝlGB@�x�K2���S\"�Y��f�1������r�\"s�����é#LԠc�%ӓ�ȳn�\r��S���\"=�._�߯��S?�-�`��ߚ|�܉�23���\"\0�a�#�_��΅P2��Ɋ�+E\r]1��B��3��i���L>h����BV�FE\0`����o�)���&���&�n�>�d3FT,b8��z)e�L;(�7�j�kȥ+�2�E\$��Fb{CV���=���\r�`�Q�t>�/�`B,@oFI��^͠'���?d�	lgfK�ڵ�\n8��9\0�<��'.JbB�	�>B�.�2%��o���L�6J�0�\r��㾾*���7�V���D�֑\$.S��%�(�P��\r�\$C���P�jy�pM�;��\r����G����.��`- �,�ȅ����.���펺O�id����^�Q(���MG��� د�^\r�}�\r�Qp��WFT}��m��~�Dy�8P�Z�����mVU�0=q4s1��\r�&��*v�2vq�1��9 5�q�z����8��l\$4���_�,�&.�l��+��E��\"�1!�R8����!\$O���*I�.B;%6%;�?%����`���N��Ξ�����j�B�K;(̾�2�#� �ҟ(��*c�)R�>~\r��a��!ƪ&�̽��I�FQ�>Bx݊�\0%Za�M �V�Vc�����e�������'��~H�Ϋ�炞9.�>j�L�.��ޤ�j*,�\$�*2����d�a�&�����0f^f\$���N��Ase)Q)��6�G+�},	�-~�d8ޣ��s�*�Ca91	9�'�7�39��'��9��'^:s�:�<š/ct?&j�b	b<�/'�JU�b~\r����@�.of��m s� �+?�k&��*�P�rM?�;A3T'��jGa�u	�_α<.eB�j׳��\$7&��a��w�:o�/D�\rbjEjK9N �k��l�^6�+�BoE�cGS�%�t�PvqH#m<��ԁF��=@2�Ԥ��8.J��E�7I�Y=n�@g7Q+LD7�:BCM3:���.:n�M.����7�9�����T2�6�!OK�)�\"���D4�K�N�vHӍ;�RO�O��Jt�@T�N�OdO��AS�/T53P�{Q�\r<3*�I?�Jh����c\0�@_s칫ddK����zES��&9Xd-�yW��>�~������#1�DI��'\$�\n��<��Yp�8����2:\n'���	)�\r�V=@�\rcPDcV��V�r�t-��@��Dt�#�e��1P:��if:*x\0�\n���p��|�\0���2H0�V4DS+c�ރ5�#�x�7b'(9c��,y�TB&\"�.�F�sԎ2`���J#d�����'��6��e,JiDҀ�.ó&E�#��3��9��^	\$�AB�s.i���![	�^=�F�R\"K2-��G\0+�m�cf�:�|-�k�U1���8gt!�������+o�!L���7�X�������\\�7'#��F���3d^�;��f@��bq:�u�r�њ)�X�JDS�,7@\nOgtp���r�L6�:-�N��y&\"V\r����w��m��ob�5d,��=>��i�YPҗ�1�kqm�l/�qc��ԓF�\n�\r�(*&0:\r�H�\n�\0";break;case"sl":$f="%���(�eM�#)�@n0�\r�U��i'Cy��k2���Q���F��\"	1��k7�Α��v?5B�2��5��f�A��2�dB\0P�b2��a��r\n)Ǆep�(0��#�Up�z7�P�I��6A�C	��l�a�CH(�H;_Iу��di1ȋ&��a�C�����l2�̧1p@u8F�GCA�9t1f\$E3A��}�k�B|<�6����?��&�Ʒ_�7K08�ʱ����D�ы*�P�IFSԼU8B�ҩ��i;�L�#�.}��Np�!�7��������c�2\$B��9�#hXϿ��2��:V7���(���@����	��T��<ˌ R~:�sj� ��Kx�9,@P��\"�Ȏ2��h�:IDr�<C��\rk��86\r2<�+1�|�\rn�%\r2c'��T~9�Q����JT�����\rH�)52H�2\r�{�>�K���i��1�l�7�V�>/�@;��CA+p9�Xx���(��C@�:�t��T6�ʈ9�X��{�9�0^'a��926�cH�7�x�\$N��ʫp��B�ޡ\"���3�� ĵ\nj�#�����!6mB�	�|5qO+������Ē�M�_�R�_�\0ӄ`��#�`�2�`P�'�B\\�.�����,�ɼ)2P2��\nsS��6&yH�:�6s־�ë�1�S�2C���n�P��i��%��4�+n�\r�8&A(�R\"\r�e�9(*FX��y��63��0�k��7�&-c\"�n4sp��b1�W�r �B�\n��Sho<;���|�:+�;\r��F|H�Ůk��\\}�\r.�n'hH��z�E�����p�d�id9���3-�����8�ÑSM�'L�B��z}h�<#�tc�m[��O Va�1lln���2\\�\$Bx�5��,7�v �<����0fe���缂�#�(Hڼ�*�����S*��[�bg`� �c�1�XA�Ϩu��q�Aa���C	َ!�}P�5J��J�U��X+%h�y�\"]c��}�*�y��r�Jl)@��Y�-!ش�����\"	�ȏBEn�T��	@���b�!��TJ�S*�T�bx���9+5j���߈\n�������!�#H���\$�������B�4ޒ�����\"�a ����DkՃ�E8�rT�g`�!��(F���aє�?�\n� h���HC;+�aH@�1��8H��F�0�SD�H1FBa\n��CHhB�]yIب� ���0����\r���+���Nf\\̆Y��^Y�O�)����?�%���G*HX��X�EC��ND�!�8A*���1�\$����S1�:��k�dp���F��X��,B%�/F���� �pt�\$���v8i\"HZx���8�	�'І2(�'�T@�^,�\"N#X�Y�<��3��m\r�T�QBY��Ǵ�B�yF�Hc\"J:����f��0%��h�D4�XP	�L*F���Qح5P��7���\"+��B��D�澚XrM6�T1�@܂` x������'IaB�\$�2-n��mD�X1cvFY��V�ʓ	^Z!����K*�:�<�^	B	�]\r��̳�k�q�EMu����Dҹ1\"�̍�R��M\r�I�9Nǐ3�<�`���L����T1ȦrD�=�2v@����t�U�,�!�#v�����FP7���n���j��_�Y݉��=u�c&�%vBsΒv�`���G\$�L{��xs\$�d�jl�XTtF`�:���<L!L��B<�BѐH�&�o?��3��9��ʄ� �L�''�#f��=gC�Քˠ�����n�DZW�\"�CZ]M���0���A��7�K�\\��t݂�n�F�p��L�2��f�K-��U\$��P��es^�ı��pzd\$�Ϲ9.XX�-�d�)\$+5yt.�(#,27��HpI��S�MƵ���ī@�\$�����T!\$\n��ϻ�'�8\\ZH��B%�EԒe�_X/)�v��8ig�@�q ��8v������,K��E\$���NQ?�qSR�J��kzOU�K�]�|��r���K�B�D��]�C3�;��>C�y%<���5Љg.P��rN9�bq���u���9F1��t>�BH�un�\"t��w�wd� �������\\���R\"�}��a��.�mz?���ɨ�Z_��><���%޹��\"&O�t��ً�XO\$���tc���4C�}xv=�6\r}��B)�9i\$F�r�K��@#�OH���\"D��`��|Ӈ�g�&�&m�	}Z�`��I�dȇgەy#m��8\n��A6|�?�w�u7�d��^�f��»��� ��u���\0�h<�bV��8L<)F-x�%ت�,���.��p8Y��]̸\\Ŏ�,Т�0��-/����,���-���ږ���B�\"�L/���	*�9�����<I����\r�R#�xFf\r��L��F;���e����\r��Ȑ\$�P*������L�,0,��'>F�G�@�ԕGM0'\r0���_���Xr3	p��b\\���%��9(����\0b8b`��|z�x����\$!(�q.#�5cf�<�N�1C/y�,\r�106B���b,1f�QM�QQr��:����Z���y�}\0�7��%o��\\�Q����Nsp#jg�sf\"b`�!#�6����B����	�B)\"/�]	�6ɘԱ��&\$g��6��)U�B\rC&�c�B��������r%pLE,`o��\$���F(�E���D!RP]�\r�e�%\$+%�<t�&��B�?&,;&b|�Ҁ�rWQ�k��(2qѩ\$'>��K2v��-*��&N(&2X�O�&rl6�r4\rc\r���K���!����2����R�-�K2��0�FvMG�+I//�'�\0\rfy\"+k�+�0]�0̀�\$��m���g�-3\n1)��>BC.ѵ3��b?4I��5�L-F/��(q�6�R�0�:c�Z.\rdb�v1�8.ɶhlbd	8�h1��i�\"(�����S�9,�-n��D&`OjK8�6ؤ���(��mx[-�%�CVؓ�=3E%ҥs�\"��*��~���ü�>R~�������H��/\$�?Q>�5Ĺ/Q'1��\"`/�d-R��k��/���\n|�4���o=�~��Z,��/FC7�FГF,Z3q_F�^�1�Ō\\�E厺�L\nr�?�x_��E�H��H��Ώ?p8�\"WG/�HnaK���cLb/K��H��2��^I�H��k�>I�k��ǌdK�\$@��B\r��Cj\n���Z�3\$(:\"�s+H�m�#RRf��Q]R��B��9�<��'UF1,��죬X����¾����@��m�O��B��C��J;�!.�o��l���0�DͫfW��>����Q 6R���E �.�@�-���<mt�W��L?\\�]l\n��!]�B��l����n�.5�5#�1�#9C��.O-9��6��ц�&O���c��%R\n�~&`��a�0�t��ÚM�C,X�\"�\nδ/��Z@�\nu4���/��.hj%�,�+\n�\$�4��X��f��Na����G&4�������*#�S2�LL\"���4#O�F��BH";break;case"sr":$f="%���)��h.��i��4���	������|Ez�\\4S֊\r��h/�P����H�P��n���v��0��G��� h��\r\n�)�E��Ȅ�:%9����>/����M}�H��`(`1ƃQ��p9�Whtu��O`�J\r�������e�;���ьF\rgK�B`����X42�]nG<^PdeCR�������F��t��ɼ� 4N�Q�� 8�'cI��g2��N9��d0�8�CA��t0��ոD1%�Co-'�3�Do�8e�A������Z����A�)�@�{b�0*;p�&�\0��\r#p΃4���\rY����] �s(�>�X�7\rn0�7(�9\r�\\\";/�9�� �踣x�:Äk!���;ƣ\"�N\"��\\���:C�*�����	z��E�<�E-����¶�-н���\"�#JҐ+d���*{�^@���5�1D�K��0j��F�9A���h�uPڬXD��*��*L������@2��^@-�8��R6U4��5�z�'QƎT�8Ч��V��������G3R�D�=O��i1� ��l+��Hc��#��1�#�*3ݷ,r1Gn �4���0�T�9�`@`@�2���D4���9�Ax^;�p�p�q�j3��(��#��&���\r���\n�Ѩ��#x��|�2\rGYA�,¯*��77ҰeýM:�	+YJ\"o�VˡMƦۢZS:���'O��ږx�0�Cu悄�\"\"ѽH���i�ѻ�M��=5���(T2�_�Mz��0�1 �*jSO1a�=b&0��d�;#`�2����6f�H�#�I�K�CD��j��?�3�N�%�Ѱib\"ˢp�O�I���2k+Cf\$L4#L[/_b��E-F��u2��٣פ6�D��*����z�k0Z������&J��S/k�*�n��\nT�����F��yY�9������j�)��)I�\$/�L�*/�#O� П�hM��`�k!p�t���^c�k�&j�ǶvԂ B ЉB-S�]:E`���el,:VڻQ�lA�<��tK��s�\r�`��e���D�+C�7;Ǆ�G\0@�Q�n��&G��C��\r�ɛG~�\0\ns�������f��q��<D���\n���0�A\0u�a�w���A\0l\r�\n�6��!�0����n�h0RV��(%F���&O�.\n�&b�\n�B��pK�d���\r!�r0����kb,M��v2��L���}��5d`�N�h��Y[ycE�5Hl�Ke�W\$�B��rj�i��?�k�J\$���vv��%d����XZN`�&p0� Ę�cݍ1�܌�sd,�@H)	<�XI\r����D#\\v����H�C[/I�OS���VidSiDbl�Z\n�i�u���h�!�(4E�<Y� _a�6\0�q�2�����F\$�dҞ�ʩX���:u��|!����e�mZ�C�.�j��z_��FL�,�	�@\$�d�R�\0����e�99in�̒���xc�3N���sNxenI9C�w�\n����;�\"�L\n2gR���s!\rZ�dFL��0\0�W� ��q����.�&`m�;���\"lgb���@����#WI ��F)��b�k�b��!\0���\$���xFE �_*Н��#�M	\n6M�=�k#u��@(���4!���*�J\$(��u�W��\$���&�� ����Ӥ�Ë��\0�3#@�5)r伈�1ʤy`�BI:UJT�G�P	�L*Y�c��1J����J������;5y�,�q&��-(&�DԂ��n/	c�E\"Q#��\r��2`�,p%����t`u�S^��3�\0���e�1�`�i�nnA������2vCG\r�*�q�&�]<(^���H܄��P�*[WB�^4M\nm0*L�g�! +c\0�B`Eٻ>����Td��m�n�\nX��d���ba�4�\r!��N-�����Ւ�5�a�Y\n`�k-w:��T�Bc/f]�n�x����f��l��FJ�AjLf��s��M��ǋr�mNo��,�=�7�<��Og�O˄��\r-�M����ΰ���^G���u��b�n ���W��4�OΑ�h�O���\n\rIp2�ZlO��V��-C�J!:�\"���a=�������a���;>~�()����#%;�n�)�S�n�3�E!�0����9���P�bC+\"a�!D<.^��\\>J�r�SwE�Ō��=���օT�B��x��B\0PI\rՔ�\\m`�k�#�!�%��������|�F��)f��RWmG	>�ᠨ�vI�8\nu�1��\n�Y�8��2�^�T�R)O΁�bL\0z�x���Z�8�L�Y\$0��P�H2)� �'��|!��-O��:|�����nn1(Vـ� �	\0@�\$d\r\$�m��]��;D�z�����d��n�&��@�f�j��6�0��fʂ0�J*�L�Bh��.W�h�b�`��j����(?���Z%D��\r��20����h�	������Q\r#��cK\r��)��P�,��R��F��0��1\n���Q+�2.XD-ï�h*��🭲�]�i1q1�!,W\r�U\n�e��qa�eQm	�Vm��y�}��5o:@�Ս^F�� ���)ʢ��X�.�ez'J�&�Uq%�?�M�X����hVq�Z��*�M#��b�#Ab�V�����5C���|N�.\"���Hv[c*���xe&�x��N�@�r-\$�x�0QG�����L��<C'�o\0x̀>�f�10��6���<� M���?�v��hM��N�΢��'N(�.�� ��ֳ#vZ�z4����q(#UO�)�'�\n�O�+����3���AA*�p4%aD�z����ޢ��mK\0�h�1r����'J5��-�R�,��S����r�?�\r)gW�B*h[���j_���(�t@ڐb�\0{��\$e\n�쀭\0�6��YP�Rm*kg�,Ŏ�P��)+2\$#Lk��(NY6�`��|F�ѳ9���St{�n2�\"���A'�q*DQ*��<I)�){9�\\���2�a(S�0�y\n�J(i<��j\"LU#�p�7~j�5\rp����7��s]@H'Β�B1s�A3�9s�\$����t���)\rB��'�y.���y<R�7E�>o�E��>OF2�FtV��,E):�t�y-@���r��gIn���K���fN�	-ET!f\rI\"B(	�}�>,T�r����M�3�,T��N)�T��Īy����8f�7��഼�twMtiE�� ��K��N2��R^C�<z;I�>lN.kE�Q3kg|�d�F�_*d�¯�Sԁ:mp�CB��S5<��/T{TT��c\rC�V�1G!zMo�VUw�HU~����s0OU�\"������T�`Y�KJL�� �N�<�1|��&�,v�3A�;uk<��\\���3�;�5(a�U�5�O9ʘ&?!u��ണY�4�7��/:�=_�u��z2�c�98!n/�&\0qΈ�1'2?X�F'p��N�=�j��IW��Ho���6Hm,�V�&�ge*�Ud��'U�C�_2�=���xUD�6\r\nT�;KR�O�\rc�Gk�dE�0*������8#����t*0�֭lV�l�Rʏ��\\'<\\��������\0006�FQoB�Kfv�\0�i]Tvh\"uop�[a�#q�@SR�\n+��WBDV�Wguo�meMs��pu�e�t�Gq�+aK�25�C�sHZ�<�t3?�c\$�o�aF0�`Χ��D	Jd�'w�ܶ2ꗇy�N��hƕ�i��%Qn(ay�\$��ClB��;ЦL�t*��K}.s}rz�},\"�l�\0�jt�!1��\"��M���l(@��H��j޼D`\n���Z�,�B�S�	��i1k\np�}����tB74F�Lo��,�8��fY����1-O�l.�	���\0�/���C��17<�t�.gx��g\n�Oc�/�_�'��b0��#%x�5�<��u<}���B��.�~4++��*��J�P�}P��&��������	�~�HO�#��3X�\$����d��)���t1�\0�C!�s���P4\rS�<�ժz����܁���Z��6޴M.g�@���S��'�5�5M<݄ރFhqc�3�1*p �]����o''�.h0��#L�H� >���9S��%�i.؍��.���f�@���������\$�R5�R��\r�h�t�S>�Y^�����5�\ny�l����`";break;case"sv":$f="%���(�e:�5)�@i7�	�� 6EL���p�&�)�\\\n\$0��s��8t��!�CtrZo9I\rb�%9���i�C7��,�X\nFC1��l7AL4\$8�u�OMfS��t7�AS�I� a6�&�<��b2�\$�)9H�d��7#q��u�]D(��ND�0�(�r4����\$�U0�!1�n%�(Ɖ�:]x�Id�3�O��\r�3D�pt9�tQN��������!����ݾ�r#�-�+/5��&���d�~hI�����':4�Td5gb(ī�7'\"N+<�c7\"�#̋��죦E#μ���j(\n�\$Cr�ů�\nL	è�6��3C7M�@�=��9<˫�!\"\rh�8C�����*҄3	#c��<�H�<��*�)����C&���p&?�,5ñH�(,�lD��(��4\r̫�2\r��:�/I���8�LD9���]�!��>JU\r?���\0��\0x�\r0��CCD8a�^��(\\��#s��zJ����;�!xD��l��Sr`7���^0��z6\rMK�\n�H�Fc��:�¸��򭐖���.\"p�/�-������7`Aw\"H(�7в�&W�O8]B\r��6rv�F� �:��R\\�c\$�95Ve�5B0�7ZcM��#8��.���)�O\nU+.dv)��3��X��2�o0����<����d(腧�F4�E��6c\\E�9B���kL����,����mn[�Tʂ��\0�� ����M��4m�%9��t��3I#8�	#hᘹ\"(���Y�����z!9[�,�Z�6��m,0�5�A(���6������`\$C=�2���0�\"�f:F���QM������v}���ϐ�D�K�r��e�� �'���3@�RN&M�\r���\0چ.���Y\r��ǩ5J\\�g��X�Ó�['p;t6��R��p	υ�W���r�}O���\$�C���}���ւK���C�X\rh ��u���vC�~�����P�)�=AA4\$,l��VgM		R��L�U6�T��Tj�;�xh���U���E��V��Z(bl�*�c� ��d-�����?�ޚPB\$� :�`�#:�b�\"\"5#a\"��q#����Tʢ�褫��)1�[+�	\"()�1ؼR��A�o�@��>G\rQ	I��7�fi\r�+ ��9�3;R�77/R�v���i�A\re���(�aJ�ƝE ���ȫ�����ȉ��~T9�B��9'.m����zȌIAƤ��\0�l��-82}��d)@����k��H.��0�sơ3<Q\r0˙�6L�q��B�D�0�\"AГ���ˋl�\rѽ�M�?7�	��u���҃#!����*ca#,d%� ��nQ\$���Q�FL)�C\naH#O�X�0 qa�h�zP��!�^9��X���šdʍ!x&)t�'��+51*T�BP�Ւ���OK���\\���&l+��R�T9aD3U&t��PAOMI`>�H�L(�e�Da@'�0�Tb�3 �<�*H�Q���X-��s���1�}G ��Rd�=�?`I�\nmX� �\r�I�P(\"Ӝ��%�=�\"Y�\$���3	�N@�2v�1dő;`�\0U\n@\"�B�I	�f^p@�xR\n�P �p�|���_(x0����PD�[��R�,��.vL�?��c�GL�1��h��p�˾�\"�����F��F#�|9dB񕦖おRƭ'�g[�= �@9�h����2w\$1���+����<X/gt�Xd�H�4g�mʹt&�8ZW��#7��0Ӵ�s�'@)���`�8l=��\$��cH��������q�(s\r�⪐B[�tMĜ&��\\u��l+-��㋛t3����j��d���j�����\n	�0��}V`��4y\$��5���YyA\r�>�\n�6�\r��� ��Y��~s�����8ɬɓؚ�l�!-��P诚�F'\n�%\r\r@PEG�E���^�<W� �0�qL��!���ZS��\naC/4�dp+\n��Y�����*�H��������F6��o�yq�C�p��	��*�dƐ�y�Lo+�6=�3U�)O[���W���w�c^]��^c�I8K3�ќ0��G8���v��f2H�%��pB� �&���|�U+��Y.3���#&�G0Q�.+5g�3sމC�-��u}�q�Y�f��z�X�k�6)Y��_N�1�\0ٮWy�-Q��px�jq��\$�}�y����׬����z?d��mф�'�(��(�\$�`��}D�9��㤯���I\$�Tzo4hy֧�+� ��	��Ajux�� �z0:�ug����|qq��Ļ�|<`�M\\~�tkHz���[�p��b����/�����**��r-\$S���P�c~6g\$���`�/]\0Nt	o��a\0�jK��h4��nG�0Hv�i�NJ�N�p�B�צj\"m�}nƐ(�0.c0|���,of�Ϯ�n�����	�~��B�\0Z���։�i�bA	p?�\$���l�BI������ؼ\$L�.9�@=Ì���J�*X��'����Mh5��Ò�,5E�ӯ��G��0*�Ř\\oh����[M��b���QBN#N�QQoD�Q#��M�������P�v\\��?,�\r\"�5�Ji�4\"��m���L����1��R��G1�q`[�n�f8d�T5.�¾;<#��cf:���l�b�Z��hĪAjJIlDJ���b��/��P5�-o`�Ѵ5� �rE�\$�~q�\"�-�p\n�� 18�qbE��q��m���^`�Ql�#��\$��T2O'%\$.O%�I&M&b�m�\"HN���ك�-�M�8��\"�-��&�)P?�u)��B'�#��*��q�+���`�\r#���K\r�*H�ɪ!/(���-D�-�-�4!/�(\$��ҳ-�\r/*��N	�2C�ò&\"fD��jN+1�VOL��y.1��VK\\��,Q�F	d�l\"�%��]��#^E�\$��0/P�r��Q�\\�;5��6P5R\\F`�`�@ʪ�P��&���\0001���x��\"j~Ջ�\n����cB\$�n\"�h\r+�q23.�!ӻ;�O����P(\rG1�����C�mFe.��D�͢X܂�9���n�\"{n�E�Ylʷ��,���Z%�D	�e�,Goe6��6ƲIC�p�x�h{I�7<��k ��[E�!��EoL\r��;���J3��[D�e0Ц�w�d�g�>/��D&�K�\r\r��'�6=4wAC�Mb<b�Jd/í?4@7��>P�vA�A��l@�4^q@�o������\$�rG�1�A�F\0U@�";break;case"ta":$f="%���)��J��:���:������u�>8�@#\"��\0��p6�&ALQ\\��!����_ FK�h������3Xҽ.�B!P�t9_��`�\$RT��mq?5MN%�urι@W�DS�\n����4���;��(�pP�0��cA��n8�U���_\\��dj����?��&J���GF��M���SI�XrJ�΢_�'���JuC�^���ʽp� i4�=���xS������/Q*Ad�u'c(��oF����e3�Nb��Nd0�;�CA��t0����l�,W�K�ɨNCR,H�\0��k��7�S��*R�ޢj��MY`��,�#es�����r�ʢ����\rB������B��4��;�2�)(�|���\n�D�����@\0P�7\rn��7(�9\r㒐\">/��9�� ��;�x�\$��9�X�;̣#w�I�@���k6�G�\"I �uW(��R0,d�����\rØ�7��j*+�]�!1��%�n,L��k��\n.�uHY��3V�7drڱĪ�\\)�Kz��0\\W+�����q�1ezw�v�櫖�J)���ӮdB���H=�Ͷ\n����Z̫��kF����8�7��-��8l���2�=u@�)u��L�WbDh:a	�;@��@�<�o��rR\n�h�)�R_���9d��M����tFa@�6f\nM���i�lƪl\"֫\n�@��ۓa۷��J*4�I+��qj8J��ښ�#A5kE�y�# �\"LA�8;��:��\0�1�oU=\"��t�1Mn��4����0�3��9�`@q@�2���D4���9�Ax^;�rW���]2��x�7���=ϡxD��l��ȃ4�6�4���}?�M�V���=���*b��Z�v�����±�S�X�U�U��+���c�0�_�Y�䀫F���@�2x�2y���.l�P*�V�-	�Vd�ҐW!�7\$@�AA(dE͍v��#޸�z�i4��W[�U�5�\"�j�W�`����=�s�ͅK�Da���v!�:�WƵ�\"�8/8W�u���na��T4��̉`� �p���;�T��A��A��e+��`��:�i-ql�R���H�'o��Ƶ�\r��]����t]R�}KU\$�x��{�l�9b�\0�a�<�1�ܐB�L%�z3�YH��F�F\"H���sP2�ƞ��B*GP����+�\"N~����Z��Cꗏ�_Fy�g�F�:c���\0�r��q�	G�d��L+��Y0�3�|��.cCW�)��x�u��H�t�+���40����2���VP(	&�;�Hi3!�ѡ�tA�O-_���RM��ו\\,A!��4Ltŝ3V#��z��H�L����\\xav�L:XݓA�<��R��j�3��O�-FŬ��J��ϴ�;�e2��V�� ��d2��V��\0s7p��b����\n��c���o��66�vf���D�@@�x�n �(�6�ރ4?�3�@��v�5Z�AwHO�(`���'��,�[rn(��Тm��6��ҵi�	H\n�i.�t�c{����D��i\r!�����ܫ�s.mι�B��bfu��&���yޤZ�\$��f��,3b4ץ�\0��ٕ��E�@��-\$+�54��U�U�W!�\nyH	���\\\\�ba�4�4�Nn{�r�a�9�<���mWeӇ'R��UfS���;JJ\r��J���h w���'��bq��\"���ek�q��eV�y&��\n;B�zs��v�a\"�A��{������o�!��K�쌘��Y��Cٗ a` �1�ldbj3%j[�\n+*�gDW(�bC�z:F������.�Kq������,�i�Q�\n�a���8{�<���X\$���t�����i.þ�?���5�r�(���2>�\rG�59��6�1;����yo ��Gp���q.��� �}Ch�U9�f3�\$�7� !�0��q�U9@�x�f�\$�k��/U).Q�ʿ��,Fh�\$p{	WN�I��&�yA�q5K�ȝˎ���ŧ:��Ԫ{F��xi�{񲍤�+9Z��*�N\\��錒����)�*�_6Z}�����-QZ�<��e�Hy:��������=nL8�Zp� m�����\r��)M���8��n�<�F�!UH%���O\naQ�V�8Շ�A��JJ4lgg~��ȋ��e~k	�h��R��hE�\r�6��<����;�Fe�w�:Di��ru0rRJ��b���)�ASd��q*i�=�M�;q9��\0As��r��(�*ŧ��z%ţ�SU�W�O	��*�\0�B�E_�@�/�H��B=��a<nR�ا(vpb��abꀍ\n�FLM\"��f��摥p�����_/��ҧ���|knxGD�*X/^[C>�!Z�a����.)j�RjnJ^0:�ㄘ��h�j	����f�Ȯ��px���潃y�̢b����iH��t��c	%�o4��<��w�Ԍ�l��G�\0���i�қ\n<���hd��)\nb���(����Z+K޵/�g ��m\0?C�d��Vj��\$\ny<?\nz�`鍖�� t�#�L������2�*�wʨ`�f�ɹ%�b�Î9NV(\"J\nG(r`�\rH��p'p��� ,��	�� �\r �ʖ4k@����Ίmm)��@�%K��舲�:@�Ϡʬ��NJL��\0jV��\n�����y��,J\rȄ��\$\nm�4@´��l�\n�(\$<���)�qP7i�5g����˃��O~�*MX�ϲ��J	 ܹ��%�?�\n�)�6��%X����D�B{\"�/\n\n�m&��������D�pC\r0���l�`� ��rc�;�*�'��s��{+N����	�J^'��\n�J�0h@�&kH���1ކ/�3p\"�p��B�df��Y�6g �wc�d�C�����j�b�2�\$P2�	�\"����f�J6��lR0�'��\0� �	\0@��\r\$��N����O���/��S8�**F9Q:�I�9&�\\,�P����)����83����,�F�}S���q�/:pE(�}�̟h\rg�����1�=E�;�;�M��3E<�>p�3�:FJCß:��\n1�]@�N�F�����?���%��.�>�2(�I�.��,�3���-7��\r��-�C��t(����E�����I\$�3Fs�0�\\E3�H�B̍C];��<ID8@��'��BEf�NjD���r���mT8�¥-E3�I�P����KM\"V)�I�f�R�F��U�)��J�\r)k%�6��DS��6E�QA�Q(��T��qoM�v��6'l\r)n*���@�%�uS̑��zUJJGNk>T\0[�ڿ���eYTg�=KV(sܙ�t��&\0�<�d�\"lt�C\n5E\$|B0v��	S��YF�/��sD��7sL��R��Y��ux�5�cK�\\U�O��\$�DԨ�Q��W�I�*��x����t��u>�<�w\\6]�;+t�Xe�`̧a�G��s�~��4�TU�`��_�sb��;v��1JH�)(��,�i V�rЉ�'�(x�|�X�u2G�\nFL�ઃ0AR�+U��5c=r����P��ʅ��Uӯ\0�\$�9�Zrb���� A�>{��_�7k��:�Ԗ��X�M%\0@\n����N ���p��\r�T\r�\r��[p �QqeSHDmV�wп3s���0�P�\n��]�1aPyF~��e3���B6\"E��GV+s��)j�,�4uqZ�H�jAs7Sm6Gs�Mv���U�q^V)dS���4��/`�Qd�]���V�ydu\\wm55��7�zP7ו03l��=��bvC{�����1���l�k�����l���mPp��9�=��xW-\"f�Q��>�I1�c~�\n�7~��7sP3�P��-tR��~W�(�����W4.\$+J���,��y�#bT�wW���BM=;(O�2���9a���f���ׯ^3Q~��}3�Rw'4�'Ъ]�O9��'�aCv�%�nRN��z5rk��z|��[�&�s�uӂ|ͪ�Ml���-\"���+UԾ��Q��r���)�n,�+����D�4�R�V��L�>��\"��F�m��*h�\r�<�	k[2�r�q�6� ��\"���X��X�~����8}xXk�6Ia6S��It�\"�x��إ,�-0G{p�W�\r\"�N�;\"75d�{!�t7\r�׉��GٙBXv�[|�_��-��iF��v�?{JE.,���h�x\0�;���#`��~�wsv��\\��%��9��Rgl�Ś6�:��\nh����V68��c�uPwz�FM2�b��X��:|�h��#�zKe�5�.�7���yX�7a0�BR~8�<\$�d�-�I�jI�m�շNI�f�E�mX�����}����c؏z8�7w�uCa2�(������������uu������L�]qN��ݦxq&��M\\T3{:r�Td&�;Tx�c���V��%k=V␶��{#y����ì�Ւ��|[E�9v��=�Y�ArC�g��)w�WO�mxؕX�z�_a�Y�=m�S��}Z�{/��`4����:ś{h8Տ�@˦�+�ّ��|��z������yi([˲{Y�[-5R���;\$���Vmֈ��y�{�;C�̛�l�MU)�׾�.�*�v)�Ͳ�\rr�WJ��س��qzM�|+a�/�<3��׷����},U�S��zq���û�,<,�\\Y�i�ě��<j��o�����ݧ��Z��	�����&�����k�Fa�G��ě��d�����O�������3=ty1[��4\\���ٮ�a�W�	�ˀ�}�w��<΢V��/�K-X9�8�)J*g9�d�'���+n�����3����D�4�v�/��W�?@{{��7aQe��%'Jd��B5��/��Ә��e�CӑE��]��}{�l֨��Q�yҼ��}2uiBu�N50���4�ޅ�\r�V� Ӿ�q���`�@�q�̱g)\0�֌t���̍�L\0�\n���p�˓qĊ)}�yt3�z�݆��T����g��c���5%��k,�xp����\$����&�\r�]���W�;̣pЦ��^4��#��;4Vj���`�ܩ��}-�I�Q��E:���Z�w��E0�?j�wf��>h�ZhYe��=i��3�T䰵4��%`Q��lrf�?�̼a�IH6��ڔ8檎;���Q�e���5c^��\\ߌ�eJ�J\\(���w �	s~AW%q}u��G�A�m?/S��B)T��6��̤�|�u���i`n����w�\n��=c�;��L\0�4��!Cw�>���ZH�0�a�iT�yH'���o�r_Ѱ����e�e�cU�J��m���_�չvE�nj˅��X��?\0@�&�ہ�~lX�`��͘%W|�A�J	�dmq�f=�)�\0�e\\,ͺ�3b�����Ie��菞}�\$¼�PO�J�����V3�Q�`�:�>sBo>(�g�u�/�N��4�ť�X\rh�^t�����mQ*Ur�s�ٗ�)kO��\"��!U���%��F�\$\0�	�M���";break;case"th":$f="%���OZAS0U�/Z���\$CDAUPȴqp������*�\n������*�\n���W	�lM1���\"��T���!���R4\\K�3u�mp����PU��q\\-c8UR\n��%bh9\\��EY�*uq2[��S�\ny8\\E�1��B�H�#'�\0P�b2��a��s=�UW	8��{��#+��&�\\K#�[��[=��-���O5�,��%�&ݶ\\&��T�J�}�'��[�A�C��\\�����k�%�'T��L�WȽg+!��'�Mb�C��� �ɼ� 4N�Q�� 8�'cI��3���@:>��2#��:\rL:#���-ڀ� �����E�M��˘���a9��~��NsL���^\\.-R\\��\"��C����CEÚΩM�R�:�����()E��<����)�CH�3��sr���R�7�!p���b�L�B��5�ø����7�I���#���|���@9�Ä�C��;�\$(θ�(��34��#mSA�Js������ت,�p�A\0b�)��>֪m�/�:�\$�J�R����\n;��~�&�u�U��*��9l�\\S,?#�N��D��N\\�M��GR��\\��Ə�6�\nH#�\n���j�&4���ŵ̝{8����R�!*�����L1	pNY�52�-SR���<+/օ��\\�f�)i��_H.!�؜ϊ�8��؅P�'��V�ŶeJ�)7�z�)�z���x�4�/����c�W��zF7���Ȣ�R��2\r���P4�CQ�9P��1�#��3��>S��;�0cݶ�u 9�`@n�@�2���D4���9�Ax^;�pðlS��3��(�ѣ�H���\r���-����#x��|�:R�J�3�����+|ΩɃX\\�铎�TKS�{a2���I���7=n�z���f�L���Ñn���W쳺�\\�;`P�0�Cv�9�A(�A\r�!씂�#ȗ���F�1��H%	��#ʜ�#�.�IGgu/4∅���*�d�!�hO�	݄� GC�lP��0���W��]���>[iLd���&��h��4b���h�#2I�����N9Zd�AҬ���0WEᄣv|(��MJ~D׼P���(g�t�J�X�'�)�2@�\n�I�(#C؀Љ�P�0�� A`�N��D0�ߍ�m��D����Goe�dd[�k_�����_;�f^S\"Q\"�@evd����.%�aJ�\\�5`x��-�	<YxB��B\"�t��QS��;C��h���}*���\$^�hB�sa1�t���t�:�5�[�����T���a.������Cv��4�y�h >X@�-,\$�I��I�:�3D���������(o��G�d�a�n�,���cbB���U���SC��*����py֓V��C41�7�t��0tU(0�p�Eh���ih:��P�M;�t��)BP�~�/�\$�Ś�R)�'�P����C�KnIl5�����t�4�F����q�=ȹ7*��˛���9�B��\r��т }h]�[�\$�)�H� �Ft��W�>�+p�R�r?M�jѪI�)�s������7i�������t�:��\\Z�p�&�8� 䜣�s��9�烓�tN��:*Oi]XI\r����D(������I�C[�Q�֤_u�]�Y�a0<̩���䭮v��\\�P�hݰ o��C�#������0�k���spt�FC�J����@xT9��پ�Ғ�v�)�C�m�*j�ȱ�#�\\�+<e��T�vd�@@P\0���`V%�N���2�yeQ�(��P��b0�s@g������+�ma� ��p�o��\nL�~l�;\$HƠlz��uu�	�5�(�sA��7\n��]3����J�܀ ����H��]�n8���=�cJ�\0C\naH#@\rj�[@3�џKr��Z.��0�\\L��N���IN�F� [���я@�[,�[\nB�K��B�d��6�9��#; -��ja\$MD���EA\$���d,nP�����Ì7���3'p�ao3c�i�1�D����@<De��D�;\$�f=�\n�E���-\r�4\n�2\$K�(����\0ު���d�A�k�P�r�D�t��sq�������'�����恪��n����Y/�3� ?��#L�#_�i�j.�(n�zG�<�����a2�E~�{ ��ŉU��&��p \n�@\"�|?��&_YA�<�@�/���Q���u���<���/xތ#��6hYl\"W~���ɓ��x���dd'����v���lC�Y�g-��?��0����47ZZ��l��#��������j^�)��mZ������<l���O�'ߗfR�z̏�Fh��&6�/|�e�5)j�Ej�iTD��@M�Ga2N�a�w�D�\"~�(���XI�4h*ȴ�c'��7�~4MƜ͞��\0�FD/��������\n`�Hp�K欨p������K�x@�\r�6�#���^��� ʽ��P�\ni��͞JM�GM�*+�A\$�Ǌs��?���P�Ot���\r�r?L���d,d�\")`|IF��^�dC��\"�W���-���%�����J�IHD�Ί���M�&H����g�Ge�ir`���qp��R\rbz+���3�V&�2��,@c��\0��̂��%H�f.FEH-�+�q�E�g��,���x�h\$3��q�(��ͺ��iO��i���-�VY�TSN���\n��`���l�PmEЎ��M��~���͆����^0��D�\r�jú\\FTFBe �&yo�Ze`X���J�c����#���a���R>-��/��cF#DK�V�y\"o]#ѱ!m3�R��V-�̶ŦB�v��a#P0h ��F����]?PZ���6[�g+�SD�&E��Ж�ѧ�E|gd(��:F>��A&J\n��N����PV�(<b�A/�ZOZ4G�2G�,±1/�úֆ@:Jx�G-�yB���p�����:�S?\"�{�V:��&ID��Y4R9�W�p-�b�d����-�d�c`HҠ}H�5�t{�~���)ӌ'���GԶ��I�a8Q;��\$3�8ps:�S:\n�6�\$&B~�s4s�<�����\0	�~p�<�B�O3Dg=O������]���/̑�Q5Nx���g\0�N��X@~'�L��+�[�D�H��3�<��s�B�ap��b�\"�5Q2{iN��C��)����@1E� ���o��\r��\r�l\r�L��@��=\"�^�S>��\0�	@Fw)�FS���c;�#T-��e/�Jq�]�>Ũ��I>	Q@o�x�`87=��E�K��d�Mt�@��K3�\ni��3�!��L�YP)�\$����O��P�QR�OR{7Q��3��Dl�q�Vƀ�A;C��s���@�2c\$�\0003�+RB���)�ZB�@���b%���(пK��BY/]���MR��R��S[Xh�X���B�J��549C;ҋ&�n��M�&��C�\\��`���Ae�T���5J�)C�yU�{�:��d_3���cEԗF�cT�M�_��iW\0H�]�́E�Ku�T�WW�U�Z�|���.GZ.;�W<�[=wA\$`�J�Ǵ��@T�AYu��Y�3ZG�f�eXT�SvzdU�_ZS�e�Kfodc��9s�V�)-�	h�=��\\��\0�)�l�6r���=��Nv�kRZ8��g��}v��T�Y��f��l�j�k���Gi��J#'IDaAo�)ì7�۩6+�G�3&R��z-��q�m%j-�>@�o��Pr�P��'�>��CVT�g�nvwt�=ttU�m��v,�W[IN	\n\r��v��/c�N���oq�wʙx4��T��7�\r��ys�ab\na��]Q������J�/;	+[w�>�~�U�J��}\r1m��Q��|�o}7iS��u��w��~��~��X�Y��gU�h7�~Հ�~u�L��(�{�֮7qf摂��h��~�pZ3nEw�c��y��SNa���%.�vf1P�T>��P�N`�A�@RL�8l@L<tF�M%��g���Xr�\\AX}GLOP1T@��/Ӄ�L�����uW�wW�E��v��~X?�8C�u*|�]w��8Qz��N��*��k6�o�KoS�*��UR��8߀���되^b�R��lץo��W��cJu�	�\r�aȴ����ͺ�\"�`���ļT�yU���*�{��p�2�d��y�<-Ag!�F�x�{rf\\q+^U]<US�֫)#�?�j~X3)\rr�@�n*\r8j�%��DQ<�{�'���)��mV���\n���p����(2LZ5c��:(5iLe1�2`�NL��E��\0���dSF&L�@�\r�\0��H�<;���é]ɥpC;�vU��q����U�<ES��TAC��97W���D�`��	n�u�hA!	P����W��L��h�}ȗ#q :Secv�)��mւ�j�y�ȭ0ᙂ�Jw�1/cp�ڞ����63�g�J��X`��\$>#��\r��f�\rpnFF5i��D�W�e�B�Fu�\0005��u���(��Ȏv^:Ε�]H�`#��bo`��w3�Ee.�\"�d\n����H�iC�*5��EH+	�{�(a=im�<��i���b�cBX�����3�>/0�&q;N���T���JZ�M�d<�����}��=�	 @���Ї�'D�Pe���*��pD��ǽ�H5C:��D(( 	\0�@�	�t\n`�";break;case"tr":$f="%���(�o9�L\";\rln2NF�a��i<��B�S`z4��h�P�\"2B!B��u:`�E��hr��2r	��L�c�Ab'��\0(`1ƃQ��p9b�(��Bi=�R�*|4��&`(�a1\r�ɮ|�^��Zɮ�K0�f�K���\n!L����x7̦ȭ� 4������k����|�\"tit�3-�z7eL��lD�a6�3ڜ�I7��F�Ӻ�AE=���F�qH7P�u�M�����n7��Q#�j|aŘ�'=���sx0�3����=g3�hȎ'a\0�=;C�h6)�j2;I`҉��\0��A	�j�%H\\:\$���&��0@�A#H�� ��:����#�\0�4�B\n��(ޡ��S\n;I�Ɯ�����B��9Ãk�:�ê�!�0��X�B�7�\0P���{�G�xҲ�	;�4=	�� ���\$��σ�>����#\$9��p�!pc������:\rz���T#�9�`@!c@�2���D4���9�Ax^;Ձp�:�(�\\��zNү���I�|6�MjB3#Qx�4�!�^0���Ɖ��+4#��D�ym(\"Q�92�ڼ(�*�5��<O31����,�U�7BL�!PTL�\"X���M��-@�08+t�j#C��'����4�����PH�{D�m�n�v�N�֯#-���L�,�b�43%8���Ô)��fd ���&\r(�P&�����&�:X,��Pܽ+�@Ÿqx�9b��	G�h0�c[��Y�=B�-�x��Q�O\"���x];�纄\0�x��>ӫ�)b,���.#�cn���� �z��,�Js�r�b�p8�!n[�^=��6���60���b9\$Pl�6U��S������H�����|�>�v�I�c[\0�M���y��ꌣ�87+��h��\r�a��&6���>�qp��}	���|�;���a� �\"���y^.�Y��b������pNW���r#ɡ#�A��3��PPy�]�hG�vz�M,��M��3Fq8���Q�\"\$L�)�@���T��T*�X�r��mZ+`��K�X�^��\rŉe�a����^*����B8nC�J=�����T�l/�3!�9IMQ��-t.�^��)A�O�bEE⟁Q�;��@`bF')���jg\"4HT*�R�uR��j��J�9+Un�^�݊��9��Vs�|wJ�	\$F��)�\"+qs��>g\$�l&�8����E�сm��6�s.��`g\$�N�N'�б�D,7��)�k�1r>�f�<\"����S\$�Py\n�7 g]H1��V ��Ƞ�&>A;1��u���)�]�-���P�/��/��+?���1h��J�c),p�OR.Ffj=rAȯ)�5�tٛa��@�D�������D�n\\�u�٠cEd\\3�BXkj� ��2��u<i�`�)� �D�Q�8!�K2P�� Ԁz�d��M	-zO��@}#��Q�t��@#�}\$H���J�PL�AA���11\nP �*�9zCH|C(G<<�Ìh�2ca�����~���/�1��^�P	�L*�&W��5#��s�9@&@��D���8��<�2D�IČh�L�pG0T�5��@z/-�����)���P,U�9&�l3�~}�EA����ӈ��Э6��>���\"	_m�9X�:�I��	�8P�T�@\$�A�9�0`�\".f�Q� +\r���.\"Ę�3b�.�\"NF��\\f�˓���v�>�2\\�J��:���ȉ<�[�\$� �Yr��ʳ��adr�ce}�s!#̱ZM�p���\"J��c�+������˩dn@8w@�\\Τ�X#u�W�oᬽ�Љ0W���^�t����'-OԞq�6�o���M�'! b%���2�y�sZ�ƻ�'<��Y/5�����a�vG�&�^s���i�:�Ƨ�8sR&���*{\"��	�������:ߍIKt�m8�(.!���QȘt>1��!Û�#��������zy[�ͤq{q�8�\"��C�ፓ�����%b�yX*4����5\n9A�G�:��Ěp�����H���H,��p��z�n���+̵[���@��A���c2L:I��9j�:�Ȏz��5��dH�X�0��{�>���B؀j����\n��K׳�dlI��	��O�NS��?u]\$�����g��+3���TG����\\5�]P���o��;���>/^X�!�M_�x~�x�1�5�u}�^��,{EQ�����Q��[_#�w�9F�b\"J�[���(bO�֮�2��2[>��Y�;I,���}s�MN�2Z����9M�����\n�čC\\/-*7���j��T#!��2C(��Ԭ��F�*֍����\"�.s���c���0.e^k��b'cF8B��\"G��G�,L��j\\��/�X�\\70RK�Z)0dr`��N�7픯Ў\" �L��/r�\"�R�w�\r��@l���i���Â9�;mp��P/\r,�&�p��/�����ԓl�t0J���Z\r�a	�Jo��������H��Q,\\���v�N�07P�\"���h�������10A�r�:�t_�D0�&\$�6r�V��,k:f�qj�/Q'�x�Q}��#��C~��l�D�&��D��# \"-VE�TSQ�T�8\$L�Þq�X;��r7�ѐA����/T��z�,��j��n\"D�8.T[���q��,ݭ�\\Qrϒ�H�!��P��� �\r;gfƎ�!��r;	p�,�##Q��L��\"��9\$�&1\0�j&d�öħ�E�`-�^��p!o;\"�:K�OQ#���R[\$q	)2Q\"��d�L!%�J�Z���,���^FJ;�Q Rb2�J2��Š���>j��b8�.2�\"��\$QJf�2��g,�\0�2=sz�'.�\n\\��n3,�4�8���@�C��<��9�91�\"N'2�j|��?�<�s\$��:���ܓH3Dz�2H�2�䥎2�!\n��3*3l\r)�7\"�7���`R~;rV��Ks�K.�72II|�{��רZ�r�^i��<@���c]*8��΁�\"��	=M��*��r��R\r��!D�b-�E��s�����IO^�CW�`�g++�\$]C,�C6\$C^��Zd�\r�V���c�t��\n���Z��(l�jB��B�1F������=�>Tm>jv��+Gmg��&^9�\rCgi�n,��D��\0����74.��QI�d_⒤���r�����&N��K�/�ȾJ:\$NDg�u0(�e���,��|�]�1l,���O�g?�����Q���C���ξ\"�i3uPI7�Q!n^[���� 	��:G�Cc>i�\n:P�#\r��m00e�\nÈa��	��X��5��5Z�\0�/��!��o�7qX�js'�&T�Mp�\r�P��E�`��g�Φ���#�/�@|b�\r`�h�o�dE��A�fc��";break;case"uk":$f="%���)��h-ZƂ���h.���� h-��m��h���Ć& h�#˘����.�(�.<�h�#�v���_�Ps94R\\����h�%��p�	Nm������c�L��4�PҒ�\0(`1ƃQ��p9�\$����&;d�H��5�}Q��\$���C��˩�Z��B��	D�8����(i�yA~�Gt(�y�g��Y�1~�Қ(��Bd��ׯK��m�JI���\r.(���V��V1>�#��\$:-���r�%C���Ǵ)/����t�p�^�\r���>�[73�'���6�SP�5dZ��{�h>/Ѡ���z0�)28�?��v�(P|\"��o���KB�\"i{*���� �5ϲ�:㹉��в���H���8ޣ�\"JB��Z�薉�(F�)��Z��Y(���\$�&�Y����6,�X\\�N�z�#����D�Z�9����)�ĵ+�;D�Lh1(�3�� �(1@ݷ��lhQ�ɠ�MH��>K� X Ě��!���аq�Q&���1�d3W�H�\\C�%�P�nTx�H��\$�D-���h��U͋^5��O�R�\"���\"9#:���h�ƁGQ8�mn#��N��O���*�# �4��(�&��Ԥ�!r��ް��X_ܥ�0�\\k�Usɐ��;(�~�����\r��3��:����x�\r��`Ap�9�x�7��9�c�v2��Fn�=,��@�Mn;GB���^0��jXƐ�/Q�� �Ѭ+�\rbe^V�8<\n��v�xZnz�	\n�O[D�_q��N��l��i��R�I�!7`PJ2biZB��ʫ\rs��5����hZ��~�H(5h���|�\$�`K ąD�U��D�ΐ���':�)Y:�%�<N����3u�^��j\"���Se#Y�j�/��p�f�<���Ǒr\r�AS\0Zޖ�|�)z���P��8���FF�V�T��z\$���,bdÛ��V.5'E�J,�4���V�@PS\n!1�1�hA��>&I��F_���:�Н��n��B\\�1%�����!D���BI��U�ġ�35b<NX���+x[*S]�H�aM�2�[\n�׍*o��\$+\$-h�����j��\"(���(k���0fҰ dM-��%JZP�&�=�5�] ÛL!q1���M�������׊2�0II0���E�b�!�RQ�����{\$�����NĤ��qi�������%&�A��@��)�Y���1'F�[T�0uG\$��e��B렟����9���L�D����TEaI�2V\\��2ȭC��4&T'�5�M	�N�Q��6&\$��6�C@\npDj\r9zqCӨ�N�#;����D��CY�>��w�����5	��mЩ�7�\r!ӕwiқ���cs��D9�Gf4��P�O4���bu���]��&W�I�&E����4DI<MILذ��Q\n�_�9&yK�<�8Ӎ�2&HəC*e���3&hͫ9gl������pa���4��E��l�h�,E�a)�<FD�IT2#+4�L	�J+�aU���%�D�J�/R�lO+N��h�a��:�b?���|�İ;6ԊA�e8+s%d쥕��^�Y�wf�޲3�xϚ\0eџ�;�T���IC��PU5�jڪ麟�Y�i�l�0Ks�х�.�jB�i�_'Q�x%��Un��D��x��P����i�m󾩇�'�v�'f�POs��Rٻ����s��ڴ�QI������C<�<;����y,̲BF,�@*PP	@ㆡ,ݡ9\0����O\nU� �1)\n ���\0��_L^�A\\��E�;�@'��)����|<]�1,Jh��y����Ɔ��9���a�7�0����ue[r���\0�4ɦ��T��I���\0�6�8�-�C�DGg�#h�2JS��!�0��Kgv�6Iϼ4��.J�mWGU�����P1�d�>y�kL&�mo���F,�\\��R1��X����	���\$#u���u̥PWƋԚ����r���B��F�Ć�V&qYl�Z�G�RDɚ���S=�}�2:B���s�y��x�O\naQ��u�Ca�I�W�%bF ��ܯFImӣ��`�\$��ML���� ���D����9��-����\$�uiON\$Rf�`�BIڄ��F\n�B�h��������b�4�pUB�-�u!�TxeQT�����[��L��L\"��7���&��wBn3#mت����5ue�p)�EW#E��[�F)?�y�~�	EY~���D����M����3�������\$�>��%!����1���b��Izu�}�\ny^�q��LAǗLG\$Q&�7�j�ǵBZD�f���#����6;f�F�z>_��u-��BșKD�ⴘ)R�\n�B����d����E�M��y�NViN�C�Ra\"�Fl(P��FÆFm�0Oz�hlA�\0I(�rmc��|�~6��fL���\r��6�P���脩ĄE���c��À#D��&�g�;\"z���S��=�*	 �\r\r �`@��\r�ڋ�v'�l�O�n�*��Ѝn�G���D�\$1����\\\n@�0�/NC��/���&2��[OXBDr14��:�D:q��Ђ!D�G�T�6�\$�^̦&�6*00O\rlEh(����M�ޅ�c�]\r���w�Z�\0DD�B�\n�CF5�9�(�Ⱥ�0Yϵ/�/j�WI.��\"U\0�\n�� �	��Gn��J�d���\\�,�vk*��Nm-�t�,s\0^-�4m��'�tt#u�5aE�Q��� z��(bh�&�;��J\0C�y�7�>�1� GW �1 �!G�	��2���\"�	\"��Y�\n�2!�#�p��c������%	��!%�;�*o%R2²Zϑ�(K�(�/(ī#Mn;��(2p6�t��!ң)6!��(�ʀbm�\$<r �Q��V�\"F�΢�w �v��x�,/�L�Z��<!j=�\nT��{bPR�͞��f&�Z�\"��(��*��>�&���d¡�n0�R[�.}md\\iR�D��q3��HZH���*d�&�p���|A)0�%� 	v�����#�#����B�R�r�8���8n���k]�ೕ:��8�?;0�po5;��)��<0�\n��;g�:o4M������Z���=��m���>A甝��zJ!�@zp���x���6��+C�p2��~/c�<�Lq�@\$�}��\r�4�^�9�a9�(v�Db�D�� ��w����\r����\r�\"\",�\$`F�\"Fv\r��ˮ\\\$����s̙Ӿ�3�I�L��c4RG�Z8�T���Њ	Jo'�hϔ��4��T�5��=J茛�U8J�E4�<(WK��Z��5OTU=4��\$���\$\\4�<���/�\r��hL�qEQ;QR����AD�\"�(�o�0�.��2������R5N��TU\"H�'Q�QRф(g�SGE*��:��C�W,풦�M�[��S��<X:��!5���X��!��E�F���Y��=Pf�P�����I��,\0j�].�&��qPb�Y��<��M�%6U���A]�^~&?��D��D-��)�>*�`Q[#]��ؕ�3MP��D�q	Yu�[SU	s�pS�y��<5%�`-�H��oB{Z�9ՑQ�{gAiZ����p�ouʩ��;!i��o�\n3I�h��h�l֭g�_Nָ���PV�P��f�j3AlGv�l>_QSu�E�=&�gP1\$>o0��l,�q�0��@g���]�Uq���Z4�E��KQ���}q�eS�irWW��ih�\\��e������p��vr�r�#m��2�N&WSi�f��;r�iE�����E�?1�ؑRQ��Z�3�h�rQZ��v�<��t,wg���dj�y�3X�Ag�V���a��zl{�qM?z7�z����\\V��\"��g�^(@�v�[����j(����gcdI���s�r7�qW�sb7�݂x\\׳M��m6�1,�g]E�~�i�g��q[V�Qq2aF*Tу���xY����pw��QD���VGR�� [1���ؓ�yd�q�{�X�Z�A��kl�EE�J?\$�	d>[wwS\r2c���,�7RH'��2�#�\\��*&j?Ts���	��btX��	��Î��}��;��wu���e�7�m(\$0�K�!��қ����X����\"�79��VyK\$J�rH+������_2ji~\r�V����\n��q4D:�D!sW�n��o�/V6��hӮ�Y�A\$,\n���Z�\$2fl��L	\n�L�V�eUc�n�!��m�).���E-GM�n�~�� �L�b ����ǵ5��	\rx�\"��7�5�\$ESx��EQ�%f�\"���i�@m|�yI3cȦ�@R}8��R��M	2\"=.�[,�esf�4�a��D5��^D��٥�S�e��Z�U��?U�q�(���Ei<z�k�B�,ጔY�3�s�V���~�����V�(8����è:\ra��	օ5�Pm�����/��CH��Rī?�s�*�����/a4c�#a5G�n������Q�8�cYApI�һ�@�Ep�wG��z{�S_l�6r�Aʛ8y��iPn��0�Й�LȰ[�ܱ;b ڪP����9V�4��GU��sS�==\n�%��VRx��\0";break;case"uz":$f="%���(�a<�\rƑ��k6LB�Nl6�L��p(�a5��1�`��u<�'A��i6�&��%4MF�`��B���\"���u2Kc'8�0��cA��n8��'3A��c4M�sI�@k7�#��**'��'3`(�;M��6,q��&�������ƙ}ģ+7��7���:B:�\rW��.3�b\r���4�����q��/�|\0(�a8�ۍ�� :`�*�{Vv��N��-�o�����)��d�g�x�i�w�7M�X(�'�b�%I��y��awu��:�D����5��������0�K�82cz�(��������\n2�#��ؗ�C�X���:\$��V�L[<�&�{♺�\nn�*2���M�4�7csX߯#��%ct�\$�n��5�L�� P�2�)s\n<�/s�&c�����\$��+*F����6�ј�1L�r�4�B���Cc�7�+��@S�� ޑ�#���;�Ȟ\r�hAPsS@t\rAI�D3Њ.��P��\"0�7��c2���D49c���x�_���)6�̈�ġ|9�c�\"2�|-8�L�4���x�@/��O2l�%:2��=&K��Z��T��ȳ\n���,=&C��w;˸ȼ���~�눲�!�(�2��,�'��x��a8�&�L<��N:�D�\0�9��=�9+C�,#��7���9�;W����и��:CF�`�3�C*d:\$R�(�(�'#j2�FR�n9L��\r!(�:��!�* 7��@�]m;��f	\$�	\r6�7��H&�J���(����<��8O<\r�J�:��?�9%�!�;'����!`�=���F���/S��	�)s��6���%���##��}.��K.u�<!uH�s�Q�ci�i���\0004۶�I�@��E����a�9�Ø�ݴ���|��а��:���*���D́�reY�cG���(��`S,�3��Y�#������R\rb�1�M��\\jM39¸_#5l�8��fA�c{��B��L}0��NnD+,���C�Ra�}�Ƣ��k\r\$�Dz�xRJ�� ='��R:��}�,�¢�b�ϑ2��%�bh�C@V\nɦ�Un�UڽW��`�2ı2�\r��2�VJ�����4�z�W{�t�\$�3PN�H�S�2KҐj�ze&J�@�;8*����T�{���T�S*�� \n�E��Ϗ�\\4����0�é�3�����l���W��`,)�(rX�\$2���I�ZO��Y,��~R�Q�X����Bʰ��s�L#�g\"�m��I��?d�m9�L!���Т\$���#s���v�)�bȉ#�-�(k��jhIT*�/	�\r4(��� (i.r�|\nMhe,\$£�tR]L+N�F�����\n��(Ю*\"NJIYM����\":}Y�'q����H��\0��a>��2�Q�l���#2J�9-�\$��@�v�u_PZ����F�D�wL�NH��{\$4:�Y@��(^g*�E\\W���_Ep4�3�) 	(|��b���m,ɸ�q'ہ��~7�-@k�Ka�����]�!�\r\$��P�-b!%r�(�(k�{@�:����dd��?�z��@n��3���n%����Ie�]�5�ēb�\0F\n����X�C����x9����q#�^�FR�)��b0'E�r�ch��,���HL��@�y�8C	\$)b�X�p\nd줚'bx�L�KO�;��ݏ�\n\n�h���Hu��T�Z�0�^di�!\"ǥ���P���\\yA<�3��M`��|�VU��T\n\\5��ӷK��e\"I����p	�����Pg��#ˉwlUt�2	��\rO�Ӓt�XR\0HAĭ�`��H���֛�*MN����|�A:/�N�'�)��t�~#],	�i�t@PH]��1��I�0�Y[�bh�dѠ(9�6�:\n�G�U�6;7F�u�Q���q���p�\$���aZ�5S;v�F�]�����}:f�H�n@� 8��Ɍ4��0Es�3�K6U;�S{���8�!�ƏC�@�aC8gM���>D_x�a.!	�Ԁ��b�'' ����#���Jzp()��C%��:�w4����\0Fk��:W�:�T\n�[u2����R}��B3�S^������Y/)̎�0�ȊOm2)�[��D�5�Q����CL1�&@����H)	�^\"�����g}{^�=��l�2��\\�y:epY':P�1F�gx��W�����Y�n��w���{�0�A�<���),\r��'�C�*7��-��`SbnM��%US�~�}�чY�c<�)��(,�Xg2� ����߃'����oh<7�n�Bv���ct�b �%���;\0 bC>��f�P\0@�*��m�`�����ׇ�0#�4x�%�)����)�.��gG>���h�F\r�˄Bx-�X�i�b&\\\r�#�?L|O��`e��\$/0��P��;	'ƍ��\"b�\0� d? � ��IL�>�H01�!�έS\0���n�ϭ\nB&����P�d��)�'J�0:y��~�\ngh�B�D;�W��\"rg̺���&��Q#\0�*�O	�\r�����	�6��`��?\0�	�8^c����u�bf@�|5�2�44�PnǴ��\$��s��Xi�X�j:��Dq��ѐǂ�}\"���B�L*���cZG-66I�:�\"\\J���(�<o�I�7l<��	��`�'�@�cNg���M�^���JG!E�����P��R)!n�.-4#bU\"Q#��!�?!͂�?\"�;\$BT߱XyRY��i����i�`ϣւAM��(��'*;�D��-l��R��/�M)n��T(&���]'�*�\rү!��*�-#r�����jg�Q�O\nH�@Z��\$M-�3-�].2�P�].��?�H�R1/`�.�\n?�\$�0S	/=d�.P(\n�/3\$��%�2��n*R �N2�i�)�#3��2�L`�N@��>C�J�%-4�A5�-2�m2��u3c5���d�\$�<K�������)\$;8���/+)9��Ns��D�@��f4���,����f�2,(yFF��+À\"��:�8�4�-6O�83ܤ`ش\rvCBz��=��<ʑ\00006��df0s��P�hW3�J5�h`�0�V\"���l(`�\n���pf�t+����\n��-<�\$w���]>86T^g��FP*3�|�):�*d��r�N�%����2�4!9�4t' ��0��m6\$H�ΖF����<k�P(�-�>D�<�n,\"l@�o0Ǉ����\r �'�6L�;OjN`�?��P4����\$���D�4SQ\r�6C�\"�cu}1��StgƬy@��PaΏ\"�'\"vv�0���Up �Ɓ�~�f7?��] �Q�GR%�4.6J#?�K��>�yIpr+��V.��S�4T,�g���;����](��guZ�/�e�?<�hH�PK�R ";break;case"vi":$f="%���(�ha�\r�q���]��Ҍ�]��c\rTnA�j��hc,\"	�b5H�؉q��	Nd)	R!/5�!PäA&n���&��0��cA��n8��QE\r ��Y�\$�Ey�t9D0�Q�(���Vh<&b�-�[��no���\n�(�U`�+�~�da���H��8i��D��\\�Pn��p��u<�4��k{�C3��	2Rum�����]/�tUږ[�]�7;q�q�w�N(�a;m��{\rB\n'�ٻ��_���2�[aT�k7��)��o9HH����0�c+�7���67�� �8�8@�������@����� \\��j L�+@�ƻ�l7)vO�IvL���:�I�枧��fa�k��jc�]�/�P!\0��d�!�� K� P� k�<�M\0��\r��@��h4�A�N!c3�(�7\$�X�b,(����R�-�2j�]��2<�!iJ N��A1���[�(�R�f1B�\"���\r������A���Z8B<��&u=SI#qtI>�(��0��P�2\r�����<9�ph��#��n������\0@C�҇\r㭘B�%\n�\0x����3��:����x�{��\r�a?/����p_p�c���I�|6��3?k�4���^0���2�T�.́BED�\"�,�9e���9)��:�&Y^�\"����;�\n��7ZH(J2/C��2��S)�c�s2�R̩���J�VJ\"!7���\"]q�����:��V6�qJć�eJZ7k,2 J���GV\n���5�����Hƈ3��Q7tW�céVI�~;U��6�Ê�4J4���Yf��B�Γ�F�\n#��TĮ�@�-џR��|[46'�h�(��P�Ccn�\r������)��+�u�ߢ�\$��\n�)C�4{�au�!�FTz~�ص%�W��h�UH�*]R�T���s�/��5��u��x� �%���J�aK�:V~�>�9�1�C��>h�3���,���t~�J6A�@��	�������8nZ(�����C�)\r\$�\0���`�\r�3*�I�h;�����\\F� ����BnE�P.��)���]�,\\� Q��z^Q�fi��.�Hn2����T���	�3ŕx�3@�� @��WK�1�@���u��޼W��^��|��4��\0`A��4N���\r�L�¢B�&��~KQ�AC��:G4��ċY3o�Č�Eғ�K���uK�\$�t.�ػ���^��|/�2}e�r_��D�	�&���BIfm�Od�9S���C�Na�\"��[ȹ{�Hq1B@���X-����I���fh�Md,��� \r��'���C�:FԘ�.�@��f��ԡ�*.��]S��צ8����u��[����'p&i�	w�D	%|D�\"x���w��8 �va�g�� hb���>T���y���cH����MC�Y�����\\E	�j:�(�뾐Ӓč�	!Ki�t�A5zaH#X)�f�����1&�4��Ы�e�����c��6i�\0(��;(�v(�Msr����s��j-DȚ6��BI�>腦��mR��u\$�\$�0�\$��74B]�Q�@�\$3s�&�9+��\0դ�+��2�|��� M��/\n<)�H�w���s�\$L��pjĘ�\\�XK�݀���:M+��C3\$���<�R���3�~�Gr\"RH�(�!�p�*�ζ3d�����ҜE��2��ti�-����b^f,��+���N �^E��G�B\$y������Q��+� �j�gF\$�X�\rE�)w8���I)�>��12Y;������'��z�zd�qv\"�m(Y�hD���ӱ^h�?�#�����ta�L_(�#/L\0�0�*:G04Uz����m(b�z��\rP�Lܓs���ٟwY���\n��^#\$���7�Z���-�-���\\Ãg��9�5�=��N\np%��ވ��#6��P�كHz�gd2�s�\r�1W�<���Ã�����]���qYY�m�C�\"㌒��GR�D�j��C�Yl3�֤��Jk������@T��.H�<ãQ�_L;�Ŕ�U�\r����pP�#B��K릜��1 ��i��@()-�ҁR:o��e^�L���Ʊ<�aF��|�Aa\"6p�ϐ�X�%W�zXxRX}20�8�2!��}��@� d��WĖ�^�db�g���^]�A�)�ϐ�XE�(,'�VPOG�Y!\$1���n�	6�,e*;�nI��C�-o�<��PI���d�K�b�J�!��\\��L�Ԯ�Tb��~�u�#7�a%���#v�o������t�/���\"V.�̢��.~�Fdl2KrNJ\09Zތ���p��\"��K�T�� K��#lЛ �I�*��cb��L�C�`0V{�H�8!�J&k�lX+�<o�����6�a~#��-*s,1	�N�n�������#bt�!D+�@5�(&r�D6�F˦�UТFA�Z\"�|�Ѐ�C6�|���|\r�z��m��l�ڈNg\n�2�GJ���D��dNJmG���D�-��\r;�n�MGB�{qC��G�{�MQ^bQLy��n�.ߧ��Z�D��O����[ń\\�O�\"�h2/l1h�<���d�MW�y0m�#�5�B �ˉ�ѷ�|*Fk�.c�7�G殡E�kl\\�VC��������D���L�c̬��NΆޫq�#������i�l�����	�� �0�fd){���[�f&g�rA%�I\$��FG�¯�BN�G���N�dqkq(�x1c'#�(2�H�m)r���)F�*/0�a^A/b�p�C�D��,�\"p\$�i�룠eE�����Y'�]n�(r4\"��XR��db���#'�{o�1G�.�q\0����02�/O���Sp���\"��5H����%ЧoD(�r2`��Eũ3ԑ�	4���|ST�L�q[��M��|Sj�r�e�� ��5��M�>��֔d\0�&=P��d+8n�8�@�9&̥oJ��:�+Έh�&�Xg��E���\"�4nU<�'=2}3��=�S=�5>N�8�+��Qet��i*��*�� ���Q��e����@�3�dQ4ﱚ�p���:���N|�J#cN~#V0�؍�DW���c��rF�2h=p���,��X'P\ntb�*�Ա�/�	�8��bФ�p����\r�k�%4�x�s�\"��B�6/p�4��R\n���ZE�������TrT4ep\"G�r��7�n}��&��4�/����&��!3	I�!6&�hmF8j�	7�@T�x6B�U�R-��Ҥ�\n�lw�뒾���s4�;CDd�bCUK&�mF�f\r@%��U1�V,��l8�boW��!��e�dP�Xo�N�@�&E\r����0�	�v���\$Q�į\\��(�����%bZPp����N�3[�,H����]�\\�Aro��X�vMKL�\0�0��46j�4Pa^0���ʙ,����U0�p��E<���4I��#&d�:�l� \r��>�����LI�\"���Aj��3�qA�v�f�k�CD(`";break;case"zh":$f="%��:�\$\nr.����r/d�Ȼ[8� S�8�r�NT*Ю\\9�HH�Z1!S�V�J�@%9��Q�l]m	F�U��*qQ;C��f4����u�s�U�Ut� �w��:�t\nr���U:.:�PǑ.�\r7d^%��u��)c�x�U`�F��j���rs'Pn��A̛ZE��f��]��E�v���it�U��λS�ծ{�����P��g5�	E�P�N�1	V�\n���W�]\n�!z�s���ΟR�R������V�I:�(�s#.UzΠ@�:w'_�T\$��pV�L��D�')bJ�\$�pŢ���[�MZ��\n.����>s��K��AZK��aL��HAtF3���D�!zH����C��*r�e��^�K#�s��X�g)<��v׬h�E')2���Anr�j����\n:�1'+ֲ2izJ���sͲ� ��h�7���]�	9H���N_�es���K��?	RY4=D��F�@4C(��C@�:�t��T3��>��x�3��(���9�����I�|��1B�:LΝ\$=0�!�t�I�E�'5(����RMy&s�#SE�͒CH���]K�:KC%�um0�K�V��)\"EA(�CGA�Fpܗ&���fTY��C�G)\0D��G�S�W�)\0^c���T�e��wa D#��8s��*.]��\"h^��9zW#�s\0]c����9�a D�j<V���]2��g��C�\$�CC�m�8)�\"e��ntI����4�}�|=3Q'�'1Q,���g^����n�K�s��SL̋&��e�Ȝ�:Ͽ���C3�4�;���.Ml`#�@6����S6::���=��9C�Z�\\u��|!��p�4�����Z)�M=�����?�pA\$�_��Kz�<�O66����ҙt_����N�o-6M��HX��:+��3����.~ɻFbt�\"�\$r�!b�J��ՄP�~�T]�'�@�G�����r��[��\0 �@�\$�\$C1v+ʛS�}P�5J��J�U��X+%h��xdx��:����2°_:X�%��P�Q�'Ea/1ir\"&���B�\rB�o��M� ����~����pO��r��TJ�S*�T�b��*�Y�UnC�tV��'+u�����ABV2>,�E��\$�\$W1�,��\"r��,�E����4H=���I�>�Ŋ�H9���kd�vd��\$?�M���#����9#� ��9t�,Ǩ�4��z�Z��) @@Pz�\"M�Q-�DV'�:�HI�A�ØG\nTf,8�o&Hs��_;��0�hDM#�bʹ{m�R�� NAr@���a�(�3��W��T&(8��LZ(��(���-I\0PP�\n\"\0C\naH#.)(�#g�8/I�\$V�&.��F�R�:����E=�9)%hhs\n�j��;?c���a@�+�\\�p� Z��лНW�*�RdȱQ��4G4��\\�р�\0�£�R����AOX�c���H�U��t���*����!Y�?l��� 	�E���L#@�CȈ�&	8E�@�OIy�\"�9+1d��ϣ����R	c��(�Y����P�*[�s� E	��a/WE�`LS�A/���D��MB�����sF��QB.Qw�Eߢ�)���0t��7gʅ��2�Ş�����\rn�a��#�/���-�/)�&�dF�@&g�@DCOA��^�|���\n|J����I�a��s4GEʹ�nٓ3�+���n<�ArV\n9�07����Àl��=�����\r�:1�;>��t/�vJ�ֻNx�]�� ��B}\r!��`��idf��8E�.Y��Єt]	�&�P�����t�g	\r��\0!����CS�02�\0ǧ�^q_�<H�������z�-���#��EpM�&/�ႢPs 9&����Í!��0�I�p�#���#e�r��P �0�9��F/p����`,�\r�&�ܢ�lM��#4R�x\n;��C#�`���h�H�M�D͝�R7�.;�<�v,��l�1|g1�*�^d�%����\"\\(U�4�v�X��LU[Ա��PW���[�Qn�63�B���7J Ô@��Zͅ؅j+ypn��Zr��s�e���z/�tt�=_�Yͽ�0�~*f�k�Y_C܅r�ݣ)顗�~�hTDm?G\r\r�Г\0G1�\0��\$�'5��m+W\nL��_\\x�FZ��]:'B?M/��a6ue��F�x�h6��x�g���&\n,\0S�\r��=�_A�2���	6{��t�C����<��y���/\n�W�����7��#�аg�dl��#�d!�gk}�9��8�{)i������6�ͧ\0N�'�a!�I��\n>���)b�bH�����	�%k,�D�R�+�F!��aBg�c���~�Ap��p8�pPI�tB�ܸ����\"�6��гke/����H/�9�����|��sL����EM�#/����٢}	��0���]0�k�P�-�-��e�����������.�CJ�*�P��,(M��o�\0���h���a[����rr�T�P��m��O�V��9A6�<-����a1��]��#�f�p��a.�9�S��1<^шӠ���6W@@@�V�@��\0����\r�Ѡ'�O���-QgM�f�\0�Ԁ�w�X�@���P���J���]1�Ց��0�-h4F��qAN�np�DFD��q|ڡo�!с\"B�	t� ���i	��#\$-t�߃>F-��^�.����F�����,�w%D�\$�8�\0�����>,��g�\r�v��~�p� 3�\"F)��� �N�PR�C�\n���Zh�����Ю�C��!��d��e�J��H.!��6ì���6���̀�����dgʳ���T3\n���1��䊪��#��\\J������\"��������Z�Q!�5�B����F����-�4*2fM1�o��ҽ+��M���At��:,�FE�B������� ���\r��!d��,#�G3C������\$\$�3�B9�{4�'�\n�iJ��>��=Ʈ9�L>�7<�vCo�8�B>(+�D�z�";break;case"zh-tw":$f="%��:�\$\ns�.e�UȸE9PK72�(�P�h)ʅ@�:i	��a�Je �R)ܫ{��	Nd(�vQDCѮUjaʜTOAB�P�b2��a��r\nr/Tu�ʮM9R��z�?Tא��9>�S��Ne�I̜D�hw2Y2�P�c����мW���*�=s���7���B��9�J����\"X�Q��2��M�/�J2�@\"�W��r�TD�{u������t�s�p�������S��\\=\0�V����p��\"R� )ЪOH����ΔT\\ӊ�:}J�F+��JV�*r�EZ�s�!Z�y���V꽯yP��A.���yZ�6Y�I�)\ns	�Z����̢��[��2�̒�K�d�J���12A\$�&���Y+;ZY+\$j[GAn�%�J��s�t)�P��)<�?��\0U��w�*�x].�2����ft+<�Kd���(A2]��*�X!rB��\n# �4��(�t��E\r�l	�Tr��{:�OpbJBO�:�F�@4C(��C@�:�t�㽄4�)K�x�3��(���9��P��I�|t(�B�1֯�B�|�\$	q���/��9H]D�̸�et\\���K6���?஋LQ��\\��1�H�@PJ2�:�@��ea	&�s�2��S�o1Q�d��0�ם3M�e�w�d:<C��)xG�d�r�B�H���re��B�i�^��1I@\"Z���P@fg1pM�	j^�B��<��J��L�f*�8��3(ڰ:�s� �(��&^�)�D�r\n�淘1(\\մ	�_�ܾ��7�&]�>Tt7�34���ҥ�r<���/hC�H�Hs���,��o7|�u+�wxbØ@6����X�U��:�Cp@0���9#��u�W�9���7�H����}�U��1	~1KT���N�����F�Q8�)HTK�P��s3c�M�#�&� ��)F�Gp������X�a*%�)F��G4��B',a\n�a�\$\n0���C�ո)�Ȉ%�)�(�pfD ��N���*��R��:a\0��(�&��D	`\$U��V��\\��z��\n�X�Id,����xd|�:�ζ����V��\"@���XC�t��	e/��0ʴ��E��#Ȫ��髃�����d���pO��­��WJ�_,��\"Ɗk%e�՞���nrEl-�b��(�����f\0CG@�e}���!]����>]�w/���U��\$fEh�C�5�1Q��B�'!!�&Ѱ�9�sa\"����C�Q>-��0d\$��TD�2(2xD�v������\0� \r��\$BG�u\"��#䄑��Fօ*�D�M?�!P�D*��\$G@�&d͘tl!E*�U)�\r\$8lG9i^*��h�Ѓ��L\n�f#�@�A\n�/�8F[�(��4��ZjI�\0C\naH#\0��Z�'��)��E�\$&r�a\\E�^0��\n��G0���\\C�k=��&ȵ�4t�X�EP,S!�'��Bb�S*r�?�QX�ʼW�~9�����K�Ă\"G4��N�\"�xS\n��V�EFLI�fdΜ;��&���/�U����iਪ\r@��50T\n��;&��8L%�DޜG*s��p��,9�6�Թ�BL�pO	��*�\0�B�EX@�.	d,�^�1 #G9##�=��V��0�sn�黳�b�a�:�X��VAE�X/�OD�堔����q��hT��ػ�����ޛE\0*�0���H �P\"��`�\$ӣR\"�\0���\0R�]�aeP\0ֈ�YEh�D4n��A��j���՘q��]�	9ӑ�bL�!\"���J%܆�E<�07�P���l��J0��Y��4��B+-gU�\r�:�EH��,��b�*��`��d�\nCphR��:<���xm!�Q4\$�����3g��9�А!9	�,.qE���������a�O5k( {�5�aN.+��N�0�o}��G��sL�I�����ԱxК&��A��.Ŷ�2��ҡ�t1��@�K@��@�>�r�>T)yex=�|��TyX� ���1�G��������4H\\^��'���26�H��v)*���^�0��F��&^��c��O-7�F/2\\�E�B����˭�IA��NI�a&:&��\"ro�Q|t�x�NG�CIA@ orp�[���ֺ-#,�]sT| �����-�轼��?d�ӈ��\".b�/c�a�A�A�S�h��~n�#��E��5F-�N��}Q�\n�5�Y��,��D<�� k���6����T�d=������e6��>#������Ȋ���\r/���N���#��#��s���m��*�����d� \r��YM�\r\r�|�4\r�t^f�n�<�l4|�����.4L̄F��Ϯσql>uo��n;���'<�!W���'Nx�jߐ�����ts\rXu�h.��L�F��.�|2�鮞�/����k�Ak	r������ߐ�ܫ�����(�\$9\r�^B�ʛ0>�\$�����\$�U���ͺ���	���p�J��������LU�%B���俑�\nˏ��#4�(I�'	&`cm�%�u���t�cn�xC�q�x�p~�,jm\r\r�n1n;�0p���A�rB�.GB���^h��+�B^��~(�7q�\n�)��(�!Q��쓰�!�h ��0%�Ѳ�\0hr cy ��L\"'G'���\$-.�P�#R/��\"�<Ѳ(�R%#�d����\"R%��� ��efZF2��\0��\0�\r.|2i&��'\0�'G���-(-�ޒnyR�'mB����2�M�ޑ�FV�2���#�0����RU+��0�-R��mr�,C���Hq�\r\$���K��/�\r/�{s\0��	��@�!�k����4�tC���j*�\0ƚ�P��R���D�<�c���az!ph!\n.�C��F�rC���AB�1���2��h \r��8�:�T%�bg\$��0�E�93\0\n���Z�u��h�ʠ*d!bx�z[��	m�^kj\\��K)�9C�[��0l�P�����?j��	>K\$�C�@g�\"�t+A��Q�����z,aBB:t����4��5��!`^0�Pj�F�		o�w���q�)VƘi�=��!2�PAM�G�IG���, ����&ʨ�\n��`��ڑT++�EMnN^�+>�M���R�t w4)B�n�D0���L�j=5��&rrK1�\$�B<)���,�HPB�";break;}$dj=array();foreach(explode("\n",lzw_decompress($f))as$X)$dj[]=(strpos($X,"\t")?explode("\t",$X):$X);return$dj;}abstract
class
SqlDb{static$instance;var$extension;var$flavor='';var$server_info;var$affected_rows=0;var$info='';var$errno=0;var$error='';protected$multi;abstract
function
attach($N,$V,$F);abstract
function
quote($Q);abstract
function
select_db($Pb);abstract
function
query($H,$nj=false);function
multi_query($H){return$this->multi=$this->query($H);}function
store_result(){return$this->multi;}function
next_result(){return
false;}}if(extension_loaded('pdo')){abstract
class
PdoDb
extends
SqlDb{protected$pdo;function
dsn($pc,$V,$F,array$bg=array()){$bg[\PDO::ATTR_ERRMODE]=\PDO::ERRMODE_SILENT;$bg[\PDO::ATTR_STATEMENT_CLASS]=array('Adminer\PdoResult');try{$this->pdo=new
\PDO($pc,$V,$F,$bg);}catch(\Exception$Kc){return$Kc->getMessage();}$this->server_info=@$this->pdo->getAttribute(\PDO::ATTR_SERVER_VERSION);return'';}function
quote($Q){return$this->pdo->quote($Q);}function
query($H,$nj=false){$I=$this->pdo->query($H);$this->error="";if(!$I){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($I);return$I;}function
store_result($I=null){if(!$I){$I=$this->multi;if(!$I)return
false;}if($I->columnCount()){$I->num_rows=$I->rowCount();return$I;}$this->affected_rows=$I->rowCount();return
true;}function
next_result(){$I=$this->multi;if(!is_object($I))return
false;$I->_offset=0;return@$I->nextRowset();}}class
PdoResult
extends
\PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch_array(\PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch_array(\PDO::FETCH_NUM);}private
function
fetch_array($uf){$J=$this->fetch($uf);return($J?array_map(array($this,'unresource'),$J):$J);}private
function
unresource($X){return(is_resource($X)?stream_get_contents($X):$X);}function
fetch_field(){$K=(object)$this->getColumnMeta($this->_offset++);$U=$K->pdo_type;$K->type=($U==\PDO::PARAM_INT?0:15);$K->charsetnr=($U==\PDO::PARAM_LOB||(isset($K->flags)&&in_array("blob",(array)$K->flags))?63:0);return$K;}function
seek($C){for($t=0;$t<$C;$t++)$this->fetch();}}}function
add_driver($u,$B){SqlDriver::$drivers[$u]=$B;}function
get_driver($u){return
SqlDriver::$drivers[$u];}abstract
class
SqlDriver{static$instance;static$drivers=array();static$extensions=array();static$jush;protected$conn;protected$types=array();var$insertFunctions=array();var$editFunctions=array();var$unsigned=array();var$operators=array();var$functions=array();var$grouping=array();var$onActions="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";var$partitionBy=array();var$inout="IN|OUT|INOUT";var$enumLength="'(?:''|[^'\\\\]|\\\\.)*'";var$generated=array();static
function
connect($N,$V,$F){$g=new
Db;return($g->attach($N,$V,$F)?:$g);}function
__construct(Db$g){$this->conn=$g;}function
types(){return
call_user_func_array('array_merge',array_values($this->types));}function
structuredTypes(){return
array_map('array_keys',$this->types);}function
enumLength(array$n){}function
unconvertFunction(array$n){}function
select($R,array$M,array$Z,array$yd,array$dg=array(),$z=1,$D=0,$Wg=false){$ve=(count($yd)<count($M));$H=adminer()->selectQueryBuild($M,$Z,$yd,$dg,$z,$D);if(!$H)$H="SELECT".limit(($_GET["page"]!="last"&&$z&&$yd&&$ve&&JUSH=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$M)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($yd&&$ve?"\nGROUP BY ".implode(", ",$yd):"").($dg?"\nORDER BY ".implode(", ",$dg):""),$z,($D?$z*$D:0),"\n");$ni=microtime(true);$J=$this->conn->query($H);if($Wg)echo
adminer()->selectQuery($H,$ni,!$J);return$J;}function
delete($R,$fh,$z=0){$H="FROM ".table($R);return
queries("DELETE".($z?limit1($R,$H,$fh):" $H$fh"));}function
update($R,array$O,$fh,$z=0,$Qh="\n"){$Fj=array();foreach($O
as$y=>$X)$Fj[]="$y = $X";$H=table($R)." SET$Qh".implode(",$Qh",$Fj);return
queries("UPDATE".($z?limit1($R,$H,$fh,$Qh):" $H$fh"));}function
insert($R,array$O){return
queries("INSERT INTO ".table($R).($O?" (".implode(", ",array_keys($O)).")\nVALUES (".implode(", ",$O).")":" DEFAULT VALUES").$this->insertReturning($R));}function
insertReturning($R){return"";}function
insertUpdate($R,array$L,array$G){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($H,$Pi){}function
convertSearch($v,array$X,array$n){return$v;}function
convertOperator($Xf){return$Xf;}function
value($X,array$n){return(method_exists($this->conn,'value')?$this->conn->value($X,$n):$X);}function
quoteBinary($Dh){return
q($Dh);}function
warnings(){}function
tableHelp($B,$ze=false){}function
inheritsFrom($R){return
array();}function
inheritedTables($R){return
array();}function
partitionsInfo($R){return
array();}function
hasCStyleEscapes(){return
false;}function
engines(){return
array();}function
supportsIndex(array$S){return!is_view($S);}function
indexAlgorithms(array$xi){return
array();}function
checkConstraints($R){return
get_key_vals("SELECT c.CONSTRAINT_NAME, CHECK_CLAUSE
FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS c
JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS t ON c.CONSTRAINT_SCHEMA = t.CONSTRAINT_SCHEMA AND c.CONSTRAINT_NAME = t.CONSTRAINT_NAME
WHERE c.CONSTRAINT_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
AND t.TABLE_NAME = ".q($R)."
AND CHECK_CLAUSE NOT LIKE '% IS NOT NULL'",$this->conn);}function
allFields(){$J=array();if(DB!=""){foreach(get_rows("SELECT TABLE_NAME AS tab, COLUMN_NAME AS field, IS_NULLABLE AS nullable, DATA_TYPE AS type, CHARACTER_MAXIMUM_LENGTH AS length".(JUSH=='sql'?", COLUMN_KEY = 'PRI' AS `primary`":"")."
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
ORDER BY TABLE_NAME, ORDINAL_POSITION",$this->conn)as$K){$K["null"]=($K["nullable"]=="YES");$J[$K["tab"]][]=$K;}}return$J;}}add_driver("sqlite","SQLite");if(isset($_GET["sqlite"])){define('Adminer\DRIVER',"sqlite");if(class_exists("SQLite3")&&$_GET["ext"]!="pdo"){abstract
class
SqliteDb
extends
SqlDb{var$extension="SQLite3";private$link;function
attach($p,$V,$F){$this->link=new
\SQLite3($p);$Ij=$this->link->version();$this->server_info=$Ij["versionString"];return'';}function
query($H,$nj=false){$I=@$this->link->query($H);$this->error="";if(!$I){$this->errno=$this->link->lastErrorCode();$this->error=$this->link->lastErrorMsg();return
false;}elseif($I->numColumns())return
new
Result($I);$this->affected_rows=$this->link->changes();return
true;}function
quote($Q){return(is_utf8($Q)?"'".$this->link->escapeString($Q)."'":"x'".first(unpack('H*',$Q))."'");}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;}function
fetch_assoc(){return$this->result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$d=$this->offset++;$U=$this->result->columnType($d);return(object)array("name"=>$this->result->columnName($d),"type"=>($U==SQLITE3_TEXT?15:0),"charsetnr"=>($U==SQLITE3_BLOB?63:0),);}function
__destruct(){$this->result->finalize();}}}elseif(extension_loaded("pdo_sqlite")){abstract
class
SqliteDb
extends
PdoDb{var$extension="PDO_SQLite";function
attach($p,$V,$F){$this->dsn(DRIVER.":$p","","");$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return'';}}}if(class_exists('Adminer\SqliteDb')){class
Db
extends
SqliteDb{function
attach($p,$V,$F){parent::attach($p,$V,$F);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return'';}function
select_db($p){if(is_readable($p)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$p)?$p:dirname($_SERVER["SCRIPT_FILENAME"])."/$p")." AS a"))return!self::attach($p,'','');return
false;}}}class
Driver
extends
SqlDriver{static$extensions=array("SQLite3","PDO_SQLite");static$jush="sqlite";protected$types=array(array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0));var$insertFunctions=array();var$editFunctions=array("integer|real|numeric"=>"+/-","text"=>"||",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("hex","length","lower","round","unixepoch","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($N,$V,$F){if($F!="")return
lang(22);return
parent::connect(":memory:","","");}function
__construct(Db$g){parent::__construct($g);if(min_version(3.31,0,$g))$this->generated=array("STORED","VIRTUAL");}function
structuredTypes(){return
array_keys($this->types[0]);}function
insertUpdate($R,array$L,array$G){$Fj=array();foreach($L
as$O)$Fj[]="(".implode(", ",$O).")";return
queries("REPLACE INTO ".table($R)." (".implode(", ",array_keys(reset($L))).") VALUES\n".implode(",\n",$Fj));}function
tableHelp($B,$ze=false){if($B=="sqlite_sequence")return"fileformat2.html#seqtab";if($B=="sqlite_master")return"fileformat2.html#$B";}function
checkConstraints($R){preg_match_all('~ CHECK *(\( *(((?>[^()]*[^() ])|(?1))*) *\))~',get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R),0,$this->conn),$cf);return
array_combine($cf[2],$cf[2]);}function
allFields(){$J=array();foreach(tables_list()as$R=>$U){foreach(fields($R)as$n)$J[$R][]=$n;}return$J;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
array();}function
limit($H,$Z,$z,$C=0,$Qh=" "){return" $H$Z".($z?$Qh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Qh="\n"){return(preg_match('~^INTO~',$H)||get_val("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($H,$Z,1,0,$Qh):" $H WHERE rowid = (SELECT rowid FROM ".table($R).$Z.$Qh."LIMIT 1)");}function
db_collation($k,$lb){return
get_val("PRAGMA encoding");}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($j){return
array();}function
table_status($B=""){$J=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($B!=""?"AND name = ".q($B):"ORDER BY name"))as$K){$K["Rows"]=get_val("SELECT COUNT(*) FROM ".idf_escape($K["Name"]));$J[$K["Name"]]=$K;}foreach(get_rows("SELECT * FROM sqlite_sequence".($B!=""?" WHERE name = ".q($B):""),null,"")as$K)$J[$K["name"]]["Auto_increment"]=$K["seq"];return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return!get_val("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($R){$J=array();$G="";foreach(get_rows("PRAGMA table_".(min_version(3.31)?"x":"")."info(".table($R).")")as$K){$B=$K["name"];$U=strtolower($K["type"]);$l=$K["dflt_value"];$J[$B]=array("field"=>$B,"type"=>(preg_match('~int~i',$U)?"integer":(preg_match('~char|clob|text~i',$U)?"text":(preg_match('~blob~i',$U)?"blob":(preg_match('~real|floa|doub~i',$U)?"real":"numeric")))),"full_type"=>$U,"default"=>(preg_match("~^'(.*)'$~",$l,$A)?str_replace("''","'",$A[1]):($l=="NULL"?null:$l)),"null"=>!$K["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["pk"],);if($K["pk"]){if($G!="")$J[$G]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$U))$J[$B]["auto_increment"]=true;$G=$B;}}$hi=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));$v='(("[^"]*+")+|[a-z0-9_]+)';preg_match_all('~'.$v.'\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$hi,$cf,PREG_SET_ORDER);foreach($cf
as$A){$B=str_replace('""','"',preg_replace('~^"|"$~','',$A[1]));if($J[$B])$J[$B]["collation"]=trim($A[3],"'");}preg_match_all('~'.$v.'\s.*GENERATED ALWAYS AS \((.+)\) (STORED|VIRTUAL)~i',$hi,$cf,PREG_SET_ORDER);foreach($cf
as$A){$B=str_replace('""','"',preg_replace('~^"|"$~','',$A[1]));$J[$B]["default"]=$A[3];$J[$B]["generated"]=strtoupper($A[4]);}return$J;}function
indexes($R,$h=null){$h=connection($h);$J=array();$hi=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R),0,$h);if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$hi,$A)){$J[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$A[1],$cf,PREG_SET_ORDER);foreach($cf
as$A){$J[""]["columns"][]=idf_unescape($A[2]).$A[4];$J[""]["descs"][]=(preg_match('~DESC~i',$A[5])?'1':null);}}if(!$J){foreach(fields($R)as$B=>$n){if($n["primary"])$J[""]=array("type"=>"PRIMARY","columns"=>array($B),"lengths"=>array(),"descs"=>array(null));}}$li=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($R),$h);foreach(get_rows("PRAGMA index_list(".table($R).")",$h)as$K){$B=$K["name"];$w=array("type"=>($K["unique"]?"UNIQUE":"INDEX"));$w["lengths"]=array();$w["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($B).")",$h)as$Ch){$w["columns"][]=$Ch["name"];$w["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($B).' ON '.idf_escape($R),'~').' \((.*)\)$~i',$li[$B],$qh)){preg_match_all('/("[^"]*+")+( DESC)?/',$qh[2],$cf);foreach($cf[2]as$y=>$X){if($X)$w["descs"][$y]='1';}}if(!$J[""]||$w["type"]!="UNIQUE"||$w["columns"]!=$J[""]["columns"]||$w["descs"]!=$J[""]["descs"]||!preg_match("~^sqlite_~",$B))$J[$B]=$w;}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("PRAGMA foreign_key_list(".table($R).")")as$K){$q=&$J[$K["id"]];if(!$q)$q=$K;$q["source"][]=$K["from"];$q["target"][]=$K["to"];}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',get_val("SELECT sql FROM sqlite_master WHERE type = 'view' AND name = ".q($B))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($k){return
false;}function
error(){return
h(connection()->error);}function
check_sqlite_name($B){$Sc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Sc)\$~",$B)){connection()->error=lang(23,str_replace("|",", ",$Sc));return
false;}return
true;}function
create_database($k,$c){if(file_exists($k)){connection()->error=lang(24);return
false;}if(!check_sqlite_name($k))return
false;try{$_=new
Db();$_->attach($k,'','');}catch(\Exception$Kc){connection()->error=$Kc->getMessage();return
false;}$_->query('PRAGMA encoding = "UTF-8"');$_->query('CREATE TABLE adminer (i)');$_->query('DROP TABLE adminer');return
true;}function
drop_databases($j){connection()->attach(":memory:",'','');foreach($j
as$k){if(!@unlink($k)){connection()->error=lang(24);return
false;}}return
true;}function
rename_database($B,$c){if(!check_sqlite_name($B))return
false;connection()->attach(":memory:",'','');connection()->error=lang(24);return@rename(DB,$B);}function
auto_increment(){return" PRIMARY KEY AUTOINCREMENT";}function
alter_table($R,$B,$o,$ld,$qb,$_c,$c,$Ba,$E){$zj=($R==""||$ld);foreach($o
as$n){if($n[0]!=""||!$n[1]||$n[2]){$zj=true;break;}}$b=array();$og=array();foreach($o
as$n){if($n[1]){$b[]=($zj?$n[1]:"ADD ".implode($n[1]));if($n[0]!="")$og[$n[0]]=$n[1][0];}}if(!$zj){foreach($b
as$X){if(!queries("ALTER TABLE ".table($R)." $X"))return
false;}if($R!=$B&&!queries("ALTER TABLE ".table($R)." RENAME TO ".table($B)))return
false;}elseif(!recreate_table($R,$B,$b,$og,$ld,$Ba))return
false;if($Ba){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $Ba WHERE name = ".q($B));if(!connection()->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($B).", $Ba)");queries("COMMIT");}return
true;}function
recreate_table($R,$B,array$o,array$og,array$ld,$Ba="",$x=array(),$lc="",$la=""){if($R!=""){if(!$o){foreach(fields($R)as$y=>$n){if($x)$n["auto_increment"]=0;$o[]=process_field($n,$n);$og[$y]=idf_escape($y);}}$Vg=false;foreach($o
as$n){if($n[6])$Vg=true;}$nc=array();foreach($x
as$y=>$X){if($X[2]=="DROP"){$nc[$X[1]]=true;unset($x[$y]);}}foreach(indexes($R)as$Ce=>$w){$e=array();foreach($w["columns"]as$y=>$d){if(!$og[$d])continue
2;$e[]=$og[$d].($w["descs"][$y]?" DESC":"");}if(!$nc[$Ce]){if($w["type"]!="PRIMARY"||!$Vg)$x[]=array($w["type"],$Ce,$e);}}foreach($x
as$y=>$X){if($X[0]=="PRIMARY"){unset($x[$y]);$ld[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($R)as$Ce=>$q){foreach($q["source"]as$y=>$d){if(!$og[$d])continue
2;$q["source"][$y]=idf_unescape($og[$d]);}if(!isset($ld[" $Ce"]))$ld[]=" ".format_foreign_key($q);}queries("BEGIN");}$Wa=array();foreach($o
as$n){if(preg_match('~GENERATED~',$n[3]))unset($og[array_search($n[0],$og)]);$Wa[]="  ".implode($n);}$Wa=array_merge($Wa,array_filter($ld));foreach(driver()->checkConstraints($R)as$Ya){if($Ya!=$lc)$Wa[]="  CHECK ($Ya)";}if($la)$Wa[]="  CHECK ($la)";$Ji=($R==$B?"adminer_$B":$B);if(!queries("CREATE TABLE ".table($Ji)." (\n".implode(",\n",$Wa)."\n)"))return
false;if($R!=""){if($og&&!queries("INSERT INTO ".table($Ji)." (".implode(", ",$og).") SELECT ".implode(", ",array_map('Adminer\idf_escape',array_keys($og)))." FROM ".table($R)))return
false;$jj=array();foreach(triggers($R)as$hj=>$Qi){$gj=trigger($hj,$R);$jj[]="CREATE TRIGGER ".idf_escape($hj)." ".implode(" ",$Qi)." ON ".table($B)."\n$gj[Statement]";}$Ba=$Ba?"":get_val("SELECT seq FROM sqlite_sequence WHERE name = ".q($R));if(!queries("DROP TABLE ".table($R))||($R==$B&&!queries("ALTER TABLE ".table($Ji)." RENAME TO ".table($B)))||!alter_indexes($B,$x))return
false;if($Ba)queries("UPDATE sqlite_sequence SET seq = $Ba WHERE name = ".q($B));foreach($jj
as$gj){if(!queries($gj))return
false;}queries("COMMIT");}return
true;}function
index_sql($R,$U,$B,$e){return"CREATE $U ".($U!="INDEX"?"INDEX ":"").idf_escape($B!=""?$B:uniqid($R."_"))." ON ".table($R)." $e";}function
alter_indexes($R,$b){foreach($b
as$G){if($G[0]=="PRIMARY")return
recreate_table($R,$R,array(),array(),array(),"",$b);}foreach(array_reverse($b)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($R,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($T){return
apply_queries("DELETE FROM",$T);}function
drop_views($Kj){return
apply_queries("DROP VIEW",$Kj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
move_tables($T,$Kj,$Hi){return
false;}function
trigger($B,$R){if($B=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$v='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$ij=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$v\\s*(".implode("|",$ij["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($v))?\\s+ON\\s*$v\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",get_val("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($B)),$A);$Lf=$A[3];return
array("Timing"=>strtoupper($A[1]),"Event"=>strtoupper($A[2]).($Lf?" OF":""),"Of"=>idf_unescape($Lf),"Trigger"=>$B,"Statement"=>$A[4],);}function
triggers($R){$J=array();$ij=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R))as$K){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$ij["Timing"]).')\s*(.*?)\s+ON\b~i',$K["sql"],$A);$J[$K["name"]]=array($A[1],$A[2]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id($I){return
get_val("SELECT LAST_INSERT_ROWID()");}function
explain($g,$H){return$g->query("EXPLAIN QUERY PLAN $H");}function
found_rows($S,$Z){}function
types(){return
array();}function
create_sql($R,$Ba,$ri){$J=get_val("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($R));foreach(indexes($R)as$B=>$w){if($B=='')continue;$J
.=";\n\n".index_sql($R,$w['type'],$B,"(".implode(", ",array_map('Adminer\idf_escape',$w['columns'])).")");}return$J;}function
truncate_sql($R){return"DELETE FROM ".table($R);}function
use_sql($Pb){}function
trigger_sql($R){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R)));}function
show_variables(){$J=array();foreach(get_rows("PRAGMA pragma_list")as$K){$B=$K["name"];if($B!="pragma_list"&&$B!="compile_options"){$J[$B]=array($B,'');foreach(get_rows("PRAGMA $B")as$K)$J[$B][1].=implode(", ",$K)."\n";}}return$J;}function
show_status(){$J=array();foreach(get_vals("PRAGMA compile_options")as$ag)$J[]=explode("=",$ag,2)+array('','');return$J;}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Xc){return
preg_match('~^(check|columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Xc);}}add_driver("pgsql","PostgreSQL");if(isset($_GET["pgsql"])){define('Adminer\DRIVER',"pgsql");if(extension_loaded("pgsql")&&$_GET["ext"]!="pdo"){class
PgsqlDb
extends
SqlDb{var$extension="PgSQL";var$timeout=0;private$link,$string,$database=true;function
_error($Fc,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
attach($N,$V,$F){$k=adminer()->database();set_error_handler(array($this,'_error'));$this->string="host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' user='".addcslashes($V,"'\\")."' password='".addcslashes($F,"'\\")."'";$mi=adminer()->connectSsl();if(isset($mi["mode"]))$this->string
.=" sslmode='".$mi["mode"]."'";$this->link=@pg_connect("$this->string dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->link&&$k!=""){$this->database=false;$this->link=@pg_connect("$this->string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->link)pg_set_client_encoding($this->link,"UTF8");return($this->link?'':$this->error);}function
quote($Q){return(function_exists('pg_escape_literal')?pg_escape_literal($this->link,$Q):"'".pg_escape_string($this->link,$Q)."'");}function
value($X,array$n){return($n["type"]=="bytea"&&$X!==null?pg_unescape_bytea($X):$X);}function
select_db($Pb){if($Pb==adminer()->database())return$this->database;$J=@pg_connect("$this->string dbname='".addcslashes($Pb,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($J)$this->link=$J;return$J;}function
close(){$this->link=@pg_connect("$this->string dbname='postgres'");}function
query($H,$nj=false){$I=@pg_query($this->link,$H);$this->error="";if(!$I){$this->error=pg_last_error($this->link);$J=false;}elseif(!pg_num_fields($I)){$this->affected_rows=pg_affected_rows($I);$J=true;}else$J=new
Result($I);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$J;}function
warnings(){return
h(pg_last_notice($this->link));}function
copyFrom($R,array$L){$this->error='';set_error_handler(function($Fc,$m){$this->error=(ini_bool('html_errors')?html_entity_decode($m):$m);return
true;});$J=pg_copy_from($this->link,$R,$L);restore_error_handler();return$J;}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=pg_num_rows($I);}function
fetch_assoc(){return
pg_fetch_assoc($this->result);}function
fetch_row(){return
pg_fetch_row($this->result);}function
fetch_field(){$d=$this->offset++;$J=new
\stdClass;$J->orgtable=pg_field_table($this->result,$d);$J->name=pg_field_name($this->result,$d);$U=pg_field_type($this->result,$d);$J->type=(preg_match(number_type(),$U)?0:15);$J->charsetnr=($U=="bytea"?63:0);return$J;}function
__destruct(){pg_free_result($this->result);}}}elseif(extension_loaded("pdo_pgsql")){class
PgsqlDb
extends
PdoDb{var$extension="PDO_PgSQL";var$timeout=0;function
attach($N,$V,$F){$k=adminer()->database();$pc="pgsql:host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' client_encoding=utf8 dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'";$mi=adminer()->connectSsl();if(isset($mi["mode"]))$pc
.=" sslmode='".$mi["mode"]."'";return$this->dsn($pc,$V,$F);}function
select_db($Pb){return(adminer()->database()==$Pb);}function
query($H,$nj=false){$J=parent::query($H,$nj);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$J;}function
warnings(){}function
copyFrom($R,array$L){$J=$this->pdo->pgsqlCopyFromArray($R,$L);$this->error=idx($this->pdo->errorInfo(),2)?:'';return$J;}function
close(){}}}if(class_exists('Adminer\PgsqlDb')){class
Db
extends
PgsqlDb{function
multi_query($H){if(preg_match('~\bCOPY\s+(.+?)\s+FROM\s+stdin;\n?(.*)\n\\\\\.$~is',str_replace("\r\n","\n",$H),$A)){$L=explode("\n",$A[2]);$this->affected_rows=count($L);return$this->copyFrom($A[1],$L);}return
parent::multi_query($H);}}}class
Driver
extends
SqlDriver{static$extensions=array("PgSQL","PDO_PgSQL");static$jush="pgsql";var$operators=array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT ILIKE","NOT IN","IS NOT NULL");var$functions=array("char_length","lower","round","to_hex","to_timestamp","upper");var$grouping=array("avg","count","count distinct","max","min","sum");var$nsOid="(SELECT oid FROM pg_namespace WHERE nspname = current_schema())";static
function
connect($N,$V,$F){$g=parent::connect($N,$V,$F);if(is_string($g))return$g;$Ij=get_val("SELECT version()",0,$g);$g->flavor=(preg_match('~CockroachDB~',$Ij)?'cockroach':'');$g->server_info=preg_replace('~^\D*([\d.]+[-\w]*).*~','\1',$Ij);if(min_version(9,0,$g))$g->query("SET application_name = 'Adminer'");if($g->flavor=='cockroach')add_driver(DRIVER,"CockroachDB");return$g;}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(26)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(27)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(28)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(29)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"macaddr8"=>23,"txid_snapshot"=>0),lang(30)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),);if(min_version(9.2,0,$g)){$this->types[lang(27)]["json"]=4294967295;if(min_version(9.4,0,$g))$this->types[lang(27)]["jsonb"]=4294967295;}$this->insertFunctions=array("char"=>"md5","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",);if(min_version(12,0,$g))$this->generated=array("STORED");$this->partitionBy=array("RANGE","LIST");if(!$g->flavor)$this->partitionBy[]="HASH";}function
enumLength(array$n){$Bc=$this->types[lang(31)][$n["type"]];return($Bc?type_values($Bc):"");}function
setUserTypes($mj){$this->types[lang(31)]=array_flip($mj);}function
insertReturning($R){$Ba=array_filter(fields($R),function($n){return$n['auto_increment'];});return(count($Ba)==1?" RETURNING ".idf_escape(key($Ba)):"");}function
insertUpdate($R,array$L,array$G){foreach($L
as$O){$vj=array();$Z=array();foreach($O
as$y=>$X){$vj[]="$y = $X";if(isset($G[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$vj)." WHERE ".implode(" AND ",$Z))&&connection()->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
slowQuery($H,$Pi){$this->conn->query("SET statement_timeout = ".(1000*$Pi));$this->conn->timeout=1000*$Pi;return$H;}function
convertSearch($v,array$X,array$n){$Mi="char|text";if(strpos($X["op"],"LIKE")===false)$Mi
.="|date|time(stamp)?|boolean|uuid|inet|cidr|macaddr|".number_type();return(preg_match("~$Mi~",$n["type"])?$v:"CAST($v AS text)");}function
quoteBinary($Dh){return"'\\x".bin2hex($Dh)."'";}function
warnings(){return$this->conn->warnings();}function
tableHelp($B,$ze=false){$Ue=array("information_schema"=>"infoschema","pg_catalog"=>($ze?"view":"catalog"),);$_=$Ue[$_GET["ns"]];if($_)return"$_-".str_replace("_","-",$B).".html";}function
inheritsFrom($R){return
get_vals("SELECT relname FROM pg_class JOIN pg_inherits ON inhparent = oid WHERE inhrelid = ".$this->tableOid($R)." ORDER BY 1");}function
inheritedTables($R){return
get_vals("SELECT relname FROM pg_inherits JOIN pg_class ON inhrelid = oid WHERE inhparent = ".$this->tableOid($R)." ORDER BY 1");}function
partitionsInfo($R){$K=connection()->query("SELECT * FROM pg_partitioned_table WHERE partrelid = ".driver()->tableOid($R))->fetch_assoc();if($K){$_a=get_vals("SELECT attname FROM pg_attribute WHERE attrelid = $K[partrelid] AND attnum IN (".str_replace(" ",", ",$K["partattrs"]).")");$Qa=array('h'=>'HASH','l'=>'LIST','r'=>'RANGE');return
array("partition_by"=>$Qa[$K["partstrat"]],"partition"=>implode(", ",array_map('Adminer\idf_escape',$_a)),);}return
array();}function
tableOid($R){return"(SELECT oid FROM pg_class WHERE relnamespace = $this->nsOid AND relname = ".q($R)." AND relkind IN ('r', 'm', 'v', 'f', 'p'))";}function
indexAlgorithms(array$xi){static$J=array();if(!$J)$J=get_vals("SELECT amname FROM pg_am".(min_version(9.6)?" WHERE amtype = 'i'":"")." ORDER BY amname = 'btree' DESC, amname");return$J;}function
supportsIndex(array$S){return$S["Engine"]!="view";}function
hasCStyleEscapes(){static$Sa;if($Sa===null)$Sa=(get_val("SHOW standard_conforming_strings",0,$this->conn)=="off");return$Sa;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT datname FROM pg_database
WHERE datallowconn = TRUE AND has_database_privilege(datname, 'CONNECT')
ORDER BY datname");}function
limit($H,$Z,$z,$C=0,$Qh=" "){return" $H$Z".($z?$Qh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Qh="\n"){return(preg_match('~^INTO~',$H)?limit($H,$Z,1,0,$Qh):" $H".(is_view(table_status1($R))?$Z:$Qh."WHERE ctid = (SELECT ctid FROM ".table($R).$Z.$Qh."LIMIT 1)"));}function
db_collation($k,$lb){return
get_val("SELECT datcollate FROM pg_database WHERE datname = ".q($k));}function
logged_user(){return
get_val("SELECT user");}function
tables_list(){$H="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support("materializedview"))$H
.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$H
.="
ORDER BY 1";return
get_key_vals($H);}function
count_tables($j){$J=array();foreach($j
as$k){if(connection()->select_db($k))$J[$k]=count(tables_list());}return$J;}function
table_status($B=""){static$Hd;if($Hd===null)$Hd=get_val("SELECT 'pg_table_size'::regproc");$J=array();foreach(get_rows("SELECT
	relname AS \"Name\",
	CASE relkind WHEN 'v' THEN 'view' WHEN 'm' THEN 'materialized view' ELSE 'table' END AS \"Engine\"".($Hd?",
	pg_table_size(oid) AS \"Data_length\",
	pg_indexes_size(oid) AS \"Index_length\"":"").",
	obj_description(oid, 'pg_class') AS \"Comment\",
	".(min_version(12)?"''":"CASE WHEN relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\",
	reltuples as \"Rows\",
	inhparent AS inherited,
	current_schema() AS nspname
FROM pg_class
LEFT JOIN pg_inherits ON inhrelid = oid
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
AND relnamespace = ".driver()->nsOid."
".($B!=""?"AND relname = ".q($B):"ORDER BY relname"))as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return
in_array($S["Engine"],array("view","materialized view"));}function
fk_support($S){return
true;}function
fields($R){$J=array();$ta=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);foreach(get_rows("SELECT
	a.attname AS field,
	format_type(a.atttypid, a.atttypmod) AS full_type,
	pg_get_expr(d.adbin, d.adrelid) AS default,
	a.attnotnull::int,
	col_description(a.attrelid, a.attnum) AS comment".(min_version(10)?",
	a.attidentity".(min_version(12)?",
	a.attgenerated":""):"")."
FROM pg_attribute a
LEFT JOIN pg_attrdef d ON a.attrelid = d.adrelid AND a.attnum = d.adnum
WHERE a.attrelid = ".driver()->tableOid($R)."
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$K){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$K["full_type"],$A);list(,$U,$Qe,$K["length"],$ma,$xa)=$A;$K["length"].=$xa;$ab=$U.$ma;if(isset($ta[$ab])){$K["type"]=$ta[$ab];$K["full_type"]=$K["type"].$Qe.$xa;}else{$K["type"]=$U;$K["full_type"]=$K["type"].$Qe.$ma.$xa;}if(in_array($K['attidentity'],array('a','d')))$K['default']='GENERATED '.($K['attidentity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$K["generated"]=($K["attgenerated"]=="s"?"STORED":"");$K["null"]=!$K["attnotnull"];$K["auto_increment"]=$K['attidentity']||preg_match('~^nextval\(~i',$K["default"])||preg_match('~^unique_rowid\(~',$K["default"]);$K["privileges"]=array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1);if(preg_match('~(.+)::[^,)]+(.*)~',$K["default"],$A))$K["default"]=($A[1]=="NULL"?null:idf_unescape($A[1]).$A[2]);$J[$K["field"]]=$K;}return$J;}function
indexes($R,$h=null){$h=connection($h);$J=array();$_i=driver()->tableOid($R);$e=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $_i AND attnum > 0",$h);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption, (indpred IS NOT NULL)::int as indispartial, pg_am.amname as algorithm, pg_get_expr(pg_index.indpred, pg_index.indrelid, true) AS partial
FROM pg_index
JOIN pg_class ON indexrelid = oid
JOIN pg_am ON pg_am.oid = pg_class.relam
WHERE indrelid = $_i
ORDER BY indisprimary DESC, indisunique DESC",$h)as$K){$rh=$K["relname"];$J[$rh]["type"]=($K["indispartial"]?"INDEX":($K["indisprimary"]?"PRIMARY":($K["indisunique"]?"UNIQUE":"INDEX")));$J[$rh]["columns"]=array();$J[$rh]["descs"]=array();$J[$rh]["algorithm"]=$K["algorithm"];$J[$rh]["partial"]=$K["partial"];if($K["indkey"]){foreach(explode(" ",$K["indkey"])as$ge)$J[$rh]["columns"][]=$e[$ge];foreach(explode(" ",$K["indoption"])as$he)$J[$rh]["descs"][]=(intval($he)&1?'1':null);}$J[$rh]["lengths"]=array();}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = ".driver()->tableOid($R)."
AND contype = 'f'::char
ORDER BY conkey, conname")as$K){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$K['definition'],$A)){$K['source']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$A[1])));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$A[2],$af)){$K['ns']=idf_unescape($af[2]);$K['table']=idf_unescape($af[4]);}$K['target']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$A[3])));$K['on_delete']=(preg_match("~ON DELETE (".driver()->onActions.")~",$A[4],$af)?$af[1]:'NO ACTION');$K['on_update']=(preg_match("~ON UPDATE (".driver()->onActions.")~",$A[4],$af)?$af[1]:'NO ACTION');$J[$K['conname']]=$K;}}return$J;}function
view($B){return
array("select"=>trim(get_val("SELECT pg_get_viewdef(".driver()->tableOid($B).")")));}function
collations(){return
array();}function
information_schema($k){return
get_schema()=="information_schema";}function
error(){$J=h(connection()->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$J,$A))$J=$A[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($A[3]).'})(.*)~','\1<b>\2</b>',$A[2]).$A[4];return
nl_br($J);}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).($c?" ENCODING ".idf_escape($c):""));}function
drop_databases($j){connection()->close();return
apply_queries("DROP DATABASE",$j,'Adminer\idf_escape');}function
rename_database($B,$c){connection()->close();return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($B));}function
auto_increment(){return"";}function
alter_table($R,$B,$o,$ld,$qb,$_c,$c,$Ba,$E){$b=array();$eh=array();if($R!=""&&$R!=$B)$eh[]="ALTER TABLE ".table($R)." RENAME TO ".table($B);$Rh="";foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$b[]="DROP $d";else{$Ej=$X[5];unset($X[5]);if($n[0]==""){if(isset($X[6]))$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";$b[]=($R!=""?"ADD ":"  ").implode($X);if(isset($X[6]))$b[]=($R!=""?"ADD":" ")." PRIMARY KEY ($X[0])";}else{if($d!=$X[0])$eh[]="ALTER TABLE ".table($B)." RENAME $d TO $X[0]";$b[]="ALTER $d TYPE$X[1]";$Sh=$R."_".idf_unescape($X[0])."_seq";$b[]="ALTER $d ".($X[3]?"SET".preg_replace('~GENERATED ALWAYS(.*) STORED~','EXPRESSION\1',$X[3]):(isset($X[6])?"SET DEFAULT nextval(".q($Sh).")":"DROP DEFAULT"));if(isset($X[6]))$Rh="CREATE SEQUENCE IF NOT EXISTS ".idf_escape($Sh)." OWNED BY ".idf_escape($R).".$X[0]";$b[]="ALTER $d ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}if($n[0]!=""||$Ej!="")$eh[]="COMMENT ON COLUMN ".table($B).".$X[0] IS ".($Ej!=""?substr($Ej,9):"''");}}$b=array_merge($b,$ld);if($R==""){$P="";if($E){$gb=(connection()->flavor=='cockroach');$P=" PARTITION BY $E[partition_by]($E[partition])";if($E["partition_by"]=='HASH'){$Cg=+$E["partitions"];for($t=0;$t<$Cg;$t++)$eh[]="CREATE TABLE ".idf_escape($B."_$t")." PARTITION OF ".idf_escape($B)." FOR VALUES WITH (MODULUS $Cg, REMAINDER $t)";}else{$Ug="MINVALUE";foreach($E["partition_names"]as$t=>$X){$Y=$E["partition_values"][$t];$zg=" VALUES ".($E["partition_by"]=='LIST'?"IN ($Y)":"FROM ($Ug) TO ($Y)");if($gb)$P
.=($t?",":" (")."\n  PARTITION ".(preg_match('~^DEFAULT$~i',$X)?$X:idf_escape($X))."$zg";else$eh[]="CREATE TABLE ".idf_escape($B."_$X")." PARTITION OF ".idf_escape($B)." FOR$zg";$Ug=$Y;}$P
.=($gb?"\n)":"");}}array_unshift($eh,"CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)$P");}elseif($b)array_unshift($eh,"ALTER TABLE ".table($R)."\n".implode(",\n",$b));if($Rh)array_unshift($eh,$Rh);if($qb!==null)$eh[]="COMMENT ON TABLE ".table($B)." IS ".q($qb);foreach($eh
as$H){if(!queries($H))return
false;}return
true;}function
alter_indexes($R,$b){$i=array();$kc=array();$eh=array();foreach($b
as$X){if($X[0]!="INDEX")$i[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$kc[]=idf_escape($X[1]);else$eh[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R).($X[3]?" USING $X[3]":"")." (".implode(", ",$X[2]).")".($X[4]?" WHERE $X[4]":"");}if($i)array_unshift($eh,"ALTER TABLE ".table($R).implode(",",$i));if($kc)array_unshift($eh,"DROP INDEX ".implode(", ",$kc));foreach($eh
as$H){if(!queries($H))return
false;}return
true;}function
truncate_tables($T){return
queries("TRUNCATE ".implode(", ",array_map('Adminer\table',$T)));}function
drop_views($Kj){return
drop_tables($Kj);}function
drop_tables($T){foreach($T
as$R){$P=table_status1($R);if(!queries("DROP ".strtoupper($P["Engine"])." ".table($R)))return
false;}return
true;}function
move_tables($T,$Kj,$Hi){foreach(array_merge($T,$Kj)as$R){$P=table_status1($R);if(!queries("ALTER ".strtoupper($P["Engine"])." ".table($R)." SET SCHEMA ".idf_escape($Hi)))return
false;}return
true;}function
trigger($B,$R){if($B=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");$e=array();$Z="WHERE trigger_schema = current_schema() AND event_object_table = ".q($R)." AND trigger_name = ".q($B);foreach(get_rows("SELECT * FROM information_schema.triggered_update_columns $Z")as$K)$e[]=$K["event_object_column"];$J=array();foreach(get_rows('SELECT trigger_name AS "Trigger", action_timing AS "Timing", event_manipulation AS "Event", \'FOR EACH \' || action_orientation AS "Type", action_statement AS "Statement"
FROM information_schema.triggers'."
$Z
ORDER BY event_manipulation DESC")as$K){if($e&&$K["Event"]=="UPDATE")$K["Event"].=" OF";$K["Of"]=implode(", ",$e);if($J)$K["Event"].=" OR $J[Event]";$J=$K;}return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE trigger_schema = current_schema() AND event_object_table = ".q($R))as$K){$gj=trigger($K["trigger_name"],$R);$J[$gj["Trigger"]]=array($gj["Timing"],$gj["Event"]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE","INSERT OR UPDATE","INSERT OR UPDATE OF","DELETE OR INSERT","DELETE OR UPDATE","DELETE OR UPDATE OF","DELETE OR INSERT OR UPDATE","DELETE OR INSERT OR UPDATE OF"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($B,$U){$L=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($B));$J=idx($L,0,array());$J["returns"]=array("type"=>$J["type_udt_name"]);$J["fields"]=get_rows('SELECT parameter_name AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($B).'
ORDER BY ordinal_position');return$J;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($B,$K){$J=array();foreach($K["fields"]as$n){$Qe=$n["length"];$J[]=$n["type"].($Qe?"($Qe)":"");}return
idf_escape($B)."(".implode(", ",$J).")";}function
last_id($I){$K=(is_object($I)?$I->fetch_row():array());return($K?$K[0]:0);}function
explain($g,$H){return$g->query("EXPLAIN $H");}function
found_rows($S,$Z){if(preg_match("~ rows=([0-9]+)~",get_val("EXPLAIN SELECT * FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$qh))return$qh[1];}function
types(){return
get_key_vals("SELECT oid, typname
FROM pg_type
WHERE typnamespace = ".driver()->nsOid."
AND typtype IN ('b','d','e')
AND typelem = 0");}function
type_values($u){$Ec=get_vals("SELECT enumlabel FROM pg_enum WHERE enumtypid = $u ORDER BY enumsortorder");return($Ec?"'".implode("', '",array_map('addslashes',$Ec))."'":"");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){return
get_val("SELECT current_schema()");}function
set_schema($Fh,$h=null){if(!$h)$h=connection();$J=$h->query("SET search_path TO ".idf_escape($Fh));driver()->setUserTypes(types());return$J;}function
foreign_keys_sql($R){$J="";$P=table_status1($R);$hd=foreign_keys($R);ksort($hd);foreach($hd
as$gd=>$fd)$J
.="ALTER TABLE ONLY ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." ADD CONSTRAINT ".idf_escape($gd)." $fd[definition] ".($fd['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($J?"$J\n":$J);}function
create_sql($R,$Ba,$ri){$wh=array();$Th=array();$P=table_status1($R);if(is_view($P)){$Jj=view($R);return
rtrim("CREATE VIEW ".idf_escape($R)." AS $Jj[select]",";");}$o=fields($R);if(count($P)<2||empty($o))return
false;$J="CREATE TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." (\n    ";foreach($o
as$n){$xg=idf_escape($n['field']).' '.$n['full_type'].default_value($n).($n['null']?"":" NOT NULL");$wh[]=$xg;if(preg_match('~nextval\(\'([^\']+)\'\)~',$n['default'],$cf)){$Sh=$cf[1];$gi=first(get_rows((min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q(idf_unescape($Sh)):"SELECT * FROM $Sh"),null,"-- "));$Th[]=($ri=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $Sh;\n":"")."CREATE SEQUENCE $Sh INCREMENT $gi[increment_by] MINVALUE $gi[min_value] MAXVALUE $gi[max_value]".($Ba&&$gi['last_value']?" START ".($gi["last_value"]+1):"")." CACHE $gi[cache_value];";}}if(!empty($Th))$J=implode("\n\n",$Th)."\n\n$J";$G="";foreach(indexes($R)as$ee=>$w){if($w['type']=='PRIMARY'){$G=$ee;$wh[]="CONSTRAINT ".idf_escape($ee)." PRIMARY KEY (".implode(', ',array_map('Adminer\idf_escape',$w['columns'])).")";}}foreach(driver()->checkConstraints($R)as$wb=>$yb)$wh[]="CONSTRAINT ".idf_escape($wb)." CHECK $yb";$J
.=implode(",\n    ",$wh)."\n)";$zg=driver()->partitionsInfo($P['Name']);if($zg)$J
.="\nPARTITION BY $zg[partition_by]($zg[partition])";$J
.="\nWITH (oids = ".($P['Oid']?'true':'false').");";if($P['Comment'])$J
.="\n\nCOMMENT ON TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." IS ".q($P['Comment']).";";foreach($o
as$Zc=>$n){if($n['comment'])$J
.="\n\nCOMMENT ON COLUMN ".idf_escape($P['nspname']).".".idf_escape($P['Name']).".".idf_escape($Zc)." IS ".q($n['comment']).";";}foreach(get_rows("SELECT indexdef FROM pg_catalog.pg_indexes WHERE schemaname = current_schema() AND tablename = ".q($R).($G?" AND indexname != ".q($G):""),null,"-- ")as$K)$J
.="\n\n$K[indexdef];";return
rtrim($J,';');}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
trigger_sql($R){$P=table_status1($R);$J="";foreach(triggers($R)as$fj=>$ej){$gj=trigger($fj,$P['Name']);$J
.="\nCREATE TRIGGER ".idf_escape($gj['Trigger'])." $gj[Timing] $gj[Event] ON ".idf_escape($P["nspname"]).".".idf_escape($P['Name'])." $gj[Type] $gj[Statement];;\n";}return$J;}function
use_sql($Pb){return"\connect ".idf_escape($Pb);}function
show_variables(){return
get_rows("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Xc){return
preg_match('~^(check|columns|comment|database|drop_col|dump|descidx|indexes|kill|partial_indexes|routine|scheme|sequence|sql|table|trigger|type|variables|view'.(min_version(9.3)?'|materializedview':'').(min_version(11)?'|procedure':'').(connection()->flavor=='cockroach'?'':'|processlist').')$~',$Xc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){return
get_val("SHOW max_connections");}}add_driver("oracle","Oracle (beta)");if(isset($_GET["oracle"])){define('Adminer\DRIVER',"oracle");if(extension_loaded("oci8")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="oci8";var$_current_db;private$link;function
_error($Fc,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
attach($N,$V,$F){$this->link=@oci_new_connect($V,$F,$N,"AL32UTF8");if($this->link){$this->server_info=oci_server_version($this->link);return'';}$m=oci_error();return$m["message"];}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($Pb){$this->_current_db=$Pb;return
true;}function
query($H,$nj=false){$I=oci_parse($this->link,$H);$this->error="";if(!$I){$m=oci_error($this->link);$this->errno=$m["code"];$this->error=$m["message"];return
false;}set_error_handler(array($this,'_error'));$J=@oci_execute($I);restore_error_handler();if($J){if(oci_num_fields($I))return
new
Result($I);$this->affected_rows=oci_num_rows($I);oci_free_statement($I);}return$J;}}class
Result{var$num_rows;private$result,$offset=1;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$y=>$X){if(is_a($X,'OCILob')||is_a($X,'OCI-Lob'))$K[$y]=$X->load();}return$K;}function
fetch_assoc(){return$this->convert(oci_fetch_assoc($this->result));}function
fetch_row(){return$this->convert(oci_fetch_row($this->result));}function
fetch_field(){$d=$this->offset++;$J=new
\stdClass;$J->name=oci_field_name($this->result,$d);$J->type=oci_field_type($this->result,$d);$J->charsetnr=(preg_match("~raw|blob|bfile~",$J->type)?63:0);return$J;}function
__destruct(){oci_free_statement($this->result);}}}elseif(extension_loaded("pdo_oci")){class
Db
extends
PdoDb{var$extension="PDO_OCI";var$_current_db;function
attach($N,$V,$F){return$this->dsn("oci:dbname=//$N;charset=AL32UTF8",$V,$F);}function
select_db($Pb){$this->_current_db=$Pb;return
true;}}}class
Driver
extends
SqlDriver{static$extensions=array("OCI8","PDO_OCI");static$jush="oracle";var$insertFunctions=array("date"=>"current_date","timestamp"=>"current_timestamp",);var$editFunctions=array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("length","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(26)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(27)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(28)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),);}function
begin(){return
true;}function
insertUpdate($R,array$L,array$G){foreach($L
as$O){$vj=array();$Z=array();foreach($O
as$y=>$X){$vj[]="$y = $X";if(isset($G[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$vj)." WHERE ".implode(" AND ",$Z))&&connection()->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
hasCStyleEscapes(){return
true;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT DISTINCT tablespace_name FROM (
SELECT tablespace_name FROM user_tablespaces
UNION SELECT tablespace_name FROM all_tables WHERE tablespace_name IS NOT NULL
)
ORDER BY 1");}function
limit($H,$Z,$z,$C=0,$Qh=" "){return($C?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $H$Z) t WHERE rownum <= ".($z+$C).") WHERE rnum > $C":($z?" * FROM (SELECT $H$Z) WHERE rownum <= ".($z+$C):" $H$Z"));}function
limit1($R,$H,$Z,$Qh="\n"){return" $H$Z";}function
db_collation($k,$lb){return
get_val("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
logged_user(){return
get_val("SELECT USER FROM DUAL");}function
get_current_db(){$k=connection()->_current_db?:DB;unset(connection()->_current_db);return$k;}function
where_owner($Sg,$rg="owner"){if(!$_GET["ns"])return'';return"$Sg$rg = sys_context('USERENV', 'CURRENT_SCHEMA')";}function
views_table($e){$rg=where_owner('');return"(SELECT $e FROM all_views WHERE ".($rg?:"rownum < 0").")";}function
tables_list(){$Jj=views_table("view_name");$rg=where_owner(" AND ");return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."$rg
UNION SELECT view_name, 'view' FROM $Jj
ORDER BY 1");}function
count_tables($j){$J=array();foreach($j
as$k)$J[$k]=get_val("SELECT COUNT(*) FROM all_tables WHERE tablespace_name = ".q($k));return$J;}function
table_status($B=""){$J=array();$Jh=q($B);$k=get_current_db();$Jj=views_table("view_name");$rg=where_owner(" AND ");foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q($k).$rg.($B!=""?" AND table_name = $Jh":"")."
UNION SELECT view_name, 'view', 0, 0 FROM $Jj".($B!=""?" WHERE view_name = $Jh":"")."
ORDER BY 1")as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return
true;}function
fields($R){$J=array();$rg=where_owner(" AND ");foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($R)."$rg ORDER BY column_id")as$K){$U=$K["DATA_TYPE"];$Qe="$K[DATA_PRECISION],$K[DATA_SCALE]";if($Qe==",")$Qe=$K["CHAR_COL_DECL_LENGTH"];$J[$K["COLUMN_NAME"]]=array("field"=>$K["COLUMN_NAME"],"full_type"=>$U.($Qe?"($Qe)":""),"type"=>strtolower($U),"length"=>$Qe,"default"=>$K["DATA_DEFAULT"],"null"=>($K["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),);}return$J;}function
indexes($R,$h=null){$J=array();$rg=where_owner(" AND ","aic.table_owner");foreach(get_rows("SELECT aic.*, ac.constraint_type, atc.data_default
FROM all_ind_columns aic
LEFT JOIN all_constraints ac ON aic.index_name = ac.constraint_name AND aic.table_name = ac.table_name AND aic.index_owner = ac.owner
LEFT JOIN all_tab_cols atc ON aic.column_name = atc.column_name AND aic.table_name = atc.table_name AND aic.index_owner = atc.owner
WHERE aic.table_name = ".q($R)."$rg
ORDER BY ac.constraint_type, aic.column_position",$h)as$K){$ee=$K["INDEX_NAME"];$nb=$K["DATA_DEFAULT"];$nb=($nb?trim($nb,'"'):$K["COLUMN_NAME"]);$J[$ee]["type"]=($K["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($K["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$J[$ee]["columns"][]=$nb;$J[$ee]["lengths"][]=($K["CHAR_LENGTH"]&&$K["CHAR_LENGTH"]!=$K["COLUMN_LENGTH"]?$K["CHAR_LENGTH"]:null);$J[$ee]["descs"][]=($K["DESCEND"]&&$K["DESCEND"]=="DESC"?'1':null);}return$J;}function
view($B){$Jj=views_table("view_name, text");$L=get_rows('SELECT text "select" FROM '.$Jj.' WHERE view_name = '.q($B));return
reset($L);}function
collations(){return
array();}function
information_schema($k){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
h(connection()->error);}function
explain($g,$H){$g->query("EXPLAIN PLAN FOR $H");return$g->query("SELECT * FROM plan_table");}function
found_rows($S,$Z){}function
auto_increment(){return"";}function
alter_table($R,$B,$o,$ld,$qb,$_c,$c,$Ba,$E){$b=$kc=array();$kg=($R?fields($R):array());foreach($o
as$n){$X=$n[1];if($X&&$n[0]!=""&&idf_escape($n[0])!=$X[0])queries("ALTER TABLE ".table($R)." RENAME COLUMN ".idf_escape($n[0])." TO $X[0]");$jg=$kg[$n[0]];if($X&&$jg){$Nf=process_field($jg,$jg);if($X[2]==$Nf[2])$X[2]="";}if($X)$b[]=($R!=""?($n[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($R!=""?")":"");else$kc[]=idf_escape($n[0]);}if($R=="")return
queries("CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)");return(!$b||queries("ALTER TABLE ".table($R)."\n".implode("\n",$b)))&&(!$kc||queries("ALTER TABLE ".table($R)." DROP (".implode(", ",$kc).")"))&&($R==$B||queries("ALTER TABLE ".table($R)." RENAME TO ".table($B)));}function
alter_indexes($R,$b){$kc=array();$eh=array();foreach($b
as$X){if($X[0]!="INDEX"){$X[2]=preg_replace('~ DESC$~','',$X[2]);$i=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");array_unshift($eh,"ALTER TABLE ".table($R).$i);}elseif($X[2]=="DROP")$kc[]=idf_escape($X[1]);else$eh[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($kc)array_unshift($eh,"DROP INDEX ".implode(", ",$kc));foreach($eh
as$H){if(!queries($H))return
false;}return
true;}function
foreign_keys($R){$J=array();$H="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($R);foreach(get_rows($H)as$K)$J[$K['NAME']]=array("db"=>$K['DEST_DB'],"table"=>$K['DEST_TABLE'],"source"=>array($K['SRC_COLUMN']),"target"=>array($K['DEST_COLUMN']),"on_delete"=>$K['ON_DELETE'],"on_update"=>null,);return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($Kj){return
apply_queries("DROP VIEW",$Kj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
last_id($I){return
0;}function
schemas(){$J=get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX')) ORDER BY 1");return($J?:get_vals("SELECT DISTINCT owner FROM all_tables WHERE tablespace_name = ".q(DB)." ORDER BY 1"));}function
get_schema(){return
get_val("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($Hh,$h=null){if(!$h)$h=connection();return$h->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($Hh));}function
show_variables(){return
get_rows('SELECT name, display_value FROM v$parameter');}function
show_status(){$J=array();$L=get_rows('SELECT * FROM v$instance');foreach(reset($L)as$y=>$X)$J[]=array($y,$X);return$J;}function
process_list(){return
get_rows('SELECT
	sess.process AS "process",
	sess.username AS "user",
	sess.schemaname AS "schema",
	sess.status AS "status",
	sess.wait_class AS "wait_class",
	sess.seconds_in_wait AS "seconds_in_wait",
	sql.sql_text AS "sql_text",
	sess.machine AS "machine",
	sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Xc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view)$~',$Xc);}}add_driver("mssql","MS SQL");if(isset($_GET["mssql"])){define('Adminer\DRIVER',"mssql");if(extension_loaded("sqlsrv")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="sqlsrv";private$link,$result;private
function
get_error(){$this->error="";foreach(sqlsrv_errors()as$m){$this->errno=$m["code"];$this->error
.="$m[message]\n";}$this->error=rtrim($this->error);}function
attach($N,$V,$F){$xb=array("UID"=>$V,"PWD"=>$F,"CharacterSet"=>"UTF-8");$mi=adminer()->connectSsl();if(isset($mi["Encrypt"]))$xb["Encrypt"]=$mi["Encrypt"];if(isset($mi["TrustServerCertificate"]))$xb["TrustServerCertificate"]=$mi["TrustServerCertificate"];$k=adminer()->database();if($k!="")$xb["Database"]=$k;$this->link=@sqlsrv_connect(preg_replace('~:~',',',$N),$xb);if($this->link){$ie=sqlsrv_server_info($this->link);$this->server_info=$ie['SQLServerVersion'];}else$this->get_error();return($this->link?'':$this->error);}function
quote($Q){$oj=strlen($Q)!=strlen(utf8_decode($Q));return($oj?"N":"")."'".str_replace("'","''",$Q)."'";}function
select_db($Pb){return$this->query(use_sql($Pb));}function
query($H,$nj=false){$I=sqlsrv_query($this->link,$H);$this->error="";if(!$I){$this->get_error();return
false;}return$this->store_result($I);}function
multi_query($H){$this->result=sqlsrv_query($this->link,$H);$this->error="";if(!$this->result){$this->get_error();return
false;}return
true;}function
store_result($I=null){if(!$I)$I=$this->result;if(!$I)return
false;if(sqlsrv_field_metadata($I))return
new
Result($I);$this->affected_rows=sqlsrv_rows_affected($I);return
true;}function
next_result(){return$this->result?!!sqlsrv_next_result($this->result):false;}}class
Result{var$num_rows;private$result,$offset=0,$fields;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$y=>$X){if(is_a($X,'DateTime'))$K[$y]=$X->format("Y-m-d H:i:s");}return$K;}function
fetch_assoc(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->fields)$this->fields=sqlsrv_field_metadata($this->result);$n=$this->fields[$this->offset++];$J=new
\stdClass;$J->name=$n["Name"];$J->type=($n["Type"]==1?254:15);$J->charsetnr=0;return$J;}function
seek($C){for($t=0;$t<$C;$t++)sqlsrv_fetch($this->result);}function
__destruct(){sqlsrv_free_stmt($this->result);}}function
last_id($I){return
get_val("SELECT SCOPE_IDENTITY()");}function
explain($g,$H){$g->query("SET SHOWPLAN_ALL ON");$J=$g->query($H);$g->query("SET SHOWPLAN_ALL OFF");return$J;}}else{abstract
class
MssqlDb
extends
PdoDb{function
select_db($Pb){return$this->query(use_sql($Pb));}function
lastInsertId(){return$this->pdo->lastInsertId();}}function
last_id($I){return
connection()->lastInsertId();}function
explain($g,$H){}if(extension_loaded("pdo_sqlsrv")){class
Db
extends
MssqlDb{var$extension="PDO_SQLSRV";function
attach($N,$V,$F){return$this->dsn("sqlsrv:Server=".str_replace(":",",",$N),$V,$F);}}}elseif(extension_loaded("pdo_dblib")){class
Db
extends
MssqlDb{var$extension="PDO_DBLIB";function
attach($N,$V,$F){return$this->dsn("dblib:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$F);}}}}class
Driver
extends
SqlDriver{static$extensions=array("SQLSRV","PDO_SQLSRV","PDO_DBLIB");static$jush="mssql";var$insertFunctions=array("date|time"=>"getdate");var$editFunctions=array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");var$functions=array("len","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");var$generated=array("PERSISTED","VIRTUAL");var$onActions="NO ACTION|CASCADE|SET NULL|SET DEFAULT";static
function
connect($N,$V,$F){if($N=="")$N="localhost:1433";return
parent::connect($N,$V,$F);}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(26)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(27)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(28)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),);}function
insertUpdate($R,array$L,array$G){$o=fields($R);$vj=array();$Z=array();$O=reset($L);$e="c".implode(", c",range(1,count($O)));$Ra=0;$oe=array();foreach($O
as$y=>$X){$Ra++;$B=idf_unescape($y);if(!$o[$B]["auto_increment"])$oe[$y]="c$Ra";if(isset($G[$B]))$Z[]="$y = c$Ra";else$vj[]="$y = c$Ra";}$Fj=array();foreach($L
as$O)$Fj[]="(".implode(", ",$O).")";if($Z){$Td=queries("SET IDENTITY_INSERT ".table($R)." ON");$J=queries("MERGE ".table($R)." USING (VALUES\n\t".implode(",\n\t",$Fj)."\n) AS source ($e) ON ".implode(" AND ",$Z).($vj?"\nWHEN MATCHED THEN UPDATE SET ".implode(", ",$vj):"")."\nWHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($Td?$O:$oe)).") VALUES (".($Td?$e:implode(", ",$oe)).");");if($Td)queries("SET IDENTITY_INSERT ".table($R)." OFF");}else$J=queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES\n".implode(",\n",$Fj));return$J;}function
begin(){return
queries("BEGIN TRANSACTION");}function
tableHelp($B,$ze=false){$Ue=array("sys"=>"catalog-views/sys-","INFORMATION_SCHEMA"=>"information-schema-views/",);$_=$Ue[get_schema()];if($_)return"relational-databases/system-$_".preg_replace('~_~','-',strtolower($B))."-transact-sql";}}function
idf_escape($v){return"[".str_replace("]","]]",$v)."]";}function
table($v){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($H,$Z,$z,$C=0,$Qh=" "){return($z?" TOP (".($z+$C).")":"")." $H$Z";}function
limit1($R,$H,$Z,$Qh="\n"){return
limit($H,$Z,1,0,$Qh);}function
db_collation($k,$lb){return
get_val("SELECT collation_name FROM sys.databases WHERE name = ".q($k));}function
logged_user(){return
get_val("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($j){$J=array();foreach($j
as$k){connection()->select_db($k);$J[$k]=get_val("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$J;}function
table_status($B=""){$J=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment
FROM sys.all_objects AS ao
WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($B!=""?"AND name = ".q($B):"ORDER BY name"))as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return$S["Engine"]=="VIEW";}function
fk_support($S){return
true;}function
fields($R){$sb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($R).", 'column', NULL)");$J=array();$yi=get_val("SELECT object_id FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') AND name = ".q($R));foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, d.definition [default], d.name default_constraint, i.is_primary_key
FROM sys.all_columns c
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.object_id
LEFT JOIN sys.index_columns ic ON c.object_id = ic.object_id AND c.column_id = ic.column_id
LEFT JOIN sys.indexes i ON ic.object_id = i.object_id AND ic.index_id = i.index_id
WHERE c.object_id = ".q($yi))as$K){$U=$K["type"];$Qe=(preg_match("~char|binary~",$U)?intval($K["max_length"])/($U[0]=='n'?2:1):($U=="decimal"?"$K[precision],$K[scale]":""));$J[$K["name"]]=array("field"=>$K["name"],"full_type"=>$U.($Qe?"($Qe)":""),"type"=>$U,"length"=>$Qe,"default"=>(preg_match("~^\('(.*)'\)$~",$K["default"],$A)?str_replace("''","'",$A[1]):$K["default"]),"default_constraint"=>$K["default_constraint"],"null"=>$K["is_nullable"],"auto_increment"=>$K["is_identity"],"collation"=>$K["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["is_primary_key"],"comment"=>$sb[$K["name"]],);}foreach(get_rows("SELECT * FROM sys.computed_columns WHERE object_id = ".q($yi))as$K){$J[$K["name"]]["generated"]=($K["is_persisted"]?"PERSISTED":"VIRTUAL");$J[$K["name"]]["default"]=$K["definition"];}return$J;}function
indexes($R,$h=null){$J=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($R),$h)as$K){$B=$K["name"];$J[$B]["type"]=($K["is_primary_key"]?"PRIMARY":($K["is_unique"]?"UNIQUE":"INDEX"));$J[$B]["lengths"]=array();$J[$B]["columns"][$K["key_ordinal"]]=$K["column_name"];$J[$B]["descs"][$K["key_ordinal"]]=($K["is_descending_key"]?'1':null);}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',get_val("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($B))));}function
collations(){$J=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$c)$J[preg_replace('~_.*~','',$c)][]=$c;return$J;}function
information_schema($k){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',connection()->error)));}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).(preg_match('~^[a-z0-9_]+$~i',$c)?" COLLATE $c":""));}function
drop_databases($j){return
queries("DROP DATABASE ".implode(", ",array_map('Adminer\idf_escape',$j)));}function
rename_database($B,$c){if(preg_match('~^[a-z0-9_]+$~i',$c))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $c");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($B));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($R,$B,$o,$ld,$qb,$_c,$c,$Ba,$E){$b=array();$sb=array();$kg=fields($R);foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$b["DROP"][]=" COLUMN $d";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$sb[$n[0]]=$X[5];unset($X[5]);if(preg_match('~ AS ~',$X[3]))unset($X[1],$X[2]);if($n[0]=="")$b["ADD"][]="\n  ".implode("",$X).($R==""?substr($ld[$X[0]],16+strlen($X[0])):"");else{$l=$X[3];unset($X[3]);unset($X[6]);if($d!=$X[0])queries("EXEC sp_rename ".q(table($R).".$d").", ".q(idf_unescape($X[0])).", 'COLUMN'");$b["ALTER COLUMN ".implode("",$X)][]="";$jg=$kg[$n[0]];if(default_value($jg)!=$l){if($jg["default"]!==null)$b["DROP"][]=" ".idf_escape($jg["default_constraint"]);if($l)$b["ADD"][]="\n $l FOR $d";}}}}if($R=="")return
queries("CREATE TABLE ".table($B)." (".implode(",",(array)$b["ADD"])."\n)");if($R!=$B)queries("EXEC sp_rename ".q(table($R)).", ".q($B));if($ld)$b[""]=$ld;foreach($b
as$y=>$X){if(!queries("ALTER TABLE ".table($B)." $y".implode(",",$X)))return
false;}foreach($sb
as$y=>$X){$qb=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($B).", @level2type = N'Column', @level2name = ".q($y));queries("EXEC sp_addextendedproperty
@name = N'MS_Description',
@value = $qb,
@level0type = N'Schema',
@level0name = ".q(get_schema()).",
@level1type = N'Table',
@level1name = ".q($B).",
@level2type = N'Column',
@level2name = ".q($y));}return
true;}function
alter_indexes($R,$b){$w=array();$kc=array();foreach($b
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$kc[]=idf_escape($X[1]);else$w[]=idf_escape($X[1])." ON ".table($R);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R):"ALTER TABLE ".table($R)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$w||queries("DROP INDEX ".implode(", ",$w)))&&(!$kc||queries("ALTER TABLE ".table($R)." DROP ".implode(", ",$kc)));}function
found_rows($S,$Z){}function
foreign_keys($R){$J=array();$Uf=array("CASCADE","NO ACTION","SET NULL","SET DEFAULT");foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($R).", @fktable_owner = ".q(get_schema()))as$K){$q=&$J[$K["FK_NAME"]];$q["db"]=$K["PKTABLE_QUALIFIER"];$q["ns"]=$K["PKTABLE_OWNER"];$q["table"]=$K["PKTABLE_NAME"];$q["on_update"]=$Uf[$K["UPDATE_RULE"]];$q["on_delete"]=$Uf[$K["DELETE_RULE"]];$q["source"][]=$K["FKCOLUMN_NAME"];$q["target"][]=$K["PKCOLUMN_NAME"];}return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($Kj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$Kj)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables($T,$Kj,$Hi){return
apply_queries("ALTER SCHEMA ".idf_escape($Hi)." TRANSFER",array_merge($T,$Kj));}function
trigger($B,$R){if($B=="")return
array();$L=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($B));$J=reset($L);if($J)$J["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$J["text"]);return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($R))as$K)$J[$K["name"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){if($_GET["ns"]!="")return$_GET["ns"];return
get_val("SELECT SCHEMA_NAME()");}function
set_schema($Fh){$_GET["ns"]=$Fh;return
true;}function
create_sql($R,$Ba,$ri){if(is_view(table_status1($R))){$Jj=view($R);return"CREATE VIEW ".table($R)." AS $Jj[select]";}$o=array();$G=false;foreach(fields($R)as$B=>$n){$X=process_field($n,$n);if($X[6])$G=true;$o[]=implode("",$X);}foreach(indexes($R)as$B=>$w){if(!$G||$w["type"]!="PRIMARY"){$e=array();foreach($w["columns"]as$y=>$X)$e[]=idf_escape($X).($w["descs"][$y]?" DESC":"");$B=idf_escape($B);$o[]=($w["type"]=="INDEX"?"INDEX $B":"CONSTRAINT $B ".($w["type"]=="UNIQUE"?"UNIQUE":"PRIMARY KEY"))." (".implode(", ",$e).")";}}foreach(driver()->checkConstraints($R)as$B=>$Ya)$o[]="CONSTRAINT ".idf_escape($B)." CHECK ($Ya)";return"CREATE TABLE ".table($R)." (\n\t".implode(",\n\t",$o)."\n)";}function
foreign_keys_sql($R){$o=array();foreach(foreign_keys($R)as$ld)$o[]=ltrim(format_foreign_key($ld));return($o?"ALTER TABLE ".table($R)." ADD\n\t".implode(",\n\t",$o).";\n\n":"");}function
truncate_sql($R){return"TRUNCATE TABLE ".table($R);}function
use_sql($Pb){return"USE ".idf_escape($Pb);}function
trigger_sql($R){$J="";foreach(triggers($R)as$B=>$gj)$J
.=create_trigger(" ON ".table($R),trigger($B,$R)).";";return$J;}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Xc){return
preg_match('~^(check|comment|columns|database|drop_col|dump|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$Xc);}}class
Adminer{static$instance;var$error='';function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'><img src='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.3.0")."' width='24' height='24' alt='' id='logo'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($i=false){return
password_file($i);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($N){return
h($N);}function
database(){return
DB;}function
databases($jd=true){return
get_databases($jd);}function
pluginsLinks(){}function
operators(){return
driver()->operators;}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(array$Ib){return$Ib;}function
head($Mb=null){return
true;}function
bodyClass(){echo" adminer";}function
css(){$J=array();foreach(array("","-dark")as$uf){$p="adminer$uf.css";if(file_exists($p)){$bd=file_get_contents($p);$J["$p?v=".crc32($bd)]=($uf?"dark":(preg_match('~prefers-color-scheme:\s*dark~',$bd)?'':'light'));}}return$J;}function
loginForm(){echo"<table class='layout'>\n",adminer()->loginFormField('driver','<tr><th>'.lang(32).'<td>',html_select("auth[driver]",SqlDriver::$drivers,DRIVER,"loginDriver(this);")),adminer()->loginFormField('server','<tr><th>'.lang(33).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'),adminer()->loginFormField('username','<tr><th>'.lang(34).'<td>','<input name="auth[username]" id="username" autofocus value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("const authDriver = qs('#username').form['auth[driver]']; authDriver && authDriver.onchange();")),adminer()->loginFormField('password','<tr><th>'.lang(35).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'),adminer()->loginFormField('db','<tr><th>'.lang(36).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'),"</table>\n","<p><input type='submit' value='".lang(37)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(38))."\n";}function
loginFormField($B,$Jd,$Y){return$Jd.$Y."\n";}function
login($We,$F){if($F=="")return
lang(39,target_blank());return
true;}function
tableName(array$xi){return
h($xi["Name"]);}function
fieldName(array$n,$dg=0){$U=$n["full_type"];$qb=$n["comment"];return'<span title="'.h($U.($qb!=""?($U?": ":"").$qb:'')).'">'.h($n["field"]).'</span>';}function
selectLinks(array$xi,$O=""){$B=$xi["Name"];echo'<p class="links">';$Ue=array("select"=>lang(40));if(support("table")||support("indexes"))$Ue["table"]=lang(41);$ze=false;if(support("table")){$ze=is_view($xi);if($ze)$Ue["view"]=lang(42);else$Ue["create"]=lang(43);}if($O!==null)$Ue["edit"]=lang(44);foreach($Ue
as$y=>$X)echo" <a href='".h(ME)."$y=".urlencode($B).($y=="edit"?$O:"")."'".bold(isset($_GET[$y])).">$X</a>";echo
doc_link(array(JUSH=>driver()->tableHelp($B,$ze)),"?"),"\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$wi){return
array();}function
backwardKeysPrint(array$Fa,array$K){}function
selectQuery($H,$ni,$Vc=false){$J="</p>\n";if(!$Vc&&($Nj=driver()->warnings())){$u="warnings";$J=", <a href='#$u'>".lang(45)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."$J<div id='$u' class='hidden'>\n$Nj</div>\n";}return"<p><code class='jush-".JUSH."'>".h(str_replace("\n"," ",$H))."</code> <span class='time'>(".format_time($ni).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($H)."'>".lang(10)."</a>":"").$J;}function
sqlCommandQuery($H){return
shorten_utf8(trim($H),1000);}function
sqlPrintAfter(){}function
rowDescription($R){return"";}function
rowDescriptions(array$L,array$md){return$L;}function
selectLink($X,array$n){}function
selectVal($X,$_,array$n,$ng){$J=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$n["type"])&&!preg_match("~var~",$n["type"])?"<code>$X</code>":(preg_match('~json~',$n["type"])?"<code class='jush-js'>$X</code>":$X)));if(preg_match('~blob|bytea|raw|file~',$n["type"])&&!is_utf8($X))$J="<i>".lang(46,strlen($ng))."</i>";return($_?"<a href='".h($_)."'".(is_url($_)?target_blank():"").">$J</a>":$J);}function
editVal($X,array$n){return$X;}function
config(){return
array();}function
tableStructurePrint(array$o,$xi=null){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr><th>".lang(47)."<td>".lang(48).(support("comment")?"<td>".lang(49):"")."</thead>\n";$qi=driver()->structuredTypes();foreach($o
as$n){echo"<tr><th>".h($n["field"]);$U=h($n["full_type"]);$c=h($n["collation"]);echo"<td><span title='$c'>".(in_array($U,(array)$qi[lang(31)])?"<a href='".h(ME.'type='.urlencode($U))."'>$U</a>":$U.($c&&isset($xi["Collation"])&&$c!=$xi["Collation"]?" $c":""))."</span>",($n["null"]?" <i>NULL</i>":""),($n["auto_increment"]?" <i>".lang(50)."</i>":"");$l=h($n["default"]);echo(isset($n["default"])?" <span title='".lang(51)."'>[<b>".($n["generated"]?"<code class='jush-".JUSH."'>$l</code>":$l)."</b>]</span>":""),(support("comment")?"<td>".h($n["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint(array$x,array$xi){$yg=false;foreach($x
as$B=>$w)$yg|=!!$w["partial"];echo"<table>\n";$Ub=first(driver()->indexAlgorithms($xi));foreach($x
as$B=>$w){ksort($w["columns"]);$Wg=array();foreach($w["columns"]as$y=>$X)$Wg[]="<i>".h($X)."</i>".($w["lengths"][$y]?"(".$w["lengths"][$y].")":"").($w["descs"][$y]?" DESC":"");echo"<tr title='".h($B)."'>","<th>$w[type]".($Ub&&$w['algorithm']!=$Ub?" ($w[algorithm])":""),"<td>".implode(", ",$Wg);if($yg)echo"<td>".($w['partial']?"<code class='jush-".JUSH."'>WHERE ".h($w['partial']):"");echo"\n";}echo"</table>\n";}function
selectColumnsPrint(array$M,array$e){print_fieldset("select",lang(52),$M);$t=0;$M[""]=array();foreach($M
as$y=>$X){$X=idx($_GET["columns"],$y,array());$d=select_input(" name='columns[$t][col]'",$e,$X["col"],($y!==""?"selectFieldChange":"selectAddRow"));echo"<div>".(driver()->functions||driver()->grouping?html_select("columns[$t][fun]",array(-1=>"")+array_filter(array(lang(53)=>driver()->functions,lang(54)=>driver()->grouping)),$X["fun"]).on_help("event.target.value && event.target.value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($y!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($d)":$d)."</div>\n";$t++;}echo"</div></fieldset>\n";}function
selectSearchPrint(array$Z,array$e,array$x){print_fieldset("search",lang(55),$Z);foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT")echo"<div>(<i>".implode("</i>, <i>",array_map('Adminer\h',$w["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$t]' value='".h(idx($_GET["fulltext"],$t))."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$t]",1,isset($_GET["boolean"][$t]),"BOOL"),"</div>\n";}$Va="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$t=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],adminer()->operators())))echo"<div>".select_input(" name='where[$t][col]'",$e,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(56).")"),html_select("where[$t][op]",adminer()->operators(),$X["op"],$Va),"<input type='search' name='where[$t][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Va }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}echo"</div></fieldset>\n";}function
selectOrderPrint(array$dg,array$e,array$x){print_fieldset("sort",lang(57),$dg);$t=0;foreach((array)$_GET["order"]as$y=>$X){if($X!=""){echo"<div>".select_input(" name='order[$t]'",$e,$X,"selectFieldChange"),checkbox("desc[$t]",1,isset($_GET["desc"][$y]),lang(58))."</div>\n";$t++;}}echo"<div>".select_input(" name='order[$t]'",$e,"","selectAddRow"),checkbox("desc[$t]",1,false,lang(58))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($z){echo"<fieldset><legend>".lang(59)."</legend><div>","<input type='number' name='limit' class='size' value='".intval($z)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($Ni){if($Ni!==null)echo"<fieldset><legend>".lang(60)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($Ni)."'>","</div></fieldset>\n";}function
selectActionPrint(array$x){echo"<fieldset><legend>".lang(61)."</legend><div>","<input type='submit' value='".lang(52)."'>"," <span id='noindex' title='".lang(62)."'></span>","<script".nonce().">\n","const indexColumns = ";$e=array();foreach($x
as$w){$Lb=reset($w["columns"]);if($w["type"]!="FULLTEXT"&&$Lb)$e[$Lb]=1;}$e[""]=1;foreach($e
as$y=>$X)json_row($y);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint(array$xc,array$e){}function
selectColumnsProcess(array$e,array$x){$M=array();$yd=array();foreach((array)$_GET["columns"]as$y=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],driver()->functions)||in_array($X["fun"],driver()->grouping)))){$M[$y]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],driver()->grouping))$yd[]=$M[$y];}}return
array($M,$yd);}function
selectSearchProcess(array$o,array$x){$J=array();foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"&&idx($_GET["fulltext"],$t)!="")$J[]="MATCH (".implode(", ",array_map('Adminer\idf_escape',$w["columns"])).") AGAINST (".q($_GET["fulltext"][$t]).(isset($_GET["boolean"][$t])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$y=>$X){$jb=$X["col"];if("$jb$X[val]"!=""&&in_array($X["op"],adminer()->operators())){$ub=array();foreach(($jb!=""?array($jb=>$o[$jb]):$o)as$B=>$n){$Sg="";$tb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Yd=process_length($X["val"]);$tb
.=" ".($Yd!=""?$Yd:"(NULL)");}elseif($X["op"]=="SQL")$tb=" $X[val]";elseif(preg_match('~^(I?LIKE) %%$~',$X["op"],$A))$tb=" $A[1] ".adminer()->processInput($n,"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$Sg="$X[op](".q($X["val"]).", ";$tb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$tb
.=" ".adminer()->processInput($n,$X["val"]);if($jb!=""||(isset($n["privileges"]["where"])&&(preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$n["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$n["type"]))&&(!preg_match('~date|timestamp~',$n["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"]))))$ub[]=$Sg.driver()->convertSearch(idf_escape($B),$X,$n).$tb;}$J[]=(count($ub)==1?$ub[0]:($ub?"(".implode(" OR ",$ub).")":"1 = 0"));}}return$J;}function
selectOrderProcess(array$o,array$x){$J=array();foreach((array)$_GET["order"]as$y=>$X){if($X!="")$J[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$y])?" DESC":"");}return$J;}function
selectLimitProcess(){return(isset($_GET["limit"])?intval($_GET["limit"]):50);}function
selectLengthProcess(){return(isset($_GET["text_length"])?"$_GET[text_length]":"100");}function
selectEmailProcess(array$Z,array$md){return
false;}function
selectQueryBuild(array$M,array$Z,array$yd,array$dg,$z,$D){return"";}function
messageQuery($H,$Oi,$Vc=false){restart_session();$Ld=&get_session("queries");if(!idx($Ld,$_GET["db"]))$Ld[$_GET["db"]]=array();if(strlen($H)>1e6)$H=preg_replace('~[\x80-\xFF]+$~','',substr($H,0,1e6))."\n…";$Ld[$_GET["db"]][]=array($H,time(),$Oi);$ji="sql-".count($Ld[$_GET["db"]]);$J="<a href='#$ji' class='toggle'>".lang(63)."</a>\n";if(!$Vc&&($Nj=driver()->warnings())){$u="warnings-".count($Ld[$_GET["db"]]);$J="<a href='#$u' class='toggle'>".lang(45)."</a>, $J<div id='$u' class='hidden'>\n$Nj</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $J<div id='$ji' class='hidden'><pre><code class='jush-".JUSH."'>".shorten_utf8($H,1000)."</code></pre>".($Oi?" <span class='time'>($Oi)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Ld[$_GET["db"]])-1)).'">'.lang(10).'</a>':'').'</div>';}function
editRowPrint($R,array$o,$K,$vj){}function
editFunctions(array$n){$J=($n["null"]?"NULL/":"");$vj=isset($_GET["select"])||where($_GET);foreach(array(driver()->insertFunctions,driver()->editFunctions)as$y=>$td){if(!$y||(!isset($_GET["call"])&&$vj)){foreach($td
as$Gg=>$X){if(!$Gg||preg_match("~$Gg~",$n["type"]))$J
.="/$X";}}if($y&&$td&&!preg_match('~set|blob|bytea|raw|file|bool~',$n["type"]))$J
.="/SQL";}if($n["auto_increment"]&&!$vj)$J=lang(50);return
explode("/",$J);}function
editInput($R,array$n,$_a,$Y){if($n["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$_a value='-1' checked><i>".lang(8)."</i></label> ":"").($n["null"]?"<label><input type='radio'$_a value=''".($Y!==null||isset($_GET["select"])?"":" checked")."><i>NULL</i></label> ":"").enum_input("radio",$_a,$n,$Y,$Y===0?0:null);return"";}function
editHint($R,array$n,$Y){return"";}function
processInput(array$n,$Y,$s=""){if($s=="SQL")return$Y;$B=$n["field"];$J=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$s))$J="$s()";elseif(preg_match('~^current_(date|timestamp)$~',$s))$J=$s;elseif(preg_match('~^([+-]|\|\|)$~',$s))$J=idf_escape($B)." $s $J";elseif(preg_match('~^[+-] interval$~',$s))$J=idf_escape($B)." $s ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$J);elseif(preg_match('~^(addtime|subtime|concat)$~',$s))$J="$s(".idf_escape($B).", $J)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$s))$J="$s($J)";return
unconvert_field($n,$J);}function
dumpOutput(){$J=array('text'=>lang(64),'file'=>lang(65));if(function_exists('gzencode'))$J['gz']='gzip';return$J;}function
dumpFormat(){return(support("dump")?array('sql'=>'SQL'):array())+array('csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($k){}function
dumpTable($R,$ri,$ze=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($ri)dump_csv(array_keys(fields($R)));}else{if($ze==2){$o=array();foreach(fields($R)as$B=>$n)$o[]=idf_escape($B)." $n[full_type]";$i="CREATE TABLE ".table($R)." (".implode(", ",$o).")";}else$i=create_sql($R,$_POST["auto_increment"],$ri);set_utf8mb4($i);if($ri&&$i){if($ri=="DROP+CREATE"||$ze==1)echo"DROP ".($ze==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($ze==1)$i=remove_definer($i);echo"$i;\n\n";}}}function
dumpData($R,$ri,$H){if($ri){$ef=(JUSH=="sqlite"?0:1048576);$o=array();$Ud=false;if($_POST["format"]=="sql"){if($ri=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$o=fields($R);if(JUSH=="mssql"){foreach($o
as$n){if($n["auto_increment"]){echo"SET IDENTITY_INSERT ".table($R)." ON;\n";$Ud=true;break;}}}}$I=connection()->query($H,1);if($I){$oe="";$Pa="";$De=array();$ud=array();$ti="";$Yc=($R!=''?'fetch_assoc':'fetch_row');$Eb=0;while($K=$I->$Yc()){if(!$De){$Fj=array();foreach($K
as$X){$n=$I->fetch_field();if(idx($o[$n->name],'generated')){$ud[$n->name]=true;continue;}$De[]=$n->name;$y=idf_escape($n->name);$Fj[]="$y = VALUES($y)";}$ti=($ri=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$Fj):"").";\n";}if($_POST["format"]!="sql"){if($ri=="table"){dump_csv($De);$ri="INSERT";}dump_csv($K);}else{if(!$oe)$oe="INSERT INTO ".table($R)." (".implode(", ",array_map('Adminer\idf_escape',$De)).") VALUES";foreach($K
as$y=>$X){if($ud[$y]){unset($K[$y]);continue;}$n=$o[$y];$K[$y]=($X!==null?unconvert_field($n,preg_match(number_type(),$n["type"])&&!preg_match('~\[~',$n["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$Dh=($ef?"\n":" ")."(".implode(",\t",$K).")";if(!$Pa)$Pa=$oe.$Dh;elseif(JUSH=='mssql'?$Eb%1000!=0:strlen($Pa)+4+strlen($Dh)+strlen($ti)<$ef)$Pa
.=",$Dh";else{echo$Pa.$ti;$Pa=$oe.$Dh;}}$Eb++;}if($Pa)echo$Pa.$ti;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",connection()->error)."\n";if($Ud)echo"SET IDENTITY_INSERT ".table($R)." OFF;\n";}}function
dumpFilename($Sd){return
friendly_url($Sd!=""?$Sd:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($Sd,$wf=false){$qg=$_POST["output"];$Qc=(preg_match('~sql~',$_POST["format"])?"sql":($wf?"tar":"csv"));header("Content-Type: ".($qg=="gz"?"application/x-gzip":($Qc=="tar"?"application/x-tar":($Qc=="sql"||$qg!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($qg=="gz"){ob_start(function($Q){return
gzencode($Q);},1e6);}return$Qc;}function
dumpFooter(){if($_POST["format"]=="sql")echo"-- ".gmdate("Y-m-d H:i:s e")."\n";}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(66)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(67):lang(68))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(69)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(70)."</a>\n":"");return
true;}function
navigation($tf){echo"<h1>".adminer()->name()." <span class='version'>".VERSION;$Df=$_COOKIE["adminer_version"];echo" <a href='https://www.adminer.org/#download'".target_blank()." id='version'>".(version_compare(VERSION,$Df)<0?h($Df):"")."</a>","</span></h1>\n";switch_lang();if($tf=="auth"){$qg="";foreach((array)$_SESSION["pwds"]as$Hj=>$Vh){foreach($Vh
as$N=>$Cj){$B=h(get_setting("vendor-$Hj-$N")?:get_driver($Hj));foreach($Cj
as$V=>$F){if($F!==null){$Sb=$_SESSION["db"][$Hj][$N][$V];foreach(($Sb?array_keys($Sb):array(""))as$k)$qg
.="<li><a href='".h(auth_url($Hj,$N,$V,$k))."'>($B) ".h($V.($N!=""?"@".adminer()->serverName($N):"").($k!=""?" - $k":""))."</a>\n";}}}}if($qg)echo"<ul id='logins'>\n$qg</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$T=array();if($_GET["ns"]!==""&&!$tf&&DB!=""){connection()->select_db(DB);$T=table_status('',true);}adminer()->syntaxHighlighting($T);adminer()->databasesPrint($tf);$ka=array();if(DB==""||!$tf){if(support("sql")){$ka[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(63)."</a>";$ka[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(71)."</a>";}$ka[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(72)."</a>";}$Zd=$_GET["ns"]!==""&&!$tf&&DB!="";if($Zd)$ka[]='<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(73)."</a>";echo($ka?"<p class='links'>\n".implode("\n",$ka)."\n":"");if($Zd){if($T)adminer()->tablesPrint($T);else
echo"<p class='message'>".lang(9)."</p>\n";}}}function
syntaxHighlighting(array$T){echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=5.3.0",true);if(support("sql")){echo"<script".nonce().">\n";if($T){$Ue=array();foreach($T
as$R=>$U)$Ue[]=preg_quote($R,'/');echo"var jushLinks = { ".JUSH.": [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$Ue).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.".JUSH.";\n";if(isset($_GET["sql"])||isset($_GET["trigger"])||isset($_GET["check"])){$Di=array_fill_keys(array_keys($T),array());foreach(driver()->allFields()as$R=>$o){foreach($o
as$n)$Di[$R][]=$n["field"];}echo"addEventListener('DOMContentLoaded', () => { autocompleter = jush.autocompleteSql('".idf_escape("")."', ".json_encode($Di)."); });\n";}}echo"</script>\n";}echo
script("syntaxHighlighting('".preg_replace('~^(\d\.?\d).*~s','\1',connection()->server_info)."', '".connection()->flavor."');");}function
databasesPrint($tf){$j=adminer()->databases();if(DB&&$j&&!in_array(DB,$j))array_unshift($j,DB);echo"<form action=''>\n<p id='dbs'>\n";hidden_fields_get();$Qb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<label title='".lang(36)."'>".lang(74).": ".($j?html_select("db",array(""=>"")+$j,DB).$Qb:"<input name='db' value='".h(DB)."' autocapitalize='off' size='19'>\n")."</label>","<input type='submit' value='".lang(20)."'".($j?" class='hidden'":"").">\n";if(support("scheme")){if($tf!="db"&&DB!=""&&connection()->select_db(DB)){echo"<br><label>".lang(75).": ".html_select("ns",array(""=>"")+adminer()->schemas(),$_GET["ns"])."$Qb</label>";if($_GET["ns"]!="")set_schema($_GET["ns"]);}}foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo
input_hidden($X);break;}}echo"</p></form>\n";}function
tablesPrint(array$T){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$R=>$P){$R="$R";$B=adminer()->tableName($P);if($B!=""&&!$P["inherited"])echo'<li><a href="'.h(ME).'select='.urlencode($R).'"'.bold($_GET["select"]==$R||$_GET["edit"]==$R,"select")." title='".lang(40)."'>".lang(76)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($R).'"'.bold(in_array($R,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"],$_GET["check"],$_GET["view"])),(is_view($P)?"view":"structure"))." title='".lang(41)."'>$B</a>":"<span>$B</span>")."\n";}echo"</ul>\n";}}class
Plugins{private
static$append=array('dumpFormat'=>true,'dumpOutput'=>true,'editRowPrint'=>true,'editFunctions'=>true,'config'=>true);var$plugins;var$error='';private$hooks=array();function
__construct($Lg){if($Lg===null){$Lg=array();$Ja="adminer-plugins";if(is_dir($Ja)){foreach(glob("$Ja/*.php")as$p)$ae=include_once"./$p";}$Kd=" href='https://www.adminer.org/plugins/#use'".target_blank();if(file_exists("$Ja.php")){$ae=include_once"./$Ja.php";if(is_array($ae)){foreach($ae
as$Kg)$Lg[get_class($Kg)]=$Kg;}else$this->error
.=lang(77,"<b>$Ja.php</b>",$Kd)."<br>";}foreach(get_declared_classes()as$fb){if(!$Lg[$fb]&&preg_match('~^Adminer\w~i',$fb)){$oh=new
\ReflectionClass($fb);$zb=$oh->getConstructor();if($zb&&$zb->getNumberOfRequiredParameters())$this->error
.=lang(78,$Kd,"<b>$fb</b>","<b>$Ja.php</b>")."<br>";else$Lg[$fb]=new$fb;}}}$this->plugins=$Lg;$na=new
Adminer;$Lg[]=$na;$oh=new
\ReflectionObject($na);foreach($oh->getMethods()as$rf){foreach($Lg
as$Kg){$B=$rf->getName();if(method_exists($Kg,$B))$this->hooks[$B][]=$Kg;}}}function
__call($B,array$vg){$wa=array();foreach($vg
as$y=>$X)$wa[]=&$vg[$y];$J=null;foreach($this->hooks[$B]as$Kg){$Y=call_user_func_array(array($Kg,$B),$wa);if($Y!==null){if(!self::$append[$B])return$Y;$J=$Y+(array)$J;}}return$J;}}abstract
class
Plugin{protected$translations=array();function
description(){return$this->lang('');}function
screenshot(){return"";}protected
function
lang($v,$Jf=null){$wa=func_get_args();$wa[0]=idx($this->translations[LANG],$v)?:$v;return
call_user_func_array('Adminer\lang_format',$wa);}}Adminer::$instance=(function_exists('adminer_object')?adminer_object():(is_dir("adminer-plugins")||file_exists("adminer-plugins.php")?new
Plugins(null):new
Adminer));SqlDriver::$drivers=array("server"=>"MySQL / MariaDB")+SqlDriver::$drivers;if(!defined('Adminer\DRIVER')){define('Adminer\DRIVER',"server");if(extension_loaded("mysqli")&&$_GET["ext"]!="pdo"){class
Db
extends
\MySQLi{static$instance;var$extension="MySQLi",$flavor='';function
__construct(){parent::init();}function
attach($N,$V,$F){mysqli_report(MYSQLI_REPORT_OFF);list($Od,$Mg)=explode(":",$N,2);$mi=adminer()->connectSsl();if($mi)$this->ssl_set($mi['key'],$mi['cert'],$mi['ca'],'','');$J=@$this->real_connect(($N!=""?$Od:ini_get("mysqli.default_host")),($N.$V!=""?$V:ini_get("mysqli.default_user")),($N.$V.$F!=""?$F:ini_get("mysqli.default_pw")),null,(is_numeric($Mg)?intval($Mg):ini_get("mysqli.default_port")),(is_numeric($Mg)?null:$Mg),($mi?($mi['verify']!==false?2048:64):0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return($J?'':$this->error);}function
set_charset($Xa){if(parent::set_charset($Xa))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Xa");}function
next_result(){return
self::more_results()&&parent::next_result();}function
quote($Q){return"'".$this->escape_string($Q)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Db
extends
SqlDb{private$link;function
attach($N,$V,$F){if(ini_bool("mysql.allow_local_infile"))return
lang(79,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");$this->link=@mysql_connect(($N!=""?$N:ini_get("mysql.default_host")),("$N$V"!=""?$V:ini_get("mysql.default_user")),("$N$V$F"!=""?$F:ini_get("mysql.default_password")),true,131072);if(!$this->link)return
mysql_error();$this->server_info=mysql_get_server_info($this->link);return'';}function
set_charset($Xa){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Xa,$this->link))return
true;mysql_set_charset('utf8',$this->link);}return$this->query("SET NAMES $Xa");}function
quote($Q){return"'".mysql_real_escape_string($Q,$this->link)."'";}function
select_db($Pb){return
mysql_select_db($Pb,$this->link);}function
query($H,$nj=false){$I=@($nj?mysql_unbuffered_query($H,$this->link):mysql_query($H,$this->link));$this->error="";if(!$I){$this->errno=mysql_errno($this->link);$this->error=mysql_error($this->link);return
false;}if($I===true){$this->affected_rows=mysql_affected_rows($this->link);$this->info=mysql_info($this->link);return
true;}return
new
Result($I);}}class
Result{var$num_rows;private$result;private$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=mysql_num_rows($I);}function
fetch_assoc(){return
mysql_fetch_assoc($this->result);}function
fetch_row(){return
mysql_fetch_row($this->result);}function
fetch_field(){$J=mysql_fetch_field($this->result,$this->offset++);$J->orgtable=$J->table;$J->charsetnr=($J->blob?63:0);return$J;}function
__destruct(){mysql_free_result($this->result);}}}elseif(extension_loaded("pdo_mysql")){class
Db
extends
PdoDb{var$extension="PDO_MySQL";function
attach($N,$V,$F){$bg=array(\PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$mi=adminer()->connectSsl();if($mi){if($mi['key'])$bg[\PDO::MYSQL_ATTR_SSL_KEY]=$mi['key'];if($mi['cert'])$bg[\PDO::MYSQL_ATTR_SSL_CERT]=$mi['cert'];if($mi['ca'])$bg[\PDO::MYSQL_ATTR_SSL_CA]=$mi['ca'];if(isset($mi['verify']))$bg[\PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT]=$mi['verify'];}return$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$F,$bg);}function
set_charset($Xa){return$this->query("SET NAMES $Xa");}function
select_db($Pb){return$this->query("USE ".idf_escape($Pb));}function
query($H,$nj=false){$this->pdo->setAttribute(\PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$nj);return
parent::query($H,$nj);}}}class
Driver
extends
SqlDriver{static$extensions=array("MySQLi","MySQL","PDO_MySQL");static$jush="sql";var$unsigned=array("unsigned","zerofill","unsigned zerofill");var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($N,$V,$F){$g=parent::connect($N,$V,$F);if(is_string($g)){if(function_exists('iconv')&&!is_utf8($g)&&strlen($Dh=iconv("windows-1250","utf-8",$g))>strlen($g))$g=$Dh;return$g;}$g->set_charset(charset($g));$g->query("SET sql_quote_show_create = 1, autocommit = 1");$g->flavor=(preg_match('~MariaDB~',$g->server_info)?'maria':'mysql');add_driver(DRIVER,($g->flavor=='maria'?"MariaDB":"MySQL"));return$g;}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(26)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(27)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(80)=>array("enum"=>65535,"set"=>64),lang(28)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(30)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),);$this->insertFunctions=array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",);if(min_version('5.7.8',10.2,$g))$this->types[lang(27)]["json"]=4294967295;if(min_version('',10.7,$g)){$this->types[lang(27)]["uuid"]=128;$this->insertFunctions['uuid']='uuid';}if(min_version(9,'',$g)){$this->types[lang(25)]["vector"]=16383;$this->insertFunctions['vector']='string_to_vector';}if(min_version(5.1,'',$g))$this->partitionBy=array("HASH","LINEAR HASH","KEY","LINEAR KEY","RANGE","LIST");if(min_version(5.7,10.2,$g))$this->generated=array("STORED","VIRTUAL");}function
unconvertFunction(array$n){return(preg_match("~binary~",$n["type"])?"<code class='jush-sql'>UNHEX</code>":($n["type"]=="bit"?doc_link(array('sql'=>'bit-value-literals.html'),"<code>b''</code>"):(preg_match("~geometry|point|linestring|polygon~",$n["type"])?"<code class='jush-sql'>GeomFromText</code>":"")));}function
insert($R,array$O){return($O?parent::insert($R,$O):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,array$L,array$G){$e=array_keys(reset($L));$Sg="INSERT INTO ".table($R)." (".implode(", ",$e).") VALUES\n";$Fj=array();foreach($e
as$y)$Fj[$y]="$y = VALUES($y)";$ti="\nON DUPLICATE KEY UPDATE ".implode(", ",$Fj);$Fj=array();$Qe=0;foreach($L
as$O){$Y="(".implode(", ",$O).")";if($Fj&&(strlen($Sg)+$Qe+strlen($Y)+strlen($ti)>1e6)){if(!queries($Sg.implode(",\n",$Fj).$ti))return
false;$Fj=array();$Qe=0;}$Fj[]=$Y;$Qe+=strlen($Y)+2;}return
queries($Sg.implode(",\n",$Fj).$ti);}function
slowQuery($H,$Pi){if(min_version('5.7.8','10.1.2')){if($this->conn->flavor=='maria')return"SET STATEMENT max_statement_time=$Pi FOR $H";elseif(preg_match('~^(SELECT\b)(.+)~is',$H,$A))return"$A[1] /*+ MAX_EXECUTION_TIME(".($Pi*1000).") */ $A[2]";}}function
convertSearch($v,array$X,array$n){return(preg_match('~char|text|enum|set~',$n["type"])&&!preg_match("~^utf8~",$n["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($v USING ".charset($this->conn).")":$v);}function
warnings(){$I=$this->conn->query("SHOW WARNINGS");if($I&&$I->num_rows){ob_start();print_select_result($I);return
ob_get_clean();}}function
tableHelp($B,$ze=false){$Ye=($this->conn->flavor=='maria');if(information_schema(DB))return
strtolower("information-schema-".($Ye?"$B-table/":str_replace("_","-",$B)."-table.html"));if(DB=="mysql")return($Ye?"mysql$B-table/":"system-schema.html");}function
partitionsInfo($R){$rd="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($R);$I=connection()->query("SELECT PARTITION_METHOD, PARTITION_EXPRESSION, PARTITION_ORDINAL_POSITION $rd ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");$J=array();list($J["partition_by"],$J["partition"],$J["partitions"])=$I->fetch_row();$Cg=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $rd AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$J["partition_names"]=array_keys($Cg);$J["partition_values"]=array_values($Cg);return$J;}function
hasCStyleEscapes(){static$Sa;if($Sa===null){$ki=get_val("SHOW VARIABLES LIKE 'sql_mode'",1,$this->conn);$Sa=(strpos($ki,'NO_BACKSLASH_ESCAPES')===false);}return$Sa;}function
engines(){$J=array();foreach(get_rows("SHOW ENGINES")as$K){if(preg_match("~YES|DEFAULT~",$K["Support"]))$J[]=$K["Engine"];}return$J;}function
indexAlgorithms(array$xi){return(preg_match('~^(MEMORY|NDB)$~',$xi["Engine"])?array("HASH","BTREE"):array());}}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
table($v){return
idf_escape($v);}function
get_databases($jd){$J=get_session("dbs");if($J===null){$H="SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME";$J=($jd?slow_query($H):get_vals($H));restart_session();set_session("dbs",$J);stop_session();}return$J;}function
limit($H,$Z,$z,$C=0,$Qh=" "){return" $H$Z".($z?$Qh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Qh="\n"){return
limit($H,$Z,1,0,$Qh);}function
db_collation($k,array$lb){$J=null;$i=get_val("SHOW CREATE DATABASE ".idf_escape($k),1);if(preg_match('~ COLLATE ([^ ]+)~',$i,$A))$J=$A[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$i,$A))$J=$lb[$A[1]][-1];return$J;}function
logged_user(){return
get_val("SELECT USER()");}function
tables_list(){return
get_key_vals("SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME");}function
count_tables(array$j){$J=array();foreach($j
as$k)$J[$k]=count(get_vals("SHOW TABLES IN ".idf_escape($k)));return$J;}function
table_status($B="",$Wc=false){$J=array();foreach(get_rows($Wc?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($B!=""?"AND TABLE_NAME = ".q($B):"ORDER BY Name"):"SHOW TABLE STATUS".($B!=""?" LIKE ".q(addcslashes($B,"%_\\")):""))as$K){if($K["Engine"]=="InnoDB")$K["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$K["Comment"]);if(!isset($K["Engine"]))$K["Comment"]="";if($B!="")$K["Name"]=$B;$J[$K["Name"]]=$K;}return$J;}function
is_view(array$S){return$S["Engine"]===null;}function
fk_support(array$S){return
preg_match('~InnoDB|IBMDB2I'.(min_version(5.6)?'|NDB':'').'~i',$S["Engine"]);}function
fields($R){$Ye=(connection()->flavor=='maria');$J=array();foreach(get_rows("SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ".q($R)." ORDER BY ORDINAL_POSITION")as$K){$n=$K["COLUMN_NAME"];$U=$K["COLUMN_TYPE"];$vd=$K["GENERATION_EXPRESSION"];$Tc=$K["EXTRA"];preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$Tc,$ud);preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$U,$bf);$l=$K["COLUMN_DEFAULT"];if($l!=""){$ye=preg_match('~text|json~',$bf[1]);if(!$Ye&&$ye)$l=preg_replace("~^(_\w+)?('.*')$~",'\2',stripslashes($l));if($Ye||$ye){$l=($l=="NULL"?null:preg_replace_callback("~^'(.*)'$~",function($A){return
stripslashes(str_replace("''","'",$A[1]));},$l));}if(!$Ye&&preg_match('~binary~',$bf[1])&&preg_match('~^0x(\w*)$~',$l,$A))$l=pack("H*",$A[1]);}$J[$n]=array("field"=>$n,"full_type"=>$U,"type"=>$bf[1],"length"=>$bf[2],"unsigned"=>ltrim($bf[3].$bf[4]),"default"=>($ud?($Ye?$vd:stripslashes($vd)):$l),"null"=>($K["IS_NULLABLE"]=="YES"),"auto_increment"=>($Tc=="auto_increment"),"on_update"=>(preg_match('~\bon update (\w+)~i',$Tc,$A)?$A[1]:""),"collation"=>$K["COLLATION_NAME"],"privileges"=>array_flip(explode(",","$K[PRIVILEGES],where,order")),"comment"=>$K["COLUMN_COMMENT"],"primary"=>($K["COLUMN_KEY"]=="PRI"),"generated"=>($ud[1]=="PERSISTENT"?"STORED":$ud[1]),);}return$J;}function
indexes($R,$h=null){$J=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$h)as$K){$B=$K["Key_name"];$J[$B]["type"]=($B=="PRIMARY"?"PRIMARY":($K["Index_type"]=="FULLTEXT"?"FULLTEXT":($K["Non_unique"]?($K["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$J[$B]["columns"][]=$K["Column_name"];$J[$B]["lengths"][]=($K["Index_type"]=="SPATIAL"?null:$K["Sub_part"]);$J[$B]["descs"][]=null;$J[$B]["algorithm"]=$K["Index_type"];}return$J;}function
foreign_keys($R){static$Gg='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$J=array();$Fb=get_val("SHOW CREATE TABLE ".table($R),1);if($Fb){preg_match_all("~CONSTRAINT ($Gg) FOREIGN KEY ?\\(((?:$Gg,? ?)+)\\) REFERENCES ($Gg)(?:\\.($Gg))? \\(((?:$Gg,? ?)+)\\)(?: ON DELETE (".driver()->onActions."))?(?: ON UPDATE (".driver()->onActions."))?~",$Fb,$cf,PREG_SET_ORDER);foreach($cf
as$A){preg_match_all("~$Gg~",$A[2],$ei);preg_match_all("~$Gg~",$A[5],$Hi);$J[idf_unescape($A[1])]=array("db"=>idf_unescape($A[4]!=""?$A[3]:$A[4]),"table"=>idf_unescape($A[4]!=""?$A[4]:$A[3]),"source"=>array_map('Adminer\idf_unescape',$ei[0]),"target"=>array_map('Adminer\idf_unescape',$Hi[0]),"on_delete"=>($A[6]?:"RESTRICT"),"on_update"=>($A[7]?:"RESTRICT"),);}}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',get_val("SHOW CREATE VIEW ".table($B),1)));}function
collations(){$J=array();foreach(get_rows("SHOW COLLATION")as$K){if($K["Default"])$J[$K["Charset"]][-1]=$K["Collation"];else$J[$K["Charset"]][]=$K["Collation"];}ksort($J);foreach($J
as$y=>$X)sort($J[$y]);return$J;}function
information_schema($k){return($k=="information_schema")||(min_version(5.5)&&$k=="performance_schema");}function
error(){return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",connection()->error));}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).($c?" COLLATE ".q($c):""));}function
drop_databases(array$j){$J=apply_queries("DROP DATABASE",$j,'Adminer\idf_escape');restart_session();set_session("dbs",null);return$J;}function
rename_database($B,$c){$J=false;if(create_database($B,$c)){$T=array();$Kj=array();foreach(tables_list()as$R=>$U){if($U=='VIEW')$Kj[]=$R;else$T[]=$R;}$J=(!$T&&!$Kj)||move_tables($T,$Kj,$B);drop_databases($J?array(DB):array());}return$J;}function
auto_increment(){$Ca=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$w){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$w["columns"],true)){$Ca="";break;}if($w["type"]=="PRIMARY")$Ca=" UNIQUE";}}return" AUTO_INCREMENT$Ca";}function
alter_table($R,$B,array$o,array$ld,$qb,$_c,$c,$Ba,$E){$b=array();foreach($o
as$n){if($n[1]){$l=$n[1][3];if(preg_match('~ GENERATED~',$l)){$n[1][3]=(connection()->flavor=='maria'?"":$n[1][2]);$n[1][2]=$l;}$b[]=($R!=""?($n[0]!=""?"CHANGE ".idf_escape($n[0]):"ADD"):" ")." ".implode($n[1]).($R!=""?$n[2]:"");}else$b[]="DROP ".idf_escape($n[0]);}$b=array_merge($b,$ld);$P=($qb!==null?" COMMENT=".q($qb):"").($_c?" ENGINE=".q($_c):"").($c?" COLLATE ".q($c):"").($Ba!=""?" AUTO_INCREMENT=$Ba":"");if($E){$Cg=array();if($E["partition_by"]=='RANGE'||$E["partition_by"]=='LIST'){foreach($E["partition_names"]as$y=>$X){$Y=$E["partition_values"][$y];$Cg[]="\n  PARTITION ".idf_escape($X)." VALUES ".($E["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$P
.="\nPARTITION BY $E[partition_by]($E[partition])";if($Cg)$P
.=" (".implode(",",$Cg)."\n)";elseif($E["partitions"])$P
.=" PARTITIONS ".(+$E["partitions"]);}elseif($E===null)$P
.="\nREMOVE PARTITIONING";if($R=="")return
queries("CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)$P");if($R!=$B)$b[]="RENAME TO ".table($B);if($P)$b[]=ltrim($P);return($b?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$b)):true);}function
alter_indexes($R,$b){$Wa=array();foreach($b
as$X)$Wa[]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$Wa));}function
truncate_tables(array$T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views(array$Kj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$Kj)));}function
drop_tables(array$T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables(array$T,array$Kj,$Hi){$sh=array();foreach($T
as$R)$sh[]=table($R)." TO ".idf_escape($Hi).".".table($R);if(!$sh||queries("RENAME TABLE ".implode(", ",$sh))){$Yb=array();foreach($Kj
as$R)$Yb[table($R)]=view($R);connection()->select_db($Hi);$k=idf_escape(DB);foreach($Yb
as$B=>$Jj){if(!queries("CREATE VIEW $B AS ".str_replace(" $k."," ",$Jj["select"]))||!queries("DROP VIEW $k.$B"))return
false;}return
true;}return
false;}function
copy_tables(array$T,array$Kj,$Hi){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$B=($Hi==DB?table("copy_$R"):idf_escape($Hi).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $B"))||!queries("CREATE TABLE $B LIKE ".table($R))||!queries("INSERT INTO $B SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K){$gj=$K["Trigger"];if(!queries("CREATE TRIGGER ".($Hi==DB?idf_escape("copy_$gj"):idf_escape($Hi).".".idf_escape($gj))." $K[Timing] $K[Event] ON $B FOR EACH ROW\n$K[Statement];"))return
false;}}foreach($Kj
as$R){$B=($Hi==DB?table("copy_$R"):idf_escape($Hi).".".table($R));$Jj=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $B"))||!queries("CREATE VIEW $B AS $Jj[select]"))return
false;}return
true;}function
trigger($B,$R){if($B=="")return
array();$L=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($B));return
reset($L);}function
triggers($R){$J=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K)$J[$K["Trigger"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($B,$U){$ta=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$fi="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Bc=driver()->enumLength;$lj="((".implode("|",array_merge(array_keys(driver()->types()),$ta)).")\\b(?:\\s*\\(((?:[^'\")]|$Bc)++)\\))?"."\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$Gg="$fi*(".($U=="FUNCTION"?"":driver()->inout).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$lj";$i=get_val("SHOW CREATE $U ".idf_escape($B),2);preg_match("~\\(((?:$Gg\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$lj\\s+":"")."(.*)~is",$i,$A);$o=array();preg_match_all("~$Gg\\s*,?~is",$A[1],$cf,PREG_SET_ORDER);foreach($cf
as$ug)$o[]=array("field"=>str_replace("``","`",$ug[2]).$ug[3],"type"=>strtolower($ug[5]),"length"=>preg_replace_callback("~$Bc~s",'Adminer\normalize_enum',$ug[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$ug[8] $ug[7]"))),"null"=>true,"full_type"=>$ug[4],"inout"=>strtoupper($ug[1]),"collation"=>strtolower($ug[9]),);return
array("fields"=>$o,"comment"=>get_val("SELECT ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE() AND ROUTINE_NAME = ".q($B)),)+($U!="FUNCTION"?array("definition"=>$A[11]):array("returns"=>array("type"=>$A[12],"length"=>$A[13],"unsigned"=>$A[15],"collation"=>$A[16]),"definition"=>$A[17],"language"=>"SQL",));}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE()");}function
routine_languages(){return
array();}function
routine_id($B,array$K){return
idf_escape($B);}function
last_id($I){return
get_val("SELECT LAST_INSERT_ID()");}function
explain(Db$g,$H){return$g->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$H);}function
found_rows(array$S,array$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
create_sql($R,$Ba,$ri){$J=get_val("SHOW CREATE TABLE ".table($R),1);if(!$Ba)$J=preg_replace('~ AUTO_INCREMENT=\d+~','',$J);return$J;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($Pb){return"USE ".idf_escape($Pb);}function
trigger_sql($R){$J="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$K)$J
.="\nCREATE TRIGGER ".idf_escape($K["Trigger"])." $K[Timing] $K[Event] ON ".table($K["Table"])." FOR EACH ROW\n$K[Statement];;\n";return$J;}function
show_variables(){return
get_rows("SHOW VARIABLES");}function
show_status(){return
get_rows("SHOW STATUS");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
convert_field(array$n){if(preg_match("~binary~",$n["type"]))return"HEX(".idf_escape($n["field"]).")";if($n["type"]=="bit")return"BIN(".idf_escape($n["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($n["field"]).")";}function
unconvert_field(array$n,$J){if(preg_match("~binary~",$n["type"]))$J="UNHEX($J)";if($n["type"]=="bit")$J="CONVERT(b$J, UNSIGNED)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"])){$Sg=(min_version(8)?"ST_":"");$J=$Sg."GeomFromText($J, $Sg"."SRID($n[field]))";}return$J;}function
support($Xc){return
preg_match('~^(comment|columns|copy|database|drop_col|dump|indexes|kill|privileges|move_col|procedure|processlist|routine|sql|status|table|trigger|variables|view'.(min_version(5.1)?'|event':'').(min_version(8)?'|descidx':'').(min_version('8.0.16','10.2.1')?'|check':'').')$~',$Xc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){return
get_val("SELECT @@max_connections");}function
types(){return
array();}function
type_values($u){return"";}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Fh,$h=null){return
true;}}define('Adminer\JUSH',Driver::$jush);define('Adminer\SERVER',$_GET[DRIVER]);define('Adminer\DB',$_GET["db"]);define('Adminer\ME',preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').($_GET["ext"]?"ext=".urlencode($_GET["ext"]).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));function
page_header($Ri,$m="",$Oa=array(),$Si=""){page_headers();if(is_ajax()&&$m){page_messages($m);exit;}if(!ob_get_level())ob_start('ob_gzhandler',4096);$Ti=$Ri.($Si!=""?": $Si":"");$Ui=strip_tags($Ti.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".adminer()->name());echo'<!DOCTYPE html>
<html lang="',LANG,'" dir="',lang(81),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>',$Ui,'</title>
<link rel="stylesheet" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=5.3.0"),'">
';$Jb=adminer()->css();if(is_int(key($Jb)))$Jb=array_fill_keys($Jb,'light');$Gd=in_array('light',$Jb)||in_array('',$Jb);$Ed=in_array('dark',$Jb)||in_array('',$Jb);$Mb=($Gd?($Ed?null:false):($Ed?:null));$kf=" media='(prefers-color-scheme: dark)'";if($Mb!==false)echo"<link rel='stylesheet'".($Mb?"":$kf)." href='".h(preg_replace("~\\?.*~","",ME)."?file=dark.css&version=5.3.0")."'>\n";echo"<meta name='color-scheme' content='".($Mb===null?"light dark":($Mb?"dark":"light"))."'>\n",script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=5.3.0");if(adminer()->head($Mb))echo"<link rel='icon' href='data:image/gif;base64,R0lGODlhEAAQAJEAAAQCBPz+/PwCBAROZCH5BAEAAAAALAAAAAAQABAAAAI2hI+pGO1rmghihiUdvUBnZ3XBQA7f05mOak1RWXrNq5nQWHMKvuoJ37BhVEEfYxQzHjWQ5qIAADs='>\n","<link rel='apple-touch-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.3.0")."'>\n";foreach($Jb
as$xj=>$uf){$_a=($uf=='dark'&&!$Mb?$kf:($uf=='light'&&$Ed?" media='(prefers-color-scheme: light)'":""));echo"<link rel='stylesheet'$_a href='".h($xj)."'>\n";}echo"\n<body class='".lang(81)." nojs";adminer()->bodyClass();echo"'>\n";$p=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($p)&&filemtime($p)+86400>time()){$Ij=unserialize(file_get_contents($p));$ch="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($Ij["version"],base64_decode($Ij["signature"]),$ch)==1)$_COOKIE["adminer_version"]=$Ij["version"];}echo
script("mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick".(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '".VERSION."', '".js_escape(ME)."', '".get_token()."')")."});
document.body.classList.replace('nojs', 'js');
const offlineMessage = '".js_escape(lang(82))."';
const thousandsSeparator = '".js_escape(lang(4))."';"),"<div id='help' class='jush-".JUSH." jsonly hidden'></div>\n",script("mixin(qs('#help'), {onmouseover: () => { helpOpen = 1; }, onmouseout: helpMouseout});"),"<div id='content'>\n","<span id='menuopen' class='jsonly'>".icon("move","","menu","")."</span>".script("qs('#menuopen').onclick = event => { qs('#foot').classList.toggle('foot'); event.stopPropagation(); }");if($Oa!==null){$_=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($_?:".").'">'.get_driver(DRIVER).'</a> » ';$_=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$N=adminer()->serverName(SERVER);$N=($N!=""?$N:lang(33));if($Oa===false)echo"$N\n";else{echo"<a href='".h($_)."' accesskey='1' title='Alt+Shift+1'>$N</a> » ";if($_GET["ns"]!=""||(DB!=""&&is_array($Oa)))echo'<a href="'.h($_."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> » ';if(is_array($Oa)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> » ';foreach($Oa
as$y=>$X){$ac=(is_array($X)?$X[1]:h($X));if($ac!="")echo"<a href='".h(ME."$y=").urlencode(is_array($X)?$X[0]:$X)."'>$ac</a> » ";}}echo"$Ri\n";}}echo"<h2>$Ti</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($m);$j=&get_session("dbs");if(DB!=""&&$j&&!in_array(DB,$j,true))$j=null;stop_session();define('Adminer\PAGE_HEADER',1);}function
page_headers(){header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach(adminer()->csp(csp())as$Ib){$Id=array();foreach($Ib
as$y=>$X)$Id[]="$y $X";header("Content-Security-Policy: ".implode("; ",$Id));}adminer()->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$Ff;if(!$Ff)$Ff=base64_encode(rand_string());return$Ff;}function
page_messages($m){$wj=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$qf=idx($_SESSION["messages"],$wj);if($qf){echo"<div class='message'>".implode("</div>\n<div class='message'>",$qf)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$wj]);}if($m)echo"<div class='error'>$m</div>\n";if(adminer()->error)echo"<div class='error'>".adminer()->error."</div>\n";}function
page_footer($tf=""){echo"</div>\n\n<div id='foot' class='foot'>\n<div id='menu'>\n";adminer()->navigation($tf);echo"</div>\n";if($tf!="auth")echo'<form action="" method="post">
<p class="logout">
<span>',h($_GET["username"])."\n",'</span>
<input type="submit" name="logout" value="',lang(83),'" id="logout">
',input_token(),'</form>
';echo"</div>\n\n",script("setupSubmitHighlight(document);");}function
int32($yf){while($yf>=2147483648)$yf-=4294967296;while($yf<=-2147483649)$yf+=4294967296;return(int)$yf;}function
long2str(array$W,$Mj){$Dh='';foreach($W
as$X)$Dh
.=pack('V',$X);if($Mj)return
substr($Dh,0,end($W));return$Dh;}function
str2long($Dh,$Mj){$W=array_values(unpack('V*',str_pad($Dh,4*ceil(strlen($Dh)/4),"\0")));if($Mj)$W[]=strlen($Dh);return$W;}function
xxtea_mx($Tj,$Sj,$ui,$Be){return
int32((($Tj>>5&0x7FFFFFF)^$Sj<<2)+(($Sj>>3&0x1FFFFFFF)^$Tj<<4))^int32(($ui^$Sj)+($Be^$Tj));}function
encrypt_string($pi,$y){if($pi=="")return"";$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($pi,true);$yf=count($W)-1;$Tj=$W[$yf];$Sj=$W[0];$dh=floor(6+52/($yf+1));$ui=0;while($dh-->0){$ui=int32($ui+0x9E3779B9);$rc=$ui>>2&3;for($sg=0;$sg<$yf;$sg++){$Sj=$W[$sg+1];$xf=xxtea_mx($Tj,$Sj,$ui,$y[$sg&3^$rc]);$Tj=int32($W[$sg]+$xf);$W[$sg]=$Tj;}$Sj=$W[0];$xf=xxtea_mx($Tj,$Sj,$ui,$y[$sg&3^$rc]);$Tj=int32($W[$yf]+$xf);$W[$yf]=$Tj;}return
long2str($W,false);}function
decrypt_string($pi,$y){if($pi=="")return"";if(!$y)return
false;$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($pi,false);$yf=count($W)-1;$Tj=$W[$yf];$Sj=$W[0];$dh=floor(6+52/($yf+1));$ui=int32($dh*0x9E3779B9);while($ui){$rc=$ui>>2&3;for($sg=$yf;$sg>0;$sg--){$Tj=$W[$sg-1];$xf=xxtea_mx($Tj,$Sj,$ui,$y[$sg&3^$rc]);$Sj=int32($W[$sg]-$xf);$W[$sg]=$Sj;}$Tj=$W[$yf];$xf=xxtea_mx($Tj,$Sj,$ui,$y[$sg&3^$rc]);$Sj=int32($W[0]-$xf);$W[0]=$Sj;$ui=int32($ui-0x9E3779B9);}return
long2str($W,true);}$Ig=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($y)=explode(":",$X);$Ig[$y]=$X;}}function
add_invalid_login(){$Ha=get_temp_dir()."/adminer.invalid";foreach(glob("$Ha*")?:array($Ha)as$p){$r=file_open_lock($p);if($r)break;}if(!$r)$r=file_open_lock("$Ha-".rand_string());if(!$r)return;$te=unserialize(stream_get_contents($r));$Oi=time();if($te){foreach($te
as$ue=>$X){if($X[0]<$Oi)unset($te[$ue]);}}$se=&$te[adminer()->bruteForceKey()];if(!$se)$se=array($Oi+30*60,0);$se[1]++;file_write_unlock($r,serialize($te));}function
check_invalid_login(array&$Ig){$te=array();foreach(glob(get_temp_dir()."/adminer.invalid*")as$p){$r=file_open_lock($p);if($r){$te=unserialize(stream_get_contents($r));file_unlock($r);break;}}$se=idx($te,adminer()->bruteForceKey(),array());$Ef=($se[1]>29?$se[0]-time():0);if($Ef>0)auth_error(lang(84,ceil($Ef/60)),$Ig);}$Aa=$_POST["auth"];if($Aa){session_regenerate_id();$Hj=$Aa["driver"];$N=$Aa["server"];$V=$Aa["username"];$F=(string)$Aa["password"];$k=$Aa["db"];set_password($Hj,$N,$V,$F);$_SESSION["db"][$Hj][$N][$V][$k]=true;if($Aa["permanent"]){$y=implode("-",array_map('base64_encode',array($Hj,$N,$V,$k)));$Xg=adminer()->permanentLogin(true);$Ig[$y]="$y:".base64_encode($Xg?encrypt_string($F,$Xg):"");cookie("adminer_permanent",implode(" ",$Ig));}if(count($_POST)==1||DRIVER!=$Hj||SERVER!=$N||$_GET["username"]!==$V||DB!=$k)redirect(auth_url($Hj,$N,$V,$k));}elseif($_POST["logout"]&&(!$_SESSION["token"]||verify_token())){foreach(array("pwds","db","dbs","queries")as$y)set_session($y,null);unset_permanent($Ig);redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(85).' '.lang(86));}elseif($Ig&&!$_SESSION["pwds"]){session_regenerate_id();$Xg=adminer()->permanentLogin();foreach($Ig
as$y=>$X){list(,$eb)=explode(":",$X);list($Hj,$N,$V,$k)=array_map('base64_decode',explode("-",$y));set_password($Hj,$N,$V,decrypt_string(base64_decode($eb),$Xg));$_SESSION["db"][$Hj][$N][$V][$k]=true;}}function
unset_permanent(array&$Ig){foreach($Ig
as$y=>$X){list($Hj,$N,$V,$k)=array_map('base64_decode',explode("-",$y));if($Hj==DRIVER&&$N==SERVER&&$V==$_GET["username"]&&$k==DB)unset($Ig[$y]);}cookie("adminer_permanent",implode(" ",$Ig));}function
auth_error($m,array&$Ig){$Wh=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$Wh]||$_GET[$Wh])&&!$_SESSION["token"])$m=lang(87);else{restart_session();add_invalid_login();$F=get_password();if($F!==null){if($F===false)$m
.=($m?'<br>':'').lang(88,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent($Ig);}}if(!$_COOKIE[$Wh]&&$_GET[$Wh]&&ini_bool("session.use_only_cookies"))$m=lang(89);$vg=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?:rand_string()),$vg["lifetime"]);if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);page_header(lang(37),$m,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(90)."\n";echo"</div>\n";adminer()->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists('Adminer\Db')){unset($_SESSION["pwds"][DRIVER]);unset_permanent($Ig);page_header(lang(91),lang(92,implode(", ",Driver::$extensions)),false);page_footer("auth");exit;}$g='';if(isset($_GET["username"])&&is_string(get_password())){list($Od,$Mg)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$Mg,$A)&&($A[1]<1024||$A[1]>65535))auth_error(lang(93),$Ig);check_invalid_login($Ig);$Hb=adminer()->credentials();$g=Driver::connect($Hb[0],$Hb[1],$Hb[2]);if(is_object($g)){Db::$instance=$g;Driver::$instance=new
Driver($g);if($g->flavor)save_settings(array("vendor-".DRIVER."-".SERVER=>get_driver(DRIVER)));}}$We=null;if(!is_object($g)||($We=adminer()->login($_GET["username"],get_password()))!==true){$m=(is_string($g)?nl_br(h($g)):(is_string($We)?$We:lang(94))).(preg_match('~^ | $~',get_password())?'<br>'.lang(95):'');auth_error($m,$Ig);}if($_POST["logout"]&&$_SESSION["token"]&&!verify_token()){page_header(lang(83),lang(96));page_footer("db");exit;}if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);stop_session(true);if($Aa&&$_POST["token"])$_POST["token"]=get_token();$m='';if($_POST){if(!verify_token()){$le="max_input_vars";$if=ini_get($le);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$y){$X=ini_get($y);if($X&&(!$if||$X<$if)){$le=$y;$if=$X;}}}$m=(!$_POST["token"]&&$if?lang(97,"'$le'"):lang(96).' '.lang(98));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$m=lang(99,"'post_max_size'");if(isset($_GET["sql"]))$m
.=' '.lang(100);}function
print_select_result($I,$h=null,array$hg=array(),$z=0){$Ue=array();$x=array();$e=array();$Ma=array();$mj=array();$J=array();for($t=0;(!$z||$t<$z)&&($K=$I->fetch_row());$t++){if(!$t){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr>";for($_e=0;$_e<count($K);$_e++){$n=$I->fetch_field();$B=$n->name;$gg=(isset($n->orgtable)?$n->orgtable:"");$fg=(isset($n->orgname)?$n->orgname:$B);if($hg&&JUSH=="sql")$Ue[$_e]=($B=="table"?"table=":($B=="possible_keys"?"indexes=":null));elseif($gg!=""){if(isset($n->table))$J[$n->table]=$gg;if(!isset($x[$gg])){$x[$gg]=array();foreach(indexes($gg,$h)as$w){if($w["type"]=="PRIMARY"){$x[$gg]=array_flip($w["columns"]);break;}}$e[$gg]=$x[$gg];}if(isset($e[$gg][$fg])){unset($e[$gg][$fg]);$x[$gg][$fg]=$_e;$Ue[$_e]=$gg;}}if($n->charsetnr==63)$Ma[$_e]=true;$mj[$_e]=$n->type;echo"<th".($gg!=""||$n->name!=$fg?" title='".h(($gg!=""?"$gg.":"").$fg)."'":"").">".h($B).($hg?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($B),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr>";foreach($K
as$y=>$X){$_="";if(isset($Ue[$y])&&!$e[$Ue[$y]]){if($hg&&JUSH=="sql"){$R=$K[array_search("table=",$Ue)];$_=ME.$Ue[$y].urlencode($hg[$R]!=""?$hg[$R]:$R);}else{$_=ME."edit=".urlencode($Ue[$y]);foreach($x[$Ue[$y]]as$jb=>$_e)$_
.="&where".urlencode("[".bracket_escape($jb)."]")."=".urlencode($K[$_e]);}}elseif(is_url($X))$_=$X;if($X===null)$X="<i>NULL</i>";elseif($Ma[$y]&&!is_utf8($X))$X="<i>".lang(46,strlen($X))."</i>";else{$X=h($X);if($mj[$y]==254)$X="<code>$X</code>";}if($_)$X="<a href='".h($_)."'".(is_url($_)?target_blank():'').">$X</a>";echo"<td".($mj[$y]<=9||$mj[$y]==246?" class='number'":"").">$X";}}echo($t?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$J;}function
referencable_primary($Oh){$J=array();foreach(table_status('',true)as$zi=>$R){if($zi!=$Oh&&fk_support($R)){foreach(fields($zi)as$n){if($n["primary"]){if($J[$zi]){unset($J[$zi]);break;}$J[$zi]=$n;}}}}return$J;}function
textarea($B,$Y,$L=10,$mb=80){echo"<textarea name='".h($B)."' rows='$L' cols='$mb' class='sqlarea jush-".JUSH."' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
select_input($_a,array$bg,$Y="",$Vf="",$Jg=""){$Gi=($bg?"select":"input");return"<$Gi$_a".($bg?"><option value=''>$Jg".optionlist($bg,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$Jg'>").($Vf?script("qsl('$Gi').onchange = $Vf;",""):"");}function
json_row($y,$X=null){static$dd=true;if($dd)echo"{";if($y!=""){echo($dd?"":",")."\n\t\"".addcslashes($y,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$dd=false;}else{echo"\n}\n";$dd=true;}}function
edit_type($y,array$n,array$lb,array$nd=array(),array$Uc=array()){$U=$n["type"];echo"<td><select name='".h($y)."[type]' class='type' aria-labelledby='label-type'>";if($U&&!array_key_exists($U,driver()->types())&&!isset($nd[$U])&&!in_array($U,$Uc))$Uc[]=$U;$qi=driver()->structuredTypes();if($nd)$qi[lang(101)]=$nd;echo
optionlist(array_merge($Uc,$qi),$U),"</select><td>","<input name='".h($y)."[length]' value='".h($n["length"])."' size='3'".(!$n["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"")." aria-labelledby='label-length'>","<td class='options'>",($lb?"<input list='collations' name='".h($y)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'")." value='".h($n["collation"])."' placeholder='(".lang(102).")'>":''),(driver()->unsigned?"<select name='".h($y)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist(driver()->unsigned,$n["unsigned"]).'</select>':''),(isset($n['on_update'])?"<select name='".h($y)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(103).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"CURRENT_TIMESTAMP":$n["on_update"])).'</select>':''),($nd?"<select name='".h($y)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(104).")".optionlist(explode("|",driver()->onActions),$n["on_delete"])."</select> ":" ");}function
process_length($Qe){$Dc=driver()->enumLength;return(preg_match("~^\\s*\\(?\\s*$Dc(?:\\s*,\\s*$Dc)*+\\s*\\)?\\s*\$~",$Qe)&&preg_match_all("~$Dc~",$Qe,$cf)?"(".implode(",",$cf[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$Qe)));}function
process_type(array$n,$kb="COLLATE"){return" $n[type]".process_length($n["length"]).(preg_match(number_type(),$n["type"])&&in_array($n["unsigned"],driver()->unsigned)?" $n[unsigned]":"").(preg_match('~char|text|enum|set~',$n["type"])&&$n["collation"]?" $kb ".(JUSH=="mssql"?$n["collation"]:q($n["collation"])):"");}function
process_field(array$n,array$kj){if($n["on_update"])$n["on_update"]=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$n["on_update"]);return
array(idf_escape(trim($n["field"])),process_type($kj),($n["null"]?" NULL":" NOT NULL"),default_value($n),(preg_match('~timestamp|datetime~',$n["type"])&&$n["on_update"]?" ON UPDATE $n[on_update]":""),(support("comment")&&$n["comment"]!=""?" COMMENT ".q($n["comment"]):""),($n["auto_increment"]?auto_increment():null),);}function
default_value(array$n){$l=$n["default"];$ud=$n["generated"];return($l===null?"":(in_array($ud,driver()->generated)?(JUSH=="mssql"?" AS ($l)".($ud=="VIRTUAL"?"":" $ud")."":" GENERATED ALWAYS AS ($l) $ud"):" DEFAULT ".(!preg_match('~^GENERATED ~i',$l)&&(preg_match('~char|binary|text|json|enum|set~',$n["type"])||preg_match('~^(?![a-z])~i',$l))?(JUSH=="sql"&&preg_match('~text|json~',$n["type"])?"(".q($l).")":q($l)):str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",(JUSH=="sqlite"?"($l)":$l)))));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$y=>$X){if(preg_match("~$y|$X~",$U))return" class='$y'";}}function
edit_fields(array$o,array$lb,$U="TABLE",array$nd=array()){$o=array_values($o);$Vb=(($_POST?$_POST["defaults"]:get_setting("defaults"))?"":" class='hidden'");$rb=(($_POST?$_POST["comments"]:get_setting("comments"))?"":" class='hidden'");echo"<thead><tr>\n",($U=="PROCEDURE"?"<td>":""),"<th id='label-name'>".($U=="TABLE"?lang(105):lang(106)),"<td id='label-type'>".lang(48)."<textarea id='enum-edit' rows='4' cols='12' wrap='off' style='display: none;'></textarea>".script("qs('#enum-edit').onblur = editingLengthBlur;"),"<td id='label-length'>".lang(107),"<td>".lang(108);if($U=="TABLE")echo"<td id='label-null'>NULL\n","<td><input type='radio' name='auto_increment_col' value=''><abbr id='label-ai' title='".lang(50)."'>AI</abbr>",doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype-numeric.html#DATATYPE-SERIAL",'mssql'=>"t-sql/statements/create-table-transact-sql-identity-property",)),"<td id='label-default'$Vb>".lang(51),(support("comment")?"<td id='label-comment'$rb>".lang(49):"");echo"<td>".icon("plus","add[".(support("move_col")?0:count($o))."]","+",lang(109)),"</thead>\n<tbody>\n",script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($o
as$t=>$n){$t++;$ig=$n[($_POST?"orig":"field")];$gc=(isset($_POST["add"][$t-1])||(isset($n["field"])&&!idx($_POST["drop_col"],$t)))&&(support("drop_col")||$ig=="");echo"<tr".($gc?"":" style='display: none;'").">\n",($U=="PROCEDURE"?"<td>".html_select("fields[$t][inout]",explode("|",driver()->inout),$n["inout"]):"")."<th>";if($gc)echo"<input name='fields[$t][field]' value='".h($n["field"])."' data-maxlength='64' autocapitalize='off' aria-labelledby='label-name'>";echo
input_hidden("fields[$t][orig]",$ig);edit_type("fields[$t]",$n,$lb,$nd);if($U=="TABLE")echo"<td>".checkbox("fields[$t][null]",1,$n["null"],"","","block","label-null"),"<td><label class='block'><input type='radio' name='auto_increment_col' value='$t'".($n["auto_increment"]?" checked":"")." aria-labelledby='label-ai'></label>","<td$Vb>".(driver()->generated?html_select("fields[$t][generated]",array_merge(array("","DEFAULT"),driver()->generated),$n["generated"])." ":checkbox("fields[$t][generated]",1,$n["generated"],"","","","label-default")),"<input name='fields[$t][default]' value='".h($n["default"])."' aria-labelledby='label-default'>",(support("comment")?"<td$rb><input name='fields[$t][comment]' value='".h($n["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");echo"<td>",(support("move_col")?icon("plus","add[$t]","+",lang(109))." ".icon("up","up[$t]","↑",lang(110))." ".icon("down","down[$t]","↓",lang(111))." ":""),($ig==""||support("drop_col")?icon("cross","drop_col[$t]","x",lang(112)):"");}}function
process_fields(array&$o){$C=0;if($_POST["up"]){$Ke=0;foreach($o
as$y=>$n){if(key($_POST["up"])==$y){unset($o[$y]);array_splice($o,$Ke,0,array($n));break;}if(isset($n["field"]))$Ke=$C;$C++;}}elseif($_POST["down"]){$pd=false;foreach($o
as$y=>$n){if(isset($n["field"])&&$pd){unset($o[key($_POST["down"])]);array_splice($o,$C,0,array($pd));break;}if(key($_POST["down"])==$y)$pd=$n;$C++;}}elseif($_POST["add"]){$o=array_values($o);array_splice($o,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum(array$A){$X=$A[0];return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($X[0].$X[0],$X[0],substr($X,1,-1))),'\\'))."'";}function
grant($wd,array$Zg,$e,$Sf){if(!$Zg)return
true;if($Zg==array("ALL PRIVILEGES","GRANT OPTION"))return($wd=="GRANT"?queries("$wd ALL PRIVILEGES$Sf WITH GRANT OPTION"):queries("$wd ALL PRIVILEGES$Sf")&&queries("$wd GRANT OPTION$Sf"));return
queries("$wd ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$e, ",$Zg).$e).$Sf);}function
drop_create($kc,$i,$mc,$Ki,$oc,$Ve,$pf,$nf,$of,$Pf,$Bf){if($_POST["drop"])query_redirect($kc,$Ve,$pf);elseif($Pf=="")query_redirect($i,$Ve,$of);elseif($Pf!=$Bf){$Gb=queries($i);queries_redirect($Ve,$nf,$Gb&&queries($kc));if($Gb)queries($mc);}else
queries_redirect($Ve,$nf,queries($Ki)&&queries($oc)&&queries($kc)&&queries($i));}function
create_trigger($Sf,array$K){$Qi=" $K[Timing] $K[Event]".(preg_match('~ OF~',$K["Event"])?" $K[Of]":"");return"CREATE TRIGGER ".idf_escape($K["Trigger"]).(JUSH=="mssql"?$Sf.$Qi:$Qi.$Sf).rtrim(" $K[Type]\n$K[Statement]",";").";";}function
create_routine($_h,array$K){$O=array();$o=(array)$K["fields"];ksort($o);foreach($o
as$n){if($n["field"]!="")$O[]=(preg_match("~^(".driver()->inout.")\$~",$n["inout"])?"$n[inout] ":"").idf_escape($n["field"]).process_type($n,"CHARACTER SET");}$Xb=rtrim($K["definition"],";");return"CREATE $_h ".idf_escape(trim($K["name"]))." (".implode(", ",$O).")".($_h=="FUNCTION"?" RETURNS".process_type($K["returns"],"CHARACTER SET"):"").($K["language"]?" LANGUAGE $K[language]":"").(JUSH=="pgsql"?" AS ".q($Xb):"\n$Xb;");}function
remove_definer($H){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$H);}function
format_foreign_key(array$q){$k=$q["db"];$Gf=$q["ns"];return" FOREIGN KEY (".implode(", ",array_map('Adminer\idf_escape',$q["source"])).") REFERENCES ".($k!=""&&$k!=$_GET["db"]?idf_escape($k).".":"").($Gf!=""&&$Gf!=$_GET["ns"]?idf_escape($Gf).".":"").idf_escape($q["table"])." (".implode(", ",array_map('Adminer\idf_escape',$q["target"])).")".(preg_match("~^(".driver()->onActions.")\$~",$q["on_delete"])?" ON DELETE $q[on_delete]":"").(preg_match("~^(".driver()->onActions.")\$~",$q["on_update"])?" ON UPDATE $q[on_update]":"");}function
tar_file($p,$Vi){$J=pack("a100a8a8a8a12a12",$p,644,0,0,decoct($Vi->size),decoct(time()));$db=8*32;for($t=0;$t<strlen($J);$t++)$db+=ord($J[$t]);$J
.=sprintf("%06o",$db)."\0 ";echo$J,str_repeat("\0",512-strlen($J));$Vi->send();echo
str_repeat("\0",511-($Vi->size+511)%512);}function
ini_bytes($le){$X=ini_get($le);switch(strtolower(substr($X,-1))){case'g':$X=(int)$X*1024;case'm':$X=(int)$X*1024;case'k':$X=(int)$X*1024;}return$X;}function
doc_link(array$Fg,$Li="<sup>?</sup>"){$Uh=connection()->server_info;$Ij=preg_replace('~^(\d\.?\d).*~s','\1',$Uh);$yj=array('sql'=>"https://dev.mysql.com/doc/refman/$Ij/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/".(connection()->flavor=='cockroach'?"current":$Ij)."/",'mssql'=>"https://learn.microsoft.com/en-us/sql/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$Uh)."&id=",);if(connection()->flavor=='maria'){$yj['sql']="https://mariadb.com/kb/en/";$Fg['sql']=(isset($Fg['mariadb'])?$Fg['mariadb']:str_replace(".html","/",$Fg['sql']));}return($Fg[JUSH]?"<a href='".h($yj[JUSH].$Fg[JUSH].(JUSH=='mssql'?"?view=sql-server-ver$Ij":""))."'".target_blank().">$Li</a>":"");}function
db_size($k){if(!connection()->select_db($k))return"?";$J=0;foreach(table_status()as$S)$J+=$S["Data_length"]+$S["Index_length"];return
format_number($J);}function
set_utf8mb4($i){static$O=false;if(!$O&&preg_match('~\butf8mb4~i',$i)){$O=true;echo"SET NAMES ".charset(connection()).";\n\n";}}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?connection()->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(36).": ".h(DB),lang(113),true);}else{if($_POST["db"]&&!$m)queries_redirect(substr(ME,0,-1),lang(114),drop_databases($_POST["db"]));page_header(lang(115),$m,false);echo"<p class='links'>\n";foreach(array('database'=>lang(116),'privileges'=>lang(70),'processlist'=>lang(117),'variables'=>lang(118),'status'=>lang(119),)as$y=>$X){if(support($y))echo"<a href='".h(ME)."$y='>$X</a>\n";}echo"<p>".lang(120,get_driver(DRIVER),"<b>".h(connection()->server_info)."</b>","<b>".connection()->extension."</b>")."\n","<p>".lang(121,"<b>".h(logged_user())."</b>")."\n";$j=adminer()->databases();if($j){$Hh=support("scheme");$lb=collations();echo"<form action='' method='post'>\n","<table class='checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(36).(get_session("dbs")!==null?" - <a href='".h(ME)."refresh=1'>".lang(122)."</a>":"")."<td>".lang(123)."<td>".lang(124)."<td>".lang(125)." - <a href='".h(ME)."dbsize=1'>".lang(126)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$j=($_GET["dbsize"]?count_tables($j):array_flip($j));foreach($j
as$k=>$T){$zh=h(ME)."db=".urlencode($k);$u=h("Db-".$k);echo"<tr>".(support("database")?"<td>".checkbox("db[]",$k,in_array($k,(array)$_POST["db"]),"","","",$u):""),"<th><a href='$zh' id='$u'>".h($k)."</a>";$c=h(db_collation($k,$lb));echo"<td>".(support("database")?"<a href='$zh".($Hh?"&amp;ns=":"")."&amp;database=' title='".lang(66)."'>$c</a>":$c),"<td align='right'><a href='$zh&amp;schema=' id='tables-".h($k)."' title='".lang(69)."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($k)."'>".($_GET["dbsize"]?db_size($k):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(127)." <span id='selected'></span></legend><div>\n".input_hidden("all").script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(128)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),input_token(),"</form>\n",script("tableCheck();");}if(!empty(adminer()->plugins)){echo"<div class='plugins'>\n","<h3>".lang(129)."</h3>\n<ul>\n";foreach(adminer()->plugins
as$Kg){$bc=(method_exists($Kg,'description')?$Kg->description():"");if(!$bc){$oh=new
\ReflectionObject($Kg);if(preg_match('~^/[\s*]+(.+)~',$oh->getDocComment(),$A))$bc=$A[1];}$Ih=(method_exists($Kg,'screenshot')?$Kg->screenshot():"");echo"<li><b>".get_class($Kg)."</b>".h($bc?": $bc":"").($Ih?" (<a href='".h($Ih)."'".target_blank().">".lang(130)."</a>)":"")."\n";}echo"</ul>\n";adminer()->pluginsLinks();echo"</div>\n";}}page_footer("db");exit;}if(support("scheme")){if(DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){header("HTTP/1.1 404 Not Found");page_header(lang(75).": ".h($_GET["ns"]),lang(131),true);page_footer("ns");exit;}}}class
TmpFile{private$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($Ab){$this->size+=strlen($Ab);fwrite($this->handler,$Ab);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$o=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$M=array(idf_escape($_GET["field"]));$I=driver()->select($a,$M,array(where($_GET,$o)),$M);$K=($I?$I->fetch_row():array());echo
driver()->value($K[0],$o[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$o=fields($a);if(!$o)$m=error()?:lang(9);$S=table_status1($a);$B=adminer()->tableName($S);page_header(($o&&is_view($S)?$S['Engine']=='materialized view'?lang(132):lang(133):lang(134)).": ".($B!=""?$B:h($a)),$m);$yh=array();foreach($o
as$y=>$n)$yh+=$n["privileges"];adminer()->selectLinks($S,(isset($yh["insert"])||!support("table")?"":null));$qb=$S["Comment"];if($qb!="")echo"<p class='nowrap'>".lang(49).": ".h($qb)."\n";function
tables_links($T){echo"<ul>\n";foreach($T
as$R)echo"<li><a href='".h(ME."table=".urlencode($R))."'>".h($R)."</a>";echo"</ul>\n";}$ke=driver()->inheritsFrom($a);if($ke){echo"<h3>".lang(135)."</h3>\n";tables_links($ke);}elseif($o)adminer()->tableStructurePrint($o,$S);if(support("indexes")&&driver()->supportsIndex($S)){echo"<h3 id='indexes'>".lang(136)."</h3>\n";$x=indexes($a);if($x)adminer()->tableIndexesPrint($x,$S);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(137)."</a>\n";}if(!is_view($S)){if(fk_support($S)){echo"<h3 id='foreign-keys'>".lang(101)."</h3>\n";$nd=foreign_keys($a);if($nd){echo"<table>\n","<thead><tr><th>".lang(138)."<td>".lang(139)."<td>".lang(104)."<td>".lang(103)."<td></thead>\n";foreach($nd
as$B=>$q){echo"<tr title='".h($B)."'>","<th><i>".implode("</i>, <i>",array_map('Adminer\h',$q["source"]))."</i>";$_=($q["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($q["db"]),ME):($q["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($q["ns"]),ME):ME));echo"<td><a href='".h($_."table=".urlencode($q["table"]))."'>".($q["db"]!=""&&$q["db"]!=DB?"<b>".h($q["db"])."</b>.":"").($q["ns"]!=""&&$q["ns"]!=$_GET["ns"]?"<b>".h($q["ns"])."</b>.":"").h($q["table"])."</a>","(<i>".implode("</i>, <i>",array_map('Adminer\h',$q["target"]))."</i>)","<td>".h($q["on_delete"]),"<td>".h($q["on_update"]),'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($B)).'">'.lang(140).'</a>',"\n";}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(141)."</a>\n";}if(support("check")){echo"<h3 id='checks'>".lang(142)."</h3>\n";$Za=driver()->checkConstraints($a);if($Za){echo"<table>\n";foreach($Za
as$y=>$X)echo"<tr title='".h($y)."'>","<td><code class='jush-".JUSH."'>".h($X),"<td><a href='".h(ME.'check='.urlencode($a).'&name='.urlencode($y))."'>".lang(140)."</a>","\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'check='.urlencode($a).'">'.lang(143)."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(144)."</h3>\n";$jj=triggers($a);if($jj){echo"<table>\n";foreach($jj
as$y=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($y)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($y))."'>".lang(140)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(145)."</a>\n";}$je=driver()->inheritedTables($a);if($je){echo"<h3 id='partitions'>".lang(146)."</h3>\n";$zg=driver()->partitionsInfo($a);if($zg)echo"<p><code class='jush-".JUSH."'>BY ".h("$zg[partition_by]($zg[partition])")."</code>\n";tables_links($je);}}elseif(isset($_GET["schema"])){page_header(lang(69),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$Ai=array();$Bi=array();$da=($_GET["schema"]?:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$da,$cf,PREG_SET_ORDER);foreach($cf
as$t=>$A){$Ai[$A[1]]=array($A[2],$A[3]);$Bi[]="\n\t'".js_escape($A[1])."': [ $A[2], $A[3] ]";}$Yi=0;$Ia=-1;$Fh=array();$nh=array();$Oe=array();$ua=driver()->allFields();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$Ng=0;$Fh[$R]["fields"]=array();foreach($ua[$R]as$n){$Ng+=1.25;$n["pos"]=$Ng;$Fh[$R]["fields"][$n["field"]]=$n;}$Fh[$R]["pos"]=($Ai[$R]?:array($Yi,0));foreach(adminer()->foreignKeys($R)as$X){if(!$X["db"]){$Me=$Ia;if(idx($Ai[$R],1)||idx($Ai[$X["table"]],1))$Me=min(idx($Ai[$R],1,0),idx($Ai[$X["table"]],1,0))-1;else$Ia-=.1;while($Oe[(string)$Me])$Me-=.0001;$Fh[$R]["references"][$X["table"]][(string)$Me]=array($X["source"],$X["target"]);$nh[$X["table"]][$R][(string)$Me]=$X["target"];$Oe[(string)$Me]=true;}}$Yi=max($Yi,$Fh[$R]["pos"][0]+2.5+$Ng);}echo'<div id="schema" style="height: ',$Yi,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = () => false;
const tablePos = {',implode(",",$Bi)."\n",'};
const em = qs(\'#schema\').offsetHeight / ',$Yi,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($Fh
as$B=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($B).'"><b>'.h($B)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$n){$X='<span'.type_class($n["type"]).' title="'.h($n["type"].($n["length"]?"($n[length])":"").($n["null"]?" NULL":'')).'">'.h($n["field"]).'</span>';echo"<br>".($n["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$Ii=>$ph){foreach($ph
as$Me=>$kh){$Ne=$Me-idx($Ai[$B],1);$t=0;foreach($kh[0]as$ei)echo"\n<div class='references' title='".h($Ii)."' id='refs$Me-".($t++)."' style='left: $Ne"."em; top: ".$R["fields"][$ei]["pos"]."em; padding-top: .5em;'>"."<div style='border-top: 1px solid gray; width: ".(-$Ne)."em;'></div></div>";}}foreach((array)$nh[$B]as$Ii=>$ph){foreach($ph
as$Me=>$e){$Ne=$Me-idx($Ai[$B],1);$t=0;foreach($e
as$Hi)echo"\n<div class='references arrow' title='".h($Ii)."' id='refd$Me-".($t++)."' style='left: $Ne"."em; top: ".$R["fields"][$Hi]["pos"]."em;'>"."<div style='height: .5em; border-bottom: 1px solid gray; width: ".(-$Ne)."em;'></div>"."</div>";}}echo"\n</div>\n";}foreach($Fh
as$B=>$R){foreach((array)$R["references"]as$Ii=>$ph){foreach($ph
as$Me=>$kh){$sf=$Yi;$gf=-10;foreach($kh[0]as$y=>$ei){$Og=$R["pos"][0]+$R["fields"][$ei]["pos"];$Pg=$Fh[$Ii]["pos"][0]+$Fh[$Ii]["fields"][$kh[1][$y]]["pos"];$sf=min($sf,$Og,$Pg);$gf=max($gf,$Og,$Pg);}echo"<div class='references' id='refl$Me' style='left: $Me"."em; top: $sf"."em; padding: .5em 0;'><div style='border-right: 1px solid gray; margin-top: 1px; height: ".($gf-$sf)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($da)),'" id="schema-link">',lang(147),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$m){save_settings(array_intersect_key($_POST,array_flip(array("output","format","db_style","types","routines","events","table_style","auto_increment","triggers","data_style"))),"adminer_export");$T=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Qc=dump_headers((count($T)==1?key($T):DB),(DB==""||count($T)>1));$xe=preg_match('~sql~',$_POST["format"]);if($xe){echo"-- Adminer ".VERSION." ".get_driver(DRIVER)." ".str_replace("\n"," ",connection()->server_info)." dump\n\n";if(JUSH=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";connection()->query("SET time_zone = '+00:00'");connection()->query("SET sql_mode = ''");}}$ri=$_POST["db_style"];$j=array(DB);if(DB==""){$j=$_POST["databases"];if(is_string($j))$j=explode("\n",rtrim(str_replace("\r","",$j),"\n"));}foreach((array)$j
as$k){adminer()->dumpDatabase($k);if(connection()->select_db($k)){if($xe&&preg_match('~CREATE~',$ri)&&($i=get_val("SHOW CREATE DATABASE ".idf_escape($k),1))){set_utf8mb4($i);if($ri=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($k).";\n";echo"$i;\n";}if($xe){if($ri)echo
use_sql($k).";\n\n";$pg="";if($_POST["types"]){foreach(types()as$u=>$U){$Ec=type_values($u);if($Ec)$pg
.=($ri!='DROP+CREATE'?"DROP TYPE IF EXISTS ".idf_escape($U).";;\n":"")."CREATE TYPE ".idf_escape($U)." AS ENUM ($Ec);\n\n";else$pg
.="-- Could not export type $U\n\n";}}if($_POST["routines"]){foreach(routines()as$K){$B=$K["ROUTINE_NAME"];$_h=$K["ROUTINE_TYPE"];$i=create_routine($_h,array("name"=>$B)+routine($K["SPECIFIC_NAME"],$_h));set_utf8mb4($i);$pg
.=($ri!='DROP+CREATE'?"DROP $_h IF EXISTS ".idf_escape($B).";;\n":"")."$i;\n\n";}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$K){$i=remove_definer(get_val("SHOW CREATE EVENT ".idf_escape($K["Name"]),3));set_utf8mb4($i);$pg
.=($ri!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($K["Name"]).";;\n":"")."$i;;\n\n";}}echo($pg&&JUSH=='sql'?"DELIMITER ;;\n\n$pg"."DELIMITER ;\n\n":$pg);}if($_POST["table_style"]||$_POST["data_style"]){$Kj=array();foreach(table_status('',true)as$B=>$S){$R=(DB==""||in_array($B,(array)$_POST["tables"]));$Nb=(DB==""||in_array($B,(array)$_POST["data"]));if($R||$Nb){$Vi=null;if($Qc=="tar"){$Vi=new
TmpFile;ob_start(array($Vi,'write'),1e5);}adminer()->dumpTable($B,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$Kj[]=$B;elseif($Nb){$o=fields($B);adminer()->dumpData($B,$_POST["data_style"],"SELECT *".convert_fields($o,$o)." FROM ".table($B));}if($xe&&$_POST["triggers"]&&$R&&($jj=trigger_sql($B)))echo"\nDELIMITER ;;\n$jj\nDELIMITER ;\n";if($Qc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$k/")."$B.csv",$Vi);}elseif($xe)echo"\n";}}if(function_exists('Adminer\foreign_keys_sql')){foreach(table_status('',true)as$B=>$S){$R=(DB==""||in_array($B,(array)$_POST["tables"]));if($R&&!is_view($S))echo
foreign_keys_sql($B);}}foreach($Kj
as$Jj)adminer()->dumpTable($Jj,$_POST["table_style"],1);if($Qc=="tar")echo
pack("x512");}}}adminer()->dumpFooter();exit;}page_header(lang(72),$m,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table class="layout">
';$Rb=array('','USE','DROP+CREATE','CREATE');$Ci=array('','DROP+CREATE','CREATE');$Ob=array('','TRUNCATE+INSERT','INSERT');if(JUSH=="sql")$Ob[]='INSERT+UPDATE';$K=get_settings("adminer_export");if(!$K)$K=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($K["events"])){$K["routines"]=$K["events"]=($_GET["dump"]=="");$K["triggers"]=$K["table_style"];}echo"<tr><th>".lang(148)."<td>".html_radios("output",adminer()->dumpOutput(),$K["output"])."\n","<tr><th>".lang(149)."<td>".html_radios("format",adminer()->dumpFormat(),$K["format"])."\n",(JUSH=="sqlite"?"":"<tr><th>".lang(36)."<td>".html_select('db_style',$Rb,$K["db_style"]).(support("type")?checkbox("types",1,$K["types"],lang(31)):"").(support("routine")?checkbox("routines",1,$K["routines"],lang(150)):"").(support("event")?checkbox("events",1,$K["events"],lang(151)):"")),"<tr><th>".lang(124)."<td>".html_select('table_style',$Ci,$K["table_style"]).checkbox("auto_increment",1,$K["auto_increment"],lang(50)).(support("trigger")?checkbox("triggers",1,$K["triggers"],lang(144)):""),"<tr><th>".lang(152)."<td>".html_select('data_style',$Ob,$K["data_style"]),'</table>
<p><input type="submit" value="',lang(72),'">
',input_token(),'
<table>
',script("qsl('table').onclick = dumpClick;");$Tg=array();if(DB!=""){$bb=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$bb>".lang(124)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(152)."<input type='checkbox' id='check-data'$bb></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$Kj="";$Ei=tables_list();foreach($Ei
as$B=>$U){$Sg=preg_replace('~_.*~','',$B);$bb=($a==""||$a==(substr($a,-1)=="%"?"$Sg%":$B));$Wg="<tr><td>".checkbox("tables[]",$B,$bb,$B,"","block");if($U!==null&&!preg_match('~table~i',$U))$Kj
.="$Wg\n";else
echo"$Wg<td align='right'><label class='block'><span id='Rows-".h($B)."'></span>".checkbox("data[]",$B,$bb)."</label>\n";$Tg[$Sg]++;}echo$Kj;if($Ei)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(36)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$j=adminer()->databases();if($j){foreach($j
as$k){if(!information_schema($k)){$Sg=preg_replace('~_.*~','',$k);echo"<tr><td>".checkbox("databases[]",$k,$a==""||$a=="$Sg%",$k,"","block")."\n";$Tg[$Sg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$dd=true;foreach($Tg
as$y=>$X){if($y!=""&&$X>1){echo($dd?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$y%")."'>".h($y)."</a>";$dd=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(70));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(153)."</a>";$I=connection()->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$wd=$I;if(!$I)$I=connection()->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo
input_hidden("db",DB),($wd?"":input_hidden("grant")),"<table class='odds'>\n","<thead><tr><th>".lang(34)."<th>".lang(33)."<th></thead>\n";while($K=$I->fetch_assoc())echo'<tr><td>'.h($K["User"])."<td>".h($K["Host"]).'<td><a href="'.h(ME.'user='.urlencode($K["User"]).'&host='.urlencode($K["Host"])).'">'.lang(10)."</a>\n";if(!$wd||DB!="")echo"<tr><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$m&&$_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers("sql");adminer()->dumpTable("","");adminer()->dumpData("","table",$_POST["query"]);adminer()->dumpFooter();exit;}restart_session();$Md=&get_session("queries");$Ld=&$Md[DB];if(!$m&&$_POST["clear"]){$Ld=array();redirect(remove_from_uri("history"));}stop_session();page_header((isset($_GET["import"])?lang(71):lang(63)),$m);$Te='--'.(JUSH=='sql'?' ':'');if(!$m&&$_POST){$r=false;if(!isset($_GET["import"]))$H=$_POST["query"];elseif($_POST["webfile"]){$ii=adminer()->importServerPath();$r=@fopen((file_exists($ii)?$ii:"compress.zlib://$ii.gz"),"rb");$H=($r?fread($r,1e6):false);}else$H=get_file("sql_file",true,";");if(is_string($H)){if(function_exists('memory_get_usage')&&($lf=ini_bytes("memory_limit"))!="-1")@ini_set("memory_limit",max($lf,strval(2*strlen($H)+memory_get_usage()+8e6)));if($H!=""&&strlen($H)<1e6){$dh=$H.(preg_match("~;[ \t\r\n]*\$~",$H)?"":";");if(!$Ld||first(end($Ld))!=$dh){restart_session();$Ld[]=array($dh,time());set_session("queries",$Md);stop_session();}}$fi="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|$Te)[^\n]*\n?|--\r?\n)";$Zb=";";$C=0;$zc=true;$h=connect();if($h&&DB!=""){$h->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$h);}$pb=0;$Gc=array();$wg='[\'"'.(JUSH=="sql"?'`#':(JUSH=="sqlite"?'`[':(JUSH=="mssql"?'[':''))).']|/\*|'.$Te.'|$'.(JUSH=="pgsql"?'|\$[^$]*\$':'');$Zi=microtime(true);$oa=get_settings("adminer_import");$qc=adminer()->dumpFormat();unset($qc["sql"]);while($H!=""){if(!$C&&preg_match("~^$fi*+DELIMITER\\s+(\\S+)~i",$H,$A)){$Zb=preg_quote($A[1]);$H=substr($H,strlen($A[0]));}elseif(!$C&&JUSH=='pgsql'&&preg_match("~^($fi*+COPY\\s+)[^;]+\\s+FROM\\s+stdin;~i",$H,$A)){$Zb="\n\\\\\\.\r?\n";$C=strlen($A[0]);}else{preg_match("($Zb\\s*|$wg)",$H,$A,PREG_OFFSET_CAPTURE,$C);list($pd,$Ng)=$A[0];if(!$pd&&$r&&!feof($r))$H
.=fread($r,1e5);else{if(!$pd&&rtrim($H)=="")break;$C=$Ng+strlen($pd);if($pd&&!preg_match("(^$Zb)",$pd)){$Ta=driver()->hasCStyleEscapes()||(JUSH=="pgsql"&&($Ng>0&&strtolower($H[$Ng-1])=="e"));$Gg=($pd=='/*'?'\*/':($pd=='['?']':(preg_match("~^$Te|^#~",$pd)?"\n":preg_quote($pd).($Ta?'|\\\\.':''))));while(preg_match("($Gg|\$)s",$H,$A,PREG_OFFSET_CAPTURE,$C)){$Dh=$A[0][0];if(!$Dh&&$r&&!feof($r))$H
.=fread($r,1e5);else{$C=$A[0][1]+strlen($Dh);if(!$Dh||$Dh[0]!="\\")break;}}}else{$zc=false;$dh=substr($H,0,$Ng+($Zb[0]=="\n"?3:0));$pb++;$Wg="<pre id='sql-$pb'><code class='jush-".JUSH."'>".adminer()->sqlCommandQuery($dh)."</code></pre>\n";if(JUSH=="sqlite"&&preg_match("~^$fi*+ATTACH\\b~i",$dh,$A)){echo$Wg,"<p class='error'>".lang(154)."\n";$Gc[]=" <a href='#sql-$pb'>$pb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$Wg;ob_flush();flush();}$ni=microtime(true);if(connection()->multi_query($dh)&&$h&&preg_match("~^$fi*+USE\\b~i",$dh))$h->query($dh);do{$I=connection()->store_result();if(connection()->error){echo($_POST["only_errors"]?$Wg:""),"<p class='error'>".lang(155).(connection()->errno?" (".connection()->errno.")":"").": ".error()."\n";$Gc[]=" <a href='#sql-$pb'>$pb</a>";if($_POST["error_stops"])break
2;}else{$Oi=" <span class='time'>(".format_time($ni).")</span>".(strlen($dh)<1000?" <a href='".h(ME)."sql=".urlencode(trim($dh))."'>".lang(10)."</a>":"");$qa=connection()->affected_rows;$Nj=($_POST["only_errors"]?"":driver()->warnings());$Oj="warnings-$pb";if($Nj)$Oi
.=", <a href='#$Oj'>".lang(45)."</a>".script("qsl('a').onclick = partial(toggle, '$Oj');","");$Oc=null;$hg=null;$Pc="explain-$pb";if(is_object($I)){$z=$_POST["limit"];$hg=print_select_result($I,$h,array(),$z);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$If=$I->num_rows;echo"<p class='sql-footer'>".($If?($z&&$If>$z?lang(156,$z):"").lang(157,$If):""),$Oi;if($h&&preg_match("~^($fi|\\()*+SELECT\\b~i",$dh)&&($Oc=explain($h,$dh)))echo", <a href='#$Pc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Pc');","");$u="export-$pb";echo", <a href='#$u'>".lang(72)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."<span id='$u' class='hidden'>: ".html_select("output",adminer()->dumpOutput(),$oa["output"])." ".html_select("format",$qc,$oa["format"]).input_hidden("query",$dh)."<input type='submit' name='export' value='".lang(72)."'>".input_token()."</span>\n"."</form>\n";}}else{if(preg_match("~^$fi*+(CREATE|DROP|ALTER)$fi++(DATABASE|SCHEMA)\\b~i",$dh)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h(connection()->info)."'>".lang(158,$qa)."$Oi\n";}echo($Nj?"<div id='$Oj' class='hidden'>\n$Nj</div>\n":"");if($Oc){echo"<div id='$Pc' class='hidden explain'>\n";print_select_result($Oc,$h,$hg);echo"</div>\n";}}$ni=microtime(true);}while(connection()->next_result());}$H=substr($H,$C);$C=0;}}}}if($zc)echo"<p class='message'>".lang(159)."\n";elseif($_POST["only_errors"])echo"<p class='message'>".lang(160,$pb-count($Gc))," <span class='time'>(".format_time($Zi).")</span>\n";elseif($Gc&&$pb>1)echo"<p class='error'>".lang(155).": ".implode("",$Gc)."\n";}else
echo"<p class='error'>".upload_error($H)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$Mc="<input type='submit' value='".lang(161)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$dh=$_GET["sql"];if($_POST)$dh=$_POST["query"];elseif($_GET["history"]=="all")$dh=$Ld;elseif($_GET["history"]!="")$dh=idx($Ld[$_GET["history"]],0);echo"<p>";textarea("query",$dh,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>";adminer()->sqlPrintAfter();echo"$Mc\n",lang(162).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(163)."</legend><div>";$Bd=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$Bd (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$Mc":lang(164)),"</div></fieldset>\n";$Xd=adminer()->importServerPath();if($Xd)echo"<fieldset><legend>".lang(165)."</legend><div>",lang(166,"<code>".h($Xd)."$Bd</code>"),' <input type="submit" name="webfile" value="'.lang(167).'">',"</div></fieldset>\n";echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(168))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(169))."\n",input_token();if(!isset($_GET["import"])&&$Ld){print_fieldset("history",lang(170),$_GET["history"]!="");for($X=end($Ld);$X;$X=prev($Ld)){$y=key($Ld);list($dh,$Oi,$uc)=$X;echo'<a href="'.h(ME."sql=&history=$y").'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$Oi)."'>".@date("H:i:s",$Oi)."</span>"." <code class='jush-".JUSH."'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace("~^(#|$Te).*~m",'',$dh)))),80,"</code>").($uc?" <span class='time'>($uc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(171)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(172)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$o=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$o):""):where($_GET,$o));$vj=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($o
as$B=>$n){if(!isset($n["privileges"][$vj?"update":"insert"])||adminer()->fieldName($n)==""||$n["generated"])unset($o[$B]);}if($_POST&&!$m&&!isset($_GET["select"])){$Ve=$_POST["referer"];if($_POST["insert"])$Ve=($vj?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$Ve))$Ve=ME."select=".urlencode($a);$x=indexes($a);$qj=unique_array($_GET["where"],$x);$gh="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($Ve,lang(173),driver()->delete($a,$gh,$qj?0:1));else{$O=array();foreach($o
as$B=>$n){$X=process_input($n);if($X!==false&&$X!==null)$O[idf_escape($B)]=$X;}if($vj){if(!$O)redirect($Ve);queries_redirect($Ve,lang(174),driver()->update($a,$O,$gh,$qj?0:1));if(is_ajax()){page_headers();page_messages($m);exit;}}else{$I=driver()->insert($a,$O);$Le=($I?last_id($I):0);queries_redirect($Ve,lang(175,($Le?" $Le":"")),$I);}}}$K=null;if($_POST["save"])$K=(array)$_POST["fields"];elseif($Z){$M=array();foreach($o
as$B=>$n){if(isset($n["privileges"]["select"])){$ya=($_POST["clone"]&&$n["auto_increment"]?"''":convert_field($n));$M[]=($ya?"$ya AS ":"").idf_escape($B);}}$K=array();if(!support("table"))$M=array("*");if($M){$I=driver()->select($a,$M,array($Z),$M,array(),(isset($_GET["select"])?2:1));if(!$I)$m=error();else{$K=$I->fetch_assoc();if(!$K)$K=false;}if(isset($_GET["select"])&&(!$K||$I->fetch_assoc()))$K=null;}}if(!support("table")&&!$o){if(!$Z){$I=driver()->select($a,array("*"),array(),array("*"));$K=($I?$I->fetch_assoc():false);if(!$K)$K=array(driver()->primary=>"");}if($K){foreach($K
as$y=>$X){if(!$Z)$K[$y]=null;$o[$y]=array("field"=>$y,"null"=>($y!=driver()->primary),"auto_increment"=>($y==driver()->primary));}}}edit_form($a,$o,$K,$vj,$m);}elseif(isset($_GET["create"])){$a=$_GET["create"];$Ag=driver()->partitionBy;$Dg=driver()->partitionsInfo($a);$mh=referencable_primary($a);$nd=array();foreach($mh
as$zi=>$n)$nd[str_replace("`","``",$zi)."`".str_replace("`","``",$n["field"])]=$zi;$kg=array();$S=array();if($a!=""){$kg=fields($a);$S=table_status1($a);if(count($S)<2)$m=lang(9);}$K=$_POST;$K["fields"]=(array)$K["fields"];if($K["auto_increment_col"])$K["fields"][$K["auto_increment_col"]]["auto_increment"]=true;if($_POST)save_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($K["fields"])&&!$m){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(176),drop_tables(array($a)));else{$o=array();$ua=array();$zj=false;$ld=array();$jg=reset($kg);$sa=" FIRST";foreach($K["fields"]as$y=>$n){$q=$nd[$n["type"]];$kj=($q!==null?$mh[$q]:$n);if($n["field"]!=""){if(!$n["generated"])$n["default"]=null;$bh=process_field($n,$kj);$ua[]=array($n["orig"],$bh,$sa);if(!$jg||$bh!==process_field($jg,$jg)){$o[]=array($n["orig"],$bh,$sa);if($n["orig"]!=""||$sa)$zj=true;}if($q!==null)$ld[idf_escape($n["field"])]=($a!=""&&JUSH!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$nd[$n["type"]],'source'=>array($n["field"]),'target'=>array($kj["field"]),'on_delete'=>$n["on_delete"],));$sa=" AFTER ".idf_escape($n["field"]);}elseif($n["orig"]!=""){$zj=true;$o[]=array($n["orig"]);}if($n["orig"]!=""){$jg=next($kg);if(!$jg)$sa="";}}$E=array();if(in_array($K["partition_by"],$Ag)){foreach($K
as$y=>$X){if(preg_match('~^partition~',$y))$E[$y]=$X;}foreach($E["partition_names"]as$y=>$B){if($B==""){unset($E["partition_names"][$y]);unset($E["partition_values"][$y]);}}$E["partition_names"]=array_values($E["partition_names"]);$E["partition_values"]=array_values($E["partition_values"]);if($E==$Dg)$E=array();}elseif(preg_match("~partitioned~",$S["Create_options"]))$E=null;$mf=lang(177);if($a==""){cookie("adminer_engine",$K["Engine"]);$mf=lang(178);}$B=trim($K["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($B),$mf,alter_table($a,$B,(JUSH=="sqlite"&&($zj||$ld)?$ua:$o),$ld,($K["Comment"]!=$S["Comment"]?$K["Comment"]:null),($K["Engine"]&&$K["Engine"]!=$S["Engine"]?$K["Engine"]:""),($K["Collation"]&&$K["Collation"]!=$S["Collation"]?$K["Collation"]:""),($K["Auto_increment"]!=""?number($K["Auto_increment"]):""),$E));}}page_header(($a!=""?lang(43):lang(73)),$m,array("table"=>$a),h($a));if(!$_POST){$mj=driver()->types();$K=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($mj["int"])?"int":(isset($mj["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$K=$S;$K["name"]=$a;$K["fields"]=array();if(!$_GET["auto_increment"])$K["Auto_increment"]="";foreach($kg
as$n){$n["generated"]=$n["generated"]?:(isset($n["default"])?"DEFAULT":"");$K["fields"][]=$n;}if($Ag){$K+=$Dg;$K["partition_names"][]="";$K["partition_values"][]="";}}}$lb=collations();if(is_array(reset($lb)))$lb=call_user_func_array('array_merge',array_values($lb));$Ac=driver()->engines();foreach($Ac
as$_c){if(!strcasecmp($_c,$K["Engine"])){$K["Engine"]=$_c;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(179).": <input name='name'".($a==""&&!$_POST?" autofocus":"")." data-maxlength='64' value='".h($K["name"])."' autocapitalize='off'>\n",($Ac?html_select("Engine",array(""=>"(".lang(180).")")+$Ac,$K["Engine"]).on_help("event.target.value",1).script("qsl('select').onchange = helpClose;")."\n":"");if($lb)echo"<datalist id='collations'>".optionlist($lb)."</datalist>\n",(preg_match("~sqlite|mssql~",JUSH)?"":"<input list='collations' name='Collation' value='".h($K["Collation"])."' placeholder='(".lang(102).")'>\n");echo"<input type='submit' value='".lang(14)."'>\n";}if(support("columns")){echo"<div class='scrollable'>\n","<table id='edit-fields' class='nowrap'>\n";edit_fields($K["fields"],$lb,"TABLE",$nd);echo"</table>\n",script("editFields();"),"</div>\n<p>\n",lang(50).": <input type='number' name='Auto_increment' class='size' value='".h($K["Auto_increment"])."'>\n",checkbox("defaults",1,($_POST?$_POST["defaults"]:get_setting("defaults")),lang(181),"columnShow(this.checked, 5)","jsonly");$sb=($_POST?$_POST["comments"]:get_setting("comments"));echo(support("comment")?checkbox("comments",1,$sb,lang(49),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$K["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($sb?"":" class='hidden'").">".h($K["Comment"])."</textarea>":'<input name="Comment" value="'.h($K["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($sb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,$a));if($Ag&&(JUSH=='sql'||$a=="")){$Bg=preg_match('~RANGE|LIST~',$K["partition_by"]);print_fieldset("partition",lang(183),$K["partition_by"]);echo"<p>".html_select("partition_by",array_merge(array(""),$Ag),$K["partition_by"]).on_help("event.target.value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),"(<input name='partition' value='".h($K["partition"])."'>)\n",lang(146).": <input type='number' name='partitions' class='size".($Bg||!$K["partition_by"]?" hidden":"")."' value='".h($K["partitions"])."'>\n","<table id='partition-table'".($Bg?"":" class='hidden'").">\n","<thead><tr><th>".lang(184)."<th>".lang(185)."</thead>\n";foreach($K["partition_names"]as$y=>$X)echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($y==count($K["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h(idx($K["partition_values"],$y)).'">';echo"</table>\n</div></fieldset>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$fe=array("PRIMARY","UNIQUE","INDEX");$S=table_status1($a,true);$ce=driver()->indexAlgorithms($S);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$S["Engine"]))$fe[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$S["Engine"]))$fe[]="SPATIAL";$x=indexes($a);$G=array();if(JUSH=="mongo"){$G=$x["_id_"];unset($fe[0]);unset($x["_id_"]);}$K=$_POST;if($K)save_settings(array("index_options"=>$K["options"]));if($_POST&&!$m&&!$_POST["add"]&&!$_POST["drop_col"]){$b=array();foreach($K["indexes"]as$w){$B=$w["name"];if(in_array($w["type"],$fe)){$e=array();$Re=array();$cc=array();$de=(support("partial_indexes")?$w["partial"]:"");$be=(in_array($w["algorithm"],$ce)?$w["algorithm"]:"");$O=array();ksort($w["columns"]);foreach($w["columns"]as$y=>$d){if($d!=""){$Qe=idx($w["lengths"],$y);$ac=idx($w["descs"],$y);$O[]=idf_escape($d).($Qe?"(".(+$Qe).")":"").($ac?" DESC":"");$e[]=$d;$Re[]=($Qe?:null);$cc[]=$ac;}}$Nc=$x[$B];if($Nc){ksort($Nc["columns"]);ksort($Nc["lengths"]);ksort($Nc["descs"]);if($w["type"]==$Nc["type"]&&array_values($Nc["columns"])===$e&&(!$Nc["lengths"]||array_values($Nc["lengths"])===$Re)&&array_values($Nc["descs"])===$cc&&$Nc["partial"]==$de&&(!$ce||$Nc["algorithm"]==$be)){unset($x[$B]);continue;}}if($e)$b[]=array($w["type"],$B,$O,$be,$de);}}foreach($x
as$B=>$Nc)$b[]=array($Nc["type"],$B,"DROP");if(!$b)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(186),alter_indexes($a,$b));}page_header(lang(136),$m,array("table"=>$a),h($a));$o=array_keys(fields($a));if($_POST["add"]){foreach($K["indexes"]as$y=>$w){if($w["columns"][count($w["columns"])]!="")$K["indexes"][$y]["columns"][]="";}$w=end($K["indexes"]);if($w["type"]||array_filter($w["columns"],'strlen'))$K["indexes"][]=array("columns"=>array(1=>""));}if(!$K){foreach($x
as$y=>$w){$x[$y]["name"]=$y;$x[$y]["columns"][]="";}$x[]=array("columns"=>array(1=>""));$K["indexes"]=$x;}$Re=(JUSH=="sql"||JUSH=="mssql");$Zh=($_POST?$_POST["options"]:get_setting("index_options"));echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap">
<thead><tr>
<th id="label-type">',lang(187);$Vd=" class='idxopts".($Zh?"":" hidden")."'";if($ce)echo"<th id='label-algorithm'$Vd>".lang(188).doc_link(array('sql'=>'create-index.html#create-index-storage-engine-index-types','mariadb'=>'storage-engine-index-types/','pgsql'=>'indexes-types.html',));echo'<th><input type="submit" class="wayoff">',lang(189).($Re?"<span$Vd> (".lang(190).")</span>":"");if($Re||support("descidx"))echo
checkbox("options",1,$Zh,lang(108),"indexOptionsShow(this.checked)","jsonly")."\n";echo'<th id="label-name">',lang(191);if(support("partial_indexes"))echo"<th id='label-condition'$Vd>".lang(192);echo'<th><noscript>',icon("plus","add[0]","+",lang(109)),'</noscript>
</thead>
';if($G){echo"<tr><td>PRIMARY<td>";foreach($G["columns"]as$y=>$d)echo
select_input(" disabled",$o,$d),"<label><input disabled type='checkbox'>".lang(58)."</label> ";echo"<td><td>\n";}$_e=1;foreach($K["indexes"]as$w){if(!$_POST["drop_col"]||$_e!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$_e][type]",array(-1=>"")+$fe,$w["type"],($_e==count($K["indexes"])?"indexesAddRow.call(this);":""),"label-type");if($ce)echo"<td$Vd>".html_select("indexes[$_e][algorithm]",array_merge(array(""),$ce),$w['algorithm'],"label-algorithm");echo"<td>";ksort($w["columns"]);$t=1;foreach($w["columns"]as$y=>$d){echo"<span>".select_input(" name='indexes[$_e][columns][$t]' title='".lang(47)."'",($o?array_combine($o,$o):$o),$d,"partial(".($t==count($w["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape(JUSH=="sql"?"":$_GET["indexes"]."_")."')"),"<span$Vd>",($Re?"<input type='number' name='indexes[$_e][lengths][$t]' class='size' value='".h(idx($w["lengths"],$y))."' title='".lang(107)."'>":""),(support("descidx")?checkbox("indexes[$_e][descs][$t]",1,idx($w["descs"],$y),lang(58)):""),"</span> </span>";$t++;}echo"<td><input name='indexes[$_e][name]' value='".h($w["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n";if(support("partial_indexes"))echo"<td$Vd><input name='indexes[$_e][partial]' value='".h($w["partial"])."' autocapitalize='off' aria-labelledby='label-condition'>\n";echo"<td>".icon("cross","drop_col[$_e]","x",lang(112)).script("qsl('button').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$_e++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
',input_token(),'</form>
';}elseif(isset($_GET["database"])){$K=$_POST;if($_POST&&!$m&&!$_POST["add"]){$B=trim($K["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(193),drop_databases(array(DB)));}elseif(DB!==$B){if(DB!=""){$_GET["db"]=$B;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($B),lang(194),rename_database($B,$K["collation"]));}else{$j=explode("\n",str_replace("\r","",$B));$si=true;$Ke="";foreach($j
as$k){if(count($j)==1||$k!=""){if(!create_database($k,$K["collation"]))$si=false;$Ke=$k;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($Ke),lang(195),$si);}}else{if(!$K["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($B).(preg_match('~^[a-z0-9_]+$~i',$K["collation"])?" COLLATE $K[collation]":""),substr(ME,0,-1),lang(196));}}page_header(DB!=""?lang(66):lang(116),$m,array(),h(DB));$lb=collations();$B=DB;if($_POST)$B=$K["name"];elseif(DB!="")$K["collation"]=db_collation(DB,$lb);elseif(JUSH=="sql"){foreach(get_vals("SHOW GRANTS")as$wd){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$wd,$A)&&$A[1]){$B=stripcslashes(idf_unescape("`$A[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add"]||strpos($B,"\n")?'<textarea autofocus name="name" rows="10" cols="40">'.h($B).'</textarea><br>':'<input name="name" autofocus value="'.h($B).'" data-maxlength="64" autocapitalize="off">')."\n".($lb?html_select("collation",array(""=>"(".lang(102).")")+$lb,$K["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"relational-databases/system-functions/sys-fn-helpcollations-transact-sql",)):""),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(182,DB))."\n";elseif(!$_POST["add"]&&$_GET["db"]=="")echo
icon("plus","add[0]","+",lang(109))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["scheme"])){$K=$_POST;if($_POST&&!$m){$_=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$_,lang(197));else{$B=trim($K["name"]);$_
.=urlencode($B);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($B),$_,lang(198));elseif($_GET["ns"]!=$B)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($B),$_,lang(199));else
redirect($_);}}page_header($_GET["ns"]!=""?lang(67):lang(68),$m);if(!$K)$K["name"]=$_GET["ns"];echo'
<form action="" method="post">
<p><input name="name" autofocus value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($_GET["ns"]!="")echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(182,$_GET["ns"]))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["call"])){$ca=($_GET["name"]?:$_GET["call"]);page_header(lang(200).": ".h($ca),$m);$_h=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Yd=array();$pg=array();foreach($_h["fields"]as$t=>$n){if(substr($n["inout"],-3)=="OUT"&&JUSH=='sql')$pg[$t]="@".idf_escape($n["field"])." AS ".idf_escape($n["field"]);if(!$n["inout"]||substr($n["inout"],0,2)=="IN")$Yd[]=$t;}if(!$m&&$_POST){$Ua=array();foreach($_h["fields"]as$y=>$n){$X="";if(in_array($y,$Yd)){$X=process_input($n);if($X===false)$X="''";if(isset($pg[$y]))connection()->query("SET @".idf_escape($n["field"])." = $X");}if(isset($pg[$y]))$Ua[]="@".idf_escape($n["field"]);elseif(in_array($y,$Yd))$Ua[]=$X;}$H=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($ca)."(".implode(", ",$Ua).")";$ni=microtime(true);$I=connection()->multi_query($H);$qa=connection()->affected_rows;echo
adminer()->selectQuery($H,$ni,!$I);if(!$I)echo"<p class='error'>".error()."\n";else{$h=connect();if($h)$h->select_db(DB);do{$I=connection()->store_result();if(is_object($I))print_select_result($I,$h);else
echo"<p class='message'>".lang(201,$qa)." <span class='time'>".@date("H:i:s")."</span>\n";}while(connection()->next_result());if($pg)print_select_result(connection()->query("SELECT ".implode(", ",$pg)));}}echo'
<form action="" method="post">
';if($Yd){echo"<table class='layout'>\n";foreach($Yd
as$y){$n=$_h["fields"][$y];$B=$n["field"];echo"<tr><th>".adminer()->fieldName($n);$Y=idx($_POST["fields"],$B);if($Y!=""){if($n["type"]=="set")$Y=implode(",",$Y);}input($n,$Y,idx($_POST["function"],$B,""));echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(200),'">
',input_token(),'</form>

<pre>
';function
pre_tr($Dh){return
preg_replace('~^~m','<tr>',preg_replace('~\|~','<td>',preg_replace('~\|$~m',"",rtrim($Dh))));}$R='(\+--[-+]+\+\n)';$K='(\| .* \|\n)';echo
preg_replace_callback("~^$R?$K$R?($K*)$R?~m",function($A){$ed=pre_tr($A[2]);return"<table>\n".($A[1]?"<thead>$ed</thead>\n":$ed).pre_tr($A[4])."\n</table>";},preg_replace('~(\n(    -|mysql)&gt; )(.+)~',"\\1<code class='jush-sql'>\\3</code>",preg_replace('~(.+)\n---+\n~',"<b>\\1</b>\n",h($_h['comment']))));echo'</pre>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$B=$_GET["name"];$K=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){if(!$_POST["drop"]){$K["source"]=array_filter($K["source"],'strlen');ksort($K["source"]);$Hi=array();foreach($K["source"]as$y=>$X)$Hi[$y]=$K["target"][$y];$K["target"]=$Hi;}if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(" $B"=>($K["drop"]?"":" ".format_foreign_key($K))));else{$b="ALTER TABLE ".table($a);$I=($B==""||queries("$b DROP ".(JUSH=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($B)));if(!$K["drop"])$I=queries("$b ADD".format_foreign_key($K));}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(202):($B!=""?lang(203):lang(204))),$I);if(!$K["drop"])$m=lang(205);}page_header(lang(206),$m,array("table"=>$a),h($a));if($_POST){ksort($K["source"]);if($_POST["add"])$K["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$K["target"]=array();}elseif($B!=""){$nd=foreign_keys($a);$K=$nd[$B];$K["source"][]="";}else{$K["table"]=$a;$K["source"]=array("");}echo'
<form action="" method="post">
';$ei=array_keys(fields($a));if($K["db"]!="")connection()->select_db($K["db"]);if($K["ns"]!=""){$lg=get_schema();set_schema($K["ns"]);}$lh=array_keys(array_filter(table_status('',true),'Adminer\fk_support'));$Hi=array_keys(fields(in_array($K["table"],$lh)?$K["table"]:reset($lh)));$Vf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p><label>".lang(207).": ".html_select("table",$lh,$K["table"],$Vf)."</label>\n";if(support("scheme")){$Gh=array_filter(adminer()->schemas(),function($Fh){return!preg_match('~^information_schema$~i',$Fh);});echo"<label>".lang(75).": ".html_select("ns",$Gh,$K["ns"]!=""?$K["ns"]:$_GET["ns"],$Vf)."</label>";if($K["ns"]!="")set_schema($lg);}elseif(JUSH!="sqlite"){$Sb=array();foreach(adminer()->databases()as$k){if(!information_schema($k))$Sb[]=$k;}echo"<label>".lang(74).": ".html_select("db",$Sb,$K["db"]!=""?$K["db"]:$_GET["db"],$Vf)."</label>";}echo
input_hidden("change-js"),'<noscript><p><input type="submit" name="change" value="',lang(208),'"></noscript>
<table>
<thead><tr><th id="label-source">',lang(138),'<th id="label-target">',lang(139),'</thead>
';$_e=0;foreach($K["source"]as$y=>$X){echo"<tr>","<td>".html_select("source[".(+$y)."]",array(-1=>"")+$ei,$X,($_e==count($K["source"])-1?"foreignAddRow.call(this);":""),"label-source"),"<td>".html_select("target[".(+$y)."]",$Hi,idx($K["target"],$y),"","label-target");$_e++;}echo'</table>
<p>
<label>',lang(104),': ',html_select("on_delete",array(-1=>"")+explode("|",driver()->onActions),$K["on_delete"]),'</label>
<label>',lang(103),': ',html_select("on_update",array(-1=>"")+explode("|",driver()->onActions),$K["on_update"]),'</label>
',doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"t-sql/statements/create-table-transact-sql",'oracle'=>"SQLRF01111",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(209),'"></noscript>
';if($B!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$K=$_POST;$mg="VIEW";if(JUSH=="pgsql"&&$a!=""){$P=table_status1($a);$mg=strtoupper($P["Engine"]);}if($_POST&&!$m){$B=trim($K["name"]);$ya=" AS\n$K[select]";$Ve=ME."table=".urlencode($B);$mf=lang(210);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$B&&JUSH!="sqlite"&&$U=="VIEW"&&$mg=="VIEW")query_redirect((JUSH=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($B).$ya,$Ve,$mf);else{$Ji=$B."_adminer_".uniqid();drop_create("DROP $mg ".table($a),"CREATE $U ".table($B).$ya,"DROP $U ".table($B),"CREATE $U ".table($Ji).$ya,"DROP $U ".table($Ji),($_POST["drop"]?substr(ME,0,-1):$Ve),lang(211),$mf,lang(212),$a,$B);}}if(!$_POST&&$a!=""){$K=view($a);$K["name"]=$a;$K["materialized"]=($mg!="VIEW");if(!$m)$m=error();}page_header(($a!=""?lang(42):lang(213)),$m,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(191),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$K["materialized"],lang(132)):""),'<p>';textarea("select",$K["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,$a));echo
input_token(),'</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$re=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$oi=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$K=$_POST;if($_POST&&!$m){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(214));elseif(in_array($K["INTERVAL_FIELD"],$re)&&isset($oi[$K["STATUS"]])){$Eh="\nON SCHEDULE ".($K["INTERVAL_VALUE"]?"EVERY ".q($K["INTERVAL_VALUE"])." $K[INTERVAL_FIELD]".($K["STARTS"]?" STARTS ".q($K["STARTS"]):"").($K["ENDS"]?" ENDS ".q($K["ENDS"]):""):"AT ".q($K["STARTS"]))." ON COMPLETION".($K["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(215):lang(216)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$Eh.($aa!=$K["EVENT_NAME"]?"\nRENAME TO ".idf_escape($K["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($K["EVENT_NAME"]).$Eh)."\n".$oi[$K["STATUS"]]." COMMENT ".q($K["EVENT_COMMENT"]).rtrim(" DO\n$K[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(217).": ".h($aa):lang(218)),$m);if(!$K&&$aa!=""){$L=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$K=reset($L);}echo'
<form action="" method="post">
<table class="layout">
<tr><th>',lang(191),'<td><input name="EVENT_NAME" value="',h($K["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(219),'<td><input name="STARTS" value="',h("$K[EXECUTE_AT]$K[STARTS]"),'">
<tr><th title="datetime">',lang(220),'<td><input name="ENDS" value="',h($K["ENDS"]),'">
<tr><th>',lang(221),'<td><input type="number" name="INTERVAL_VALUE" value="',h($K["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$re,$K["INTERVAL_FIELD"]),'<tr><th>',lang(119),'<td>',html_select("STATUS",$oi,$K["STATUS"]),'<tr><th>',lang(49),'<td><input name="EVENT_COMMENT" value="',h($K["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$K["ON_COMPLETION"]=="PRESERVE",lang(222)),'</table>
<p>';textarea("EVENT_DEFINITION",$K["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,$aa));echo
input_token(),'</form>
';}elseif(isset($_GET["procedure"])){$ca=($_GET["name"]?:$_GET["procedure"]);$_h=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$K=$_POST;$K["fields"]=(array)$K["fields"];if($_POST&&!process_fields($K["fields"])&&!$m){$ig=routine($_GET["procedure"],$_h);$Ji="$K[name]_adminer_".uniqid();foreach($K["fields"]as$y=>$n){if($n["field"]=="")unset($K["fields"][$y]);}drop_create("DROP $_h ".routine_id($ca,$ig),create_routine($_h,$K),"DROP $_h ".routine_id($K["name"],$K),create_routine($_h,array("name"=>$Ji)+$K),"DROP $_h ".routine_id($Ji,$K),substr(ME,0,-1),lang(223),lang(224),lang(225),$ca,$K["name"]);}page_header(($ca!=""?(isset($_GET["function"])?lang(226):lang(227)).": ".h($ca):(isset($_GET["function"])?lang(228):lang(229))),$m);if(!$_POST){if($ca=="")$K["language"]="sql";else{$K=routine($_GET["procedure"],$_h);$K["name"]=$ca;}}$lb=get_vals("SHOW CHARACTER SET");sort($lb);$Ah=routine_languages();echo($lb?"<datalist id='collations'>".optionlist($lb)."</datalist>":""),'
<form action="" method="post" id="form">
<p>',lang(191),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',($Ah?"<label>".lang(19).": ".html_select("language",$Ah,$K["language"])."</label>\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table class="nowrap">
';edit_fields($K["fields"],$lb,$_h);if(isset($_GET["function"])){echo"<tr><td>".lang(230);edit_type("returns",(array)$K["returns"],$lb,array(),(JUSH=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$K["definition"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($ca!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,$ca));echo
input_token(),'</form>
';}elseif(isset($_GET["sequence"])){$ea=$_GET["sequence"];$K=$_POST;if($_POST&&!$m){$_=substr(ME,0,-1);$B=trim($K["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($ea),$_,lang(231));elseif($ea=="")query_redirect("CREATE SEQUENCE ".idf_escape($B),$_,lang(232));elseif($ea!=$B)query_redirect("ALTER SEQUENCE ".idf_escape($ea)." RENAME TO ".idf_escape($B),$_,lang(233));else
redirect($_);}page_header($ea!=""?lang(234).": ".h($ea):lang(235),$m);if(!$K)$K["name"]=$ea;echo'
<form action="" method="post">
<p><input name="name" value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($ea!="")echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(182,$ea))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["type"])){$fa=$_GET["type"];$K=$_POST;if($_POST&&!$m){$_=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($fa),$_,lang(236));else
query_redirect("CREATE TYPE ".idf_escape(trim($K["name"]))." $K[as]",$_,lang(237));}page_header($fa!=""?lang(238).": ".h($fa):lang(239),$m);if(!$K)$K["as"]="AS ";echo'
<form action="" method="post">
<p>
';if($fa!=""){$mj=driver()->types();$Ec=type_values($mj[$fa]);if($Ec)echo"<code class='jush-".JUSH."'>ENUM (".h($Ec).")</code>\n<p>";echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(182,$fa))."\n";}else{echo
lang(191).": <input name='name' value='".h($K['name'])."' autocapitalize='off'>\n",doc_link(array('pgsql'=>"datatype-enum.html",),"?");textarea("as",$K["as"]);echo"<p><input type='submit' value='".lang(14)."'>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["check"])){$a=$_GET["check"];$B=$_GET["name"];$K=$_POST;if($K&&!$m){if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(),"",array(),"$B",($K["drop"]?"":$K["clause"]));else{$I=($B==""||queries("ALTER TABLE ".table($a)." DROP CONSTRAINT ".idf_escape($B)));if(!$K["drop"])$I=queries("ALTER TABLE ".table($a)." ADD".($K["name"]!=""?" CONSTRAINT ".idf_escape($K["name"]):"")." CHECK ($K[clause])");}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(240):($B!=""?lang(241):lang(242))),$I);}page_header(($B!=""?lang(243).": ".h($B):lang(143)),$m,array("table"=>$a));if(!$K){$cb=driver()->checkConstraints($a);$K=array("name"=>$B,"clause"=>$cb[$B]);}echo'
<form action="" method="post">
<p>';if(JUSH!="sqlite")echo
lang(191).': <input name="name" value="'.h($K["name"]).'" data-maxlength="64" autocapitalize="off"> ';echo
doc_link(array('sql'=>"create-table-check-constraints.html",'mariadb'=>"constraint/",'pgsql'=>"ddl-constraints.html#DDL-CONSTRAINTS-CHECK-CONSTRAINTS",'mssql'=>"relational-databases/tables/create-check-constraints",'sqlite'=>"lang_createtable.html#check_constraints",),"?"),'<p>';textarea("clause",$K["clause"]);echo'<p><input type="submit" value="',lang(14),'">
';if($B!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$B="$_GET[name]";$ij=trigger_options();$K=(array)trigger($B,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$m&&in_array($_POST["Timing"],$ij["Timing"])&&in_array($_POST["Event"],$ij["Event"])&&in_array($_POST["Type"],$ij["Type"])){$Sf=" ON ".table($a);$kc="DROP TRIGGER ".idf_escape($B).(JUSH=="pgsql"?$Sf:"");$Ve=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($kc,$Ve,lang(244));else{if($B!="")queries($kc);queries_redirect($Ve,($B!=""?lang(245):lang(246)),queries(create_trigger($Sf,$_POST)));if($B!="")queries(create_trigger($Sf,$K+array("Type"=>reset($ij["Type"]))));}}$K=$_POST;}page_header(($B!=""?lang(247).": ".h($B):lang(248)),$m,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table class="layout">
<tr><th>',lang(249),'<td>',html_select("Timing",$ij["Timing"],$K["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(250),'<td>',html_select("Event",$ij["Event"],$K["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$ij["Event"])?" <input name='Of' value='".h($K["Of"])."' class='hidden'>":""),'<tr><th>',lang(48),'<td>',html_select("Type",$ij["Type"],$K["Type"]),'</table>
<p>',lang(191),': <input name="Trigger" value="',h($K["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$K["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($B!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["user"])){$ga=$_GET["user"];$Zg=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$K){foreach(explode(",",($K["Privilege"]=="Grant option"?"":$K["Context"]))as$Bb)$Zg[$Bb][$K["Privilege"]]=$K["Comment"];}$Zg["Server Admin"]+=$Zg["File access on server"];$Zg["Databases"]["Create routine"]=$Zg["Procedures"]["Create routine"];unset($Zg["Procedures"]["Create routine"]);$Zg["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$Zg["Columns"][$X]=$Zg["Tables"][$X];unset($Zg["Server Admin"]["Usage"]);foreach($Zg["Tables"]as$y=>$X)unset($Zg["Databases"][$y]);$Af=array();if($_POST){foreach($_POST["objects"]as$y=>$X)$Af[$X]=(array)$Af[$X]+idx($_POST["grants"],$y,array());}$xd=array();$Qf="";if(isset($_GET["host"])&&($I=connection()->query("SHOW GRANTS FOR ".q($ga)."@".q($_GET["host"])))){while($K=$I->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$K[0],$A)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$A[1],$cf,PREG_SET_ORDER)){foreach($cf
as$X){if($X[1]!="USAGE")$xd["$A[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$K[0]))$xd["$A[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$K[0],$A))$Qf=$A[1];}}if($_POST&&!$m){$Rf=(isset($_GET["host"])?q($ga)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $Rf",ME."privileges=",lang(251));else{$Cf=q($_POST["user"])."@".q($_POST["host"]);$Eg=$_POST["pass"];if($Eg!=''&&!$_POST["hashed"]&&!min_version(8)){$Eg=get_val("SELECT PASSWORD(".q($Eg).")");$m=!$Eg;}$Gb=false;if(!$m){if($Rf!=$Cf){$Gb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $Cf IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($Eg));$m=!$Gb;}elseif($Eg!=$Qf)queries("SET PASSWORD FOR $Cf = ".q($Eg));}if(!$m){$xh=array();foreach($Af
as$Kf=>$wd){if(isset($_GET["grant"]))$wd=array_filter($wd);$wd=array_keys($wd);if(isset($_GET["grant"]))$xh=array_diff(array_keys(array_filter($Af[$Kf],'strlen')),$wd);elseif($Rf==$Cf){$Of=array_keys((array)$xd[$Kf]);$xh=array_diff($Of,$wd);$wd=array_diff($wd,$Of);unset($xd[$Kf]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$Kf,$A)&&(!grant("REVOKE",$xh,$A[2]," ON $A[1] FROM $Cf")||!grant("GRANT",$wd,$A[2]," ON $A[1] TO $Cf"))){$m=true;break;}}}if(!$m&&isset($_GET["host"])){if($Rf!=$Cf)queries("DROP USER $Rf");elseif(!isset($_GET["grant"])){foreach($xd
as$Kf=>$xh){if(preg_match('~^(.+)(\(.*\))?$~U',$Kf,$A))grant("REVOKE",array_keys($xh),$A[2]," ON $A[1] FROM $Cf");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(252):lang(253)),!$m);if($Gb)connection()->query("DROP USER $Cf");}}page_header((isset($_GET["host"])?lang(34).": ".h("$ga@$_GET[host]"):lang(153)),$m,array("privileges"=>array('',lang(70))));$K=$_POST;if($K)$xd=$Af;else{$K=$_GET+array("host"=>get_val("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$K["pass"]=$Qf;if($Qf!="")$K["hashed"]=true;$xd[(DB==""||$xd?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table class="layout">
<tr><th>',lang(33),'<td><input name="host" data-maxlength="60" value="',h($K["host"]),'" autocapitalize="off">
<tr><th>',lang(34),'<td><input name="user" data-maxlength="80" value="',h($K["user"]),'" autocapitalize="off">
<tr><th>',lang(35),'<td><input name="pass" id="pass" value="',h($K["pass"]),'" autocomplete="new-password">
',($K["hashed"]?"":script("typePassword(qs('#pass'));")),(min_version(8)?"":checkbox("hashed",1,$K["hashed"],lang(254),"typePassword(this.form['pass'], this.checked);")),'</table>

',"<table class='odds'>\n","<thead><tr><th colspan='2'>".lang(70).doc_link(array('sql'=>"grant.html#priv_level"));$t=0;foreach($xd
as$Kf=>$wd){echo'<th>'.($Kf!="*.*"?"<input name='objects[$t]' value='".h($Kf)."' size='10' autocapitalize='off'>":input_hidden("objects[$t]","*.*")."*.*");$t++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(33),"Databases"=>lang(36),"Tables"=>lang(134),"Columns"=>lang(47),"Procedures"=>lang(255),)as$Bb=>$ac){foreach((array)$Zg[$Bb]as$Yg=>$qb){echo"<tr><td".($ac?">$ac<td":" colspan='2'").' lang="en" title="'.h($qb).'">'.h($Yg);$t=0;foreach($xd
as$Kf=>$wd){$B="'grants[$t][".h(strtoupper($Yg))."]'";$Y=$wd[strtoupper($Yg)];if($Bb=="Server Admin"&&$Kf!=(isset($xd["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$B><option><option value='1'".($Y?" selected":"").">".lang(256)."<option value='0'".($Y=="0"?" selected":"").">".lang(257)."</select>";else
echo"<td align='center'><label class='block'>","<input type='checkbox' name=$B value='1'".($Y?" checked":"").($Yg=="All privileges"?" id='grants-$t-all'>":">".($Yg=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$t-all'); };"))),"</label>";$t++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"]))echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,"$ga@$_GET[host]"));echo
input_token(),'</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$m){$Fe=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$Fe++;}queries_redirect(ME."processlist=",lang(258,$Fe),$Fe||!$_POST["kill"]);}}page_header(lang(117),$m);echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap checkable odds">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$t=-1;foreach(process_list()as$t=>$K){if(!$t){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($K
as$y=>$X)echo"<th>$y".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($y),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"REFRN30223",));echo"</thead>\n";}echo"<tr>".(support("kill")?"<td>".checkbox("kill[]",$K[JUSH=="sql"?"Id":"pid"],0):"");foreach($K
as$y=>$X)echo"<td>".((JUSH=="sql"&&$y=="Info"&&preg_match("~Query|Killed~",$K["Command"])&&$X!="")||(JUSH=="pgsql"&&$y=="current_query"&&$X!="<IDLE>")||(JUSH=="oracle"&&$y=="sql_text"&&$X!="")?"<code class='jush-".JUSH."'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($K["db"]!=""?"db=".urlencode($K["db"])."&":"")."sql=".urlencode($X)).'">'.lang(259).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill"))echo($t+1)."/".lang(260,max_connections()),"<p><input type='submit' value='".lang(261)."'>\n";echo
input_token(),'</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$x=indexes($a);$o=fields($a);$nd=column_foreign_keys($a);$Mf=$S["Oid"];$pa=get_settings("adminer_import");$yh=array();$e=array();$Kh=array();$eg=array();$Ni="";foreach($o
as$y=>$n){$B=adminer()->fieldName($n);$zf=html_entity_decode(strip_tags($B),ENT_QUOTES);if(isset($n["privileges"]["select"])&&$B!=""){$e[$y]=$zf;if(is_shortable($n))$Ni=adminer()->selectLengthProcess();}if(isset($n["privileges"]["where"])&&$B!="")$Kh[$y]=$zf;if(isset($n["privileges"]["order"])&&$B!="")$eg[$y]=$zf;$yh+=$n["privileges"];}list($M,$yd)=adminer()->selectColumnsProcess($e,$x);$M=array_unique($M);$yd=array_unique($yd);$ve=count($yd)<count($M);$Z=adminer()->selectSearchProcess($o,$x);$dg=adminer()->selectOrderProcess($o,$x);$z=adminer()->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$rj=>$K){$ya=convert_field($o[key($K)]);$M=array($ya?:idf_escape(key($K)));$Z[]=where_check($rj,$o);$J=driver()->select($a,$M,$Z,$M);if($J)echo
first($J->fetch_row());}exit;}$G=$tj=array();foreach($x
as$w){if($w["type"]=="PRIMARY"){$G=array_flip($w["columns"]);$tj=($M?$G:array());foreach($tj
as$y=>$X){if(in_array(idf_escape($y),$M))unset($tj[$y]);}break;}}if($Mf&&!$G){$G=$tj=array($Mf=>0);$x[]=array("type"=>"PRIMARY","columns"=>array($Mf));}if($_POST&&!$m){$Qj=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$cb=array();foreach($_POST["check"]as$Ya)$cb[]=where_check($Ya,$o);$Qj[]="((".implode(") OR (",$cb)."))";}$Qj=($Qj?"\nWHERE ".implode(" AND ",$Qj):"");if($_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers($a);adminer()->dumpTable($a,"");$rd=($M?implode(", ",$M):"*").convert_fields($e,$o,$M)."\nFROM ".table($a);$_d=($yd&&$ve?"\nGROUP BY ".implode(", ",$yd):"").($dg?"\nORDER BY ".implode(", ",$dg):"");$H="SELECT $rd$Qj$_d";if(is_array($_POST["check"])&&!$G){$pj=array();foreach($_POST["check"]as$X)$pj[]="(SELECT".limit($rd,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o).$_d,1).")";$H=implode(" UNION ALL ",$pj);}adminer()->dumpData($a,"table",$H);adminer()->dumpFooter();exit;}if(!adminer()->selectEmailProcess($Z,$nd)){if($_POST["save"]||$_POST["delete"]){$I=true;$qa=0;$O=array();if(!$_POST["delete"]){foreach($_POST["fields"]as$B=>$X){$X=process_input($o[$B]);if($X!==null&&($_POST["clone"]||$X!==false))$O[idf_escape($B)]=($X!==false?$X:idf_escape($B));}}if($_POST["delete"]||$O){$H=($_POST["clone"]?"INTO ".table($a)." (".implode(", ",array_keys($O)).")\nSELECT ".implode(", ",$O)."\nFROM ".table($a):"");if($_POST["all"]||($G&&is_array($_POST["check"]))||$ve){$I=($_POST["delete"]?driver()->delete($a,$Qj):($_POST["clone"]?queries("INSERT $H$Qj".driver()->insertReturning($a)):driver()->update($a,$O,$Qj)));$qa=connection()->affected_rows;if(is_object($I))$qa+=$I->num_rows;}else{foreach((array)$_POST["check"]as$X){$Pj="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o);$I=($_POST["delete"]?driver()->delete($a,$Pj,1):($_POST["clone"]?queries("INSERT".limit1($a,$H,$Pj)):driver()->update($a,$O,$Pj,1)));if(!$I)break;$qa+=connection()->affected_rows;}}}$mf=lang(262,$qa);if($_POST["clone"]&&$I&&$qa==1){$Le=last_id($I);if($Le)$mf=lang(175," $Le");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$mf,$I);if(!$_POST["delete"]){$Qg=(array)$_POST["fields"];edit_form($a,array_intersect_key($o,$Qg),$Qg,!$_POST["clone"],$m);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$m=lang(263);else{$I=true;$qa=0;foreach($_POST["val"]as$rj=>$K){$O=array();foreach($K
as$y=>$X){$y=bracket_escape($y,true);$O[idf_escape($y)]=(preg_match('~char|text~',$o[$y]["type"])||$X!=""?adminer()->processInput($o[$y],$X):"NULL");}$I=driver()->update($a,$O," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($rj,$o),($ve||$G?0:1)," ");if(!$I)break;$qa+=connection()->affected_rows;}queries_redirect(remove_from_uri(),lang(262,$qa),$I);}}elseif(!is_string($bd=get_file("csv_file",true)))$m=upload_error($bd);elseif(!preg_match('~~u',$bd))$m=lang(264);else{save_settings(array("output"=>$pa["output"],"format"=>$_POST["separator"]),"adminer_import");$I=true;$mb=array_keys($o);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$bd,$cf);$qa=count($cf[0]);driver()->begin();$Qh=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$L=array();foreach($cf[0]as$y=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$Qh]*)$Qh~",$X.$Qh,$df);if(!$y&&!array_diff($df[1],$mb)){$mb=$df[1];$qa--;}else{$O=array();foreach($df[1]as$t=>$jb)$O[idf_escape($mb[$t])]=($jb==""&&$o[$mb[$t]]["null"]?"NULL":q(preg_match('~^".*"$~s',$jb)?str_replace('""','"',substr($jb,1,-1)):$jb));$L[]=$O;}}$I=(!$L||driver()->insertUpdate($a,$L,$G));if($I)driver()->commit();queries_redirect(remove_from_uri("page"),lang(265,$qa),$I);driver()->rollback();}}}$zi=adminer()->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(52).": $zi",$m);$O=null;if(isset($yh["insert"])||!support("table")){$vg=array();foreach((array)$_GET["where"]as$X){if(isset($nd[$X["col"]])&&count($nd[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&(is_array($X["val"])||!preg_match('~[_%]~',$X["val"])))))$vg["set"."[".bracket_escape($X["col"])."]"]=$X["val"];}$O=$vg?"&".http_build_query($vg):"";}adminer()->selectLinks($S,$O);if(!$e&&support("table"))echo"<p class='error'>".lang(266).($o?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?input_hidden("db",DB).(isset($_GET["ns"])?input_hidden("ns",$_GET["ns"]):""):""),input_hidden("select",$a),"</div>\n";adminer()->selectColumnsPrint($M,$e);adminer()->selectSearchPrint($Z,$Kh,$x);adminer()->selectOrderPrint($dg,$eg,$x);adminer()->selectLimitPrint($z);adminer()->selectLengthPrint($Ni);adminer()->selectActionPrint($x);echo"</form>\n";$D=$_GET["page"];$qd=null;if($D=="last"){$qd=get_val(count_rows($a,$Z,$ve,$yd));$D=floor(max(0,intval($qd)-1)/$z);}$Lh=$M;$zd=$yd;if(!$Lh){$Lh[]="*";$Cb=convert_fields($e,$o,$M);if($Cb)$Lh[]=substr($Cb,2);}foreach($M
as$y=>$X){$n=$o[idf_unescape($X)];if($n&&($ya=convert_field($n)))$Lh[$y]="$ya AS $X";}if(!$ve&&$tj){foreach($tj
as$y=>$X){$Lh[]=idf_escape($y);if($zd)$zd[]=idf_escape($y);}}$I=driver()->select($a,$Lh,$Z,$zd,$dg,$z,$D,true);if(!$I)echo"<p class='error'>".error()."\n";else{if(JUSH=="mssql"&&$D)$I->seek($z*$D);$yc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$L=array();while($K=$I->fetch_assoc()){if($D&&JUSH=="oracle")unset($K["RNUM"]);$L[]=$K;}if($_GET["page"]!="last"&&$z&&$yd&&$ve&&JUSH=="sql")$qd=get_val(" SELECT FOUND_ROWS()");if(!$L)echo"<p class='message'>".lang(12)."\n";else{$Ga=adminer()->backwardKeys($a,$zi);echo"<div class='scrollable'>","<table id='table' class='nowrap checkable odds'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$yd&&$M?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(267)."</a>");$_f=array();$td=array();reset($M);$ih=1;foreach($L[0]as$y=>$X){if(!isset($tj[$y])){$X=idx($_GET["columns"],key($M))?:array();$n=$o[$M?($X?$X["col"]:current($M)):$y];$B=($n?adminer()->fieldName($n,$ih):($X["fun"]?"*":h($y)));if($B!=""){$ih++;$_f[$y]=$B;$d=idf_escape($y);$Pd=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($y);$ac="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($y))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});","");$sd=apply_sql_function($X["fun"],$B);$di=isset($n["privileges"]["order"])||$sd;echo($di?"<a href='".h($Pd.($dg[0]==$d||$dg[0]==$y||(!$dg&&$ve&&$yd[0]==$d)?$ac:''))."'>$sd</a>":$sd),"<span class='column hidden'>";if($di)echo"<a href='".h($Pd.$ac)."' title='".lang(58)."' class='text'> ↓</a>";if(!$X["fun"]&&isset($n["privileges"]["where"]))echo'<a href="#fieldset-search" title="'.lang(55).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($y)."');");echo"</span>";}$td[$y]=$X["fun"];next($M);}}$Re=array();if($_GET["modify"]){foreach($L
as$K){foreach($K
as$y=>$X)$Re[$y]=max($Re[$y],min(40,strlen(utf8_decode($X))));}}echo($Ga?"<th>".lang(268):"")."</thead>\n";if(is_ajax())ob_end_clean();foreach(adminer()->rowDescriptions($L,$nd)as$yf=>$K){$qj=unique_array($L[$yf],$x);if(!$qj){$qj=array();reset($M);foreach($L[$yf]as$y=>$X){if(!preg_match('~^(COUNT|AVG|GROUP_CONCAT|MAX|MIN|SUM)\(~',current($M)))$qj[$y]=$X;next($M);}}$rj="";foreach($qj
as$y=>$X){$n=(array)$o[$y];if((JUSH=="sql"||JUSH=="pgsql")&&preg_match('~char|text|enum|set~',$n["type"])&&strlen($X)>64){$y=(strpos($y,'(')?$y:idf_escape($y));$y="MD5(".(JUSH!='sql'||preg_match("~^utf8~",$n["collation"])?$y:"CONVERT($y USING ".charset(connection()).")").")";$X=md5($X);}$rj
.="&".($X!==null?urlencode("where[".bracket_escape($y)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($y));}echo"<tr>".(!$yd&&$M?"":"<td>".checkbox("check[]",substr($rj,1),in_array(substr($rj,1),(array)$_POST["check"])).($ve||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$rj)."' class='edit'>".lang(269)."</a>"));reset($M);foreach($K
as$y=>$X){if(isset($_f[$y])){$d=current($M);$n=(array)$o[$y];$X=driver()->value($X,$n);if($X!=""&&(!isset($yc[$y])||$yc[$y]!=""))$yc[$y]=(is_mail($X)?$_f[$y]:"");$_="";if(preg_match('~blob|bytea|raw|file~',$n["type"])&&$X!="")$_=ME.'download='.urlencode($a).'&field='.urlencode($y).$rj;if(!$_&&$X!==null){foreach((array)$nd[$y]as$q){if(count($nd[$y])==1||end($q["source"])==$y){$_="";foreach($q["source"]as$t=>$ei)$_
.=where_link($t,$q["target"][$t],$L[$yf][$ei]);$_=($q["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($q["db"]),ME):ME).'select='.urlencode($q["table"]).$_;if($q["ns"])$_=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($q["ns"]),$_);if(count($q["source"])==1)break;}}}if($d=="COUNT(*)"){$_=ME."select=".urlencode($a);$t=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$qj))$_
.=where_link($t++,$W["col"],$W["val"],$W["op"]);}foreach($qj
as$Be=>$W)$_
.=where_link($t++,$Be,$W);}$Qd=select_value($X,$_,$n,$Ni);$u=h("val[$rj][".bracket_escape($y)."]");$Rg=idx(idx($_POST["val"],$rj),bracket_escape($y));$tc=!is_array($K[$y])&&is_utf8($Qd)&&$L[$yf][$y]==$K[$y]&&!$td[$y]&&!$n["generated"];$U=(preg_match('~^(AVG|MIN|MAX)\((.+)\)~',$d,$A)?$o[idf_unescape($A[2])]["type"]:$n["type"]);$Li=preg_match('~text|json|lob~',$U);$we=preg_match(number_type(),$U)||preg_match('~^(CHAR_LENGTH|ROUND|FLOOR|CEIL|TIME_TO_SEC|COUNT|SUM)\(~',$d);echo"<td id='$u'".($we&&($X===null||is_numeric(strip_tags($Qd))||$U=="money")?" class='number'":"");if(($_GET["modify"]&&$tc&&$X!==null)||$Rg!==null){$Cd=h($Rg!==null?$Rg:$K[$y]);echo">".($Li?"<textarea name='$u' cols='30' rows='".(substr_count($K[$y],"\n")+1)."'>$Cd</textarea>":"<input name='$u' value='$Cd' size='$Re[$y]'>");}else{$Xe=strpos($Qd,"<i>…</i>");echo" data-text='".($Xe?2:($Li?1:0))."'".($tc?"":" data-warning='".h(lang(270))."'").">$Qd";}}next($M);}if($Ga)echo"<td>";adminer()->backwardKeysPrint($Ga,$L[$yf]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($L||$D){$Lc=true;if($_GET["page"]!="last"){if(!$z||(count($L)<$z&&($L||!$D)))$qd=($D?$D*$z:0)+count($L);elseif(JUSH!="sql"||!$ve){$qd=($ve?false:found_rows($S,$Z));if(intval($qd)<max(1e4,2*($D+1)*$z))$qd=first(slow_query(count_rows($a,$Z,$ve,$yd)));else$Lc=false;}}$tg=($z&&($qd===false||$qd>$z||$D));if($tg)echo(($qd===false?count($L)+1:$qd-$D*$z)>$z?'<p><a href="'.h(remove_from_uri("page")."&page=".($D+1)).'" class="loadmore">'.lang(271).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, $z, '".lang(272)."…');",""):''),"\n";echo"<div class='footer'><div>\n";if($tg){$ff=($qd===false?$D+(count($L)>=$z?2:1):floor(($qd-1)/$z));echo"<fieldset>";if(JUSH!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(273)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(273)."', '".($D+1)."')); return false; };"),pagination(0,$D).($D>5?" …":"");for($t=max(1,$D-4);$t<min($ff,$D+5);$t++)echo
pagination($t,$D);if($ff>0)echo($D+5<$ff?" …":""),($Lc&&$qd!==false?pagination($ff,$D):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$ff'>".lang(274)."</a>");}else
echo"<legend>".lang(273)."</legend>",pagination(0,$D).($D>1?" …":""),($D?pagination($D,$D):""),($ff>$D?pagination($D+1,$D).($ff>$D+1?" …":""):"");echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(275)."</legend>";$hc=($Lc?"":"~ ").$qd;$Wf="const checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$hc' : checked); selectCount('selected2', this.checked || !checked ? '$hc' : checked);";echo
checkbox("all",1,0,($qd!==false?($Lc?"":"~ ").lang(157,$qd):""),$Wf)."\n","</fieldset>\n";if(adminer()->selectCommandPrint())echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(267),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(263).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(127),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(259),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';$od=adminer()->dumpFormat();foreach((array)$_GET["columns"]as$d){if($d["fun"]){unset($od['sql']);break;}}if($od){print_fieldset("export",lang(72)." <span id='selected2'></span>");$qg=adminer()->dumpOutput();echo($qg?html_select("output",$qg,$pa["output"])." ":""),html_select("format",$od,$pa["format"])," <input type='submit' name='export' value='".lang(72)."'>\n","</div></fieldset>\n";}adminer()->selectEmailPrint(array_filter($yc,'strlen'),$e);echo"</div></div>\n";}if(adminer()->selectImportPrint())echo"<p>","<a href='#import'>".lang(71)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import'".($_POST["import"]?"":" class='hidden'").">: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$pa["format"])," <input type='submit' name='import' value='".lang(71)."'>","</span>";echo
input_token(),"</form>\n",(!$yd&&$M?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$P=isset($_GET["status"]);page_header($P?lang(119):lang(118));$Gj=($P?show_status():show_variables());if(!$Gj)echo"<p class='message'>".lang(12)."\n";else{echo"<table>\n";foreach($Gj
as$K){echo"<tr>";$y=array_shift($K);echo"<th><code class='jush-".JUSH.($P?"status":"set")."'>".h($y)."</code>";foreach($K
as$X)echo"<td>".nl_br(h($X));}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$vi=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$B=>$S){json_row("Comment-$B",h($S["Comment"]));if(!is_view($S)){foreach(array("Engine","Collation")as$y)json_row("$y-$B",h($S[$y]));foreach($vi+array("Auto_increment"=>0,"Rows"=>0)as$y=>$X){if($S[$y]!=""){$X=format_number($S[$y]);if($X>=0)json_row("$y-$B",($y=="Rows"&&$X&&$S["Engine"]==(JUSH=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($vi[$y]))$vi[$y]+=($S["Engine"]!="InnoDB"||$y!="Data_free"?$S[$y]:0);}elseif(array_key_exists($y,$S))json_row("$y-$B","?");}}}foreach($vi
as$y=>$X)json_row("sum-$y",format_number($X));json_row("");}elseif($_GET["script"]=="kill")connection()->query("KILL ".number($_POST["kill"]));else{foreach(count_tables(adminer()->databases())as$k=>$X){json_row("tables-$k",$X);json_row("size-$k",db_size($k));}json_row("");}exit;}else{$Fi=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($Fi&&!$m&&!$_POST["search"]){$I=true;$mf="";if(JUSH=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$I=truncate_tables($_POST["tables"]);$mf=lang(276);}elseif($_POST["move"]){$I=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$mf=lang(277);}elseif($_POST["copy"]){$I=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$mf=lang(278);}elseif($_POST["drop"]){if($_POST["views"])$I=drop_views($_POST["views"]);if($I&&$_POST["tables"])$I=drop_tables($_POST["tables"]);$mf=lang(279);}elseif(JUSH=="sqlite"&&$_POST["check"]){foreach((array)$_POST["tables"]as$R){foreach(get_rows("PRAGMA integrity_check(".q($R).")")as$K)$mf
.="<b>".h($R)."</b>: ".h($K["integrity_check"])."<br>";}}elseif(JUSH!="sql"){$I=(JUSH=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$mf=lang(280);}elseif(!$_POST["tables"])$mf=lang(9);elseif($I=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('Adminer\idf_escape',$_POST["tables"])))){while($K=$I->fetch_assoc())$mf
.="<b>".h($K["Table"])."</b>: ".h($K["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$mf,$I);}page_header(($_GET["ns"]==""?lang(36).": ".h(DB):lang(75).": ".h($_GET["ns"])),$m,true);if(adminer()->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(281)."</h3>\n";$Ei=tables_list();if(!$Ei)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(282)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(55)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=driver()->convertOperator("LIKE %%");search_tables();}}echo"<div class='scrollable'>\n","<table class='nowrap checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(134),'<td>'.lang(283).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(123).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(284).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT','oracle'=>'REFRN20286')),'<td>'.lang(285).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT')),'<td>'.lang(286).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(50).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(287).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'catalog-pg-class.html#CATALOG-PG-CLASS','oracle'=>'REFRN20286')),(support("comment")?'<td>'.lang(49).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-info.html#FUNCTIONS-INFO-COMMENT-TABLE')):''),"</thead>\n";$T=0;foreach($Ei
as$B=>$U){$Jj=($U!==null&&!preg_match('~table|sequence~i',$U));$u=h("Table-".$B);echo'<tr><td>'.checkbox(($Jj?"views[]":"tables[]"),$B,in_array("$B",$Fi,true),"","","",$u),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($B)."' title='".lang(41)."' id='$u'>".h($B).'</a>':h($B));if($Jj)echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($B).'" title="'.lang(42).'">'.(preg_match('~materialized~i',$U)?lang(132):lang(133)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($B).'" title="'.lang(40).'">?</a>';else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(43)),"Index_length"=>array("indexes",lang(137)),"Data_free"=>array("edit",lang(44)),"Auto_increment"=>array("auto_increment=1&create",lang(43)),"Rows"=>array("select",lang(40)),)as$y=>$_){$u=" id='$y-".h($B)."'";echo($_?"<td align='right'>".(support("table")||$y=="Rows"||(support("indexes")&&$y!="Data_length")?"<a href='".h(ME."$_[0]=").urlencode($B)."'$u title='$_[1]'>?</a>":"<span$u>?</span>"):"<td id='$y-".h($B)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($B)."'>":""),"\n";}echo"<tr><td><th>".lang(260,count($Ei)),"<td>".h(JUSH=="sql"?get_val("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$y)echo"<td align='right' id='sum-$y'>";echo"\n","</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$Dj="<input type='submit' value='".lang(288)."'> ".on_help("'VACUUM'");$Zf="<input type='submit' name='optimize' value='".lang(289)."'> ".on_help(JUSH=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(127)." <span id='selected'></span></legend><div>".(JUSH=="sqlite"?$Dj."<input type='submit' name='check' value='".lang(290)."'> ".on_help("'PRAGMA integrity_check'"):(JUSH=="pgsql"?$Dj.$Zf:(JUSH=="sql"?"<input type='submit' value='".lang(291)."'> ".on_help("'ANALYZE TABLE'").$Zf."<input type='submit' name='check' value='".lang(290)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(292)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(293)."'> ".on_help(JUSH=="sqlite"?"'DELETE'":"'TRUNCATE".(JUSH=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(128)."'>".on_help("'DROP TABLE'").confirm()."\n";$j=(support("scheme")?adminer()->schemas():adminer()->databases());if(count($j)!=1&&JUSH!="sqlite"){$k=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p><label>".lang(294).": ",($j?html_select("target",$j,$k):'<input name="target" value="'.h($k).'" autocapitalize="off">'),"</label> <input type='submit' name='move' value='".lang(295)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(296)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(297)):""),"\n";}echo"<input type='hidden' name='all' value=''>",script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")." }"),input_token(),"</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo"<p class='links'><a href='".h(ME)."create='>".lang(73)."</a>\n",(support("view")?"<a href='".h(ME)."view='>".lang(213)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(150)."</h3>\n";$Bh=routines();if($Bh){echo"<table class='odds'>\n",'<thead><tr><th>'.lang(191).'<td>'.lang(48).'<td>'.lang(230)."<td></thead>\n";foreach($Bh
as$K){$B=($K["SPECIFIC_NAME"]==$K["ROUTINE_NAME"]?"":"&name=".urlencode($K["ROUTINE_NAME"]));echo'<tr>','<th><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($K["SPECIFIC_NAME"]).$B).'">'.h($K["ROUTINE_NAME"]).'</a>','<td>'.h($K["ROUTINE_TYPE"]),'<td>'.h($K["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($K["SPECIFIC_NAME"]).$B).'">'.lang(140)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(229).'</a>':'').'<a href="'.h(ME).'function=">'.lang(228)."</a>\n";}if(support("sequence")){echo"<h3 id='sequences'>".lang(298)."</h3>\n";$Th=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($Th){echo"<table class='odds'>\n","<thead><tr><th>".lang(191)."</thead>\n";foreach($Th
as$X)echo"<tr><th><a href='".h(ME)."sequence=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."sequence='>".lang(235)."</a>\n";}if(support("type")){echo"<h3 id='user-types'>".lang(31)."</h3>\n";$Bj=types();if($Bj){echo"<table class='odds'>\n","<thead><tr><th>".lang(191)."</thead>\n";foreach($Bj
as$X)echo"<tr><th><a href='".h(ME)."type=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."type='>".lang(239)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(151)."</h3>\n";$L=get_rows("SHOW EVENTS");if($L){echo"<table>\n","<thead><tr><th>".lang(191)."<td>".lang(299)."<td>".lang(219)."<td>".lang(220)."<td></thead>\n";foreach($L
as$K)echo"<tr>","<th>".h($K["Name"]),"<td>".($K["Execute at"]?lang(300)."<td>".$K["Execute at"]:lang(221)." ".$K["Interval value"]." ".$K["Interval field"]."<td>$K[Starts]"),"<td>$K[Ends]",'<td><a href="'.h(ME).'event='.urlencode($K["Name"]).'">'.lang(140).'</a>';echo"</table>\n";$Jc=get_val("SELECT @@event_scheduler");if($Jc&&$Jc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($Jc)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(218)."</a>\n";}if($Ei)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();