<?php
require 'db.php';

// Buscar gateway ativo
$stmt = $pdo->query("SELECT * FROM gateways WHERE ativo=1 LIMIT 1");
$gateway = $stmt->fetch(PDO::FETCH_ASSOC);

if(!$gateway){
    die("Nenhum gateway ativo encontrado.");
}

// Mostrar informações do gateway
echo "<h2>Gateway Ativo: " . htmlspecialchars(ucfirst($gateway['nome'])) . "</h2>";
echo "<p>Client ID: " . htmlspecialchars($gateway['client_id']) . "</p>";
echo "<p>Callback URL: " . htmlspecialchars($gateway['callback_url']) . "</p>";

// Simular envio de callback
echo "<h3>Simulando callback...</h3>";

$callback_url = $gateway['callback_url'];

// Usar file_get_contents para simular
$options = [
    "http" => [
        "method" => "POST",
        "header" => "Content-Type: application/json\r\n",
        "content" => json_encode([
            "transaction_id" => "TEST123",
            "status" => "success",
            "amount" => 10.00
        ])
    ]
];

$context = stream_context_create($options);
$response = @file_get_contents($callback_url, false, $context);

if($response === false){
    echo "<p style='color:red;'>Erro ao acessar callback!</p>";
} else {
    echo "<p style='color:green;'>Callback acessado com sucesso!</p>";
    echo "<pre>Resposta do gateway: " . htmlspecialchars($response) . "</pre>";
}
