<?php
session_start();
require 'db.php';

if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
  header('Location: login.php');
  exit;
}

$busca = trim($_GET['busca'] ?? '');

if ($busca !== '') {
    $sql = "SELECT * FROM usuarios WHERE email LIKE :busca OR telefone LIKE :busca";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':busca' => '%' . $busca . '%']);
    $usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);
} else {
    $usuarios = $pdo->query("SELECT * FROM usuarios")->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Configuração de Usuários</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet" />
  <style>
    :root {
      --bg-dark: #121212;
      --bg-panel: #1e1e1e;
      --primary-green: #00ff99;
      --text-light: #e0e0e0;
      --radius: 12px;
      --transition: 0.3s ease;
      --border-panel: rgba(0, 255, 153, 0.1);
      --box-shadow-hover: 0 0 15px rgba(0, 255, 153, 0.4);
    }

    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(to bottom right, #0d0d0d, #1a1a1a);
      color: var(--text-light);
      min-height: 100vh;
    }

    .sidebar {
      position: fixed;
      top: 0;
      left: 0;
      width: 260px;
      height: 100%;
      background: #101010;
      padding: 30px 20px;
      color: var(--primary-green);
      border-right: 2px solid var(--primary-green);
    }

    .sidebar h2 {
      font-size: 24px;
      text-align: center;
      margin-bottom: 30px;
      font-weight: 700;
    }

    .sidebar ul {
      list-style: none;
      padding: 0;
    }

    .sidebar ul li {
      margin-bottom: 15px;
    }

    .sidebar ul li a {
      display: block;
      padding: 12px 20px;
      background-color: #1b1b1b;
      color: var(--text-light);
      border: 1px solid transparent;
      border-radius: var(--radius);
      text-decoration: none;
      transition: var(--transition);
    }

    .sidebar ul li a:hover {
      background-color: var(--primary-green);
      color: #000;
      border-color: var(--primary-green);
    }

    .content {
      margin-left: 260px;
      padding: 40px;
      max-width: calc(100% - 260px);
    }

    h2 {
      font-size: 28px;
      color: var(--primary-green);
      margin-bottom: 30px;
    }

    form#busca-form {
      margin-bottom: 20px;
      display: flex;
      gap: 10px;
      flex-wrap: wrap;
      align-items: center;
    }

    form#busca-form input[type="text"] {
      padding: 12px 16px;
      border-radius: var(--radius);
      border: 1px solid var(--border-panel);
      background-color: var(--bg-dark);
      color: var(--text-light);
      font-size: 16px;
      flex: 1 1 300px;
      transition: border-color 0.3s;
    }

    form#busca-form input[type="text"]:focus {
      outline: none;
      border-color: var(--primary-green);
      box-shadow: 0 0 6px var(--primary-green);
    }

    form#busca-form button {
      padding: 12px 20px;
      background-color: var(--primary-green);
      color: #000;
      font-weight: 700;
      border: none;
      border-radius: var(--radius);
      cursor: pointer;
      transition: background-color 0.3s;
      flex: 0 0 auto;
    }

    form#busca-form button:hover {
      background-color: #00cc77;
    }

    table {
      width: 100%;
      border-collapse: separate;
      border-spacing: 0 8px;
      background: transparent;
    }

    thead tr th {
      padding: 14px;
      color: var(--primary-green);
      font-weight: 700;
      text-align: left;
      border-radius: var(--radius);
      user-select: none;
    }

    tbody tr {
      box-shadow: 0 0 3px rgb(0 255 153);
      border-radius: var(--radius);
      transition: box-shadow 0.3s;
    }

    tbody tr:hover {
      box-shadow: 0 0 3px rgb(0 255 153);
    }

    tbody tr td {
      padding: 14px;
      color: var(--text-light);
      vertical-align: middle;
      border: none;
    }

    tbody tr td form {
      margin: 0;
    }

    input[type="number"] {
      width: 100px;
      padding: 8px;
      font-size: 14px;
      border: 1px solid var(--border-panel);
      border-radius: var(--radius);
      background-color: var(--bg-dark);
      color: var(--text-light);
      transition: border-color 0.3s;
    }

    input[type="number"]:focus {
      outline: none;
      border-color: var(--primary-green);
      box-shadow: 0 0 6px var(--primary-green);
    }

    input[type="checkbox"] {
      margin-right: 6px;
      cursor: pointer;
    }

    label {
      font-size: 12px;
      color: var(--primary-green);
      user-select: none;
      cursor: pointer;
    }

    .btn {
      padding: 8px 14px;
      border: none;
      border-radius: var(--radius);
      cursor: pointer;
      color: #000;
      font-weight: 700;
      font-size: 14px;
      transition: background-color 0.3s;
      text-decoration: none;
      display: inline-block;
    }

    .btn-salvar {
      background-color: var(--primary-green);
    }

    .btn-salvar:hover {
      background-color: #00cc77;
    }

    .btn-excluir {
      background-color: #e74c3c;
      margin-left: 6px;
      color: #fff;
    }

    .btn-excluir:hover {
      background-color: #c0392b;
    }

    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        border: none;
        padding: 20px;
        text-align: center;
      }

      .sidebar ul {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 15px;
      }

      .sidebar ul li {
        width: auto;
        margin-bottom: 10px;
      }

      .content {
        margin-left: 0;
        padding: 20px;
        max-width: 100%;
      }

      form#busca-form {
        flex-direction: column;
        align-items: stretch;
      }

      form#busca-form input[type="text"] {
        flex: 1 1 100%;
      }

      form#busca-form button {
        width: 100%;
      }

      table {
        font-size: 14px;
      }

      input[type="number"] {
        width: 70px;
      }

      .btn {
        padding: 6px 10px;
        font-size: 12px;
      }
    }
  </style>
</head>
<body>

  <div class="sidebar">
    <h2>Admin</h2>
    <ul>
      <li><a href="painel_admin.php">Painel de Controle</a></li>
      <li><a href="configuracoes_admin.php">Configurações</a></li>
      <li><a href="usuarios_admin.php">Config Usuários</a></li>
      <li><a href="saques_admin.php">Saques</a></li>
      <li><a href="saques_comissao_admin.php">Saques Afiliado</a></li>
      <li><a href="gateways_admin.php">Gateways</a></li>
      <li><a href="pix_admin.php">Transacoes</a></li>
    </ul>
  </div>

  <div class="content">
    <h2>Gerenciar Usuários</h2>

    <form id="busca-form" method="GET" action="">
      <input
        type="text"
        name="busca"
        placeholder="Buscar por email ou telefone"
        value="<?= htmlspecialchars($_GET['busca'] ?? '') ?>"
        autocomplete="off"
      />
      <button type="submit">Buscar</button>
    </form>

    <table>
      <thead>
        <tr>
          <th>ID</th>
          <th>Email</th>
          <th>Telefone</th>
          <th>Saldo</th>
          <th>Depósitos</th>
          <th>Saques (aprovados)</th>
          <th>% Ganho</th>
          <th>Indicações</th>
          <th>Comissão</th>
          <th>Ações</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($usuarios as $u): ?>
          <?php
            $indicacoes = $pdo->prepare("SELECT COUNT(*) FROM usuarios WHERE indicado_por = ?");
            $indicacoes->execute([$u['id']]);
            $indicados = $indicacoes->fetchColumn();

            $depositos = $pdo->prepare("SELECT SUM(valor) FROM transacoes_pix WHERE usuario_id = ? AND status = 'aprovado'");
            $depositos->execute([$u['id']]);
            $total_depositos = $depositos->fetchColumn() ?? 0;

            $saques = $pdo->prepare("SELECT SUM(valor) FROM saques WHERE usuario_id = ? AND status = 'aprovado'");
            $saques->execute([$u['id']]);
            $total_saques = $saques->fetchColumn() ?? 0;
          ?>
          <tr>
            <form action="atualizar_usuario.php" method="POST">
              <input type="hidden" name="id" value="<?= $u['id'] ?>" />
              <td><?= $u['id'] ?></td>
              <td><?= htmlspecialchars($u['email']) ?></td>
              <td><?= htmlspecialchars($u['telefone']) ?></td>
              <td><input type="number" step="0.01" name="saldo" value="<?= htmlspecialchars($u['saldo']) ?>"></td>
              <td>R$ <?= number_format($total_depositos, 2, ',', '.') ?></td>
              <td>R$ <?= number_format($total_saques, 2, ',', '.') ?></td>
              <td>
                <input
                  type="number"
                  step="0.1"
                  name="percentual_ganho"
                  value="<?= is_null($u['percentual_ganho']) ? '' : htmlspecialchars($u['percentual_ganho']) ?>"
                  style="width: 70px;"
                />
                <br />
                <label>
                  <input type="checkbox" name="usar_global" value="1" <?= is_null($u['percentual_ganho']) ? 'checked' : '' ?> />
                  Usar chance padrão
                </label>
              </td>
              <td><?= $indicados ?></td>
              <td><input type="number" step="0.01" name="comissao" value="<?= htmlspecialchars($u['comissao'] ?? 0) ?>"></td>
              <td>
                <button class="btn btn-salvar" type="submit">Salvar</button>
                <a
                  href="excluir_usuario.php?id=<?= $u['id'] ?>"
                  class="btn btn-excluir"
                  onclick="return confirm('Tem certeza?')"
                  >Excluir</a
                >
              </td>
            </form>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>

</body>
</html>
