<?php
require 'db.php';

// webhook_saque.php
header('Content-Type: application/json');
require 'db.php';

// Recebe o payload raw JSON
$payload = file_get_contents('php://input');
$data = json_decode($payload, true);

if (!$data || !isset($data['status'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Payload inválido']);
    exit;
}

// Use external_id para identificar a transação localmente
$externalId = $data['external_id'] ?? null;
if (!$externalId) {
    http_response_code(400);
    echo json_encode(['error' => 'external_id ausente']);
    exit;
}

$status = strtoupper($data['status']);  // Ex: COMPLETED, FAILED, PENDING...
$amount = floatval($data['amount'] ?? 0);
$fee = floatval($data['fee'] ?? 0);

// Mapear status Ellitium para status no banco
$statusBanco = match($status) {
    'COMPLETED' => 'aprovado',
    'FAILED' => 'erro_api',
    'CANCELLED' => 'recusado',
    default => 'pendente'
};

// Buscar saque pelo external_id
$stmt = $pdo->prepare("SELECT * FROM saques WHERE external_id = ?");
$stmt->execute([$externalId]);
$saque = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$saque) {
    http_response_code(404);
    echo json_encode(['error' => 'Saque não encontrado']);
    exit;
}

// Atualizar status e data de atualização
$stmt = $pdo->prepare("UPDATE saques SET status = ?, atualizado_em = NOW() WHERE id = ?");
$stmt->execute([$statusBanco, $saque['id']]);

// Opcional: registrar taxa, valor recebido, etc

http_response_code(200);
echo json_encode(['message' => 'Status atualizado']);
exit;
